/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ModelView.cpp,v 1.2 2004/05/19 04:11:21 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"
#include "ModelDoc.h"
#include "ModelView.h"

#include "ExtncsDoc.h"
#include "ExtncsWnd.h"
#include "ModelDoc.h"
#include "ExtncsMain.h"
#include <direct.h>
#include "ScopeFrame.h"
extern CExtncsMain*	g_pExtncsMain;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef __cplusplus
extern "C" {
#endif
__declspec(dllimport) BOOL NcsdefExec(HANDLE hStdioW,
			CDocument* pDocument,
			CView* pConsoleView,
			CView* pModelView, CString szGroup);
#ifdef __cplusplus
}
#endif

// Image indexes
#define ILI_CELL		0
#define ILI_SYNAPSE		1
#define ILI_GAP			2
#define ILI_IO			3
#define ILI_SOURCE		4
#define ILI_SINK		5
#define ILI_MATH		6
#define	ILI_SYSTEM		7
#define ILI_USER		8

/////////////////////////////////////////////////////////////////////////////
// CModelView

IMPLEMENT_DYNCREATE(CModelView, CTreeView)

CModelView::CModelView()
{
}

CModelView::~CModelView()
{
}


BEGIN_MESSAGE_MAP(CModelView, CTreeView)
	//{{AFX_MSG_MAP(CModelView)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnSelchanged)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_MODEL_ADD, OnModelAdd)
	ON_UPDATE_COMMAND_UI(ID_MODEL_ADD, OnUpdateModelAdd)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModelView `

void CModelView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: ̈ʒuɕ`p̃R[hǉĂ
}

/////////////////////////////////////////////////////////////////////////////
// CModelView ff

#ifdef _DEBUG
void CModelView::AssertValid() const
{
	CTreeView::AssertValid();
}

void CModelView::Dump(CDumpContext& dc) const
{
	CTreeView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CModelView bZ[W nh

BOOL CModelView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CTreeView::PreCreateWindow (cs))
		return FALSE;

    cs.style |= TVS_HASLINES | TVS_LINESATROOT | TVS_HASBUTTONS |
        TVS_SHOWSELALWAYS;
	return TRUE;
}

void CModelView::OnInitialUpdate() 
{
	CTreeView::OnInitialUpdate();
	BOOL bRet;
	
	// Initialize the image list.
    bRet = m_ilModules.Create (IDB_MODULEIMAGES, 24, 8, RGB (255, 0, 255));
	CImageList* pImg;
    pImg = GetTreeCtrl ().SetImageList (&m_ilModules, TVSIL_NORMAL);

	// Populate the tree view with drive items.
    AddModules ();	
	
}

int CModelView::AddModules()
{
    int nModule = 0;

	// Cell type
	AddModuleItem( "Cell" );
	nModule++;
	// Synapse
	AddModuleItem( "Synapse" );
	nModule++;
	// Synapse
	AddModuleItem( "Gap" );
	nModule++;
	// Synapse
	AddModuleItem( "I/O" );
	nModule++;
	// Math
	AddModuleItem( "Source" );
	nModule++;
	// Math
	AddModuleItem( "Sink" );
	nModule++;
	// Math
	AddModuleItem( "General" );
	nModule++;
	// System
	AddModuleItem( "System" );
	nModule++;
	// System
	AddModuleItem( "User" );
	nModule++;

Invalidate(TRUE);
    return nModule;

}

BOOL CModelView::AddModuleItem(LPCTSTR pszModule)
{
	int	nType;
    CString string;
    HTREEITEM hItem;

	if(strcmp(pszModule, "Cell") == NULL)
		nType = MODULE_CELL;
	else if(strcmp(pszModule, "Synapse") == NULL)
		nType = MODULE_SYNAPSE;
	else if(strcmp(pszModule, "Gap") == NULL)
		nType = MODULE_GAP;
	else if(strcmp(pszModule, "I/O") == NULL)
		nType = MODULE_IO;
	else if(strcmp(pszModule, "Source") == NULL)
		nType = MODULE_SOURCE;
	else if(strcmp(pszModule, "Sink") == NULL)
		nType = MODULE_SINK;
	else if(strcmp(pszModule, "General") == NULL)
		nType = MODULE_MATH;
	else if(strcmp(pszModule, "System") == NULL)
		nType = MODULE_SYSTEM;
	else if(strcmp(pszModule, "User") == NULL)
		nType = MODULE_USER;
	else
		nType = MODULE_NULL;
	if(nType == MODULE_NULL)
		return FALSE;

	switch (nType) {
	case	MODULE_CELL:
        hItem = GetTreeCtrl ().InsertItem (pszModule, ILI_CELL,
            ILI_CELL,TVGN_ROOT);
        SetButtonState (hItem, pszModule);
		break;
	case	MODULE_SYNAPSE:
        hItem = GetTreeCtrl ().InsertItem (pszModule, ILI_SYNAPSE,
            ILI_SYNAPSE,TVGN_ROOT);
        SetButtonState (hItem, pszModule);
		break;
	case	MODULE_GAP:
        hItem = GetTreeCtrl ().InsertItem (pszModule, ILI_GAP,
            ILI_GAP,TVGN_ROOT);
        SetButtonState (hItem, pszModule);
		break;
	case	MODULE_IO:
        hItem = GetTreeCtrl ().InsertItem (pszModule, ILI_IO,
            ILI_IO,TVGN_ROOT);
        SetButtonState (hItem, pszModule);
		break;
	case	MODULE_SOURCE:
        hItem = GetTreeCtrl ().InsertItem (pszModule, ILI_SOURCE,
            ILI_SOURCE,TVGN_ROOT);
        SetButtonState (hItem, pszModule);
		break;
	case	MODULE_SINK:
        hItem = GetTreeCtrl ().InsertItem (pszModule, ILI_SINK,
            ILI_SINK,TVGN_ROOT);
        SetButtonState (hItem, pszModule);
		break;
	case	MODULE_MATH:
        hItem = GetTreeCtrl ().InsertItem (pszModule, ILI_MATH,
            ILI_MATH,TVGN_ROOT);
        SetButtonState (hItem, pszModule);
		break;
	case	MODULE_SYSTEM:
        hItem = GetTreeCtrl ().InsertItem (pszModule, ILI_SYSTEM,
            ILI_SYSTEM,TVGN_ROOT);
        SetButtonState (hItem, pszModule);
		break;
	case	MODULE_USER:
        hItem = GetTreeCtrl ().InsertItem (pszModule, ILI_USER,
            ILI_USER,TVGN_ROOT);
        SetButtonState (hItem, pszModule);
		break;
	}
	return TRUE;

}

//݃TuubN݂Ȃ
//\Ƃǉ
BOOL CModelView::SetButtonState(HTREEITEM hItem, LPCTSTR pszPath)
{
 	return TRUE;
}

CString CModelView::GetPathFromItem(HTREEITEM hItem)
{
    CString strResult = GetTreeCtrl ().GetItemText (hItem);

    HTREEITEM hParent;
    while ((hParent = GetTreeCtrl ().GetParentItem (hItem)) != NULL) {
        CString string = GetTreeCtrl ().GetItemText (hParent);
#if 0
        if (string.Right (1) != _T ("\\"))
            string += _T ("\\");
#else
        if (string.Right (1) != _T ("/"))
            string += _T ("/");
#endif
        strResult = string + strResult;
        hItem = hParent;
    }
    return strResult;

}

void CModelView::OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
    NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*) pNMHDR;
    CString strPath = GetPathFromItem (pNMTreeView->itemNew.hItem);	
    GetDocument ()->UpdateAllViews (this, 0x5A, (CObject*) (LPCTSTR)strPath);
	*pResult = 0;
}

void CModelView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	HTREEITEM nItem;
	TVHITTESTINFO info;
	UINT state;

	//NbNꂽitemIĂ邩H
	info.pt = point;
	nItem = GetTreeCtrl ().HitTest( &info );
	if(nItem == NULL)
		return;

	//Is it chosen? 
	state = GetTreeCtrl ().GetItemState(nItem, TVIS_SELECTED);
	if(state != TVIS_SELECTED)
		return;

	// }EX|C^XN[Wɕϊ
	ClientToScreen( &point );
	// gɃtH[JXݒ
	SetForegroundWindow();
	// |bvAbvj[̍쐬
	CMenu menu;
	// IDR_MENUPOPUP_SCOPE̓j[̃\[XID
	menu.LoadMenu( IDR_POPUP_MODEL );
	CMenu* pPopup = menu.GetSubMenu( 0 );
	// |bvAbvj[\
	pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			point.x, point.y, this);
	// LoadMenuJ
	menu.DestroyMenu();

	CTreeView::OnRButtonDown(nFlags, point);
}

CModelDoc * CModelView::GetDocument()
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CModelDoc)));
	return (CModelDoc*)m_pDocument;

}

void CModelView::OnModelAdd() 
{
	HTREEITEM hItem;
	CString szText;
	hItem = GetTreeCtrl ().GetSelectedItem();
	if(hItem) {
		//item
		szText = GetTreeCtrl ().GetItemText(hItem);
		//ncsdefAṽR[
		NcsdefExec(g_pExtncsMain->m_hStdinW,
			(CDocument *)GetDocument(),
			(CView *)g_pExtncsMain->m_pConsoleView,
			(CView *)this, szText);
	}
	
}

void CModelView::OnUpdateModelAdd(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}
