/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: MoniWnd.cpp,v 1.2 2004/05/19 04:11:21 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"
#include "WidgetObj.h"
#include "ScopeFrame.h"
#include "MoniWnd.h"
#include "ScopeList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMoniWnd

IMPLEMENT_DYNCREATE(CMoniWnd, CMDIChildWnd)

CMoniWnd::CMoniWnd()
{
}

CMoniWnd::~CMoniWnd()
{
}

BOOL CMoniWnd::Create(LPCSTR szTitle,
		LONG style			/* = WS_OVERLAPPEDWINDOW */,
		const RECT& rect	/* = rectDefault */,
		CScopeFrame* pWnd		/* = NULL */)
{
	const char* pszConnectionClass =
		AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS,
					NULL,
					(HBRUSH)(COLOR_MENU+1),
					NULL);
	//֘A
	m_pScopeFrame = pWnd;
	//o^
	return CMDIChildWnd::Create(pszConnectionClass, szTitle,
				//WS_OVERLAPPEDWINDOW & (~WS_MINIMIZEBOX) | WS_TABSTOP | WS_CHILD,
				WS_OVERLAPPED | WS_CAPTION | WS_THICKFRAME | WS_CHILD,
					rect, pWnd, NULL );
}

BEGIN_MESSAGE_MAP(CMoniWnd, CMDIChildWnd)
	//{{AFX_MSG_MAP(CMoniWnd)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMoniWnd bZ[W nh

int CMoniWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	//
	// CScopeList̃EBhEɃA^b`
	//
	CRuntimeClass* pNewViewClass;
	pNewViewClass = RUNTIME_CLASS(CScopeList);
	CCreateContext context;
	context.m_pNewViewClass = pNewViewClass;
	context.m_pCurrentDoc = NULL;
	CView* pNewView = STATIC_DOWNCAST(CView, CreateView(&context));
	if (pNewView != NULL)
	{
		// the new view is there, but invisible and not active...
		pNewView->ShowWindow(SW_SHOW);
		pNewView->OnInitialUpdate();
		SetActiveView(pNewView);
		RecalcLayout();
	}

	return 0;
}
