/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ParamWnd.cpp,v 1.3 2004/08/02 07:16:12 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"
#include "WidgetObj.h"
#include "ParamWnd.h"

#include "ModelWnd.h"
#include "ModelDoc.h"
#include "ModelView.h"
#include "BlockView.h"
#include "ExtncsDoc.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"
extern CExtncsMain*	g_pExtncsMain;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CParamWnd

IMPLEMENT_DYNCREATE(CParamWnd, CFrameWnd)

CParamWnd::CParamWnd()
{
	int i;

	m_pCtrl = NULL;
	//m_backColor = RGB(192,255,255);
	m_backColor = RGB(255,160,0);
	m_foreColor = RGB(0, 0, 0);
	m_nStatic = 0;
	m_nEdit = 0;
	m_nCombo = 0;
	m_nSpin = 0;
	for(i = 0; i < MAX_PARAM; i++) {
		m_static[i] = NULL;
		m_edit[i] = NULL;
		m_combo[i] = NULL;
		m_spin[i] = NULL;
	}
}

CParamWnd::~CParamWnd()
{
}

BOOL CParamWnd::Create(LPCSTR szTitle,
		LONG style			/* = WS_OVERLAPPEDWINDOW */,
		const RECT& rect	/* = rectDefault */,
		CWnd* pWnd		/* = NULL */,
		CWidget* pWidget)
{
	const char* pszConnectionClass =
		AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS,
					NULL,
					(HBRUSH)(COLOR_MENU+1),
					NULL);
	//o^
	m_pWidget = pWidget;
	m_pWnd = pWnd;
	m_winRect.left = rect.left;
	m_winRect.top = rect.top;
	m_winRect.right = rect.right;
	m_winRect.bottom = rect.bottom;

	return CFrameWnd::Create(pszConnectionClass, szTitle,
				WS_OVERLAPPEDWINDOW & (~WS_MINIMIZEBOX) | WS_TABSTOP,
					rect, pWnd, NULL/*, WS_EX_CONTROLPARENT*/ );
}


BEGIN_MESSAGE_MAP(CParamWnd, CFrameWnd)
	//{{AFX_MSG_MAP(CParamWnd)
	ON_WM_CREATE()
	ON_COMMAND(ID_PARAM_QUIT, OnParamQuit)
	ON_UPDATE_COMMAND_UI(ID_PARAM_QUIT, OnUpdateParamQuit)
	ON_COMMAND(ID_PARAM_APPLY, OnParamApply)
	ON_UPDATE_COMMAND_UI(ID_PARAM_APPLY, OnUpdateParamApply)
	ON_WM_HELPINFO()
	ON_WM_DESTROY()
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CParamWnd bZ[W nh

int CParamWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	//tHg
	m_font.CreateFont(12,
		0,0,0,FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,
		OUT_STROKE_PRECIS,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
		DEFAULT_PITCH,_T("MS PSVbN"));
	// °ް̍쐬
	if (!m_toolBar.Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_TOOLTIPS) ||
		!m_toolBar.LoadToolBar(IDR_TOOLBAR_PARAM))
	{
		//쐬Ɏs̏
		AfxMessageBox("m_toolBar.CreateɎs܂B", MB_OK, NULL);
		return 1;
	}
	// °ް̻ގ擾
	m_sizeToolBar = m_toolBar.CalcFixedLayout(FALSE, TRUE);

	// ACR\[X[h
	HICON hIcon = AfxGetApp()->LoadIcon(IDI_EXTNCS);
	ASSERT(hIcon);
	// EBhEɐVACRw肷
	this->SendMessage(WM_SETICON, TRUE, (LPARAM)hIcon);
	
	//^Cg
	char title[_MAX_PATH];
	sprintf(title, "Setting parameters : %s", m_pWidget->GetName());
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);

	//\쐬
	int ymax = ParamInitialize();
	int cxborder,cyborder,cycaption;
	cxborder = GetSystemMetrics(SM_CXEDGE);
	cyborder = GetSystemMetrics(SM_CYEDGE);
	cycaption = GetSystemMetrics(SM_CYSMCAPTION);

	//WindowTCY
	CPtrArray*	p;
	int nParam,cx,cy;
	p = m_pWidget->GetParamPointer();
	nParam = (int)p->GetSize();
	if(nParam >= 8)
		cy = 10+2*cyborder+cycaption+m_sizeToolBar.cy + 10+8*(2*STATIC_HEIGHT+10);
	else
		cy = 10+2*cyborder+cycaption+ymax;
	if((nParam % 8) == 0)
		cx = 30 + STATIC_WIDTH + 2*cxborder + (10+STATIC_WIDTH)*(nParam/8-1);
	else
		cx = 30 + STATIC_WIDTH + 2*cxborder + (10+STATIC_WIDTH)*(nParam/8);
	MoveWindow(m_winRect.left, m_winRect.top, cx, cy, TRUE);
	
	return 0;
}

BOOL CParamWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
	cs.style &= ~FWS_ADDTOTITLE;
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	
	return TRUE;
}

//l`悷
int CParamWnd::ParamInitialize()
{
	int nCount,i;
	CPtrArray*	p;
	PARAMINFO *pItem;
	int	staticID,editID,comboID,spinID;
	int staticAD=0,editAD=0,comboAD=0,spinAD=0;
	int x,y,index,val;
	CFont*	pOldFont;
	CDC*	dc = GetDC();
	pOldFont = dc->SelectObject(&m_font);

	staticID = IDC_STATIC_PARAM0;
	editID = IDC_EDIT_PARAM0;
	comboID = IDC_COMBO_PARAM0;
	spinID = IDC_SPIN_PARAM0;
	y = m_sizeToolBar.cy + 10;
	p = m_pWidget->GetParamPointer();
	nCount = (int)p->GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			x = 10 + (10+STATIC_WIDTH)*(i/8);
			pItem = (PARAMINFO*) p->GetAt (i);
			//static
			m_static[staticAD] = new CColorStatic;
			if(pItem->strMessage.GetLength() == 0)
				m_static[staticAD]->Create(pItem->strName, WS_CHILD | WS_VISIBLE | WS_DLGFRAME,
					CRect(x, y, x+STATIC_WIDTH, y+STATIC_HEIGHT), this, staticID);
			else
				m_static[staticAD]->Create(pItem->strMessage, WS_CHILD | WS_VISIBLE | WS_DLGFRAME,
					CRect(x, y, x+STATIC_WIDTH, y+STATIC_HEIGHT), this, staticID);
			m_static[i]->SetFont(&m_font);
			m_static[staticAD]->SetColors(RGB(0,0,0), GetSysColor(COLOR_MENU));
			staticID++;
			staticAD++;
			if(staticID >= (IDC_STATIC_PARAM0+10))
				staticID = IDC_STATIC_PARAM10;

			//ݒ
			y += STATIC_HEIGHT;
			if(pItem->type == PARAM_EDIT) {
				///////////////////////////
				//	editRg[
				///////////////////////////
			if(pItem->step == 0) {
				//eLXg{bNX̂
				m_edit[editAD] = new CColorEdit;
				m_edit[editAD]->Create(WS_CHILD | WS_VISIBLE | WS_TABSTOP | ES_AUTOHSCROLL,
							CRect(x, y, x+EDIT_WIDTH+SPIN_WIDTH, y+EDIT_HEIGHT), this, editID);
				m_edit[editAD]->SetFont(&m_font);
				m_edit[editAD]->SetColors(RGB(0,0,0),m_backColor);
				m_edit[editAD]->SetWindowText(pItem->strValue);
				editID++;
				editAD++;
			}
			else {
				//eLXg{bNX{Xs{^
				m_edit[editAD] = new CColorEdit;
				m_edit[editAD]->Create(WS_CHILD | WS_VISIBLE | WS_TABSTOP | ES_AUTOHSCROLL,
							CRect(x, y, x+EDIT_WIDTH, y+EDIT_HEIGHT), this, editID);
				m_edit[editAD]->SetFont(&m_font);
				m_edit[editAD]->SetColors(RGB(0,0,0),m_backColor);
				m_edit[editAD]->SetWindowText(pItem->strValue);
					////////////////////////////
					//	spinRg[
					////////////////////////////
				m_spin[spinAD] = new CColorSpinButton;
				m_spin[spinAD]->Create(WS_CHILD | WS_VISIBLE | WS_TABSTOP | UDS_AUTOBUDDY | UDS_SETBUDDYINT,
							CRect(x+EDIT_WIDTH, y, x+EDIT_WIDTH+SPIN_WIDTH, y+SPIN_HEIGHT), this, spinID);
				m_spin[spinAD]->SetBuddy(m_edit[editAD]);
				//Fݒ肪s
				//m_spin[spinAD]->SetColors(RGB(0,0,0), m_backColor);
				//spin̑ݒ
				m_spin[spinAD]->SetRange( (int)pItem->min, (int)pItem->max );
				//SetBase͊ݒ
				m_spin[spinAD]->SetBase( 10 );
				//m_spin[spinAD]->SetBase( pItem->step );
				val = atoi(pItem->strValue);
				m_spin[spinAD]->SetPos( val );
				editID++;
				editAD++;
				spinID++;
				spinAD++;
			}
			//
			y += EDIT_HEIGHT;
			if(editID >= (IDC_EDIT_PARAM0+10))
				editID = IDC_EDIT_PARAM10;
			if(spinID >= (IDC_SPIN_PARAM0+10))
				spinID = IDC_SPIN_PARAM10;
			}
			else {
				//////////////////////////
				//	comboRg[
				//////////////////////////
			m_combo[comboAD] = new CColorComboBox;
			m_combo[comboAD]->Create(WS_VISIBLE | CBS_DROPDOWNLIST | WS_TABSTOP | WS_VSCROLL,
				CRect(x, y, x+COMBO_WIDTH, y+COMBO_HEIGHT*4), this, comboID);
			m_combo[comboAD]->SetFont(&m_font);
			m_combo[comboAD]->SetColors(RGB(0,0,0), m_backColor);
			SetComboParamInit(m_combo[comboAD], pItem->strInitial);
			//ؽđI
			index = atoi(pItem->strValue);
			m_combo[comboAD]->SetCurSel(index);
			//
			y += COMBO_HEIGHT;
			comboID++;
			comboAD++;
			}
			y += 10;
			if(i > 0) {		// ÿʒuݒ
				if(((i+1) % 8) == 0)
					y = m_sizeToolBar.cy + 10;
			}

		}
	}
	dc->SelectObject(pOldFont);
	ReleaseDC( dc );

	//m_pCtrĺAŏ̃Rg[
	pItem = (PARAMINFO*) p->GetAt (0);
	if(pItem->type == PARAM_EDIT) {
		m_pCtrl = m_edit[0];
	}
	else {
		m_pCtrl = m_combo[0];
	}

	return y;
}

// XǧԂ
int CParamWnd::SetComboParamInit(CColorComboBox* p, CString v)
{
	char param[256],buf[256];
	char *cptr;
	int i,n = 0;

	strcpy(param, v);
	cptr = param;
	i = 0;
	while(*cptr != '\0') {
		if(*cptr == ',' || *cptr == ')') {
			buf[i] = '\0';
			p->AddString(buf);
			n++;
			i = 0;
		}
		else {
			if(*cptr != '(')
				buf[i++] = *cptr;
		}
		cptr++;
	}
	return n;
}

void CParamWnd::OnParamQuit() 
{
	this->PostMessage(WM_CLOSE,0,0L);	
}

void CParamWnd::OnUpdateParamQuit(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CParamWnd::OnParamApply() 
{
	int nCount,i,index;
	char buf[256];
	CPtrArray*	p;
	PARAMINFO *pItem;
	int staticAD=0,editAD=0,comboAD=0,spinAD=0;

	p = m_pWidget->GetParamPointer();
	nCount = (int)p->GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			//PARAMINFO
			pItem = (PARAMINFO*) p->GetAt (i);
			//eRg[ݒǂݍ
			if(pItem->type == PARAM_EDIT) {
				//editRg[
				m_edit[editAD]->GetWindowText(buf, 256);
				if(pItem->strValue.Compare(_T(buf)) != NULL) {
					//ύXꂽ
					if(CheckParamValid(pItem, buf)) {
						pItem->strValue = _T(buf);
						pItem->changed = TRUE;
					}
					else {
						m_edit[editAD]->SetWindowText(pItem->strValue);
					}
				}
				//edit
				editAD++;
			}
			else {
				//comboRg[
				index = m_combo[comboAD]->GetCurSel();
				sprintf(buf,"%d",index);
				if(pItem->strValue.Compare(_T(buf)) != NULL) {
					//ύXꂽ
					pItem->strValue = _T(buf);
					//ύX́ARpCfɔfĂ
					//̂ŁA̋Lq͕KvȂ
					//ARpCKv
					pItem->changed = TRUE;
				}
				//comboRg[
				comboAD++;
			}
		}

		//bZ[WCExtncsViewɑ
		m_pWnd->PostMessage(WM_EXTNCS_PARAM,0,(LPARAM)m_pWidget);
	}
	
}

void CParamWnd::OnUpdateParamApply(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

//͒l̑Ó]
BOOL CParamWnd::CheckParamValid(PARAMINFO *pItem, char* str)
{
	double val,min,max;

	min = pItem->min;
	max = pItem->max;
	val = atof(str);
	if(val > max) {
		this->MessageBox("Value is larger.","ERROR",MB_OK | MB_ICONERROR);
		return FALSE;
	}
	else if(val < min) {
		this->MessageBox("Value is smaller.","ERROR",MB_OK | MB_ICONERROR);
		return FALSE;
	}
	else
		return TRUE;
}

BOOL CParamWnd::PreTranslateMessage(MSG* pMsg) 
{
	CWnd *pWnd;
	int id;
	if(pMsg->message == WM_KEYDOWN) {
		switch( pMsg->wParam ) {
		case	VK_F1:
			// F1L[
			return TRUE;
		case	VK_RETURN:
			// EnterL[
			break;
		case	VK_ESCAPE:
			// EscL[
			break;
		case	VK_TAB:
			// TabL[
			pWnd = GetNextDlgTabItem(m_pCtrl, FALSE);
			pWnd->SetFocus();
			m_pCtrl = pWnd;
			//I
			id = pWnd->GetDlgCtrlID(); 
			if((id >= IDC_EDIT_PARAM0 && id <= IDC_EDIT_PARAM9) ||
				(id >= IDC_EDIT_PARAM10 && id <= IDC_EDIT_PARAM19))
				((CEdit *)m_pCtrl)->SetSel(0, -1, FALSE);
			return TRUE;
		default:
			break;
		}
	}
	
	return CFrameWnd::PreTranslateMessage(pMsg);
}

// F1L[tbNāAI[o[Cg
BOOL CParamWnd::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	AfxGetApp()->WinHelp(0x20000+IDR_TOOLBAR_PARAM, HELP_CONTEXT);
	return TRUE;
	//return CFrameWnd::OnHelpInfo(pHelpInfo);
}

void CParamWnd::OnDestroy() 
{
	CFrameWnd::OnDestroy();
	//Rg[폜
	for(int i = 0; i < MAX_PARAM; i++) {
		if(m_static[i])
			delete m_static[i];
		if(m_edit[i])
			delete m_edit[i];
		if(m_combo[i])
			delete m_combo[i];
		if(m_spin[i])
			delete m_spin[i];
	}


	//destroy pWnd=NULLɂ
	m_pWnd->PostMessage(WM_DELETE_PARAM, 0, (LPARAM)m_pWidget);
}

void CParamWnd::OnSetFocus(CWnd* pOldWnd) 
{
	CFrameWnd::OnSetFocus(pOldWnd);
	
	//ŏ̃p[^[ɃtH[JXݒ
	CPtrArray*	p;
	PARAMINFO *pItem;
	int length;
	p = m_pWidget->GetParamPointer();
	pItem = (PARAMINFO*) p->GetAt (0);
	if(pItem->type == PARAM_EDIT) {
		length = pItem->strValue.GetLength();
		m_edit[0]->SetSel(0, -1/*length*/, FALSE);
		m_edit[0]->SetFocus();
	}
	else {
		m_combo[0]->SetFocus();
	}
	
}

void CParamWnd::OnAppExit() 
{
	//SATELLITEIAExitj[
	char cmdline[_MAX_PATH];
	strcpy(cmdline, "exit\n");
	int i,ch,len;
	DWORD size;

	//A command is transmitted. 
	len = (int)strlen(cmdline);
	for(i=0; i<len; i++){
		ch = (unsigned char)cmdline[i];
		WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
	}
	
}
