/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ScopeFrame.cpp,v 1.5 2004/09/14 07:22:21 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"
#include "WidgetObj.h"
#include "ScopeList.h"
#include "ScopeFrame.h"
#include "MoniWnd.h"

#include "ModelWnd.h"
#include "ModelDoc.h"
#include "ModelView.h"
#include "BlockView.h"
#include "ExtncsDoc.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"
extern CExtncsMain*	g_pExtncsMain;
extern CMultiDocTemplate* g_pScopeListTemplate;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScopeFrame

IMPLEMENT_DYNCREATE(CScopeFrame, CMDIFrameWnd)

CScopeFrame::CScopeFrame()
{
}

CScopeFrame::~CScopeFrame()
{
}

BOOL CScopeFrame::Create(LPCSTR szTitle,
		LONG style			/* = WS_OVERLAPPEDWINDOW */,
		const RECT& rect	/* = rectDefault */,
		CWnd* pWnd		/* = NULL */,
		CWidget* pWidget,
		int scopeIndex)
{
	const char* pszConnectionClass =
		AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS,
					NULL,
					(HBRUSH)(COLOR_MENU+1),
					NULL);
	//o^
	m_pWidget = pWidget;
	m_pView = pWnd;
	m_scopeIndex = scopeIndex;
	m_strParent = _T(szTitle);

	return CMDIFrameWnd::Create(pszConnectionClass, szTitle,
				WS_OVERLAPPEDWINDOW/* & (~WS_MINIMIZEBOX) | WS_TABSTOP | WS_CHILD*/,
					rect, NULL, MAKEINTRESOURCE(IDR_SCOPE) );
}


BEGIN_MESSAGE_MAP(CScopeFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CScopeFrame)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_HELPINFO()
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScopeFrame bZ[W nh

BOOL CScopeFrame::PreCreateWindow(CREATESTRUCT& cs) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	return CMDIFrameWnd::PreCreateWindow(cs);
}

int CScopeFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// CScopeFrameɃACRƃ^Cg\
	// ACR\[X[h
	HICON hIcon = AfxGetApp()->LoadIcon(IDR_SCOPE);
	ASSERT(hIcon);
	// EBhEɐVACRw肷
	this->SendMessage(WM_SETICON, TRUE, (LPARAM)hIcon);
	// ^Cg
	char title[_MAX_PATH];
	sprintf(title, "Scope : %s/%s", m_strParent,m_pWidget->GetName());
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);

	// j^[\ϐXg\EBhE쐬
	CMoniWnd *pMoniWnd = new CMoniWnd;
	if(!pMoniWnd->Create( "Scope list", WS_OVERLAPPEDWINDOW,
		CRect(0, 0, 140, 240), this))
	{
		return 0;
	}
	pMoniWnd->ShowWindow(SW_SHOW);
	pMoniWnd->UpdateWindow();
	
	return 0;
}

BOOL CScopeFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ

	return CMDIFrameWnd::OnCreateClient(lpcs, pContext);
}

// m_pVieẃACExtncsViewCSubsysView
void CScopeFrame::OnDestroy() 
{
	CMDIFrameWnd::OnDestroy();

	//eɍ폜sv
#if 0
	m_pView->PostMessage(WM_DELETE_SCOPEFRAME, m_scopeIndex, 0L);
#else
	m_pView->PostMessage(WM_DELETE_SCOPEFRAME, 0, (LPARAM)(m_pWidget));
#endif
	
}


BOOL CScopeFrame::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	AfxGetApp()->WinHelp(0x20000+IDR_SCOPE, HELP_CONTEXT);
	return TRUE;
	
	//return CMDIFrameWnd::OnHelpInfo(pHelpInfo);
}

BOOL CScopeFrame::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message == WM_KEYDOWN) {
		switch( pMsg->wParam ) {
		case	VK_F1:
			// F1L[
			return TRUE;
		default:
			break;
		}
	}
	
	return CMDIFrameWnd::PreTranslateMessage(pMsg);
}

void CScopeFrame::OnAppExit() 
{
	//SATELLITEIAExitj[
	char cmdline[_MAX_PATH];
	strcpy(cmdline, "exit\n");
	int i,ch,len;
	DWORD size;

	//A command is transmitted. 
	len = (int)strlen(cmdline);
	for(i=0; i<len; i++){
		ch = (unsigned char)cmdline[i];
		WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
	}
	
}

