/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ScopePage.h,v 1.2 2004/05/19 04:11:21 yoshihiko Exp $ */

#if !defined(AFX_SCOPEPAGE_H__80DE76AA_269D_44E1_B466_DA316C227BD8__INCLUDED_)
#define AFX_SCOPEPAGE_H__80DE76AA_269D_44E1_B466_DA316C227BD8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CScopeRange _CAO

class CScopeRange : public CPropertyPage
{
	DECLARE_DYNCREATE(CScopeRange)

// RXgNV
public:
	CScopeRange();
	~CScopeRange();

// _CAO f[^
	//{{AFX_DATA(CScopeRange)
	enum { IDD = IDD_SCOPE_RANGE };
	CEdit	m_ymin;
	CEdit	m_ymax;
	CEdit	m_time;
	//}}AFX_DATA
	CScopeView*		m_pView;
	CString			m_strVmin;
	CString			m_strVmax;
	CString			m_strTime;


// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B

	//{{AFX_VIRTUAL(CScopeRange)
	public:
	virtual BOOL OnApply();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CScopeRange)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CScopeGraph _CAO

class CScopeGraph : public CPropertyPage
{
	DECLARE_DYNCREATE(CScopeGraph)

// RXgNV
public:
	CScopeGraph();
	~CScopeGraph();

// _CAO f[^
	//{{AFX_DATA(CScopeGraph)
	enum { IDD = IDD_SCOPE_GRAPH };
	CComboBox	m_width;
	CStatic	m_color;
	//}}AFX_DATA
	CScopeView*		m_pView;
	int				m_nWidth;
	COLORREF		m_nColor;


// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B

	//{{AFX_VIRTUAL(CScopeGraph)
	public:
	virtual BOOL OnApply();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CScopeGraph)
	virtual BOOL OnInitDialog();
	afx_msg void OnGraphColorSel();
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};
//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_SCOPEPAGE_H__80DE76AA_269D_44E1_B466_DA316C227BD8__INCLUDED_)
