/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ScopeWnd.cpp,v 1.3 2004/08/02 07:16:12 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "ScopeList.h"
#include "ScopeView.h"
#include "ScopeWnd.h"
#include "ScopeFrame.h"

#include "ModelWnd.h"
#include "ModelDoc.h"
#include "ModelView.h"
#include "BlockView.h"
#include "ExtncsDoc.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"
extern CExtncsMain*	g_pExtncsMain;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScopeWnd

IMPLEMENT_DYNCREATE(CScopeWnd, CMDIChildWnd)

CScopeWnd::CScopeWnd()
{
}

CScopeWnd::~CScopeWnd()
{
}

BOOL CScopeWnd::Create(LPCSTR szTitle,
		LONG style			/* = WS_OVERLAPPEDWINDOW */,
		const RECT& rect	/* = rectDefault */,
		CWnd* pScopeFrame			/* = CScopeList */,
		CWnd* pScopeList			/* = CScopeList */,
		char* varname,
		int varindex)
{
	const char* pszConnectionClass =
		AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS,
					NULL,
					(HBRUSH)(COLOR_MENU+1),
					NULL);
	//MDIt[|C^
	m_pWidget = ((CScopeFrame*)pScopeFrame)->m_pWidget;
	m_pScopeList = pScopeList;
	m_strVarname = _T(varname);
	m_nVarIndex = varindex;
	//o^
	return CMDIChildWnd::Create(pszConnectionClass, szTitle,
				WS_OVERLAPPEDWINDOW & (~WS_MINIMIZEBOX) | WS_TABSTOP | WS_CHILD | WS_VISIBLE,
					rect, (CScopeFrame*)pScopeFrame, NULL );
}


BEGIN_MESSAGE_MAP(CScopeWnd, CMDIChildWnd)
	//{{AFX_MSG_MAP(CScopeWnd)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScopeWnd bZ[W nh

BOOL CScopeWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
	//^CgύX
	cs.style &= ~FWS_ADDTOTITLE;
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	return TRUE;
}

int CScopeWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// ACR\[X[h
	HICON hIcon = AfxGetApp()->LoadIcon(IDR_SCOPE);
	ASSERT(hIcon);
	// EBhEɐVACRw肷
	this->SendMessage(WM_SETICON, TRUE, (LPARAM)hIcon);
	
	// ^Cg
	char title[_MAX_PATH];
	sprintf(title, "%s:%s", m_pWidget->GetName(),m_strVarname);
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);

	// CScopeViewA^b`
	CRuntimeClass* pNewViewClass;
	pNewViewClass = RUNTIME_CLASS(CScopeView);
	CCreateContext context;
	context.m_pNewViewClass = pNewViewClass;
	context.m_pCurrentDoc = NULL;
	CView* pNewView = STATIC_DOWNCAST(CView, CreateView(&context));
	if (pNewView != NULL)
	{
		// the new view is there, but invisible and not active...
		((CScopeView*)pNewView)->m_pParentWnd = this;
		pNewView->ShowWindow(SW_SHOW);
		pNewView->OnInitialUpdate();
		SetActiveView(pNewView);
		RecalcLayout();
		m_pScopeView = pNewView;
	}
	else
		m_pScopeView = NULL;

	return 0;
}

CDocument* CScopeWnd::GetActiveDocument() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	return CMDIChildWnd::GetActiveDocument();
}

void CScopeWnd::OnDestroy() 
{
	CMDIChildWnd::OnDestroy();
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	m_pScopeList->PostMessage(WM_DELETE_SCOPEWND, m_nVarIndex,
		0L/*(LPARAM)((LPCTSTR)m_strVarname)*/);
	
}

// Scope:ݒsScopeCfbNX
void CScopeWnd::ScopeSet(int scope, double simtime, double simstep, int cycle, int size)
{
	CScopeView* pScopeView = (CScopeView*)m_pScopeView;
	if(m_pScopeView) {
		pScopeView->UpdateInit(scope, simtime, simstep, cycle, size);
	}
}

// index:XVScopeCfbNX
void CScopeWnd::ScopeUpdate(int cycle, int index, int size, float* data)
{
	CScopeView* pScopeView = (CScopeView*)m_pScopeView;
	if(m_pScopeView) {
		pScopeView->UpdateData(cycle, index, size, data);
	}
}

void CScopeWnd::OnAppExit() 
{
	//SATELLITEIAExitj[
	char cmdline[_MAX_PATH];
	strcpy(cmdline, "exit\n");
	int i,ch,len;
	DWORD size;

	//A command is transmitted. 
	len = (int)strlen(cmdline);
	for(i=0; i<len; i++){
		ch = (unsigned char)cmdline[i];
		WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
	}
	
}
