/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SimuWnd.cpp,v 1.4 2004/09/01 07:38:35 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"
#include "SimuWnd.h"
#include "ExtncsDoc.h"
#include "ExtncsView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern	BOOL	simu_exit;		//~tO

/////////////////////////////////////////////////////////////////////////////
// CSimuWnd

IMPLEMENT_DYNCREATE(CSimuWnd, CFrameWnd)

CSimuWnd::CSimuWnd()
{
	m_pCtrl = NULL;
	m_backColor = RGB(128,255,255);
	m_foreColor = RGB(0, 0, 0);
	m_fSimulation = FALSE;
}

CSimuWnd::~CSimuWnd()
{
}

BOOL CSimuWnd::Create(LPCSTR szTitle,
		LONG style			/* = WS_OVERLAPPEDWINDOW */,
		const RECT& rect	/* = rectDefault */,
		CView* pView		/* = NULL */,
		CDocument* pDoc)
{
	const char* pszConnectionClass =
		AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS,
					NULL,
					//(HBRUSH)(COLOR_WINDOW+1),
					(HBRUSH)(COLOR_MENU+1),
					NULL);
	//eEBhE
	m_pExtncsView = pView;
	m_rect = rect;
	m_pExtncsDoc = pDoc;
	return CFrameWnd::Create(pszConnectionClass, szTitle,
				WS_OVERLAPPEDWINDOW & (~WS_MINIMIZEBOX) | WS_TABSTOP,
					rect, pView, NULL, WS_EX_CONTROLPARENT );
}


BEGIN_MESSAGE_MAP(CSimuWnd, CFrameWnd)
	//{{AFX_MSG_MAP(CSimuWnd)
	ON_WM_CREATE()
	ON_COMMAND(ID_SIMU_QUIT, OnSimuQuit)
	ON_UPDATE_COMMAND_UI(ID_SIMU_QUIT, OnUpdateSimuQuit)
	ON_COMMAND(ID_SIMU_START, OnSimuStart)
	ON_UPDATE_COMMAND_UI(ID_SIMU_START, OnUpdateSimuStart)
	ON_COMMAND(ID_SIMU_STOP, OnSimuStop)
	ON_UPDATE_COMMAND_UI(ID_SIMU_STOP, OnUpdateSimuStop)
	ON_WM_HELPINFO()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSimuWnd bZ[W nh

int CSimuWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	//tHg
	m_font.CreateFont(12,
		0,0,0,FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,
		OUT_STROKE_PRECIS,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
		DEFAULT_PITCH,_T("MS PSVbN"));
	// °ް̍쐬
	if (!m_toolBar.Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_TOOLTIPS) ||
		!m_toolBar.LoadToolBar(IDR_TOOLBAR_SIMU))
	{
		//쐬Ɏs̏
		AfxMessageBox("m_toolBar.CreateɎs܂B", MB_OK, NULL);
		return 1;
	}
	// °ް̻ގ擾
	m_sizeToolBar = m_toolBar.CalcFixedLayout(FALSE, TRUE);
	// ACR\[X[h
	HICON hIcon = AfxGetApp()->LoadIcon(IDI_EXTNCS);
	ASSERT(hIcon);
	// EBhEɐVACRw肷
	this->SendMessage(WM_SETICON, TRUE, (LPARAM)hIcon);
	
	//^Cg
	char title[_MAX_PATH];
	strcpy(title, "Setting conditions");
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);

	//\쐬
	int ymax = SimuInitialize();
	int cxborder,cyborder,cycaption;
	cxborder = GetSystemMetrics(SM_CXEDGE);
	cyborder = GetSystemMetrics(SM_CYEDGE);
	cycaption = GetSystemMetrics(SM_CYSMCAPTION);

	//EɈړ
	CRect rect;
	int xp;
	m_pExtncsView->GetClientRect(&rect);
	xp = rect.right-(30 + STATIC_WIDTH + 2*cxborder);
	this->MoveWindow(xp/*m_rect.top*/, 0/*m_rect.left*/,
		30 + STATIC_WIDTH + 2*cxborder, 10+m_sizeToolBar.cy+2*cyborder+cycaption+ymax, TRUE);
	
	return 0;
}

int CSimuWnd::SimuInitialize()
{
	int		x,y;
	CFont*	pOldFont;

	CDC*	dc = GetDC();
	pOldFont = dc->SelectObject(&m_font);
	// Simulation time
	x = 10; y = m_sizeToolBar.cy + 10;
	SimuInitializeTime(x, y);
	// Step size
	x=10;
	y += (STATIC_HEIGHT+EDIT_HEIGHT);
	y += 10;
	SimuInitializeStep(x, y);

	// Save size
	x=10;
	y += (STATIC_HEIGHT+EDIT_HEIGHT);
	y += 10;
	SimuInitializeSave(x, y);
	// Intergral
	x=10;
	y += (STATIC_HEIGHT+EDIT_HEIGHT);
	y += 10;
	SimuInitializeInteg(x, y);
	// Compiler
	//x=10;
	//y += (STATIC_HEIGHT+EDIT_HEIGHT);
	//y += 10;
	//SimuInitializeComp(x, y);
	// Compiler
	x=10;
	y += (STATIC_HEIGHT+EDIT_HEIGHT);
	y += 10;
	SimuInitializeClock(x, y);
	y += STATIC_HEIGHT;
	y += 10;
	//IP
	SimuInitializeIp(x,y);
	y += IP_HEIGHT;
	y += 10;

	dc->SelectObject(pOldFont);
	ReleaseDC( dc );

	//tH[JXݒ
	m_pCtrl = m_timeData;
	m_pCtrl->SetFocus();
	((CEdit *)m_pCtrl)->SetSel(0, -1, FALSE);

	//
	SetMode(FALSE);

	return y;
}

void CSimuWnd::SimuInitializeIp(int xp, int yp)
{
	int		x,y;
	x=xp; y=yp;
	m_ipText = new CColorStatic;
	m_ipText->Create("IP Address", WS_CHILD | WS_VISIBLE | WS_DLGFRAME,
			CRect(x, y, x+STATIC_WIDTH, y+STATIC_HEIGHT), this, ID_EXTNCS_SIMU_IP_TEXT);
	m_ipText->SetFont(&m_font);
	m_ipText->SetColors(RGB(0,0,0),GetSysColor(COLOR_MENU));
	//IP control;
	y += STATIC_HEIGHT;
	m_ipData = new CIPAddressCtrl;
	m_ipData->Create(WS_CHILD | WS_VISIBLE | WS_TABSTOP | ES_AUTOHSCROLL,
				CRect(x, y, x+IP_WIDTH, y+IP_HEIGHT), this, ID_EXTNCS_SIMU_IP_DATA);
	m_ipData->SetFont(&m_font);
	m_ipData->SetAddress(172,28,210,1);
}

void CSimuWnd::SimuInitializeTime(int xp, int yp)
{
	int		x,y;
	CExtncsDoc* pExtncsDoc = (CExtncsDoc*)m_pExtncsDoc;
	x=xp; y=yp;
	m_timeText = new CColorStatic;
	m_timeText->Create("Simulation time", WS_CHILD | WS_VISIBLE | WS_DLGFRAME,
			CRect(x, y, x+STATIC_WIDTH, y+STATIC_HEIGHT), this, ID_EXTNCS_SIMU_TIME_TEXT);
	m_timeText->SetFont(&m_font);
	m_timeText->SetColors(RGB(0,0,0),GetSysColor(COLOR_MENU));
	//edit;
	y += STATIC_HEIGHT;
	m_timeData = new CColorEdit;
	m_timeData->Create(WS_CHILD | WS_VISIBLE | WS_TABSTOP | ES_AUTOHSCROLL,
				CRect(x, y, x+EDIT_WIDTH+SPIN_WIDTH, y+EDIT_HEIGHT), this, ID_EXTNCS_SIMU_TIME_DATA);
	m_timeData->SetFont(&m_font);
	m_timeData->SetColors(RGB(0,0,0), m_backColor);
	m_timeData->SetWindowText(pExtncsDoc->m_strTime);
	//Waku(x, y);
}

void CSimuWnd::SimuInitializeStep(int xp, int yp)
{
	int x,y;
	CExtncsDoc* pExtncsDoc = (CExtncsDoc*)m_pExtncsDoc;
	x = xp; y = yp;
	//text
	m_stepText = new CColorStatic;
	m_stepText->Create("Step size", WS_CHILD | WS_VISIBLE | WS_DLGFRAME,
			CRect(x, y, x+STATIC_WIDTH, y+STATIC_HEIGHT), this, ID_EXTNCS_SIMU_STEP_TEXT);
	m_stepText->SetFont(&m_font);
	m_stepText->SetColors(RGB(0,0,0),GetSysColor(COLOR_MENU));
	//data
	y += STATIC_HEIGHT;
	m_stepData = new CColorEdit;
	m_stepData->Create(WS_VISIBLE | WS_TABSTOP | ES_AUTOHSCROLL,
				CRect(x, y, x+EDIT_WIDTH+SPIN_WIDTH, y+EDIT_HEIGHT), this, ID_EXTNCS_SIMU_STEP_DATA);
	m_stepData->SetFont(&m_font);
	m_stepData->SetColors(RGB(0,0,0), m_backColor);
	m_stepData->SetWindowText(pExtncsDoc->m_strStep);
	//Waku(x, y);
}

void CSimuWnd::SimuInitializeSave(int xp, int yp)
{
	int x,y;
	CExtncsDoc* pExtncsDoc = (CExtncsDoc*)m_pExtncsDoc;

	x = xp; y = yp;
	//text
	m_saveText = new CColorStatic;
	m_saveText->Create("Save size", WS_CHILD | WS_VISIBLE | WS_DLGFRAME,
			CRect(x, y, x+STATIC_WIDTH, y+STATIC_HEIGHT), this, ID_EXTNCS_SIMU_SAVE_TEXT);
	m_saveText->SetFont(&m_font);
	m_saveText->SetColors(RGB(0,0,0),GetSysColor(COLOR_MENU));
	//edit;
	y += STATIC_HEIGHT;
	m_saveData = new CColorEdit;
	m_saveData->Create(WS_VISIBLE | WS_TABSTOP | ES_AUTOHSCROLL,
				CRect(x, y, x+EDIT_WIDTH+SPIN_WIDTH, y+EDIT_HEIGHT), this, ID_EXTNCS_SIMU_SAVE_DATA);
	m_saveData->SetFont(&m_font);
	m_saveData->SetColors(RGB(0,0,0), m_backColor);
	m_saveData->SetWindowText(pExtncsDoc->m_strSave);
	//Waku(x, y);
}

void CSimuWnd::SimuInitializeInteg(int xp, int yp)
{
	int x,y;
	CExtncsDoc* pExtncsDoc = (CExtncsDoc*)m_pExtncsDoc;

	x = xp; y = yp;
	//text
	m_integText = new CColorStatic;
	m_integText->Create("Integral method", WS_CHILD | WS_VISIBLE | WS_DLGFRAME,
			CRect(x, y, x+STATIC_WIDTH, y+STATIC_HEIGHT), this, ID_EXTNCS_SIMU_INTEG_TEXT);
	m_integText->SetFont(&m_font);
	m_integText->SetColors(RGB(0,0,0),GetSysColor(COLOR_MENU));
	// data
	y += STATIC_HEIGHT;
	m_integData = new CColorComboBox;
	m_integData->Create(WS_VISIBLE | CBS_DROPDOWNLIST | WS_TABSTOP | WS_VSCROLL,
				CRect(x, y, x+COMBO_WIDTH, y+COMBO_HEIGHT*4), this, ID_EXTNCS_SIMU_INTEG_DATA);
	m_integData->SetFont(&m_font);
	m_integData->SetColors(RGB(0,0,0), m_backColor);
	m_integData->AddString("Euler");
	m_integData->AddString("Runge");
	m_integData->AddString("Adaptive");
	//ؽđI
	m_integData->SetCurSel(pExtncsDoc->m_nInteg);
}
void CSimuWnd::SimuInitializeComp(int xp, int yp)
{
	int	x,y;
	x = xp; y = yp;
	//text
	m_compText = new CColorStatic;
	m_compText->Create("Compiler", WS_CHILD | WS_VISIBLE | WS_DLGFRAME,
			CRect(x, y, x+STATIC_WIDTH, y+STATIC_HEIGHT), this, ID_EXTNCS_SIMU_COMP_TEXT);
	m_compText->SetFont(&m_font);
	m_compText->SetColors(RGB(0,0,0),GetSysColor(COLOR_MENU));
	//data
	y += STATIC_HEIGHT;
	m_compData = new CColorComboBox;
	m_compData->Create(WS_VISIBLE | CBS_DROPDOWNLIST | WS_TABSTOP | WS_VSCROLL,
				CRect(x, y, x+COMBO_WIDTH, y+COMBO_HEIGHT*3), this, ID_EXTNCS_SIMU_COMP_DATA);
	m_compData->SetFont(&m_font);
	m_compData->SetColors(RGB(0,0,0), m_backColor);
	m_compData->AddString("Borland");
	m_compData->AddString("Microsoft");
	//ؽđI
	m_compData->SetCurSel(0);
}
void CSimuWnd::SimuInitializeClock(int xp, int yp)
{
	int x, y;
	CExtncsDoc* pExtncsDoc = (CExtncsDoc*)m_pExtncsDoc;

	x = xp; y = yp;
	m_clock = new CButton;
	m_clock->Create("Realtime mode", WS_VISIBLE | BS_AUTOCHECKBOX | WS_TABSTOP,
				CRect(x, y, x+CHECK_WIDTH, y+CHECK_HEIGHT), this, ID_EXTNCS_SIMU_REALTIME);
	m_clock->SetFont(&m_font);
	m_clock->SetCheck(pExtncsDoc->m_bRtmode);

}

void CSimuWnd::Waku(int x, int y)
{
	CRect rect, rect3d;
	CDC *dc = GetDC();

	rect.left = x;
	rect.top = y;
	rect.right = x + EDIT_WIDTH + SPIN_WIDTH;
	rect.bottom = y + EDIT_HEIGHT;

	rect3d.left = x+1;
	rect3d.top = y+1;
	rect3d.right = x + EDIT_WIDTH + SPIN_WIDTH +1;
	rect3d.bottom = y + EDIT_HEIGHT+1;
	COLORREF topColor = GetSysColor(COLOR_3DLIGHT);
	COLORREF bottomColor = GetSysColor(COLOR_3DDKSHADOW);
	dc->Draw3dRect( &rect, bottomColor, topColor );
	dc->Draw3dRect( &rect3d, bottomColor, topColor );
	ReleaseDC(dc);
}

BOOL CSimuWnd::PreTranslateMessage(MSG* pMsg) 
{
	CWnd *pWnd;
	int id;
	if(pMsg->message == WM_KEYDOWN) {
		switch( pMsg->wParam ) {
		case	VK_F1:
			return TRUE;
		case	VK_RETURN:
			// EnterL[
			break;
		case	VK_ESCAPE:
			// EscL[
			break;
		case	VK_TAB:
			// TabL[
			pWnd = GetNextDlgTabItem(m_pCtrl, FALSE);
			pWnd->SetFocus();
			m_pCtrl = pWnd;
			//I
			id = pWnd->GetDlgCtrlID(); 
			if((id == ID_EXTNCS_SIMU_TIME_DATA) || (id == ID_EXTNCS_SIMU_STEP_DATA) ||
				(id == ID_EXTNCS_SIMU_SAVE_DATA))
				((CEdit *)m_pCtrl)->SetSel(0, -1, FALSE);
			return TRUE;
		default:
			break;
		}
	}
	
	return CFrameWnd::PreTranslateMessage(pMsg);
}

void CSimuWnd::OnSimuQuit() 
{
	//
	if(!GetConditions())
		return;
	//
	this->PostMessage(WM_CLOSE, 0, 0L);	
	
}

void CSimuWnd::OnUpdateSimuQuit(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CSimuWnd::OnSimuStart() 
{
	//
	if(!GetConditions())
		return;
	//Start
	m_fSimulation = TRUE;
	//ScriptƎs
	((CExtncsView*)m_pExtncsView)->SimuInit();
	((CExtncsView*)m_pExtncsView)->SimuExe();
	
}

void CSimuWnd::OnUpdateSimuStart(CCmdUI* pCmdUI) 
{
	if(((CExtncsView*)m_pExtncsView)->m_fSimuState)
		pCmdUI->SetCheck(1);
		//pCmdUI->Enable(TRUE);
	else
		pCmdUI->SetCheck(0);	
		//pCmdUI->Enable(FALSE);	
	
}

void CSimuWnd::OnSimuStop() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	simu_exit = TRUE;		//~tO𗧂Ă
	
}

void CSimuWnd::OnUpdateSimuStop(CCmdUI* pCmdUI) 
{
	if(((CExtncsView*)m_pExtncsView)->m_fSimuState)
		pCmdUI->SetCheck(0);
		//pCmdUI->Enable(TRUE);
	else
		pCmdUI->SetCheck(1);	
		//pCmdUI->Enable(FALSE);		
}

//ݒ
//V~[Vł́AstrStepstrSave͓lłKv
BOOL CSimuWnd::GetConditions()
{
	CExtncsDoc* pExtncsDoc = (CExtncsDoc*)m_pExtncsDoc;
	CString strStep,strSave,strTime;
	double stepTime,saveTime,simTime;

	m_timeData->GetWindowText(strTime);
	simTime=atof(strTime);
	m_stepData->GetWindowText(strStep);
	stepTime=atof(strStep);
	m_saveData->GetWindowText(strSave);
	saveTime=atof(strSave);
	if(simTime < stepTime || simTime < saveTime || stepTime > saveTime) {
		AfxMessageBox("Ilegall parameter", MB_OK, NULL);
		return FALSE;
	}

	//stepTimesaveTimeقȂĂ瓯l

	pExtncsDoc->m_strTime = strTime;
	pExtncsDoc->m_strStep = strStep;
	pExtncsDoc->m_strSave = strSave;
	if(saveTime != stepTime)
		pExtncsDoc->m_strSave = strStep;
	pExtncsDoc->m_nInteg = m_integData->GetCurSel();
	if(pExtncsDoc->m_nInteg == CB_ERR)
		pExtncsDoc->m_nInteg = 0;		// Eulerɐݒ
	pExtncsDoc->m_bRtmode = m_clock->GetCheck();
	return TRUE;
}

//{^
//
void CSimuWnd::SetMode(int mode)
{
}

BOOL CSimuWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
	cs.style &= ~FWS_ADDTOTITLE;
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	
	return TRUE;
}

BOOL CSimuWnd::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	AfxGetApp()->WinHelp(0x20000+IDR_TOOLBAR_SIMU, HELP_CONTEXT);
	return TRUE;
	
	//return CFrameWnd::OnHelpInfo(pHelpInfo);
}

void CSimuWnd::OnDestroy() 
{
	//Rg[̍폜
	delete m_timeText;
	delete m_timeData;
	delete m_stepText;
	delete m_stepData;
	delete m_saveText;
	delete m_saveData;
	delete m_integText;
	delete m_integData;
	//delete m_compText;
	//delete m_compData;
	delete m_clock;
	delete m_ipText;
	delete m_ipData;
	//destroy pWnd=NULLɂ
	m_pExtncsView->PostMessage(WM_DELETE_SIMU, 0, 0L);

	CFrameWnd::OnDestroy();
	//Rg[̍폜
	//delete m_timeText;
	//delete m_timeData;
	//delete m_stepText;
	//delete m_stepData;
	//delete m_saveText;
	//delete m_saveData;
	//delete m_integText;
	//delete m_integData;
	//delete m_compText;
	//delete m_compData;
	//delete m_clock;
	//delete m_ipText;
	//delete m_ipData;
	//destroy pWnd=NULLɂ
	//m_pExtncsView->PostMessage(WM_DELETE_SIMU, 0, 0L);
	
}
