/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SimuWnd.h,v 1.2 2004/05/19 04:11:21 yoshihiko Exp $ */

#if !defined(AFX_SIMUWND_H__675D42C9_FBBD_40D0_81EB_817CBFF598CA__INCLUDED_)
#define AFX_SIMUWND_H__675D42C9_FBBD_40D0_81EB_817CBFF598CA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ColorEdit.h"

/////////////////////////////////////////////////////////////////////////////
// CSimuWnd t[

class CSimuWnd : public CFrameWnd
{
	DECLARE_DYNCREATE(CSimuWnd)
public:
	CSimuWnd();           // IɎgpveNg RXgN^B

// Agr[g
public:

// Iy[V
public:
	//method
	BOOL Create(LPCSTR szTitle, LONG style = 0,
			const RECT& rect = rectDefault,
			CView* pView = NULL, CDocument* pDocument = NULL);
	int			SimuInitialize();
	void		SimuInitializeTime(int x, int y);
	void		SimuInitializeStep(int x, int y);
	void		SimuInitializeSave(int x, int y);
	void		SimuInitializeInteg(int x, int y);
	void		SimuInitializeComp(int x, int y);
	void		SimuInitializeClock(int x, int y);
	void		SimuInitializeIp(int x, int y);
	void		Waku(int x, int y);
	BOOL		GetConditions();
	void		SetMode(int mode);
	//data
	CRect	m_rect;
	CFont	m_font;
	CView*		m_pExtncsView;
	CDocument*		m_pExtncsDoc;
	CWnd*				m_pCtrl;
	CColorStatic	*m_timeText;
	CColorEdit		*m_timeData;
	CColorStatic	*m_stepText;
	CColorEdit		*m_stepData;
	CColorStatic	*m_saveText;
	CColorEdit		*m_saveData;
	CColorStatic	*m_integText;
	CColorComboBox	*m_integData;
	CColorStatic	*m_compText;
	CColorComboBox	*m_compData;
	CButton	*m_clock;
	COLORREF		m_backColor;
	COLORREF		m_foreColor;
	CToolBar		m_toolBar;
	CSize			m_sizeToolBar;
	BOOL			m_fSimulation;
	CColorStatic	*m_ipText;
	CIPAddressCtrl	*m_ipData;

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂

	//{{AFX_VIRTUAL(CSimuWnd)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Cve[V
protected:
	virtual ~CSimuWnd();

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CSimuWnd)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSimuQuit();
	afx_msg void OnUpdateSimuQuit(CCmdUI* pCmdUI);
	afx_msg void OnSimuStart();
	afx_msg void OnUpdateSimuStart(CCmdUI* pCmdUI);
	afx_msg void OnSimuStop();
	afx_msg void OnUpdateSimuStop(CCmdUI* pCmdUI);
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_SIMUWND_H__675D42C9_FBBD_40D0_81EB_817CBFF598CA__INCLUDED_)
