/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SubsysDoc.cpp,v 1.4 2004/08/02 07:16:12 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "SubsysDoc.h"
#include "ExtncsDoc.h"
#include "SubsysView.h"
#include ".\subsysdoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSubsysDoc

IMPLEMENT_DYNCREATE(CSubsysDoc, CDocument)

CSubsysDoc::CSubsysDoc()
{
	m_nLineIndex = 0;
	//EBhEǗ̈
	int i;
	for(i = 0; i < MAX_SUBSYSTEM; i++)
		m_bSubsysWnd[i] = FALSE;
	for(i = 0; i < MAX_SCOPE; i++)
		m_bScopeWnd[i] = FALSE;
}

BOOL CSubsysDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

CSubsysDoc::~CSubsysDoc()
{
}


BEGIN_MESSAGE_MAP(CSubsysDoc, CDocument)
	//{{AFX_MSG_MAP(CSubsysDoc)
	ON_COMMAND(ID_FILE_CLOSE, OnFileClose)
	ON_UPDATE_COMMAND_UI(ID_FILE_CLOSE, OnUpdateFileClose)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_UPDATE_COMMAND_UI(ID_FILE_NEW, OnUpdateFileNew)
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, OnUpdateFileSaveAs)
	ON_UPDATE_COMMAND_UI(ID_NCS_EXTNCS, OnUpdateNcsExtncs)
	ON_UPDATE_COMMAND_UI(ID_EXTNCS_NCS, OnUpdateExtncsNcs)
	//}}AFX_MSG_MAP
//	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
ON_COMMAND(ID_FILE_SAVE, OnFileSave)
ON_COMMAND(ID_EXTNCS_CODE, OnExtncsCode)
ON_UPDATE_COMMAND_UI(ID_EXTNCS_CODE, OnUpdateExtncsCode)
ON_COMMAND(ID_EXTNCS_COMPILE, OnExtncsCompile)
ON_UPDATE_COMMAND_UI(ID_EXTNCS_COMPILE, OnUpdateExtncsCompile)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSubsysDoc ff

#ifdef _DEBUG
void CSubsysDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CSubsysDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSubsysDoc VACY

void CSubsysDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂ
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂ
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSubsysDoc R}h

void CSubsysDoc::DeleteContents() 
{
#if 0
	// Subsystemō\zĂWidgetsLineśASăCŊǗ
	if(m_pWidget) {

	// Widget
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int i = pArrWidgets->GetSize ();
	while (i)
		delete (CWidget*) pArrWidgets->GetAt(--i);
	pArrWidgets->RemoveAll ();
	// Line
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();
	i = pArrLines->GetSize ();
	while (i)
		delete pArrLines->GetAt(--i);
	pArrLines->RemoveAll ();
	}
#endif
	
	CDocument::DeleteContents();
}

void CSubsysDoc::AllDeleteContents() 
{
	if(m_pWidget) {

	// Widget
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int i = (int)pArrWidgets->GetSize ();
	while (i)
		delete (CWidget*) pArrWidgets->GetAt(--i);
	pArrWidgets->RemoveAll ();
	// Line
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();
	i = (int)pArrLines->GetSize ();
	while (i)
		delete (CLine*) pArrLines->GetAt(--i);
	pArrLines->RemoveAll ();
	}
}

// SubsystemAWidgetLine폜
void CSubsysDoc::SubDeleteContents(CWidget *pTargetWidget) 
{
	if(!pTargetWidget)
		return;

	int i;
	CWidget* pWidget;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();
	CLine* pLine;
	CPtrArray* pArrLines = pTargetWidget->GetLinesPointer();

	// Widget
	i = (int)pArrWidgets->GetSize ();
	while (i) {
		pWidget =  (CWidget*)pArrWidgets->GetAt(--i);
		if(pWidget->GetId() == M_SUBSYSTEM)
			SubDeleteContents(pWidget);
		delete pWidget;
	}
	pArrWidgets->RemoveAll ();
	// Line
	i = (int)pArrLines->GetSize ();
	while (i) {
		pLine = (CLine*)pArrLines->GetAt(--i);
		delete pLine;
	}
	pArrLines->RemoveAll ();

	//ŁASubsystemWidgetsLines͍폜Ă
	CSubsysDoc* pDoc = (CSubsysDoc*)pTargetWidget->GetDocument();
	if(pDoc)
		pDoc->m_pWidget = NULL;
}

int CSubsysDoc::GetWidgetCount()
{
	//return m_arrWidgets.GetSize ();
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	return (int)pArrWidgets->GetSize();
}

CWidget* CSubsysDoc::GetWidget(int nIndex)
{
	//if (nIndex >= m_arrWidgets.GetSize ())
	//	return NULL;
	//return (CWidget*) m_arrWidgets[nIndex];

	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	if (nIndex >= pArrWidgets->GetSize ())
		return NULL;
	return (CWidget*)pArrWidgets->GetAt(nIndex);
}

// AddWidget 1
int CSubsysDoc::AddWidget(int id, int x, int y, int cx, int cy, COLORREF color, char *name)
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int nIndex = -1;
	CWidget* pWidget = NULL;

	try {
		pWidget = new CWidget (id, x, y, cx, cy, color, name);
		nIndex = (int)pArrWidgets->Add (pWidget);	
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

// AddWidget 2
// mode = 1̏ꍇ͈ړ
int CSubsysDoc::AddWidget(int id, CPoint point, char *name, int direction, CString matrix, int cx, int cy)
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int nIndex = -1;
	CWidget* pWidget;
	int i,nCount,index;
	char blkname[128];
	char idname[16];
	BLOCKINFO *pItem;

	//OύXAidւ̑Ώ
	nCount = (int)pArrWidgets->GetSize ();
	index = 0;
	if(!name) {
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) pArrWidgets->GetAt(i);
			if(id == pWidget->GetId()) {
				index++;
			}
		}
	}

	//Widget̐
	pWidget = NULL;
	try {
		pWidget = new CWidget (point, id, cx, cy);
		pItem = pWidget->GetPitem();
		if(!name) {
			strcpy(blkname, pItem->name);
			if(index > 0) {
				sprintf(idname,"%d",index);
				strcat(blkname, idname);
			}
			pWidget->SetName(CString(blkname));
		}
		else
			pWidget->SetName(CString(name));
		pWidget->SetDirection( direction );
		pWidget->SetMatrix( matrix );
		//TODO:2004/02/24
		// inport name
		if(pItem->inport != 0)
			pWidget->SetInportName(&(pItem->inpname));
		// outport name
		if(pItem->outport != 0)
			pWidget->SetOutportName(&(pItem->outpname));
		// Subsystemǉ
		if(id == M_SUBSYSTEM) {
			InitSubsystem(pWidget, pItem->inport, pItem->outport);
		}
		nIndex = (int)pArrWidgets->Add (pWidget);	
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("AddWidget function:Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

// CWidgetm_arrWidgetsm_arrLines
void CSubsysDoc::InitSubsystem(CWidget* pWidget, int inpnum, int outpnum)
{
	int i,x,y,index;
	CRect rect;
	CPoint pos;
	CString strName;
	char name[_MAX_PATH];

	x = 32;
	y = 32;
	strName = _T("Inport");
	for(i = 0; i < inpnum; i++) {
		pos = CPoint(x, y);
		strcpy(name, strName);
		//if(i > 0) {
		//	strcat(name, "_");
		//	ChangeName(name);
		//}
		index = AddSubWidget (pWidget, M_INPORT, pos, name, DIR_RIGHT, _T("1:1"), 32, 32);
		y = y + 64;
	}
	x += 64;
	y = 32;
	strName = _T("Outport");
	for(i = 0; i < outpnum; i++) {
		pos = CPoint(x, y);
		strcpy(name, strName);
		//if(i > 0) {
		//	strcat(name, "_");
		//	ChangeName(name);
		//}
		index = AddSubWidget (pWidget, M_OUTPORT, pos, name, DIR_RIGHT, _T("1:1"), 32, 32);
		y = y + 64;
	}

	//LineIndex
	pWidget->SetLineIndex(0);

}

//Subsystem\Widgeto^
int CSubsysDoc::AddSubWidget(CWidget* pTargetWidget, int id, CPoint point, char *name,
							 int direction, CString matrix, int cx, int cy)
{
	int nIndex = -1;
	CWidget* pWidget;
	int i,nCount,index;
	char blkname[128];
	char idname[16];
	BLOCKINFO *pItem;
	CPtrArray* pArrWidgets;

	//pTargetWidgetm_arrWidgets擾
	pArrWidgets = pTargetWidget->GetWidgetsPointer();
	//OύXAidւ̑Ώ
	nCount = (int)pArrWidgets->GetSize ();
	index = 0;
	if(!name) {
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) pArrWidgets->GetAt(i);
			if(id == pWidget->GetId()) {
				index++;
			}
		}
	}

	//Widget̐
	pWidget = NULL;
	try {
		pWidget = new CWidget (point, id, cx, cy);
		pItem = pWidget->GetPitem();
		if(!name) {
			strcpy(blkname, pItem->name);
			if(index > 0) {
				sprintf(idname,"%d",index);
				strcat(blkname, idname);
			}
			pWidget->SetName(CString(blkname));
		}
		else
			pWidget->SetName(CString(name));
		// direction
		pWidget->SetDirection( direction );
		// matrix
		pWidget->SetMatrix( matrix );
		// inport name
		if(pItem->inport != 0)
			pWidget->SetInportName(&(pItem->inpname));
		// outport name
		if(pItem->outport != 0)
			pWidget->SetOutportName(&(pItem->outpname));
		// Subsystemǉ
		//if(id == M_SUBSYSTEM) {
		//	InitSubsystem(pWidget, pItem->inport, pItem->outport);
		//}
		//m_arrWidgetsɃW[ǉ
		nIndex = (int)pArrWidgets->Add (pWidget);	
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("AddWidget function:Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

// AddWidget
// p[^[܂
int CSubsysDoc::AddSubWidget2(CWidget* pTargetWidget, int id, CPoint point, char *name,
	 int direction, CString matrix, int nParam, char strValue[][16], int width, int height)
{
	int nIndex = -1;
	CWidget* pWidget;
	int i,nCount,index;
	char blkname[128];
	char idname[16];
	BLOCKINFO *pItem;
	CPtrArray*	prm;
	PARAMINFO *prmItem;
	SCOPEINFO *scopeItem;
	int prmCount;
	CPtrArray* pArrWidgets;

	//pTargetWidgetm_arrWidgets擾
	pArrWidgets = pTargetWidget->GetWidgetsPointer();
	//OύXAidւ̑Ώ
	nCount = (int)pArrWidgets->GetSize ();
	index = 0;
	if(!name) {
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) pArrWidgets->GetAt(i);
			if(id == pWidget->GetId()) {
				index++;
			}
		}
	}

	//Widget̐
	pWidget = NULL;
	try {
		pWidget = new CWidget (point, id, width, height);
		if(!name) {
			pItem = pWidget->GetPitem();
			strcpy(blkname, pItem->name);
			if(index > 0) {
				sprintf(idname,"%d",index);
				strcat(blkname, idname);
			}
			pWidget->SetName(CString(blkname));
		}
		else
			pWidget->SetName(CString(name));
		pWidget->SetDirection( direction );
		pWidget->SetMatrix(matrix);
		//p[^[
		prm = pWidget->GetParamPointer();
		prmCount = (int)prm->GetSize();
		for (i=0; i<prmCount; i++) {
			//PARAMINFO
			prmItem = (PARAMINFO*) prm->GetAt (i);
			prmItem->strValue = _T(strValue[i]);
		}
		//ScopeɃTCYݒ
		prm = pWidget->GetScopePointer();
		prmCount = (int)prm->GetSize();
		for (i=0; i<prmCount; i++) {
			//PARAMINFO
			scopeItem = (SCOPEINFO*) prm->GetAt (i);
			scopeItem->size = pWidget->GetCellRow() * pWidget->GetCellColumn();
		}

		//Widgetǉ
		nIndex = (int)pArrWidgets->Add (pWidget);	
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("AddWidget function:Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

// AddWidget
// p[^[܂
int CSubsysDoc::AddWidget2(int id, CPoint point, char *name,
	 int direction, CString matrix, int nParam, char strValue[][16], int width, int height)
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int nIndex = -1;
	CWidget* pWidget;
	int i,nCount,index;
	char blkname[128];
	char idname[16];
	BLOCKINFO *pItem;
	CPtrArray*	prm;
	PARAMINFO *prmItem;
	SCOPEINFO *scopeItem;
	int prmCount;

	//OύXAidւ̑Ώ
	nCount = (int)pArrWidgets->GetSize ();
	index = 0;
	if(!name) {
		for(i = 0; i < nCount; i++) {
			pWidget = (CWidget*) pArrWidgets->GetAt(i);
			if(id == pWidget->GetId()) {
				index++;
			}
		}
	}

	//Widget̐
	pWidget = NULL;
	try {
		pWidget = new CWidget (point, id, width, height);
		if(!name) {
			pItem = pWidget->GetPitem();
			strcpy(blkname, pItem->name);
			if(index > 0) {
				sprintf(idname,"%d",index);
				strcat(blkname, idname);
			}
			pWidget->SetName(CString(blkname));
		}
		else
			pWidget->SetName(CString(name));
		pWidget->SetDirection( direction );
		pWidget->SetMatrix(matrix);
		//p[^[
		prm = pWidget->GetParamPointer();
		prmCount = (int)prm->GetSize();
		for (i=0; i<prmCount; i++) {
			//PARAMINFO
			prmItem = (PARAMINFO*) prm->GetAt (i);
			prmItem->strValue = _T(strValue[i]);
		}
		//ScopeɃTCYݒ
		prm = pWidget->GetScopePointer();
		prmCount = (int)prm->GetSize();
		for (i=0; i<prmCount; i++) {
			//PARAMINFO
			scopeItem = (SCOPEINFO*) prm->GetAt (i);
			scopeItem->size = pWidget->GetCellRow() * pWidget->GetCellColumn();
		}

		//Widgetǉ
		nIndex = (int)pArrWidgets->Add (pWidget);	
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("AddWidget function:Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

BOOL CSubsysDoc::RemoveWidget(int nIndex)
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	if (nIndex >= pArrWidgets->GetSize ())
		return FALSE;

	// nIndexC݂΁Aɍ폜Ă
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();
	CLine* pLine;
	int i,nLine,sblk,eblk,junc;
	CWidget* pWidget;

	nLine = (int)pArrLines->GetSize();
	for (i=nLine - 1; i>=0 ; i--) {
		pLine = (CLine*) pArrLines->GetAt(i);
		if(pLine->GetSblk() == nIndex) {
			RemoveLine(i);
		}
		if(pLine->GetEblk() == nIndex) {
			RemoveLine(i);
		}
	}
	// nIndexȍ~sblkAeblkC͏C
	nLine = (int)pArrLines->GetSize();
	for (i=0; i<nLine ; i++) {
		pLine = (CLine*) pArrLines->GetAt(i);
		if((sblk = pLine->GetSblk()) > nIndex) {
			pLine->SetSblk(sblk-1);
		}
		if((eblk = pLine->GetEblk()) > nIndex) {
			pLine->SetEblk(eblk-1);
		}
		//junction
		junc = pLine->GetJunction();
		if(junc != -1) {
			if(junc > nIndex)
				pLine->SetJunction(junc-1);
		}
	}

	//Ώۂ폜
	pWidget = (CWidget*)(pArrWidgets->GetAt(nIndex));
	if(pWidget->GetId() == M_SUBSYSTEM)
		SubDeleteContents(pWidget);
	delete (CWidget*)(pArrWidgets->GetAt(nIndex));
	pArrWidgets->RemoveAt (nIndex);
	return TRUE;
}

// CSubsysViewĂ΂
BOOL CSubsysDoc::InsertWidget(int id, CPoint point) 
{
	AddWidget(id, point, NULL, DIR_RIGHT, CString(_T("1:1")), 32, 32);
	UpdateAllViews (NULL);
	return TRUE;
}
// CSubsysViewĂ΂
// M_GAPM_SYNAPSEindexŎw肵Lineɐݒ肷
void CSubsysDoc::InsertWidgetJunc(int id, CPoint point, int index) 
{
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();
	int nCount,i,ncell,eblk;
	CLine* pLine;
	CPoint mpt,spt,ept;

	mpt = point;
	nCount = (int)pArrLines->GetSize();
	for(i = 0; i < nCount; i++) {
		pLine = (CLine*) pArrLines->GetAt(i);
		if(index == pLine->GetIndex()) {
#if 0
//W[̏oɔzu
			if(pLine->GetType() == LINE_START) {
				spt = pLine->GetSpos();
				ept = pLine->GetEpos();
				if(spt.x == ept.x)
					mpt = CPoint(spt.x-8, spt.y+(ept.y-spt.y)/2-8);
				else
					mpt = CPoint(spt.x+(ept.x-spt.x)/2-8, spt.y);
			}
#else
//W[̓ɔzu
			if(pLine->GetType() == LINE_STOP) {
				spt = pLine->GetSpos();
				ept = pLine->GetEpos();
				if(spt.x == ept.x)
					mpt = CPoint(ept.x-8, ept.y-8);
				else
					mpt = CPoint(spt.x+(ept.x-spt.x)/2-8, ept.y);
			}
#endif
		}
	}
	ncell = AddWidget(id, mpt/*point*/, NULL, DIR_RIGHT, CString(_T("1:1")), 16, 16/*32, 32*/);

	//desLinejunctionݒ
	//1 indexCsblk𓾂
	eblk = -1;
	for(i = 0; i < nCount; i++) {
		pLine = (CLine *) pArrLines->GetAt(i);
		if(index == pLine->GetIndex()) {
			eblk = pLine->GetEblk();
			break;
		}
	}

	if(eblk == -1) {
		// Erroe
	}
	else {
		for(i = 0; i < nCount; i++) {
			pLine = (CLine*) pArrLines->GetAt(i);
			if(eblk == pLine->GetEblk()) {
				pLine->SetJunction(ncell);
			}
		}
	}

	//XV
	UpdateAllViews (NULL);

}


///////////////////////////////////////////////////////////////////////
//
// LineɊւ郁\bh
//
int CSubsysDoc::GetLineCount()
{
	//return m_arrLines.GetSize ();
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();
	return (int)pArrLines->GetSize();
}

CLine* CSubsysDoc::GetLine(int nIndex)
{
	//if (nIndex >= m_arrLines.GetSize ())
	//	return NULL;
	//return (CLine*) m_arrLines[nIndex];
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();
	if (nIndex >= pArrLines->GetSize ())
		return NULL;
	return (CLine*) pArrLines->GetAt(nIndex);
}

// type:`悷郉C̎
//		LINE_START,LINE_MID,LINE_END\
int CSubsysDoc::AddLine(CPoint spt, CPoint ept, int sidx, int eidx, COLORREF color, int arrow, int idx,
						int inport, int outport, int type, int junc)
{
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();
	int nIndex = -1,row;
	CLine* pLine = NULL;
	CWidget* pWidget;

	//|[gݒ
	pWidget = GetWidget(sidx);
	pWidget->SetOutportLine(outport);
	pWidget = GetWidget(eidx);
	pWidget->SetInportLine(inport);
	// CLine쐬
	try {
		pLine = new CLine (spt, ept, sidx, eidx, color, arrow, idx,
			inport, outport, type, junc);
		nIndex = (int)pArrLines->Add (pLine);	
		//Line̓͐Widget𒲂ׂĕݒ
		pWidget = GetWidget(eidx);
		row = pWidget->GetCellRow();
		//column = pWidget->GetCellColumn();
		if(row > 1) {
			//gCELL̈̏ꍇ
			if(inport > 1)
				pLine->SetThickness( 1 );
			else
				pLine->SetThickness( 2 );
		}
		else
			pLine->SetThickness( 1 );
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("Out of memory"));
		if (pLine != NULL)
			delete pLine;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

// LinẽhbvɎgp
int CSubsysDoc::AtLine(int index, CPoint spt, CPoint ept, int sidx, int eidx, COLORREF color, int arrow, int idx,
					   int inport, int outport, int type, int junc)
{
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();
	int row;
	CLine* pLine = NULL;
	CWidget* pWidget;

	// CLine쐬
	try {
		pLine = new CLine (spt, ept, sidx, eidx, color, arrow, idx,
			inport, outport, type, junc);
		pArrLines->InsertAt (index, pLine);
		//Line̓͐Widget𒲂ׂĕݒ
		pWidget = GetWidget(eidx);
		row = pWidget->GetCellRow();
		//column = pWidget->GetCellColumn();
		if(row > 1) {
			//gCELL̈̏ꍇ
			if(inport > 1)
				pLine->SetThickness( 1 );
			else
				pLine->SetThickness( 2 );
		}
		else
			pLine->SetThickness( 1 );
		pLine->SetSel(TRUE);
		SetModifiedFlag ();
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("Out of memory"));
		if (pLine != NULL)
			delete pLine;
		e->Delete ();
		return -1;
	}
	return index;
}

BOOL CSubsysDoc::RemoveLine(int nIndex)
{
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();
	if (nIndex >= pArrLines->GetSize ())
		return FALSE;

	//nIndexɊ֌WĂ郉CWidget̐ڑtONA
	int widx,inport,outport;
	CWidget* pWidget;
	CLine* pLine;
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();

	pLine = (CLine*) pArrLines->GetAt(nIndex);
	//\[X
	widx = pLine->GetSblk();
	pWidget = (CWidget*) pArrWidgets->GetAt(widx);
	outport = pLine->GetOutport();
	if(outport != -1)
		pWidget->ResetOutportLine(outport);
	//fBXeBl[V
	widx = pLine->GetEblk();
	pWidget = (CWidget*) pArrWidgets->GetAt(widx);
	inport = pLine->GetInport();
	pWidget->ResetInportLine(inport);

	delete (CLine*)pArrLines->GetAt(nIndex);
	pArrLines->RemoveAt (nIndex);
	return TRUE;
}

BOOL CSubsysDoc::RemoveLineAt(int nIndex)
{
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();
	if (nIndex >= pArrLines->GetSize ())
		return FALSE;

	//nIndexɊ֌WĂ郉CWidget̐ڑtONA
	CLine* pLine;

	pLine = (CLine*) pArrLines->GetAt(nIndex);
	delete (CLine*)pArrLines->GetAt(nIndex);
	pArrLines->RemoveAt (nIndex);
	return TRUE;
}

// Line->WidgetԐڑ̂CExtncsViewĂ΂
// CRect\̂nĕ`悷
// gݍ킹ɑΉ
// juncInit́A-1ŌĂяo
void CSubsysDoc::InsertDivide(CRect rect, int sel, int sidx, int eidx, int inport, int juncInit/*-1*/) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();
	CPoint spos,epos;
	int type,junc;
	CWidget *pEWidget;
	int	edir;
	CLine *pLine;

	//1.junc𐶐
	//sidxCjuncĂ
	junc = juncInit;
#if 0
	//junćAeidxɕt̂ō폜
	nLine = GetLineCount();
	for(i = 0; i < nLine; i++) {
		pLine = GetLine(i);
		if(sidx == pLine->GetSblk()) {
			junc = pLine->GetJunction();
			break;
		}
	}
#endif

	if(sel == VERT_LINE || sel == HORZ_LINE) {
		//Widgetړ̏
		type = sel;
		pEWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		//|[g
		pEWidget->SetInportLine(inport);
		edir = pEWidget->GetDirection();
	}
	else {
		pLine = (CLine*) pArrLines->GetAt(sel);
		pEWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		//|[g
		pEWidget->SetInportLine(inport);
		edir = pEWidget->GetDirection();
		spos = pLine->GetSpos();
		epos = pLine->GetEpos();
		//CC̔
		if(spos.x == epos.x)
			type = VERT_LINE;
		else
			type = HORZ_LINE;
	}
	if(type == HORZ_LINE) {	//CJn
		switch(edir) {
		case	DIR_RIGHT:
			InsertDivideHR(rect, sidx, eidx, inport, junc);	break;
		case	DIR_UP:
			InsertDivideHU(rect, sidx, eidx, inport, junc);	break;
		case	DIR_LEFT:
			InsertDivideHL(rect, sidx, eidx, inport, junc);	break;
		case	DIR_DOWN:
			InsertDivideHD(rect, sidx, eidx, inport, junc);	break;
		}
	}
	else {
		switch(edir) {
		case	DIR_RIGHT:
			InsertDivideVR(rect, sidx, eidx, inport, junc);	break;
		case	DIR_UP:
			InsertDivideVU(rect, sidx, eidx, inport, junc);	break;
		case	DIR_LEFT:
			InsertDivideVL(rect, sidx, eidx, inport, junc);	break;
		case	DIR_DOWN:
			InsertDivideVD(rect, sidx, eidx, inport, junc);	break;
		}
	}

}

// CSubsysViewĂ΂
// CRect\̂nĕ`悷
// sidx:	oWidget
// eidx:	Widget
// inport:	Widget|[gԍ
// outport: oWidget|[gԍ
// gݍ킹ɑΉ
void CSubsysDoc::InsertLine(CRect rect, int sidx, int eidx, int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	CWidget *pWidget;
	int	sdir,edir,sypos,dypos,srow,scolumn,drow,dcolumn;
	CRect mrect;
	BOOL flag;
	int src_style,des_style;

	// Source
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sdir = pWidget->GetDirection();
	mrect = pWidget->GetRect();
	sypos = mrect.top + mrect.Height()/2;
	srow = pWidget->GetCellRow();
	scolumn = pWidget->GetCellColumn();
	// Destination
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	edir = pWidget->GetDirection();
	mrect = pWidget->GetRect();
	dypos = mrect.top + mrect.Height()/2;
	drow = pWidget->GetCellRow();
	dcolumn = pWidget->GetCellColumn();

	//Line`FbN
	src_style =	GetCellStyle(srow, scolumn); 
	des_style =	GetCellStyle(drow, dcolumn);
	//ڑ`FbN
	flag = TRUE;
	switch(src_style) {
	case	SINGLE_CELL:
		// singleZ͂SẴZɓ̂ŖȂ
		break;
	case	COLUMN_CELL:	// columnZ
		if(outport == 1) {
			//ŏIZSẴZɌ
		}
		else {
			//CELLSẴZɌ
		}
		break;
	case	ROW_CELL:	// rowZ
		if(outport == 1) {
			switch(des_style) {
			case	SINGLE_CELL:
				flag = FALSE;	//֎~
				break;
			case	COLUMN_CELL:
				flag = FALSE;	//֎~
				return;
			case	ROW_CELL:
				//cellv΂悢
				if(inport == 1) {
					if(srow != drow)
						flag = FALSE;
				}
				else
					flag = FALSE;
				break;
			case	MATRIX_CELL:
				flag = FALSE;
				break;
			}
		}
		else {
			//ZSẴZɌ
		}
		break;
	case	MATRIX_CELL:	// matrixZ
		if(outport == 1) {
			switch(des_style) {
			case	SINGLE_CELL:
				flag = FALSE;
				break;
			case	COLUMN_CELL:
				flag = FALSE;
				break;
			case	ROW_CELL:
				flag = FALSE;
				break;
			case	MATRIX_CELL:
				if(inport == 1) {
					if(srow != drow || scolumn != dcolumn)
						flag = FALSE;
				}
				else
					flag = FALSE;
				break;
			}
		}
		else {
			//ZSẴZɌ
		}
		break;
	}
	//bZ[W
	if(!flag) {
		//AfxMessageBox("Connection inhibited.", MB_OK, NULL);
		CSubsysView* pView = (CSubsysView*)GetSubsysView();
		pView->MessageBox("Connection inhibited.", "Extncs", MB_OK | MB_ICONERROR);
		return;
	}


	//directionɉLine`
	switch(sdir) {
	case	DIR_RIGHT:
		switch(edir) {
		case	DIR_RIGHT:
			// Right -> Right
			if(src_style == SINGLE_CELL && des_style == SINGLE_CELL)
				InsertLineRR(rect, sidx, eidx, inport, outport, junc);
			else if(src_style == SINGLE_CELL && des_style > SINGLE_CELL) {
				//des_styleɂ
				if(des_style == COLUMN_CELL) {
					if(inport > 1) {
						if(sypos > dypos)
							InsertLineRU(rect, sidx, eidx, inport, outport, junc);
						else
							InsertLineRD(rect, sidx, eidx, inport, outport, junc);
					}
					else
						InsertLineRR(rect, sidx, eidx, inport, outport, junc);
				}
				else
					InsertLineRR(rect, sidx, eidx, inport, outport, junc);
			}
			else if(src_style > SINGLE_CELL && des_style == SINGLE_CELL) {
				if(srow == 1 && outport > 1) {
					//Column->Single
					if(sypos > dypos)
						InsertLineUR(rect, sidx, eidx, inport, outport, junc);
					else
						InsertLineDR(rect, sidx, eidx, inport, outport, junc);
				}
				else
					InsertLineRR(rect, sidx, eidx, inport, outport, junc);
			}
			else {
				InsertLineRR(rect, sidx, eidx, inport, outport, junc);
			}
			break;
		case	DIR_UP:
			InsertLineRU(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_LEFT:
			InsertLineRL(rect, sidx, eidx, inport, outport, junc);	break;
		case	DIR_DOWN:
			InsertLineRD(rect, sidx, eidx, inport, outport, junc);	break;
		}
		break;
	case	DIR_UP:
		switch(edir) {
		case	DIR_RIGHT:
			InsertLineUR(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_UP:
			InsertLineUU(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_LEFT:
			InsertLineUL(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_DOWN:
			InsertLineUD(rect, sidx, eidx, inport, outport, junc);
			break;
		}
		break;
	case	DIR_LEFT:
		switch(edir) {
		case	DIR_RIGHT:
			InsertLineLR(rect, sidx, eidx, inport, outport, junc);	break;
		case	DIR_UP:
			InsertLineLU(rect, sidx, eidx, inport, outport, junc);	break;
		case	DIR_LEFT:
			InsertLineLL(rect, sidx, eidx, inport, outport, junc);	break;
		case	DIR_DOWN:
			InsertLineLD(rect, sidx, eidx, inport, outport, junc);	break;
		}
		break;
	case	DIR_DOWN:
		switch(edir) {
		case	DIR_RIGHT:
			InsertLineDR(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_UP:
			InsertLineDU(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_LEFT:
			InsertLineDL(rect, sidx, eidx, inport, outport, junc);
			break;
		case	DIR_DOWN:
			InsertLineDD(rect, sidx, eidx, inport, outport, junc);
			break;
		}
		break;
	}
}

///////////////////////////////////////////////////////////////////////
// InsertLineg

// Right -> Right
void CSubsysDoc::InsertLineRR(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xm,xs,ys,xe,ye;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;

	if(rect.left > rect.right) {
		//߂̏ꍇ
		xs = rect.left;
		ys = rect.top;
		xe = rect.right;
		ye = rect.bottom;
		pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
		dRect = pWidget->GetRect();
		pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
		sRect = pWidget->GetRect();
		//EOFFSET
		spt.x = xs;	spt.y = ys;
		ept.x = xs + OFFSET; ept.y = ys;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//OFFSET
		spt = ept;
		if(sRect.bottom > dRect.bottom)
			ept.y = sRect.bottom + OFFSET;
		else
			ept.y = dRect.bottom + OFFSET;
		ept.x = spt.x;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//OFFSET
		spt = ept;
		ept.x = xe - OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//3
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//4
		//E
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//5
		m_nLineIndex++;
			
	}
	else {
		xm = rect.left + (rect.right - rect.left)/2;
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = xm;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = xm;
		spt.y = rect.top;
		ept.x = xm;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = xm;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Right -> Up
// left > light
//
void CSubsysDoc::InsertLineRU(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xm,xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;

	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dypos = dRect.top + dRect.Height() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sypos = sRect.top + sRect.Height() / 2;

	if(rect.left > rect.right) {
		//߂̏ꍇ
		//EOFFSET
		spt.x = xs;	spt.y = ys;
		ept.x = xs + OFFSET; ept.y = ys;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//OFFSET
		spt = ept;
		if(sRect.bottom > dRect.bottom)
			ept.y = sRect.bottom + OFFSET;
		else
			ept.y = dRect.bottom + OFFSET;
		ept.x = spt.x;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//OFFSET
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//3
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//4
		m_nLineIndex++;
			
	}
	else {
		if(sypos > dypos) {
			//E
			xm = rect.left + (rect.right - rect.left)/2;
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = rect.right;
			ept.y = rect.top;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt.x = rect.right;
			spt.y = rect.top;
			ept.x = rect.right;
			ept.y = rect.bottom;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//E
			xm = rect.left + (rect.right - rect.left)/2;
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = spt.x + OFFSET;
			ept.y = rect.top;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = spt.x;
			ept.y = rect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = rect.right;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = spt.x;
			ept.y = spt.y - OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Right -> LEFT
void CSubsysDoc::InsertLineRL(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPoint spt,ept;
	int OFFSET = 20;

	if(rect.left > rect.right) {
		//߂̏ꍇ
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = rect.left + OFFSET;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = rect.left + OFFSET;
		spt.y = rect.top;
		ept.x = rect.left + OFFSET;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = rect.left + OFFSET;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		m_nLineIndex++;	
	}
	else {
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = rect.right + OFFSET;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = rect.right + OFFSET;
		spt.y = rect.top;
		ept.x = rect.right + OFFSET;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = rect.right + OFFSET;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Right -> Down
void CSubsysDoc::InsertLineRD(CRect rect, int sidx, int eidx, 
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xm,xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dypos = dRect.top + dRect.Height() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sypos = sRect.top + sRect.Height() / 2;

	if(rect.left > rect.right) {
		//߂̏ꍇ
		//EOFFSET
		spt.x = xs;	spt.y = ys;
		ept.x = xs + OFFSET; ept.y = ys;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//OFFSET
		spt = ept;
		if(sRect.top > dRect.top)
			ept.y = dRect.top - OFFSET;
		else
			ept.y = sRect.top - OFFSET;
		ept.x = spt.x;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//OFFSET
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//3
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//4
		m_nLineIndex++;
			
	}
	else {
		if(dypos > sypos) {
			//E
			xm = rect.left + (rect.right - rect.left)/2;
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = rect.right;
			ept.y = rect.top;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt.x = rect.right;
			spt.y = rect.top;
			ept.x = rect.right;
			ept.y = rect.bottom;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//E
			xm = rect.left + (rect.right - rect.left)/2;
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = spt.x + OFFSET;
			ept.y = rect.top;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = spt.x;
			ept.y = rect.bottom - OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = rect.right;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt.x = ept.x;
			spt.y = ept.y;
			ept.x = spt.x;
			ept.y = spt.y + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Left -> Right
void CSubsysDoc::InsertLineLR(CRect rect, int sidx, int eidx, 
							  int inport, int outport, int junc) 
{
	CPoint spt,ept;
	int OFFSET = 20;

	if(rect.left > rect.right) {
		//߂̏ꍇ
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = rect.right - OFFSET;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = rect.right - OFFSET;
		spt.y = rect.top;
		ept.x = rect.right - OFFSET;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = rect.right - OFFSET;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		m_nLineIndex++;	
	}
	else {
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = rect.left - OFFSET;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = rect.left - OFFSET;
		spt.y = rect.top;
		ept.x = rect.left - OFFSET;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = rect.left - OFFSET;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Left -> Up
void CSubsysDoc::InsertLineLU(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xm,xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CPoint pos;
	CRect sRect,dRect;
	CWidget *pWidget;
	int OFFSET = 20;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dypos = dRect.top + dRect.Height() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sypos = sRect.top + sRect.Height() / 2;

	if(rect.left > rect.right) {
		//srcdesEɑ
		if(sypos>dypos) {
			//dessrc̏
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc̉
			xm = dRect.right + (xs-dRect.right)/2;
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = xm;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//1
		}
		m_nLineIndex++;
	}
	else {
		//srcdes荶ɑ
		if(sypos>dypos) {
			//dessrc
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = sRect.top-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//4
		}
		else {
			//dessrc艺
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = sRect.bottom+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt = ept;
			ept.x = dRect.left-OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//4
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//4
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//4
		}
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Left -> Left
void CSubsysDoc::InsertLineLL(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xm,xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CPoint pos;
	CRect sRect,dRect;
	CWidget *pWidget;
	int OFFSET = 20;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dypos = dRect.top + dRect.Height() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sypos = sRect.top + sRect.Height() / 2;

	if(rect.left > rect.right) {
		//srcdesEɑ
		xm = rect.left + (rect.right - rect.left)/2;
		spt.x = rect.left;
		spt.y = rect.top;
		ept.x = xm;
		ept.y = rect.top;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		spt.x = xm;
		spt.y = rect.top;
		ept.x = xm;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		spt.x = xm;
		spt.y = rect.bottom;
		ept.x = rect.right;
		ept.y = rect.bottom;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		m_nLineIndex++;
	}
	else {
		//srcdes荶ɑ
		//߂̏ꍇ
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x - OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//ォ
		spt = ept;
		ept.x = spt.x;
		if(sypos>dypos)
			ept.y = sRect.top-OFFSET;
		else
			ept.y = sRect.bottom+OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//E
		spt = ept;
		ept.x = xe + OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//3
		//ォ
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//4
		//
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//5
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Left -> Dworn
void CSubsysDoc::InsertLineLD(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CPoint pos;
	CRect sRect,dRect;
	CWidget *pWidget;
	int OFFSET = 20;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dypos = dRect.top + dRect.Height() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sypos = sRect.top + sRect.Height() / 2;

	if(rect.left > rect.right) {
		//srcdesEɑ
		if(dypos>sypos) {
			//srcdes̏
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc̏
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x-OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//1
		}
		m_nLineIndex++;
	}
	else {
		//srcdes荶ɑ
		if(dypos>sypos) {
			//srcdes
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = sRect.bottom+(dRect.top-sRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//4
		}
		else {
			//srcdes艺
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = dRect.bottom+(sRect.top-dRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//E
			spt = ept;
			ept.x = dRect.left-OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//4
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//4
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//4
		}
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Up -> Right
void CSubsysDoc::InsertLineUR(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xm,xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dypos = dRect.top + dRect.Height() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sypos = sRect.top + sRect.Height() / 2;

	if(rect.left > rect.right) {
		//߂̏ꍇ
		//OFFSET
		spt.x = xs;	spt.y = ys;
		if(sRect.bottom > dRect.bottom)
			ept.y = dRect.top - OFFSET;
		else
			ept.y = sRect.top - OFFSET;
		ept.x = spt.x;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//OFFSET
		spt = ept;
		ept.x = xe - OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//3
		//E
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//3
		m_nLineIndex++;
			
	}
	else {
		xm = rect.left + (rect.right - rect.left)/2;
		if(sypos > dypos) {
			//
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = rect.left;
			ept.y = rect.bottom;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//OFFSET
			spt.x = rect.left;
			spt.y = rect.top;
			ept.x = spt.x;
			ept.y = spt.y - OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xm;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//4
		}
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Up -> Up
void CSubsysDoc::InsertLineUU(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xm,xs,ys,xe,ye,sxpos,dxpos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dxpos = dRect.left + dRect.Width() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sxpos = sRect.left + sRect.Width() / 2;

	if(rect.top > rect.bottom) {
		//dessrcɑ
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = spt.y-OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//E
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//2
		m_nLineIndex++;
	}
	else {
		xm = rect.left + (rect.right - rect.left)/2;
		if(sxpos > dxpos) {
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = spt.y-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xm;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = spt.y-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xm;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Up -> Left
void CSubsysDoc::InsertLineUL(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xm,xs,ys,xe,ye,sxpos,dxpos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dxpos = dRect.left + dRect.Width() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sxpos = sRect.left + sRect.Width() / 2;

	if(rect.top < rect.bottom) {
		//srcdesɑ
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = spt.y-OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//E
		spt = ept;
		ept.y = spt.y;
		if(sRect.right > dRect.right)
			ept.x = sRect.right + OFFSET;
		else
			ept.x = dRect.right + OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//2
		m_nLineIndex++;
	}
	else {
		xm = rect.left + (rect.right - rect.left)/2;
		if(sxpos > dxpos) {
			//srcdesEɑ
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//srcdes荶ɑ
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = spt.y-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe+OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Up -> Dworn
void CSubsysDoc::InsertLineUD(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye,sxpos,dxpos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dxpos = dRect.left + dRect.Width() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sxpos = sRect.left + sRect.Width() / 2;

	if(rect.top > rect.bottom) {
		//dessrcɑ
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = ye-OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//E
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = xe;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//2
		m_nLineIndex++;
	}
	else {
		//srcdesɑ
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = spt.y-OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_START, junc);	//1
		//E
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, outport, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, outport, LINE_STOP, junc);	//2
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Down -> Right
void CSubsysDoc::InsertLineDR(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dypos = dRect.top + dRect.Height() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sypos = sRect.top + sRect.Height() / 2;

	if(rect.left > rect.right) {
		//srcdesE
		if(sypos>dypos) {
			//dessrc̏
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//OFFSET
			spt = ept;
			ept.x = xe - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		else {
			//dessrc̉
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + (dRect.top-sRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//OFFSET
			spt = ept;
			ept.x = xe - OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		m_nLineIndex++;			
	}
	else {
		if(dypos>sypos) {
			//dessrc艺
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = sRect.right+(dRect.left-sRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Down -> Up
void CSubsysDoc::InsertLineDU(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dypos = dRect.top + dRect.Height() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sypos = sRect.top + sRect.Height() / 2;

	if(rect.left > rect.right) {
		//srcdesE
		if(sypos>dypos) {
			//dessrc̏
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//OFFSET
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		else {
			//dessrc̉
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		m_nLineIndex++;			
	}
	else {
		if(dypos>sypos) {
			//dessrc艺
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Down -> Left
void CSubsysDoc::InsertLineDL(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dypos = dRect.top + dRect.Height() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sypos = sRect.top + sRect.Height() / 2;

	if(rect.left > rect.right) {
		//srcdesE
		if(sypos>dypos) {
			//dessrc̏
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = dRect.right+(sRect.left-dRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		else {
			//dessrc̉
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		m_nLineIndex++;			
	}
	else {
		if(dypos>sypos) {
			//dessrc艺
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom+(dRect.top-sRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe+OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe+OFFSET;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = xe;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}
// Down -> Dworn
void CSubsysDoc::InsertLineDD(CRect rect, int sidx, int eidx,
							  int inport, int outport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye,sypos,dypos;
	CPoint spt,ept;
	CWidget *pWidget;
	int OFFSET = 20;
	CRect sRect,dRect;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	dypos = dRect.top + dRect.Height() / 2;
	pWidget = (CWidget*) pArrWidgets->GetAt(sidx);
	sRect = pWidget->GetRect();
	sypos = sRect.top + sRect.Height() / 2;

	if(rect.left > rect.right) {
		//srcdesE
		if(dypos>sypos) {
			//srcdes̏
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + (dRect.top-sRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		else {
			//dessrc̏
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//
			spt = ept;
			ept.x = dRect.right+(sRect.left-dRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		m_nLineIndex++;			
	}
	else {
		if(dypos>sypos) {
			//dessrc艺
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom+(dRect.top-sRect.bottom)/2;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//2
		}
		else {
			//dessrc
			//OFFSET
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = sRect.bottom + OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_START, junc);	//1
			//E
			spt = ept;
			ept.x = sRect.right+(dRect.left-sRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, outport, LINE_MIDST, junc);	//3
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, outport, LINE_STOP, junc);	//3
		}
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);

}

///////////////////////////////////////////////////////////////////////
// InsertDivideg

// Horz -> Right
void CSubsysDoc::InsertDivideHR(CRect rect, int sidx, int eidx, int inport, int junc)
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CWidget* pWidget;
	CRect dRect;
	int OFFSET = 20;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	if(xs > xe) {
		//Jn_荶Widget݂
		if(ys > ye) {
			//LineWidget
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = dRect.bottom + (ys-dRect.bottom)/2;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe - OFFSET;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, -1, LINE_STOP, junc);	//4
		}
		else {
			//Line艺Widget
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ys + (dRect.top-ys)/2;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe - OFFSET;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, -1, LINE_STOP, junc);	//4
		}
		m_nLineIndex++;
	}
	else {
		//EWidget
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//2
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Horz -> Up
void CSubsysDoc::InsertDivideHU(CRect rect, int sidx, int eidx, int inport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CWidget* pWidget;
	CRect dRect;
	int OFFSET = 20;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();

	if(rect.top > rect.bottom) {
		//Widget
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = dRect.bottom + (ys-dRect.bottom)/2;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		//
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//4
		m_nLineIndex++;
	}
	else {
		//Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = ye+OFFSET;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		//E
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//2
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Horz -> Left
void CSubsysDoc::InsertDivideHL(CRect rect, int sidx, int eidx, int inport, int junc) 
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CWidget* pWidget;
	CRect dRect;
	int OFFSET = 20;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();
	if(xe > xs) {
		//Jn_EWidget݂
		if(ys > ye) {
			//LineWidget
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = dRect.bottom + (ys-dRect.bottom)/2;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe + OFFSET;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, -1, LINE_STOP, junc);	//4
		}
		else {
			//Line艺Widget
			//
			spt.x = xs;
			spt.y = ys;
			ept.x = spt.x;
			ept.y = ys + (dRect.top-ys)/2;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			//
			spt = ept;
			ept.x = xe + OFFSET;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			//
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			//E
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;	
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, -1, LINE_STOP, junc);	//4
		}
		m_nLineIndex++;
	}
	else {
		//Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//2
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Horz -> Down
void CSubsysDoc::InsertDivideHD(CRect rect, int sidx, int eidx, int inport, int junc)
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CWidget* pWidget;
	CRect dRect;
	int OFFSET = 20;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();

	if(rect.top > rect.bottom) {
		//Widget
		//
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = dRect.top - OFFSET;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		//
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;	
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//4
		m_nLineIndex++;
	}
	else {
		//Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = spt.x;
		ept.y = ys + (dRect.top-ys)/2;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		//E
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		//
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//2
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Vert -> Right
void CSubsysDoc::InsertDivideVR(CRect rect, int sidx, int eidx, int inport, int junc)
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CRect dRect;
	CWidget *pWidget;
	int OFFSET = 20;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();

	if(xs > xe) {
		//Line荶Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = dRect.left - OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		m_nLineIndex++;			
	}
	else {
		//LineEWidget
		spt.x = xs;
		spt.y = ys;
		ept.x = xs + (xe-xs)/2;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Vert -> Up
void CSubsysDoc::InsertDivideVU(CRect rect, int sidx, int eidx, int inport, int junc)
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CRect dRect;
	CWidget *pWidget;
	int OFFSET = 20;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();

	if(ys < ye) {
		//_艺Widget
		if(xs>xe) {
			//_荶Widget
			spt.x = xs;
			spt.y = ys;
			ept.x = dRect.right+(xs-dRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, -1, LINE_STOP, junc);	//3
		}
		else {
			//_EWidget
			spt.x = xs;
			spt.y = ys;
			ept.x = xs+(dRect.left-xs)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			spt = ept;
			ept.x = spt.x;
			ept.y = ye+OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, -1, LINE_STOP, junc);	//3
		}
		m_nLineIndex++;			
	}
	else {
		//_Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Vert -> Left
void CSubsysDoc::InsertDivideVL(CRect rect, int sidx, int eidx, int inport, int junc)
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CRect dRect;
	CWidget *pWidget;
	int OFFSET = 20;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();

	if(xs < xe) {
		//LineEWidget
		spt.x = xs;
		spt.y = ys;
		ept.x = dRect.right + OFFSET;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		m_nLineIndex++;			
	}
	else {
		//Line荶Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = xs + (xe-xs)/2;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//2
		spt = ept;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}

// Vert -> Down
void CSubsysDoc::InsertDivideVD(CRect rect, int sidx, int eidx, int inport, int junc)
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int xs,ys,xe,ye;
	CPoint spt,ept;
	CRect dRect;
	CWidget *pWidget;
	int OFFSET = 20;

	//l
	xs = rect.left;
	ys = rect.top;
	xe = rect.right;
	ye = rect.bottom;
	//Widget[eidx]̈ʒumF
	pWidget = (CWidget*) pArrWidgets->GetAt(eidx);
	dRect = pWidget->GetRect();

	if(ys > ye) {
		//_Widget
		if(xs>xe) {
			//_荶Widget
			spt.x = xs;
			spt.y = ys;
			ept.x = dRect.right+(xs-dRect.right)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, -1, LINE_STOP, junc);	//3
		}
		else {
			//_EWidget
			spt.x = xs;
			spt.y = ys;
			ept.x = xs+(dRect.left-xs)/2;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//1
			spt = ept;
			ept.x = spt.x;
			ept.y = ye-OFFSET;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//2
			spt = ept;
			ept.x = xe;
			ept.y = spt.y;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 0, m_nLineIndex,
				inport, -1, LINE_MIDST, junc);	//3
			spt = ept;
			ept.x = spt.x;
			ept.y = ye;
			AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
				inport, -1, LINE_STOP, junc);	//3
		}
		m_nLineIndex++;			
	}
	else {
		//_艺Widget
		spt.x = xs;
		spt.y = ys;
		ept.x = xe;
		ept.y = spt.y;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 2, m_nLineIndex,
			inport, -1, LINE_MIDST, junc);	//1
		spt = ept;
		ept.x = spt.x;
		ept.y = ye;
		AddLine(spt, ept, sidx, eidx, RGB(0,0,0), 1, m_nLineIndex,
			inport, -1, LINE_STOP, junc);	//3
		m_nLineIndex++;
	}

	//ĕ`
	UpdateAllViews (NULL);
}

void CSubsysDoc::OnFileClose() 
{
	//SubsystemEBhE̂
	OnCloseDocument();
}

void CSubsysDoc::OnUpdateFileClose(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CSubsysDoc::SaveSystem() 
{
	int	i,nCount,id,sblk,eblk,arrow,idx,inport,outport,type,junc;
	long color;
	CWidget *pWidget;
	CLine *pLine;
	CPoint spos,epos;
	CPtrArray*	pParam;
	PARAMINFO *pItem;
	int j,nParam;
	char buf[128];
	CRect rect;
	CString	strParam[MAX_PARAM];
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	CPtrArray* pArrLines = m_pWidget->GetLinesPointer();

	// m_subsysArray폜
	m_pWidget->RemoveSubsys ();
	// m_subsysWidgets폜
	m_pWidget->RemoveSubsysWidgets ();
	// m_subsysLines폜
	m_pWidget->RemoveSubsysLines ();

	// widget
	nCount = (int)pArrWidgets->GetSize ();
	SaveLine(_T("{"));
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		spos = pWidget->GetPoint();
		id = pWidget->GetId();
		rect = pWidget->GetRect();
		//fprintf(fp,"%d %d %d %s %d\n",spos.x,
		//		spos.y, id, (LPCTSTR)pWidget->GetName(), pWidget->GetDirection());
		sprintf(buf,"%d %d %d %d",spos.x,spos.y,rect.Width(),rect.Height());
		SaveLine(_T(buf));
		sprintf(buf,"%d",id);
		SaveLine(_T(buf));
		sprintf(buf,"%s",(LPCTSTR)pWidget->GetName());
		SaveLine(_T(buf));
		sprintf(buf,"%d",pWidget->GetDirection());
		SaveLine(_T(buf));
		sprintf(buf,"%s",pWidget->GetMatrix());
		SaveLine(_T(buf));
		sprintf(buf,"%d %d",pWidget->GetInport(),pWidget->GetOutport());
		SaveLine(_T(buf));
		sprintf(buf,"%d %d",pWidget->GetConnect(),pWidget->GetJunction());
		SaveLine(_T(buf));
		//p[^[
		SaveLine(_T("{"));
		pParam = pWidget->GetParamPointer();
		nParam = (int)pParam->GetSize();
		sprintf(buf, "%d", nParam);
		SaveLine(_T(buf));
		if(nParam > 0) {
			for (j=0; j<nParam; j++) {
				//PARAMINFO
				pItem = (PARAMINFO*) pParam->GetAt (j);
				sprintf(buf, "%s = %s", pItem->strName, pItem->strValue);
				SaveLine(_T(buf));
				strParam[j] = _T(buf);
			}
		}
		SaveLine(_T("}"));
		//m_subsysWidgetsɓo^
		((CExtncsDoc*)m_pExtncsDoc)->AddSubsysWidget(m_pWidget, spos.x, spos.y, id,
			pWidget->GetName(), pWidget->GetDirection(), pWidget->GetMatrix(),
			pWidget->GetInport(), pWidget->GetOutport(), nParam, strParam);
	}
	SaveLine(_T("}"));
	// line
	nCount = (int)pArrLines->GetSize ();
	SaveLine(_T("{"));
	for(i = 0; i < nCount; i++) {
		pLine = (CLine*) pArrLines->GetAt(i);
		spos = pLine->GetSpos();
		epos = pLine->GetEpos();
		sblk = pLine->GetSblk();
		eblk = pLine->GetEblk();
		color = pLine->GetColor();
		arrow = pLine->GetArrow();
		idx = pLine->GetIndex();
		inport = pLine->GetInport();
		outport = pLine->GetOutport();
		type = pLine->GetType();
		junc = pLine->GetJunction();
		sprintf(buf,"%d %d %d %d %d %d %ld %d %d %d %d %d %d",
				spos.x, spos.y, epos.x, epos.y, sblk, eblk,
				color, arrow, idx, inport, outport, type, junc);
		SaveLine(_T(buf));
		//m_subsysLinesɓo^
		((CExtncsDoc*)m_pExtncsDoc)->AddSubsysLine(m_pWidget, spos, epos, sblk, eblk, color, arrow, idx,
			inport, outport, type, junc);
	}
	SaveLine(_T("}"));
}

void CSubsysDoc::SaveLine(CString list) 
{
	//Xgɓo^
	CPtrArray*	pSubsys;
	SUBSYSINFO* pItem;
	int nCount;

	//Widgetm_subsysPtrǂ
	pSubsys = m_pWidget->GetSubsysPointer();
	try {
		pItem = new SUBSYSINFO;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return;
	}
	//@ݒ
	pItem->strList = list;
	//CfbNX
	nCount = (int)pSubsys->GetSize();
	//o^
	pSubsys->InsertAt( nCount, pItem );
}

//
// pWidget->m_subsysArraỹXgǂ݁Ȁ
// Subsystem\z
//
void CSubsysDoc::LoadSubsystem()
{
	CPtrArray* pArrWidgets = m_pWidget->GetWidgetsPointer();
	int	xs,ys,xe,ye,sblk,eblk,arrow,id,idx,cx,cy;
	CPoint spos,epos;
	BOOL flag;
	char linebuf[_MAX_PATH];
	long color;
	char name[128];
	int direction,inport,outport,nIndex,type,row,column,junc,connect;
	int j,nParam,pos;
	char strValue[100][16];
	CString matrix,str,strRight;
	CPtrArray* pSubsys;
	int lCount,addr;
	SUBSYSINFO* pItem;
	CWidget* pWidget;

	pSubsys = m_pWidget->GetSubsysPointer();
	lCount = (int)pSubsys->GetSize();
	if(!lCount)
		return;

	// widget
	flag = FALSE;
	addr = 0;
	while(1) {
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);
		if(!flag && strstr(linebuf, "{") != NULL)
			flag = TRUE;
		else if(flag) {
			if(strstr(linebuf, "}") != NULL)
				break;
			else {
				//sscanf(linebuf, "%d %d %d %s %d", &xs, &ys, &id, name, &direction);
				sscanf(linebuf, "%d %d %d %d", &xs, &ys, &cx, &cy);
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);
				sscanf(linebuf, "%d", &id);
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);
				sscanf(linebuf, "%s", name);
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);
				sscanf(linebuf, "%d", &direction);
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);
				matrix = _T(linebuf);
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);
				sscanf(linebuf, "%d %d", &inport, &outport);
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);
				sscanf(linebuf, "%d %d", &connect, &junc);
				spos.x = xs; spos.y = ys;
				//p[^[
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);	//"{"
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);	//p[^[
				sscanf(linebuf, "%d", &nParam);
				if(nParam > 0) {
//́Anewdeletegݍ킹ł͂Ȃ
					//strValue = new CString[nParam];
					for(j = 0; j < nParam; j++) {
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);
						//lo
						str = _T(linebuf);
						pos = str.Find(_T("= "));
						strRight = str.Mid(pos+2);
						strcpy(strValue[j], strRight);
					}
				}
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);	// }
				//Widget
				//gCELLɑΉ邽߁Amatrixl傫ɂ
				row = ((CExtncsDoc*)m_pExtncsDoc)->GetMatrixRow(matrix);
				column = ((CExtncsDoc*)m_pExtncsDoc)->GetMatrixColumn(matrix);
				cx = cx / column;
				cy = cy / row;
				if(nParam > 0) {
					nIndex = AddWidget2(id, spos, NULL, direction, matrix, nParam, strValue, cx, cy);
					//delete strValue;
				}
				else
					nIndex = AddWidget(id, spos, NULL, direction, matrix, cx, cy);
				//|[g
				pWidget = (CWidget*)pArrWidgets->GetAt(nIndex);
				pWidget->SetInport(inport);
				pWidget->SetOutport(outport);
				//Name
				pWidget->SetName(_T(name));
				//gCELL
				pWidget->SetConnect(connect);
				pWidget->SetJunction(junc);
			}
		}
	}
	// line
	flag = FALSE;
	while(1) {
		pItem = (SUBSYSINFO*) pSubsys->GetAt(addr++);
		strcpy(linebuf, pItem->strList);
		if(!flag && strstr(linebuf, "{") != NULL)
			flag = TRUE;
		else if(flag) {
			if(strstr(linebuf, "}") != NULL)
				break;
			else {
				sscanf(linebuf, "%d %d %d %d %d %d %ld %d %d %d %d %d %d", &xs, &ys, &xe, &ye,
					&sblk, &eblk, &color, &arrow, &idx, &inport, &outport, &type, &junc);
				spos.x = xs; spos.y = ys;
				epos.x = xe; epos.y = ye;
				AddLine(spos, epos, sblk, eblk, color, arrow, idx, inport, outport, type, junc);
				m_nLineIndex = idx;
			}
		}
	}
}

// CExtncsViewĂ΂
// Connection@ύX
void CSubsysDoc::ChangeLine(int lSel, int style)
{
	CLine* pLine;
	int i,nCount,nFirstLine,nLastLine,nIndex,index;

	//lSelŎw肳ꂽCindex
	pLine = (CLine*) GetLine(lSel);
	nIndex = pLine->GetIndex();
	//nIndexŏ̃C
	nCount = GetLineCount ();
	for(i = 0; i < nCount; i++) {
		pLine = (CLine*) GetLine( i );
		index = pLine->GetIndex();
		if(nIndex == index) {
			nFirstLine = i;
			break;
		}
	}
	//nIndexŌ̃C
	nCount = GetLineCount ();
	nLastLine = 0;
	for(i = 0; i < nCount; i++) {
		pLine = (CLine*) GetLine( i );
		index = pLine->GetIndex();
		if(nIndex == index)
			nLastLine = i;
	}

	//styleɉđύX
	switch(style) {
	case	0:
		pLine = GetLine(nFirstLine);
		pLine->SetArrow( 0 );
		pLine = GetLine(nLastLine);
		pLine->SetArrow( 1 );
		break;
	case	1:
		pLine = GetLine(nFirstLine);
		pLine->SetArrow( 3 );
		pLine = GetLine(nLastLine);
		pLine->SetArrow( 0 );
		break;
	case	2:
		pLine = GetLine(nFirstLine);
		pLine->SetArrow( 3 );
		pLine = GetLine(nLastLine);
		pLine->SetArrow( 1 );
		break;
	}

	//m_selected
	for(i = 0; i < nCount; i++) {
		pLine = (CLine*) GetLine( i );
		pLine->SetSel(FALSE);
	}
	
	//ĕ`
	UpdateAllViews (NULL);
}

void CSubsysDoc::OnFileNew() 
{
	// JĂEBhE
	CSubsysView* pView = (CSubsysView*)GetSubsysView();
	int i;

	for(i = 0; i < MAX_SCOPE; i++) {
		if(pView->m_pScopeWnd[i]) {
			pView->m_pScopeWnd[i]->DestroyWindow();
			//NA
			pView->m_pScopeWnd[i] = NULL;
			pView->m_pScopeDoc[i] = NULL;
		}
	}

	for(i = 0; i < MAX_SUBSYSTEM; i++) {
		if(pView->m_pSubsysWnd[i]) {
			pView->m_pSubsysWnd[i]->DestroyWindow();
			//NA
			pView->m_pSubsysWnd[i] = NULL;
			pView->m_pSubsysDoc[i] = NULL;
		}
	}

	// WidgetsLines폜
	AllDeleteContents();
	//ĕ`
	UpdateAllViews (NULL);
	
}

//CSubsysView𓾂
void* CSubsysDoc::GetSubsysView()
{
	POSITION pos = GetFirstViewPosition();
	CSubsysView* pView = (CSubsysView*)GetNextView( pos );
	return (void *)pView;
}

int CSubsysDoc::GetCellStyle(int row, int column)
{
	if(row == 1 && column == 1)
		return SINGLE_CELL;
	else if(row == 1 && column > 1)
		return COLUMN_CELL;
	else if(row > 1 && column == 1)
		return ROW_CELL;
	else if(row > 1 && column > 1)
		return MATRIX_CELL;
	return SINGLE_CELL;
}

//LineX^CԂ֐
int CSubsysDoc::GetLineStyle(int lSel)
{
	CLine* pLine;
	int i,nCount,nFirstLine,nLastLine,nIndex,index,srcArrow,desArrow;

	//lSelŎw肳ꂽCindex
	pLine = (CLine*) GetLine(lSel);
	nIndex = pLine->GetIndex();
	//nIndexŏ̃C
	nCount = GetLineCount ();
	for(i = 0; i < nCount; i++) {
		pLine = (CLine*) GetLine( i );
		index = pLine->GetIndex();
		if(nIndex == index) {
			nFirstLine = i;
			break;
		}
	}
	//nIndexŌ̃C
	nCount = GetLineCount ();
	nLastLine = 0;
	for(i = 0; i < nCount; i++) {
		pLine = (CLine*) GetLine( i );
		index = pLine->GetIndex();
		if(nIndex == index)
			nLastLine = i;
	}
	// srcArrow
	pLine = GetLine(nFirstLine);
	srcArrow = pLine->GetArrow();
	// desArrow
	pLine = GetLine(nLastLine);
	desArrow = pLine->GetArrow();

	if(srcArrow == 0 && desArrow == 1)
		return	CONNECT_OUT;
	else if(srcArrow == 3 && desArrow == 0)
		return	CONNECT_IN;
	else if(srcArrow == 3 && desArrow == 1)
		return	CONNECT_CROSS;
	else if(srcArrow == 2 && desArrow == 1)
		return	CONNECT_BRANCH;
	return -1;
}

void CSubsysDoc::OnUpdateFileNew(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

BOOL CSubsysDoc::SaveModified() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	return TRUE/*CDocument::SaveModified()*/;
}

void CSubsysDoc::OnUpdateFileOpen(CCmdUI* pCmdUI) 
{
	// Subsytemł́AID_FILE_OPEN͋@\Ȃ
	pCmdUI->Enable(FALSE);	
}

void CSubsysDoc::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
	// Subsytemł́ACExtncsDocID_FILE_SAVEgp
	//pCmdUI->Enable(FALSE);
	CPtrArray* pSubsys;

	pSubsys = m_pWidget->GetWidgetsPointer();
	if(pSubsys->GetSize() > 0)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
}

// matrix𕪉
int CSubsysDoc::GetMatrixRow(CString matrix)
{
	int index;
	CString strRow;

	index = matrix.Find(':');
	strRow = matrix.Left(index);
	return atoi(strRow);
}
int CSubsysDoc::GetMatrixColumn(CString matrix)
{
	int index;
	CString strColumn;

	index = matrix.Find(':');
	strColumn = matrix.Mid(index+1);
	return atoi(strColumn);
}

void CSubsysDoc::OnUpdateFileSaveAs(CCmdUI* pCmdUI) 
{
	// Subsytemł́AID_FILE_SAVE_AS͋@\Ȃ
	pCmdUI->Enable(FALSE);	
	
}

void CSubsysDoc::OnUpdateNcsExtncs(CCmdUI* pCmdUI) 
{
	// Subsytemł́AID_NCS_EXTNCS͋@\Ȃ
	pCmdUI->Enable(FALSE);	
	
}

void CSubsysDoc::OnUpdateExtncsNcs(CCmdUI* pCmdUI) 
{
	// Subsytemł́AID_EXTNCS_NCS͋@\Ȃ
	pCmdUI->Enable(FALSE);	
	
}


void CSubsysDoc::OnFileSave()
{
	// TODO : ɃR}h nh R[hǉ܂B
	((CExtncsDoc*)m_pExtncsDoc)->FileSave();
}

void CSubsysDoc::OnExtncsCode()
{
	// TODO : ɃR}h nh R[hǉ܂B
	((CExtncsDoc*)m_pExtncsDoc)->ExtncsCode();
}

void CSubsysDoc::OnUpdateExtncsCode(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	CPtrArray* pSubsys;
	pSubsys = m_pWidget->GetWidgetsPointer();
	if(pSubsys->GetSize() > 0)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
}

void CSubsysDoc::OnExtncsCompile()
{
	// TODO : ɃR}h nh R[hǉ܂B
	((CExtncsDoc*)m_pExtncsDoc)->ExtncsCompile();
}

void CSubsysDoc::OnUpdateExtncsCompile(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	CPtrArray* pSubsys;
	pSubsys = m_pWidget->GetWidgetsPointer();
	if(pSubsys->GetSize() > 0)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
}
