/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SubsysDoc.h,v 1.3 2004/06/15 04:41:21 yoshihiko Exp $ */

#if !defined(AFX_SUBSYSDOC_H__C1C03F0B_D91C_47D7_BB1B_80D798D58EAD__INCLUDED_)
#define AFX_SUBSYSDOC_H__C1C03F0B_D91C_47D7_BB1B_80D798D58EAD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "WidgetObj.h"
typedef CTypedPtrArray<CObArray, CWidget*> CWidgetArray;
typedef CTypedPtrArray<CObArray, CLine*> CLineArray;

/////////////////////////////////////////////////////////////////////////////
// CSubsysDoc hLg

class CSubsysDoc : public CDocument
{
protected:
	CSubsysDoc();           // IɎgpveNg RXgN^B
	DECLARE_DYNCREATE(CSubsysDoc)

// Agr[g
public:

// Iy[V
public:
	//method
	void SubDeleteContents(CWidget *pTargetWidget);
	void AllDeleteContents();
	void InitSubsystem(CWidget* pWidget, int inpnum, int outpnum);
	int AddSubWidget(CWidget* pTargetWidget, int id, CPoint point, char *name,
				int direction, CString matrix, int cx, int cy);
	int AddSubWidget2(CWidget* pTargetWidget, int id, CPoint point, char *name,
		 int direction, CString matrix, int nParam, char strValue[][16], int width, int height);
	int GetMatrixRow(CString matrix);
	int GetMatrixColumn(CString matrix);
	int GetCellStyle(int row, int column);
	void* GetSubsysView();
	BOOL RemoveWidget (int nIndex);
	int AddWidget (int id, int x, int y, int cx, int cy, COLORREF color, char *name);
	int AddWidget (int id, CPoint point, char *name, int direction, CString matrix,
		int width, int height);
	int AddWidget2(int id, CPoint point, char *name,
		 int direction, CString matrix, int nParam, char strValue[][16], int width, int height);
	BOOL RemoveLine (int nIndex);
	BOOL RemoveLineAt (int nIndex);
	CWidget* GetWidget (int nIndex);
	int GetWidgetCount ();
	BOOL InsertWidget(int id, CPoint point);
	void InsertWidgetJunc(int id, CPoint point, int index);
	int GetLineCount ();
	int AddLine (CPoint spt, CPoint ept, int sidx, int eidx, COLORREF color, int arrow, int idx,
		int inport, int outport, int type, int junc);
	int AtLine(int index, CPoint spt, CPoint ept, int sidx, int eidx, COLORREF color, int arrow, int idx,
					   int inport, int outport, int type, int junc);
	CLine* GetLine (int nIndex);
	void InsertLine(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	// Right->
	void InsertLineRR(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineRU(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineRL(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineRD(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	// Up->
	void InsertLineUR(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineUU(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineUL(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineUD(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	// Left->
	void InsertLineLR(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineLU(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineLL(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineLD(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	// Down->
	void InsertLineDR(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineDU(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineDL(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	void InsertLineDD(CRect rect, int sidx, int eidx, int inport, int outport, int junc);
	//Line->WidgetԐڑ
	void InsertDivide(CRect rect, int lSel, int sidx, int eidx, int inport, int junc);
	//Horz->
	void InsertDivideHR(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideHU(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideHL(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideHD(CRect rect, int sidx, int eidx, int inport, int junc);
	// Vert->
	void InsertDivideVR(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideVU(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideVL(CRect rect, int sidx, int eidx, int inport, int junc);
	void InsertDivideVD(CRect rect, int sidx, int eidx, int inport, int junc);

	//ۑɊ֌W
	void SaveLine(CString list); 
	void LoadSubsystem();
	void ChangeLine(int lSel, int style);
	void SaveSystem();
	int GetLineStyle(int lSel);

	//data
	UINT m_nFormat;
	CWidget*	m_pWidget;		//IĂubN
//TODO:Ή
	//CExtncsDoc*	m_pExtncsDoc;
	CDocument*	m_pExtncsDoc;
	CView* m_pExtncsView;
	int			m_nThisIndex;
	//CCfbNX
	int				m_nLineIndex;
	//EBhEǗptO
	BOOL			m_bSubsysWnd[MAX_SUBSYSTEM];
	BOOL			m_bScopeWnd[MAX_SCOPE];

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CSubsysDoc)
	public:
	virtual void Serialize(CArchive& ar);   // hLg I/O ɑ΂ăI[o[Ch܂B
	virtual void DeleteContents();
	protected:
	virtual BOOL OnNewDocument();
	virtual BOOL SaveModified();
	//}}AFX_VIRTUAL

// Cve[V
public:
	virtual ~CSubsysDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// bZ[W }bv֐̐
protected:
	CLineArray m_arrLines;
	CWidgetArray m_arrWidgets;
	//{{AFX_MSG(CSubsysDoc)
	afx_msg void OnFileClose();
	afx_msg void OnUpdateFileClose(CCmdUI* pCmdUI);
	afx_msg void OnFileNew();
	afx_msg void OnUpdateFileNew(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileOpen(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSaveAs(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNcsExtncs(CCmdUI* pCmdUI);
	afx_msg void OnUpdateExtncsNcs(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
//	afx_msg void OnFileSave();
	afx_msg void OnFileSave();
	afx_msg void OnExtncsCode();
	afx_msg void OnUpdateExtncsCode(CCmdUI *pCmdUI);
	afx_msg void OnExtncsCompile();
	afx_msg void OnUpdateExtncsCompile(CCmdUI *pCmdUI);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_SUBSYSDOC_H__C1C03F0B_D91C_47D7_BB1B_80D798D58EAD__INCLUDED_)
