/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SubsysView.cpp,v 1.10 2004/09/14 07:22:21 yoshihiko Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "SubsysDoc.h"
#include "SubsysView.h"
#include "SubsysWnd.h"
#include "ExtncsDoc.h"
#include "ModelDoc.h"
#include "ExtncsView.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"
#include "ParamWnd.h"
#include "LineProp.h"
#include "WidgetExtend.h"
#include "ScopeList.h"
#include "ScopeFrame.h"
#include "MoniWnd.h"
#include "XyWnd.h"
#include ".\subsysview.h"

extern CExtncsMain*	g_pExtncsMain;
extern CMultiDocTemplate* g_pScopeTemplate;
extern CMultiDocTemplate* g_pSubsysTemplate;
extern	BOOL	simu_exit;		//~tO

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ParamWnd
typedef struct tagPARAMWNDINFO {
	//Window
	CParamWnd*	pWnd;
	//id
	CWidget*	pWidget;
} PARAMWNDINFO;

/////////////////////////////////////////////////////////////////////////////
// CSubsysView

IMPLEMENT_DYNCREATE(CSubsysView, CScrollView)

CSubsysView::CSubsysView()
{
	int i,nCount;

	m_bHitRLine = FALSE;
	m_bHitLLine = FALSE;
	m_bLineMode = FALSE;
	//Cursor
	m_hCross = NULL;
	m_hArrow = NULL;
	m_hRSize = NULL;
	m_hLSize = NULL;
	//m_paramArray
	nCount = (int)m_paramArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (PARAMWNDINFO*) m_paramArray.GetAt (i);
		m_paramArray.RemoveAll();
	}
	//Scope֌W
	for(i = 0; i < MAX_SCOPE; i++) {
		m_pScopeDoc[i] = NULL;
		m_pScopeWnd[i] = NULL;
	}
	m_nScopeMax = 0;
	//Subsystem֌W
	for(i = 0; i < MAX_SUBSYSTEM; i++) {
		m_pSubsysDoc[i] = NULL;
		m_pSubsysWnd[i] = NULL;
	}
	m_nSubsysMax = 0;

	//CtrlL[
	m_bCtrlKey = FALSE;
	//Resize
	m_nSizePoint = -1;
	m_bSizeMode = FALSE;
	//Region
	m_bAreaMode = FALSE;
	//CWidgetExtend
	m_pWidgetExtend = NULL;
	//CLineProp
	m_pLineProp = NULL;
	//ڑ_Ȃ
	m_connectPoint[0].x = -1; m_connectPoint[0].y = -1;
}

CSubsysView::~CSubsysView()
{
}


BEGIN_MESSAGE_MAP(CSubsysView, CScrollView)
	//{{AFX_MSG_MAP(CSubsysView)
	ON_WM_SETCURSOR()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateEditCut)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
	ON_COMMAND(ID_EDIT_DELETE, OnEditDelete)
	ON_UPDATE_COMMAND_UI(ID_EDIT_DELETE, OnUpdateEditDelete)
	ON_COMMAND(ID_LINE_PROP, OnLineProp)
	ON_UPDATE_COMMAND_UI(ID_LINE_PROP, OnUpdateLineProp)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_WIDGET_LINE, OnWidgetLine)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_LINE, OnUpdateWidgetLine)
	ON_COMMAND(ID_WIDGET_PARAM, OnWidgetParam)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_PARAM, OnUpdateWidgetParam)
	ON_COMMAND(ID_WIDGET_SCOPE, OnWidgetScope)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_SCOPE, OnUpdateWidgetScope)
	ON_COMMAND(ID_WIDGET_0, OnWidget0)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_0, OnUpdateWidget0)
	ON_COMMAND(ID_WIDGET_90, OnWidget90)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_90, OnUpdateWidget90)
	ON_COMMAND(ID_WIDGET_180, OnWidget180)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_180, OnUpdateWidget180)
	ON_COMMAND(ID_WIDGET_270, OnWidget270)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_270, OnUpdateWidget270)
	ON_COMMAND(ID_WIDGET_EXTEND, OnWidgetExtend)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_EXTEND, OnUpdateWidgetExtend)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_DESTROY()
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_EXTNCS_PARAM, OnParamChange)
	ON_MESSAGE(WM_DELETE_EXTEND, OnDeleteExtend)
	ON_MESSAGE(WM_DELETE_PARAM, OnDeleteParam)
	ON_MESSAGE(WM_DELETE_SCOPEFRAME, OnDeleteScopeFrame)
	ON_COMMAND(ID_EXTNCS_START, OnExtncsStart)
	ON_UPDATE_COMMAND_UI(ID_EXTNCS_START, OnUpdateExtncsStart)
	ON_COMMAND(ID_EXTNCS_STOP, OnExtncsStop)
	ON_UPDATE_COMMAND_UI(ID_EXTNCS_STOP, OnUpdateExtncsStop)
	ON_COMMAND(ID_EXTNCS_CONDITION, OnExtncsCondition)
	ON_UPDATE_COMMAND_UI(ID_EXTNCS_CONDITION, OnUpdateExtncsCondition)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSubsysView `

void CSubsysView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	// CSbsysView̃TCY
	SetScrollSizes(MM_TEXT, CSize (640, 480));
	// ݒ
	m_pTempWidget = NULL;
	m_pTempLine = NULL;
	m_nSel = -1;
	m_lSel = -1;
#if 0
	CPtrArray* pSubsys;
	int nCount,inport,outport;
	CSubsysDoc* pDoc = GetDocument();

	pSubsys = pDoc->m_pWidget->GetSubsysPointer();
	nCount = pSubsys->GetSize();
	if(!nCount) {
		//VKSubsystem쐬
		inport = pDoc->m_pWidget->GetInport();
		outport = pDoc->m_pWidget->GetOutport();
		NewSubsystem(inport, outport);
	}
	else {
		// SubsystemDocumentɐݒ
		pDoc->LoadSubsystem();
	}
#endif
}

void CSubsysView::OnDraw(CDC* pDC)
{
	CSubsysDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	//////////////////////////////////////////////////////////////////////////
	//̫Đݒ
	CFont	font;
	CFont*	pOldFont;
	CWidget* pWidget;
	CLine* pLine;
	int	id,junc,i,nCount;
	CPoint mpt,spt,ept;
	CRect rect;

	//font.CreateFont(MulDiv(7, -pDC->GetDeviceCaps(LOGPIXELSY), 72),
	//	0,0,0,FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,
	//	OUT_STROKE_PRECIS,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
	//	DEFAULT_PITCH,_T("MS P"));
	font.CreateFont(12,
		0,0,0,FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,
		OUT_STROKE_PRECIS,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
		DEFAULT_PITCH,_T("MS P"));
	pOldFont = pDC->SelectObject(&font);
	//\ݒ
	pDC->SetBkMode( TRANSPARENT );
    pDC->SetTextColor(0x0);

	// Widget\
	nCount = pDoc->GetWidgetCount ();
	if (nCount) {
		// Draw all widgets.
		for (i=0; i<nCount; i++) {
			pWidget = pDoc->GetWidget (i);
			id = pWidget->GetId();
			if(id != M_GAP && id != M_SYNAPSE)
				pWidget->Draw (pDC);
		}

		// Draw the selected widget if this view has the input focus.
		if(m_bAreaMode) {
			for (i=0; i<nCount; i++) {
				pWidget = pDoc->GetWidget (i);
				id = pWidget->GetId();
				if(pWidget->GetSel()) {
					if(id != M_GAP && id != M_SYNAPSE)
						pWidget->DrawSelected (pDC);
				}
			}
		}
		else {
			if (m_nSel != -1 && CWnd::GetFocus () == this) {
				pDoc->GetWidget (m_nSel)->DrawSelected (pDC);
			}
		}
	}
	// Line\
	nCount = pDoc->GetLineCount ();
	if (nCount) {
		// Draw all lines.
		for (i=0; i<nCount; i++) {
			pLine = pDoc->GetLine (i);
			//Junction`
			junc = pLine->GetJunction();
			if(junc != -1) {
				//W[̏oɔzu
				//if(pLine->GetType() == LINE_START) {
				//	//ʒuKv
				//	spt = pLine->GetSpos();
				//	ept = pLine->GetEpos();
				//	if(spt.x == ept.x)
				//		mpt = CPoint(spt.x-8, spt.y+(ept.y-spt.y)/2-8);
				//	else
				//		mpt = CPoint(spt.x+(ept.x-spt.x)/2-8, spt.y);
				//	rect = CRect(mpt, CSize(16,16));
				//	pDoc->GetWidget (junc)->SetRect(rect);
				//	pDoc->GetWidget (junc)->Draw(pDC);
				//}
				//W[̓ɔzu
				if(pLine->GetType() == LINE_STOP) {
					//ʒuKv
					spt = pLine->GetSpos();
					ept = pLine->GetEpos();
					if(spt.x == ept.x)
						mpt = CPoint(ept.x-8, ept.y-8);
					else
						mpt = CPoint(spt.x+(ept.x-spt.x)/2-8, ept.y);
					rect = CRect(mpt, CSize(16,16));
					pDoc->GetWidget (junc)->SetRect(rect);
					pDoc->GetWidget (junc)->Draw(pDC);
				}
			}
			//Line`
			pLine->Draw (pDC);
		}
	}
    pDC->SelectObject(pOldFont);
	font.DeleteObject();
}

/////////////////////////////////////////////////////////////////////////////
// CSubsysView ff

#ifdef _DEBUG
void CSubsysView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CSubsysView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSubsysView bZ[W nh

CSubsysDoc* CSubsysView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSubsysDoc)));
	return (CSubsysDoc*)m_pDocument;
}

BOOL CSubsysView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	BOOL flag;
	CSubsysDoc* pDoc = GetDocument();
	CExtncsDoc* pExtncsDoc = (CExtncsDoc*)(pDoc->m_pExtncsDoc);

	if(!pExtncsDoc->m_DragImageFile) {
		if(m_bHitRLine || m_bHitLLine) {
			//̃NX΂ȂŖ߂
		    //m_hArrow = SetCursor (m_hCross);
		    SetCursor (m_hCross);
			return TRUE;
		}
		else if(m_nSizePoint != -1) {
			//ResizeJ[\
			if(m_nSizePoint == 1 || m_nSizePoint == 3)
				SetCursor (m_hRSize);
			else
				SetCursor (m_hLSize);
			return TRUE;
		}
		else {
			SetCursor(m_hArrow);
			return TRUE;
		}
	}
	if(pExtncsDoc->m_DragImageFile) {
		SetCursor (m_hArrow);
		//ShowCursor(FALSE);
		m_pDragImage = pExtncsDoc->m_DragImageFile;
		flag = m_pDragImage->BeginDrag(0, CPoint(0, 0));
		flag = m_pDragImage->DragEnter(NULL/*this*/, CPoint(0,0));
		//::SetCapture(this->GetSafeHwnd());
		return TRUE;
	}
	
	return CScrollView::OnSetCursor(pWnd, nHitTest, message);
}

void CSubsysView::OnMouseMove(UINT nFlags, CPoint point) 
{
	CSubsysDoc* pDoc = GetDocument();
	CExtncsDoc* pExtncsDoc = (CExtncsDoc*)(pDoc->m_pExtncsDoc);
	int nCount = pDoc->GetWidgetCount ();
	CPoint newpos;
	int	outIndex, inIndex, nResize;
	CRect rect;

	//
	// Convert the click point to logical coordinates.
	//
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	if(!m_bSizeMode && !m_bLineMode && !pExtncsDoc->m_DragImageFile) {
		if (nCount) {
			//
			// Find out whether a widget was clicked.
			//
			int i;
			m_bHitRLine = m_bHitLLine = FALSE;
			m_nSizePoint = -1;
			for (i=nCount - 1; i>=0 && !m_bHitRLine; i--) {
				CWidget* pWidget = pDoc->GetWidget (i);
				//EC
				//if (pWidget->PtInWidget (point)) {
				if ((outIndex = pWidget->PtOnRLine (point)) != FALSE) {
					m_bHitRLine = TRUE;
					m_outIndex = outIndex;
					//
					// Select the widget of line  that was clicked.
					//
					m_nWidgetRLine = i;
					break;
				}
				//C
				//if (pWidget->PtInWidget (point)) {
				if ((inIndex = pWidget->PtOnLLine (point, &newpos)) != FALSE) {
					m_bHitLLine = TRUE;
					m_inIndex = inIndex;
					//
					// Select the widget of line  that was clicked.
					//
					m_nWidgetLLine = i;
					break;
				}
				//Resize_
				if(m_nSel != -1) {
					//WidgetIĂƂ
					if((nResize = pWidget->PtOnResize(point)) != -1) {
						m_nSizePoint = nResize;
					}
				}
			}
		}
	}

	if(m_bLineMode) {
		//C[hhbOȂ
		if (GetCapture () == this) {
			if (m_ptTo != point) {
				InvertLine (&dc, m_ptFrom, m_ptTo);
				InvertLine (&dc, m_ptFrom, point);
				m_ptTo = point;
				//ڑ`FbN
				CheckConnect(&dc, point);
			}
		}
	}

	if(m_bSizeMode) {
		if (GetCapture () == this) {
			rect = CRect(m_ptFrom.x, m_ptFrom.y, m_ptTo.x, m_ptTo.y);
			rect.NormalizeRect();
			dc.DrawFocusRect(rect);
			rect.SetRect(m_ptFrom.x, m_ptFrom.y, point.x, point.y);
			rect.NormalizeRect();
			dc.DrawFocusRect(rect);
			m_ptTo = point;
		}
	}

	if(pExtncsDoc->m_DragImageFile) {
		//BlockViewhbO
		dc.LPtoDP (&point);
		GetWindowRect(&rect);
		newpos.x = rect.left + point.x;
		newpos.y = rect.top + point.y;
		m_pDragImage->DragEnter(NULL, newpos/*point*/);
		m_pDragImage->DragMove(newpos/*point*/);
	}

	if(m_bAreaMode) {
		if (GetCapture () == this) {
			if (m_ptTo != point) {
				InvertRect (&dc, m_ptFrom, m_ptTo);
				InvertRect (&dc, m_ptFrom, point);
				m_ptTo = point;
			}
		}
	}
	
	CScrollView::OnMouseMove(nFlags, point);
}

//
// }EXڑ\ȈʒuɂA͖redɕύX֐
//
void CSubsysView::CheckConnect(CDC* pDC, CPoint pos)
{
	CSubsysDoc *pDoc = GetDocument();
	int nCount = pDoc->GetWidgetCount ();
	CPoint newpos;
	int i,index,ports,direction;
	CWidget* pWidget;
	CRect rect;
	double hstep;
	CPen *oldPen;
	CBrush	*oldBrs;
	CBrush	arrowBrs(RGB(255, 0, 0));
	CPen	arrowPen(PS_SOLID, 1, RGB(255,0,0));
	CBrush	defaultBrs(RGB(0, 0, 0));


	if(m_connectPoint[0].x != -1 && m_connectPoint[0].y != -1) {
		//O`悵
		oldBrs = pDC->SelectObject(&defaultBrs);
		pDC->Polygon(m_connectPoint, 3);
		pDC->SelectObject(oldBrs);
	}
	for (i=nCount - 1; i>=0; i--) {
		pWidget = pDoc->GetWidget (i);
		if (index = pWidget->PtOnLLine (pos, &newpos)) {
			//̐ڑ_̑ύXȂ
			rect = pWidget->GetRect();
			ports = pWidget->GetInport();
			direction = pWidget->GetDirection();
			switch(direction) {
			case	DIR_RIGHT:
				hstep = (double)rect.Height() / (ports + 1);
				m_connectPoint[0].x = rect.left;
				m_connectPoint[0].y = rect.top + (int)(hstep * index + 0.5);
				m_connectPoint[1].x = m_connectPoint[0].x - 5;
				m_connectPoint[1].y = m_connectPoint[0].y - 4;
				m_connectPoint[2].x = m_connectPoint[0].x - 5;
				m_connectPoint[2].y = m_connectPoint[0].y + 4;
			break;

			case	DIR_UP:
				hstep = (double)rect.Width() / (ports + 1);
				m_connectPoint[0].x = rect.left + (int)(hstep * index + 0.5);
				m_connectPoint[0].y = rect.bottom;
				m_connectPoint[1].x = m_connectPoint[0].x - 4;
				m_connectPoint[1].y = m_connectPoint[0].y + 5;
				m_connectPoint[2].x = m_connectPoint[0].x + 4;
				m_connectPoint[2].y = m_connectPoint[0].y + 5;
			break;

			case	DIR_LEFT:
				hstep = (double)rect.Height() / (ports + 1);
				m_connectPoint[0].x = rect.right;
				m_connectPoint[0].y = rect.top + (int)(hstep * index + 0.5);
				m_connectPoint[1].x = m_connectPoint[0].x + 5;
				m_connectPoint[1].y = m_connectPoint[0].y - 4;
				m_connectPoint[2].x = m_connectPoint[0].x + 5;
				m_connectPoint[2].y = m_connectPoint[0].y + 4;
			break;

			case	DIR_DOWN:
				hstep = (double)rect.Width() / (ports + 1);
				m_connectPoint[0].x = rect.left + (int)(hstep * index + 0.5);
				m_connectPoint[0].y = rect.top;
				m_connectPoint[1].x = m_connectPoint[0].x - 4;
				m_connectPoint[1].y = m_connectPoint[0].y - 5;
				m_connectPoint[2].x = m_connectPoint[0].x + 4;
				m_connectPoint[2].y = m_connectPoint[0].y - 5;
			break;
			}
			// `
			oldPen = pDC->SelectObject(&arrowPen);
			oldBrs = pDC->SelectObject(&arrowBrs);
			pDC->Polygon(m_connectPoint, 3);
			pDC->SelectObject(oldBrs);
			pDC->SelectObject(oldPen);
		}
	}
}

void CSubsysView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CSubsysDoc *pDoc = GetDocument();
	CExtncsDoc* pExtncsDoc = (CExtncsDoc*)(pDoc->m_pExtncsDoc);
	int nCount = pDoc->GetWidgetCount ();
	CPoint pos, newpos;
	int i, index, nLine,row,column,cx,cy;
	CWidget* pWidget;
	CRect lineRect,rect;
	CLine* pLine;
	int mid;		//W[ID

	// Convert the click point to logical coordinates.
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);
	pos = point;

	if(m_bLineMode && !pExtncsDoc->m_DragImageFile) {
		//C[hhbOȂ
		if (GetCapture () == this) {
			::ReleaseCapture ();
			InvertLine (&dc, m_ptFrom, m_ptTo);
			//ڑ悩
			m_bHitLLine = FALSE;
			for (i=nCount - 1; i>=0 && !m_bHitLLine; i--) {
				pWidget = pDoc->GetWidget (i);
				if (index = pWidget->PtOnLLine (pos, &newpos)) {
					m_bHitLLine = TRUE;
					// Select the widget of line  that was clicked.
					m_nWidgetLLine = i;
				}
			}
			if(m_bHitLLine) {
				//m_ptToʒu
				//o^
				if(m_bCtrlKey) {	// Line->WidgetԐڑ
					lineRect.left = m_ptFrom.x;
					lineRect.top = m_ptFrom.y;
					lineRect.right = newpos.x/*m_ptTo.x*/;
					lineRect.bottom = newpos.y/*m_ptTo.y*/;
					pDoc->InsertDivide (lineRect, m_lSel, m_nWidgetRLine, m_nWidgetLLine, index, -1);
					//IĂ郉CI
					m_lSel = -1;
					nLine = pDoc->GetLineCount();
					for(i = 0; i < nLine; i++) {
						pLine = pDoc->GetLine(i);
						pLine->SetSel (FALSE);
					}
					pDoc->UpdateAllViews(NULL);
				}
				else {	// Widget->WidgetԐڑ
					//CELL͖
					if(m_nWidgetRLine != m_nWidgetLLine) {
						lineRect.left = m_ptFrom.x;
						lineRect.top = m_ptFrom.y;
						lineRect.right = newpos.x/*m_ptTo.x*/;
						lineRect.bottom = newpos.y/*m_ptTo.y*/;
						pDoc->InsertLine (lineRect, m_nWidgetRLine, m_nWidgetLLine, index, m_outIndex, -1);
					}
				}
			}
			//C[hNA
			m_bLineMode = FALSE;
			m_bHitLLine = FALSE;
		}	
	}

	if(m_bSizeMode && !pExtncsDoc->m_DragImageFile) {
		//Resize[hhbOȂ
		if (GetCapture () == this) {
			::ReleaseCapture ();
			//g_ɉCellTCYύX
			pWidget = pDoc->GetWidget (m_nSel);
			ASSERT (pWidget != NULL);
			switch (m_nSizePoint) {
			case	0:
				rect = CRect(pos.x, pos.y, m_ptFrom.x, m_ptFrom.y);
				break;
			case	1:
				rect = CRect(pos.x, m_ptFrom.y, m_ptFrom.x, pos.y);
				break;
			case	2:
				rect = CRect(m_ptFrom.x, m_ptFrom.y, pos.x, pos.y);
				break;
			case	3:
				rect = CRect(m_ptFrom.x, pos.y, pos.x, m_ptFrom.y);
				break;
			}
			//TCY𒲐Ăݒ
			row = pWidget->GetCellRow();
			column = pWidget->GetCellColumn();
			if(row*column > 1) {
				cx = rect.Width() / column;
				cx = column * cx;
				cy = rect.Height() / row;
				cy = row * cy;
				rect.right = rect.left + cx;
				rect.bottom = rect.top + cy;
			}
			pWidget->SetRect(rect);
			//ZɐڑĂ郉C̈ʒuύX
			//ړɂ郉Cۑ
			SaveWidgetLine(m_nSel);
			//m_nSelɊ֌W郉C폜
			nLine = pDoc->GetLineCount();
			for (i=nLine - 1; i>=0 ; i--) {
				pLine = pDoc->GetLine(i);
				if(pLine->GetSblk() == m_nSel) {
					pDoc->RemoveLine(i);
				}
				if(pLine->GetEblk() == m_nSel) {
					pDoc->RemoveLine(i);
				}
			}
			//C
			LoadWidgetLine(m_nSel, nCount+1);
			//I
			m_nSel = -1;
			if(pWidget->GetSel())
				pWidget->SetSel (FALSE);
			//ĕ`
			pDoc->UpdateAllViews (NULL);

			//Resize[hNA
			m_bSizeMode = FALSE;
			m_nSizePoint = -1;
		}
	}

	if(!m_bHitRLine && pExtncsDoc->m_DragImageFile) {
		m_pDragImage->EndDrag();
		//::ReleaseCapture();
		//ShowCursor(TRUE);
		//C[W폜
		delete m_pDragImage;
		//TvoגȂ̂łubNł̎gp𐧌
		mid = pExtncsDoc->m_DragItemIndex;
		if(/*mid == M_SHELL || mid == M_FILE ||*/ mid == M_IMAGE
			/*|| mid == M_XY*/ || mid == M_TITLE || mid == M_AD3120 || mid == M_DA3338) {
			//bZ[W\Ė
			MessageBox("Now, it cannot be used. ",PACKAGE_STRING,MB_ICONWARNING | MB_OK);
		}
		else {
			//Widget쐬AGapSynapseO[v͓삪قȂ
			//if(mid == M_GAP || mid == M_SYNAPSE) {
			if(pExtncsDoc->m_DragItemGroup == MODULE_SYNAPSE ||
				pExtncsDoc->m_DragItemGroup == MODULE_GAP) {
				if((index = CheckIntersectWidget(point)) != -1) {
					//Lineɑݒ
					pDoc->InsertWidgetJunc(pExtncsDoc->m_DragItemIndex, point, index);
				}
			}
			else {
				if(!pDoc->InsertWidget(pExtncsDoc->m_DragItemIndex, point)) {
					//s
				}
				else {
					//ExtncsViewSubsystemVKzu
					if(pExtncsDoc->m_DragItemIndex == M_SUBSYSTEM) {
						pExtncsDoc->UpdateAllViews(NULL, 0x6A);
					}
				}
			}
		}
		//
		pExtncsDoc->m_DragImageFile = NULL;
	}

	if(m_bAreaMode) {
		if (GetCapture () == this) {
			::ReleaseCapture ();
			//m_bAreaMode = FALSE;

			//̈Widget܂܂Ă邩H
			if(AreaInWidgets(m_ptFrom, m_ptTo)) {
				//|bvAbvj[J
				// }EX|C^XN[Wɕϊ
				this->ClientToScreen( &point );
				// gɃtH[JXݒ
				SetForegroundWindow();
				// |bvAbvj[̍쐬
				CMenu menu;
				// IDR_MENUPOPUP_ESLMON̓j[̃\[XID
				menu.LoadMenu( IDR_POPUP_AREA );
				CMenu* pPopup = menu.GetSubMenu( 0 );
				// |bvAbvj[\
				pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
						point.x, point.y, this);
				// LoadMenuJ
				menu.DestroyMenu();
				// IԂɂ
				pDoc->UpdateAllViews(NULL);
			}
			InvertRect (&dc, m_ptFrom, m_ptTo);
		}
	}
	
	CScrollView::OnLButtonUp(nFlags, point);
}

// ̈WidgetSɊ܂܂Ă邩
BOOL CSubsysView::AreaInWidgets(POINT from, POINT to)
{
	int nCount,i,obj,bHit;
	CSubsysDoc* pDoc = GetDocument();
	CWidget* pWidget;
	char buf[_MAX_PATH];
	CRect rect = CRect(from, to);

	obj = 0;
	nCount = pDoc->GetWidgetCount ();
	for (i=nCount - 1; i>=0 ; i--) {
		pWidget = pDoc->GetWidget (i);
		pWidget->SetSel(FALSE);
		bHit = pWidget->AreaInWidget (rect);
		if(bHit == WIDGET_CROSS) {
			obj = 0;
			sprintf(buf,"%s crossed.", pWidget->GetName());
			MessageBox(buf, "Extncs", MB_OK | MB_ICONERROR);
			break;
		}
		else if(bHit == WIDGET_IN) {
			obj++;
			pWidget->SetSel(TRUE);
		}
	}
	if(obj > 0)
		return TRUE;
	else {
		//SĂ̑I
		for (i=nCount - 1; i>=0 ; i--) {
			pWidget = pDoc->GetWidget (i);
			pWidget->SetSel(FALSE);
		}
		return FALSE;
	}
}

int CSubsysView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CScrollView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	m_oleDropTarget.Register (this);
	m_hCross = LoadCursor(NULL, MAKEINTRESOURCE(IDC_CROSS));
	m_hArrow = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
	m_hRSize = LoadCursor(NULL, MAKEINTRESOURCE(IDC_SIZENESW));	//Eオ
	m_hLSize = LoadCursor(NULL, MAKEINTRESOURCE(IDC_SIZENWSE));	//オ
	
	return 0;
}

void CSubsysView::InvertLine(CDC *pDC, POINT from, POINT to)
{
    int nOldMode = pDC->SetROP2 (R2_NOT);
    pDC->MoveTo (from);
    pDC->LineTo (to);
    pDC->SetROP2 (nOldMode);
}

void CSubsysView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CScrollView::OnLButtonDown(nFlags, point);

	// Get SubsysDoc
	CSubsysDoc *pDoc = GetDocument();
	int nCount = pDoc->GetWidgetCount ();
	int lCount = pDoc->GetLineCount();

	// Convert the click point to logical coordinates.
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	CPoint pos;
	CWidget* pWidget;
	CRect rect;
	int outport,hstep,i,sbk,nMouse,row,column;
	BOOL bHit;
	CLine* pLine;
	HANDLE hData;
	COleDataSource ods;
	UINT nFormat;

	if(m_bHitRLine) {
		//\[XWidget烉C
		pos = point;
		pWidget = pDoc->GetWidget (m_nWidgetRLine);
		ASSERT (pWidget != NULL);
		rect = pWidget->GetRect ();
		outport = pWidget->GetOutport();
		row = pWidget->GetCellRow();
		column = pWidget->GetCellColumn();

		if(row*column != 1 && m_outIndex > 1) {
			//gCELL̏ꍇAS߂
			pos = pWidget->GetWidgetCenter(point);
		}
		else {
			//SINGLE_CELL̏ꍇ́Ǎ_w肷
			switch(pWidget->GetDirection()) {
			case	DIR_RIGHT:
				pos.x = rect.right;
				hstep = (rect.bottom - rect.top) / (outport + 1);
				pos.y = rect.top + hstep * m_outIndex;
				break;
			case	DIR_UP:
				pos.y = rect.top;
				hstep = (rect.right - rect.left) / (outport + 1);
				pos.y = rect.left + hstep * m_outIndex;
				break;
			case	DIR_LEFT:
				pos.x = rect.left;
				hstep = (rect.bottom - rect.top) / (outport + 1);
				pos.y = rect.top + hstep * m_outIndex;
				break;
			case	DIR_DOWN:
				pos.y = rect.bottom;
				hstep = (rect.right - rect.left) / (outport + 1);
				pos.y = rect.left + hstep * m_outIndex;
				break;
			}
		}
		m_ptFrom = pos;
		m_ptTo = pos;
		SetCapture ();

		//C`惂[h
		m_bLineMode = TRUE;
		m_bHitRLine = m_bHitLLine = FALSE;
		return;
	}

	//򃉃C`惂[h
	if (m_nSel != -1 && m_nSizePoint != -1) {
		pos = point;
		pWidget = pDoc->GetWidget (m_nSel);
		ASSERT (pWidget != NULL);
		rect = pWidget->GetRect ();

		//ResizëɃJ[\
		switch(m_nSizePoint) {
		case	0:
			m_ptFrom = CPoint(rect.right, rect.bottom);
			break;
		case	1:
			m_ptFrom = CPoint(rect.right, rect.top);
			break;
		case	2:
			m_ptFrom = CPoint(rect.left, rect.top);
			break;
		case	3:
			m_ptFrom = CPoint(rect.left, rect.bottom);
			break;
		}
		m_ptTo = pos;
		SetCapture ();
		m_bSizeMode = TRUE;
		return;
	}

	//WidgetI[h
	if (!m_bLineMode && nCount) {
		// Find out whether a widget was clicked.
		bHit = FALSE;
		for (i=nCount - 1; i>=0 && !bHit; i--) {
			pWidget = pDoc->GetWidget (i);
			if (pWidget->PtInWidget (point)) {
				bHit = TRUE;
				pWidget->SetSel( TRUE );
			}
			else
				pWidget->SetSel( FALSE );
		}

		// If no widget was clicked, change the selection to NULL and exit.
		if (!bHit) {
			//ubNO
			m_nSel = -1;
			pDoc->UpdateAllViews (NULL);
			//InvalidateRect (NULL, FALSE);
		}
		else {
			// Select the widget that was clicked.
			int nWidgetIndex = i + 1;

			if (m_nSel != nWidgetIndex) {
				m_nSel = nWidgetIndex;
				pDoc->UpdateAllViews (NULL);
			}
			// Begin a drag-and-drop operation involving the selected widget.
			HANDLE hData = ::GlobalAlloc (GMEM_MOVEABLE, sizeof (WIDGETINFO));

			WIDGETINFO* pWidgetInfo = (WIDGETINFO*) ::GlobalLock (hData);
			pWidget = pDoc->GetWidget (nWidgetIndex);
			ASSERT (pWidget != NULL);
			rect = pWidget->GetRect ();
			pWidgetInfo->cx = point.x - rect.left;
			pWidgetInfo->cy = point.y - rect.top;
			pWidgetInfo->id = pWidget->GetId();
			char name[256];
			pWidget->GetName(pWidgetInfo->id, name);
			strcpy(pWidgetInfo->name, name);
			pWidgetInfo->color = pWidget->GetColor ();
			pWidgetInfo->direction = pWidget->GetDirection();
			strcpy(pWidgetInfo->matrix, (LPCTSTR)pWidget->GetMatrix());
			pWidgetInfo->width = rect.Width();
			pWidgetInfo->height = rect.Height();
			pWidgetInfo->inport = pWidget->GetInport();
			pWidgetInfo->outport = pWidget->GetOutport();
			strcpy(pWidgetInfo->bmp ,(LPCTSTR)pWidget->GetBitmap());
			//ړɂp[^[ۑ
			pWidgetInfo->pParamArray = pWidget->GetParamPointer();
			//ړɂ郉Cۑ
			SaveWidgetLine(nWidgetIndex);
			//Subsystem
			if(pWidget->GetId() == M_SUBSYSTEM) {
				pWidgetInfo->pDoc = NULL;
				pWidgetInfo->pSubsysArray = (CPtrArray*)pWidget/*->GetSubsysPointer()*/;
			}
			else {
				pWidgetInfo->pDoc = NULL;
				pWidgetInfo->pSubsysArray = NULL;
			}
			//CELLg
			pWidgetInfo->junction = pWidget->GetJunction();
			pWidgetInfo->connect = pWidget->GetConnect();
			//Scope
			pWidgetInfo->pScopeWnd = pWidget->GetScope();
			pWidgetInfo->pScopeArray = pWidget->GetScopePointer();

			::GlobalUnlock (hData);

			COleDataSource ods;
			UINT nFormat;
			nFormat = g_pExtncsMain->GetClipboardFormat ();
			//nFormat = pDoc->m_nFormat;
			ods.CacheGlobalData (nFormat, hData);

			int nOldSel = m_nSel;
			DROPEFFECT de = ods.DoDragDrop (DROPEFFECT_COPY | DROPEFFECT_MOVE);

			if (de == DROPEFFECT_MOVE) {
				pDoc->RemoveWidget (nWidgetIndex);
				int nCount = pDoc->GetWidgetCount ();
				if (nOldSel == m_nSel || nCount == 0)
					m_nSel = -1;
				else if (m_nSel >= nCount)
					m_nSel = nCount - 1;
				//WidgetړɊ֌W郉C`
				if(m_moveArray.GetSize() > 0) {
					LoadWidgetLine(m_nSel, nWidgetIndex);
				}
				//ړÎőI
				m_nSel = -1;
				pDoc->UpdateAllViews (NULL);
			}
			return;
		}
	}

	if (!m_bLineMode && lCount) {
		// Find out whether a line was clicked.
		bHit = FALSE;
		for (i=lCount - 1; i>=0 && !bHit; i--) {
			pLine = pDoc->GetLine (i);
			if (pLine->PtInLine (point)) {
				if(m_bCtrlKey) {
					bHit = TRUE;
					pLine->SetSel( TRUE );
				}
				else {
					if(pLine->GetType() == LINE_MIDST) {
						bHit = TRUE;
						pLine->SetSel( TRUE );
					}
					else
						pLine->SetSel(FALSE);
				}
			}
			else
				pLine->SetSel( FALSE );
		}

		// If no widget was clicked, change the selection to NULL and exit.
		if (!bHit) {
			//CO
			m_lSel = -1;
			pDoc->UpdateAllViews (NULL);
			//InvalidateRect (NULL, FALSE);
		}
		else {
			//CtrlL[̏ԂŏقȂ
			if(m_bCtrlKey) {
				//ApLineɂ́AsourceubN񂪂
				m_lSel = i + 1;		//iԖڂ̃CI
				m_nWidgetRLine = pLine->GetSblk();
				pos = point;
				m_ptFrom = pos;
				m_ptTo = pos;
				//I+J[\
				SetCursor (m_hCross);
				SetCapture ();
				//Line`惂[h
				m_bLineMode = TRUE;
				nMouse = (int)m_mouseArray.GetSize();
				if(nMouse > 0) {
					for (i=0; i<nMouse; i++)
						delete (PARAMWNDINFO*) m_mouseArray.GetAt (i);
					m_mouseArray.RemoveAll();
				}
			}
			else {
				//iԖڂ̃CI
				int nLineIndex = i + 1;
				if (m_lSel != nLineIndex) {
					m_lSel = nLineIndex;
					pDoc->UpdateAllViews (NULL);
				}
				//ڑ̂̂I
				sbk = pLine->GetSblk();
				for(i = 0; i < lCount; i++) {
					pLine = pDoc->GetLine (i);
					if(sbk == pLine->GetSblk())
						pLine->SetSel( TRUE );
				}
				InvalidateRect (NULL, FALSE);
				// Begin a drag-and-drop operation involving the selected widget.
				hData = ::GlobalAlloc (GMEM_MOVEABLE, sizeof (LINEINFO));

				LINEINFO* pLineInfo = (LINEINFO*) ::GlobalLock (hData);
				pLine = pDoc->GetLine (nLineIndex);
				ASSERT (pLine != NULL);
				pLineInfo->spt = pLine->GetSpos();
				pLineInfo->ept = pLine->GetEpos();
				pLineInfo->arrow = pLine->GetArrow();
				pLineInfo->color = pLine->GetColor ();
				pLineInfo->sblk = pLine->GetSblk();
				pLineInfo->eblk = pLine->GetEblk();
				pLineInfo->index = pLine->GetIndex();
				pLineInfo->inport = pLine->GetInport();
				pLineInfo->outport = pLine->GetOutport();
				pLineInfo->type = pLine->GetType();
				pLineInfo->junction = pLine->GetJunction();

				::GlobalUnlock (hData);

				nFormat = g_pExtncsMain->GetClipboardFormat ();
				//nFormat = pDoc->m_nFormat;
				ods.CacheGlobalData (nFormat, hData);

				int nOldSel = m_lSel;
				DROPEFFECT de = ods.DoDragDrop (DROPEFFECT_COPY | DROPEFFECT_MOVE);

				if (de == DROPEFFECT_MOVE) {
					//pDoc->RemoveLine (nLineIndex);
					pDoc->RemoveLineAt (nLineIndex);
					lCount = pDoc->GetLineCount ();
					if (nOldSel == m_lSel || lCount == 0)
						m_lSel = -1;
					else if (m_lSel >= lCount)
						m_lSel = lCount - 1;
					pDoc->UpdateAllViews (NULL);
				}
				return;
			}
		}
	}
	//̈I[h
	m_ptFrom = point;
	m_ptTo = point;
	SetCapture ();
	m_bAreaMode = TRUE;
}

void CSubsysView::SaveWidgetLine(int widget)
{
	CSubsysDoc* pDoc = GetDocument();
	CLine* pLine;
	int i,lCount,sblk,eblk,inport,outport,index,port;
	MOVELINE* pItem;
	CPoint epos;

	//NA
	lCount = (int)m_moveArray.GetSize();
	if(lCount > 0) {
		for (i=0; i<lCount; i++)
			delete (MOVELINE*) m_moveArray.GetAt (i);
		m_moveArray.RemoveAll();
	}

	//indexWidgetւ̓̓C
	lCount = pDoc->GetLineCount();
	inport = -1;
	for(i = 0; i < lCount; i++) {
		pLine = pDoc->GetLine( i );
		eblk = pLine->GetEblk();	//C̏o͒[ĂCELL
		if(eblk == widget) {
			port = pLine->GetInport();
			if(port != inport) {
				inport = port;
				try {
					pItem = new MOVELINE;
				}
				catch (CMemoryException* e) {
					AfxMessageBox (_T ("Out of memory"));
					if (pItem != NULL)
						delete pItem;
					e->Delete ();
					return;
				}
				//ݒ
				pItem->type = 0;		//Widgetւ̓͂
				pItem->eblk = eblk;
				pItem->sblk = pLine->GetSblk();
				pItem->s_arrow = pLine->GetArrow();
				pItem->inport = pLine->GetInport();
				pItem->outport = pLine->GetOutport();
				if(pItem->outport == -1) {	//_̃C
					pItem->bpt = pLine->GetSpos();
					epos = pLine->GetEpos();
					if(pItem->bpt.x == epos.x)
						pItem->btype = HORZ_LINE;
					else
						pItem->btype = VERT_LINE;
				}
				else
					pItem->bpt = CPoint(-1,-1);
				pItem->junction = pLine->GetJunction();
				//widget͍폜̂ŁA傫ꍇ͏C
				if(pItem->junction > widget)
					pItem->junction -= 1;
				index = (int)m_moveArray.Add (pItem);
			}
			else {
				pItem->e_arrow = pLine->GetArrow();
			}
		}
	}
	//indexWidget̏o̓C
	outport = -1;
	for(i = 0; i < lCount; i++) {
		pLine = pDoc->GetLine( i );
		sblk = pLine->GetSblk();
		if(sblk == widget) {
			port = pLine->GetOutport();
			if(port != outport) {
				outport = port;
				try {
					pItem = new MOVELINE;
				}
				catch (CMemoryException* e) {
					AfxMessageBox (_T ("Out of memory"));
					if (pItem != NULL)
						delete pItem;
					e->Delete ();
					return;
				}
				//ݒ
				pItem->type = 1;		//Widgetւ̓͂
				pItem->eblk = pLine->GetEblk();
				pItem->sblk = sblk;
				pItem->s_arrow = pLine->GetArrow();
				pItem->inport = pLine->GetInport();
				pItem->outport = pLine->GetOutport();
				if(pItem->outport == -1) {
					pItem->bpt = pLine->GetSpos();
					epos = pLine->GetEpos();
					if(pItem->bpt.x == epos.x)
						pItem->btype = HORZ_LINE;
					else
						pItem->btype = VERT_LINE;
				}
				else
					pItem->bpt = CPoint(-1,-1);
				pItem->junction = pLine->GetJunction();
				//widget͍폜̂ŁA傫ꍇ͏C
				if(pItem->junction > widget)
					pItem->junction -= 1;
				index = (int)m_moveArray.Add (pItem);	
			}
			else {
				pItem->e_arrow = pLine->GetArrow();
			}
		}
	}

}

void CSubsysView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if(nChar == VK_CONTROL)
		m_bCtrlKey = TRUE;
	else
		m_bCtrlKey = FALSE;
	
	CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CSubsysView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	m_bCtrlKey = FALSE;
	
	CScrollView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CSubsysView::OnEditCut() 
{
	if (m_nSel != -1 || m_lSel != -1) {
		OnEditCopy ();
		OnEditDelete ();
	}	
	
}

void CSubsysView::OnUpdateEditCut(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (m_nSel != -1 || m_lSel != -1);
}

void CSubsysView::ChangeName(char* name)
{
	CSubsysDoc* pDoc = GetDocument();
	CWidget* pWidget;
	CString tgtName,tmpName;
	char tgtIndex[16];
	int i,nCount,index;
	BOOL fg;

	nCount = pDoc->GetWidgetCount ();
	index = 1;
	for(;;) {
		sprintf(tgtIndex,"%d",index);
		tgtName = _T(name);
		tgtName += _T(tgtIndex);
		fg = TRUE;
		for(i = 0; i < nCount; i++) {
			pWidget = pDoc->GetWidget(i);
			tmpName = pWidget->GetName();
			if(tgtName.Compare(tmpName) == 0) {
				fg = FALSE;
				break;
			}
		}
		index++;
		if(fg)
			break;
	}
	strcpy(name, tgtName);
}

void CSubsysView::OnEditCopy() 
{
	CSubsysDoc* pDoc = GetDocument ();
	if (m_nSel != -1) {
		//
		// Copy data describing the currently selected widget to a
		// global memory block.
		//
		HANDLE hData = ::GlobalAlloc (GMEM_MOVEABLE, sizeof (WIDGETINFO));

		WIDGETINFO* pWidgetInfo = (WIDGETINFO*) ::GlobalLock (hData);
		CWidget* pWidget = pDoc->GetWidget (m_nSel);
		ASSERT (pWidget != NULL);
		CRect rect = pWidget->GetRect ();
		rect = pWidget->GetRect ();
		pWidgetInfo->x = rect.left + rect.Width() / 2;
		pWidgetInfo->y = rect.top + rect.Height() / 2;
		pWidgetInfo->cx = rect.right - rect.left;
		pWidgetInfo->cy = rect.bottom - rect.top;
		pWidgetInfo->id = pWidget->GetId();
		char name[_MAX_PATH];
		pWidget->GetName(pWidgetInfo->id, name);
		strcpy(pWidgetInfo->name, name);

		pWidgetInfo->color = pWidget->GetColor ();
		pWidgetInfo->direction = pWidget->GetDirection();
		strcpy(pWidgetInfo->matrix, (LPCTSTR)pWidget->GetMatrix());
		pWidgetInfo->width = rect.Width();
		pWidgetInfo->height = rect.Height();
		pWidgetInfo->inport = pWidget->GetInport();
		pWidgetInfo->outport = pWidget->GetOutport();
		strcpy(pWidgetInfo->bmp ,(LPCTSTR)pWidget->GetBitmap());
		//p[^[
		pWidgetInfo->pParamArray = pWidget->GetParamPointer();
		//ړɂ郉Cۑ
		//SubsystemŁASubsystem͎gpłȂ
		//Subsystem
		if(pWidget->GetId() == M_SUBSYSTEM) {
			pWidgetInfo->pDoc = NULL;
			pWidgetInfo->pSubsysArray = (CPtrArray*)pWidget/*->GetSubsysPointer()*/;
		}
		else {
			pWidgetInfo->pDoc = NULL;
			pWidgetInfo->pSubsysArray = NULL;
		}

		::GlobalUnlock (hData);

		//
		// Place the widget on the clipboard.
		//
		COleDataSource* pods = new COleDataSource;
		//TODO:`FbN
		UINT nFormat = g_pExtncsMain->GetClipboardFormat ();
		//UINT nFormat = pDoc->m_nFormat;
		pods->CacheGlobalData (nFormat, hData);
		pods->SetClipboard ();
	}
}

void CSubsysView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (m_nSel != -1);	
}

void CSubsysView::OnEditPaste() 
{
	// Local
	CSubsysDoc *pDoc = GetDocument();
	int	x,y,id,direction,row,column,width,height,inport,outport;
	char name[_MAX_PATH];
	CString matrix, bmpName;
	COLORREF color;
	CPtrArray* pSubsysArray;
	CSubsysDoc* pSubsysDoc;
	CWidget* pWidget;
	CPoint newpoint;
	CPtrArray* pInOut;
	CPtrArray* pParamArray;
	int i,nParam;
	char strValue[100][16];
	PARAMINFO* pItem;
	CExtncsDoc* pExtncsDoc = (CExtncsDoc*)(pDoc->m_pExtncsDoc);

	//
	// Create a COleDataObject and attach it to the clipboard.
	//
	COleDataObject odo;
	odo.AttachClipboard ();

	//
	// Retrieve the HGLOBAL from the clipboard and create a widget.
	//
	//TODO:`FbN
	UINT nFormat = g_pExtncsMain->GetClipboardFormat ();
	//UINT nFormat = pDoc->m_nFormat;
	HGLOBAL hData = odo.GetGlobalData (nFormat);

	if (hData != NULL) {
		WIDGETINFO* pWidgetInfo = (WIDGETINFO*) ::GlobalLock (hData);
		x = pWidgetInfo->x;
		y = pWidgetInfo->y;
		color = pWidgetInfo->color;
		id = pWidgetInfo->id;
		direction = pWidgetInfo->direction;
		strcpy(name, pWidgetInfo->name);
		//OAO݂΃CfbNXt
		strcat(name, "_");
		ChangeName(name);
		matrix = pWidgetInfo->matrix;
		row = pDoc->GetMatrixRow(pWidgetInfo->matrix);
		column = pDoc->GetMatrixColumn(pWidgetInfo->matrix);
		width = pWidgetInfo->width;
		height = pWidgetInfo->height;
		inport = pWidgetInfo->inport;
		outport = pWidgetInfo->outport;
		pParamArray = pWidgetInfo->pParamArray;		//parameter
		pSubsysArray = pWidgetInfo->pSubsysArray;	//subsystem
		pSubsysDoc = (CSubsysDoc *)pWidgetInfo->pDoc;
		bmpName = pWidgetInfo->bmp;

		::GlobalUnlock (hData);
		::GlobalFree (hData);

		//parameterɊւ鏈
		nParam = (int)pParamArray->GetSize();
		if(nParam > 0) {
			for (i=0; i<nParam; i++) {
				//RootVXéAl̂
				pItem = (PARAMINFO*) pParamArray->GetAt (i);
				strcpy(strValue[i], pItem->strValue);
			}
		}
		//matrixl傫ɂ
		if(row*column != 1) {
			width = pWidgetInfo->width / column;
			height = pWidgetInfo->height / row;
		}
		newpoint.x = x; newpoint.y = y;
		if(nParam > 0)
			m_nSel = pDoc->AddWidget2(id, newpoint, name,
				direction, matrix, nParam, strValue, width, height);
		else
			m_nSel = pDoc->AddWidget (id, newpoint, name, direction, matrix,
				width, height);
		//|[gݒ肵Ă
		pWidget = (CWidget*)pDoc->GetWidget(m_nSel);
		//ړꍇłA|[gԂ͕ێĂ
		pWidget->SetInport(inport);
		pInOut = pWidget->GetInportName();
		if(inport != pInOut->GetSize())		//͐`FbN
			pWidget->ChangeInportName();
		pWidget->SetOutport(outport);
		pInOut = pWidget->GetOutportName();
		if(outport != pInOut->GetSize())	//o͐`FbN
			pWidget->ChangeOutportName();
		//Subsystemt
		if(pWidget->GetId() == M_SUBSYSTEM) {
			//ǉ
			CopySubsystem(pWidget, pSubsysArray);
		}
		//Bitmap
		if(bmpName.IsEmpty() == 0)	//bitmapݒ肳Ă
			pWidget->SetBitmap(bmpName);

		if(pWidget->GetId() == M_SUBSYSTEM)
			pExtncsDoc->UpdateAllViews(NULL, 0x6A);

		//EBhEXV
		pDoc->UpdateAllViews (NULL);

		//Flush
		odo.Release();
	}	
	
}

void CSubsysView::OnUpdateEditPaste(CCmdUI* pCmdUI) 
{
	//TODO:`FbN
	UINT nFormat = g_pExtncsMain->GetClipboardFormat ();
	//UINT nFormat = pDoc->m_nFormat;
	pCmdUI->Enable (::IsClipboardFormatAvailable (nFormat));	
	
}

void CSubsysView::OnEditDelete() 
{
	CSubsysDoc* pDoc = GetDocument ();
	if (m_nSel != -1) {
		pDoc->RemoveWidget (m_nSel);
		m_nSel = -1;

		//svɂȂM_GAPAM_SYNAPSE폜
		JuncWidgetDelete();
		pDoc->UpdateAllViews (NULL);
	}

	if (m_lSel != -1) {
		int i,lCount;
		CLine *pLine;

		lCount = pDoc->GetLineCount();
		for (i=lCount - 1; i>=0 ; i--) {
			pLine = pDoc->GetLine (i);
			if(pLine->GetSel())
				pDoc->RemoveLine (i);
		}
		m_lSel = -1;
		//svɂȂM_GAPAM_SYNAPSE폜
		JuncWidgetDelete();
		pDoc->UpdateAllViews (NULL);
	}	
}

//svɂȂM_GAPAM_SYNAPSE폜
void CSubsysView::JuncWidgetDelete()
{
	CSubsysDoc* pDoc = GetDocument();
	int i,j,lCount,nCount,id;
	CWidget* pWidget;
	CLine* pLine;
	BOOL del;

	lCount = pDoc->GetLineCount();
	nCount = pDoc->GetWidgetCount();
	for(i = 0; i < nCount;) {
		pWidget = pDoc->GetWidget(i);
		id = pWidget->GetId();
		if(id != M_GAP && id != M_SYNAPSE) {
			i++;
			continue;
		}
		del = TRUE;
		for(j = 0; j < lCount; j++) {
			pLine = pDoc->GetLine(j);
			if(pLine->GetType() == LINE_START) {
				if(pLine->GetJunction() == i) {
					del = FALSE;
					break;
				}
			}
		}
		if(del) {
			//gpĂȂ
			//xAiԖWidget邽߂i{{Ȃ
			pDoc->RemoveWidget(i);
			lCount = pDoc->GetLineCount();
			nCount = pDoc->GetWidgetCount();
			if(i >= nCount)
				break;
		}
		else
			i++;
	}
}

void CSubsysView::OnUpdateEditDelete(CCmdUI* pCmdUI) 
{
	// WidgetLineIĂꍇAj[L
	pCmdUI->Enable (m_nSel != -1 || m_lSel != -1);	
}

void CSubsysView::OnLineProp() 
{
#if 0
	int style, index;
	CSubsysDoc* pDoc = GetDocument();
	CLine* pLine;
	pLine = pDoc->GetLine (m_lSel);
	BOOL flag = FALSE;

	CLineProp dlgLine(this);
	dlgLine.m_nLineStyle = pDoc->GetLineStyle(m_lSel);
	index = pLine->GetJunction();		//qCELL
	dlgLine.m_id = index;
	dlgLine.m_pExtncsDoc = pDoc->m_pExtncsDoc;

	if(dlgLine.DoModal() == IDOK) {
		//ConnectionύX
		style = dlgLine.m_nLineStyle;
		//junction
		if(dlgLine.m_id != -1) {
			//VAqݒ肳ꂽ
		}
		//m_lSelőIĂ郉C̑ύX
		pDoc->ChangeLine(m_lSel, style);
	}
#else
	int index;
	CSubsysDoc* pDoc = GetDocument();
	CLine* pLine;
	pLine = pDoc->GetLine (m_lSel);
	BOOL flag = FALSE;
	CLineProp* pLprop;

	pLprop = new CLineProp();
	if(pLprop) {
		pLprop->m_nLineStyle = pDoc->GetLineStyle(m_lSel);
		index = pLine->GetJunction();		//qCELL
		pLprop->m_id = index;
		pLprop->m_pExtncsDoc = pDoc;
		if(pLprop->Create(this) == TRUE) {
			m_pLineProp = pLprop;
		}
	}
#endif
}

void CSubsysView::OnUpdateLineProp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (m_lSel != -1);	
}

void CSubsysView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	int nCount,i;
	BOOL bHit;
	CWidget* pWidget;
	CSubsysDoc *pDoc = GetDocument();

	//XN[ɑΉ
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	// Widgetŉ
	nCount = pDoc->GetWidgetCount ();
	bHit = FALSE;
	for (i=nCount - 1; i>=0 && !bHit; i--) {
		pWidget = pDoc->GetWidget (i);
		if (pWidget->PtInWidget (point)) {
			bHit = TRUE;
			break;
		}
	}

	if(!bHit)
		return;
	//j[\̂ŁAݒ
	m_bHitRLine = m_bHitLLine = FALSE;
	SetCursor (m_hArrow);
	//
	dc.LPtoDP (&point);
	// IDR_WIDGET\Widget
	m_desIndex = i;
	m_popupPos = point;
	// }EX|C^XN[Wɕϊ
	this->ClientToScreen( &point );
	// gɃtH[JXݒ
	SetForegroundWindow();
	// |bvAbvj[̍쐬
	CMenu menu;
	// IDR_MENUPOPUP_ESLMON̓j[̃\[XID
	menu.LoadMenu( IDR_POPUP_WIDGET );
	// Scopej[
	if(pWidget->GetId() == M_SUBSYSTEM)
		menu.EnableMenuItem(ID_WIDGET_SCOPE, MF_GRAYED);
	else
		menu.EnableMenuItem(ID_WIDGET_SCOPE, MF_ENABLED);
	// Libraryj[
	if(m_nSel == -1)
		menu.EnableMenuItem(ID_WIDGET_LIB, MF_GRAYED);
	else
		menu.EnableMenuItem(ID_WIDGET_LIB, MF_ENABLED);
	// Rotatej[
	switch(pWidget->GetDirection()) {
	case	DIR_RIGHT:
		menu.CheckMenuItem(ID_WIDGET_0, MF_CHECKED);
		break;
	case	DIR_UP:
		menu.CheckMenuItem(ID_WIDGET_90, MF_CHECKED);
		break;
	case	DIR_LEFT:
		menu.CheckMenuItem(ID_WIDGET_180, MF_CHECKED);
		break;
	case	DIR_DOWN:
		menu.CheckMenuItem(ID_WIDGET_270, MF_CHECKED);
		break;
	}

	CMenu* pPopup = menu.GetSubMenu( 0 );
	// |bvAbvj[\
	pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			point.x, point.y, this);
	// LoadMenuJ
	menu.DestroyMenu();
	
	CScrollView::OnRButtonDown(nFlags, point);
}

void CSubsysView::OnWidgetLine() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
}

void CSubsysView::OnUpdateWidgetLine(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CSubsysView::OnWidgetParam() 
{
	CSubsysDoc* pDoc = GetDocument();
	CWidget* pWidget = pDoc->GetWidget (m_desIndex);
	OpenParam(pWidget, m_popupPos);	
}

void CSubsysView::OnUpdateWidgetParam(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CSubsysView::OnWidgetScope() 
{
	CSubsysDoc *pDoc = GetDocument();
	CWidget* pWidget;
	CXyWnd*	pXyWnd;
	char pathbuf[_MAX_PATH];

	// IĂWidget擾
	pWidget = pDoc->GetWidget (m_desIndex);
	if(pWidget->GetScope())
		return;		//dI[v֎~

	//TODO:x̓R[hŗL̏
	//Kw擾
	CExtncsView* pView = (CExtncsView*)(pDoc->m_pExtncsView);
	strcpy(pathbuf, "");
	pView->GetWidgetPath(pWidget, pathbuf);

	if(pWidget->GetId() == M_XY) {
		pXyWnd = new CXyWnd;
		if(!pXyWnd->Create( pathbuf, WS_OVERLAPPEDWINDOW,
			CRect(0, 0, 320, 320), this, pWidget))
		{
			return;
		}
		pXyWnd->ShowWindow(SW_SHOW);
		pXyWnd->UpdateWindow();

		//CXyWnd̓o^
		pWidget->SetScope((CWnd*)pXyWnd);
	}
	else {
		CScopeFrame *pScopeFrame = new CScopeFrame;
		if(!pScopeFrame->Create( pathbuf, WS_OVERLAPPEDWINDOW,
			CRect(0, 0, 480, 320), this, pWidget, m_nScopeMax))
		{
			return;
		}
		pScopeFrame->ShowWindow(SW_SHOW);
		pScopeFrame->UpdateWindow();

		//CScopeFrame̓o^
		pWidget->SetScope((CWnd*)pScopeFrame);
	}

}

void CSubsysView::OnUpdateWidgetScope(CCmdUI* pCmdUI) 
{
	// IĂWidget擾
	CWidget* pWidget;
	pWidget = GetDocument()->GetWidget (m_desIndex);
	if(pWidget->GetId() == M_SUBSYSTEM)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
	
}

void CSubsysView::OnWidget0() 
{
	CSubsysDoc *pDoc = GetDocument();
	CWidget* pWidget;
	pWidget = pDoc->GetWidget (m_desIndex);
	pWidget->SetDirection(DIR_RIGHT);
	pDoc->UpdateAllViews (NULL);	
}

void CSubsysView::OnUpdateWidget0(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CSubsysView::OnWidget90() 
{
	CSubsysDoc *pDoc = GetDocument();
	CWidget* pWidget;
	pWidget = pDoc->GetWidget (m_desIndex);
	pWidget->SetDirection(DIR_UP);
	pDoc->UpdateAllViews (NULL);	
}

void CSubsysView::OnUpdateWidget90(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CSubsysView::OnWidget180() 
{
	CSubsysDoc *pDoc = GetDocument();
	CWidget* pWidget;
	pWidget = pDoc->GetWidget (m_desIndex);
	pWidget->SetDirection(DIR_LEFT);
	pDoc->UpdateAllViews (NULL);	
}

void CSubsysView::OnUpdateWidget180(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CSubsysView::OnWidget270() 
{
	CSubsysDoc *pDoc = GetDocument();
	CWidget* pWidget;
	pWidget = pDoc->GetWidget (m_desIndex);
	pWidget->SetDirection(DIR_DOWN);
	pDoc->UpdateAllViews (NULL);	
}

void CSubsysView::OnUpdateWidget270(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CSubsysView::OnWidgetExtend() 
{
	WidgetExtend(m_desIndex);
}

void CSubsysView::WidgetExtend(int desIndex)
{
	CWidget* pWidget;
	int type;
	BLOCKINFO* pItem;
	m_desIndex = desIndex;
	CSubsysDoc* pDoc = GetDocument();
	CExtncsDoc* pExtncsDoc;
	pWidget = pDoc->GetWidget (m_desIndex);
	CString matrix = pWidget->GetMatrix();
	CString name = pWidget->GetName();
	int connect = pWidget->GetConnect();
	CWidgetExtend*	pExt;

	pExt = new CWidgetExtend();
	if(pExt) {
		pExt->m_matrix = matrix;
		pExt->m_cell = name;
		pExt->m_connect = connect;
		pExtncsDoc = ((CExtncsDoc*)pDoc->m_pExtncsDoc);
		pExt->m_pDoc = pExtncsDoc;
		pExt->m_id = pWidget->GetJunction();	//gZJunction
		//g̗L
		if(pWidget->GetInportLine() || pWidget->GetOutportLine())
			pExt->m_bFormat = FALSE;
		else { // ݂Ȃ
			pItem = pWidget->GetPitem();
			type = pItem->type;
			if(type == MODULE_CELL || type == MODULE_USER
				|| type == MODULE_NCS)
				pExt->m_bFormat = TRUE;
			else
				pExt->m_bFormat = FALSE;
		}
		if(pExt->Create(this) == TRUE) {
			m_pWidgetExtend = pExt;
		}
	}
}

void CSubsysView::OnUpdateWidgetExtend(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

DROPEFFECT CSubsysView::OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	CScrollView::OnDragEnter(pDataObject, dwKeyState, point);

	//
	// If a widget is available from the drop source, create a temporary
	// widget for drag imaging.
	//
	CSubsysDoc* pDoc = GetDocument();
	UINT nFormat;
	CPoint newpoint,spt,ept;
	int x,y,id,cx,cy,sbk,ebk,index,arrow,inport,outport,type,junction;
	COLORREF color;
	char name[256];

	nFormat = g_pExtncsMain->GetClipboardFormat ();
	HGLOBAL hData = pDataObject->GetGlobalData (nFormat);

	if (hData != NULL) {
		if(m_nSel != -1) {
			// Widgetړ
			WIDGETINFO* pWidgetInfo = (WIDGETINFO*) ::GlobalLock (hData);
			x = point.x - pWidgetInfo->cx;
			y = point.y - pWidgetInfo->cy;
			m_offset.cx = pWidgetInfo->cx;
			m_offset.cy = pWidgetInfo->cy;
			color = pWidgetInfo->color;
			strcpy(name, pWidgetInfo->name);
			id = pWidgetInfo->id;
			::GlobalUnlock (hData);
			::GlobalFree (hData);

			newpoint.x = x; newpoint.y = y;
			m_pTempWidget = new CWidget (newpoint, id, pWidgetInfo->width, pWidgetInfo->height);
			m_pointLastImage.x = m_pointLastImage.y = -32000;
			m_pointLastMsg = point;
		}
		else {
			// Lineړ
			LINEINFO* pLineInfo = (LINEINFO*) ::GlobalLock (hData);
			spt = pLineInfo->spt;
			ept = pLineInfo->ept;
			cx = ept.x-spt.x;
			//if(cx == 0)	cx = 1;
			cy = ept.y-spt.y;
			//if(cy == 0)	cy = 1;
			if(spt.x == ept.x) {
				spt.x = point.x;
				ept.x = point.x;
			}
			else {
				spt.y = point.y;
				ept.y = point.y;
			}
			m_offset.cx = point.x-spt.x;
			m_offset.cy = point.y-spt.y;
			arrow = pLineInfo->arrow;
			color = pLineInfo->color;
			sbk = pLineInfo->sblk;
			ebk = pLineInfo->eblk;
			index = pLineInfo->index;
			inport = pLineInfo->inport;
			outport = pLineInfo->outport;
			type = pLineInfo->type;
			junction = pLineInfo->junction;
			::GlobalUnlock (hData);
			::GlobalFree (hData);

			//spt.x = x; spt.y = y;
			//ept.x = x - cx; ept.y = y - cy;
			m_pTempLine = new CLine (spt, ept, sbk, ebk, color, arrow, index,
				inport, outport, type, junction);
			m_pointLastImage.x = m_pointLastImage.y = -32000;
			m_pointLastMsg = point;
		}

		//
		// Return DROPEFFECT_COPY if the Ctrl key is down, or DROPEFFECT_MOVE
		// if it is not.
		//
	    return (dwKeyState & MK_CONTROL) ?
			DROPEFFECT_COPY : DROPEFFECT_MOVE;
	}
	//
	// The cursor isn't carrying a widget. Indicate that the drop target will
	// not accept a drop.
	//
	m_pTempWidget = NULL;
	m_pTempLine = NULL;
	return DROPEFFECT_NONE;
	
}

DROPEFFECT CSubsysView::OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
{
	CScrollView::OnDragOver(pDataObject, dwKeyState, point);

	// Return now if the object being dragged is not a widget.
    if (m_pTempWidget == NULL && m_pTempLine == NULL)
        return DROPEFFECT_NONE;

	// Convert the drag point to logical coordinates.
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	// If the cursor has moved, erase the old drag image and draw a new one.
	if (point != m_pointLastMsg) {
		CPoint pt;
		if(m_pTempWidget) {
			pt.x = point.x - m_offset.cx;
			pt.y =  point.y - m_offset.cy;
			m_pTempWidget->DrawDragImage (&dc, m_pointLastImage);
			m_pTempWidget->DrawDragImage (&dc, pt);
		}
		else {
			CPoint spt,ept;
			spt = m_pTempLine->GetSpos();
			ept = m_pTempLine->GetEpos();
			if(spt.x == ept.x) {
				//x̂݋
				pt.x = point.x;
				pt.y = spt.y;
			}
			else {
				//ŷ݋
				pt.x = spt.x;
				pt.y =  point.y;
			}
			m_pTempLine->DrawDragImage (&dc, m_pointLastImage);
			m_pTempLine->DrawDragImage (&dc, pt);
		}
		m_pointLastImage = pt;
		m_pointLastMsg = point;
	}

	// Return DROPEFFECT_COPY if the Ctrl key is down, or DROPEFFECT_MOVE
	// if it is not.
    return (dwKeyState & MK_CONTROL) ?
        DROPEFFECT_COPY : DROPEFFECT_MOVE;	

}

void CSubsysView::OnDragLeave() 
{
	CScrollView::OnDragLeave();
	//
	// Erase the last drag image and delete the temporary widget.
	//
	if (m_pTempWidget != NULL || m_pTempLine != NULL) {
		CClientDC dc (this);
		OnPrepareDC (&dc);
		if(m_pTempWidget) {
			m_pTempWidget->DrawDragImage (&dc, m_pointLastImage);
			delete m_pTempWidget;
			m_pTempWidget = NULL;
		}
		else {
			m_pTempLine->DrawDragImage (&dc, m_pointLastImage);
			delete m_pTempLine;
			m_pTempLine = NULL;
		}
	}
	
}

BOOL CSubsysView::OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point) 
{
	CScrollView::OnDrop(pDataObject, dropEffect, point);

	// Convert the drop point to logical coordinates.
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	//
	// Erase the last drag image and delete the temporary widget.
	//
	if (m_pTempWidget != NULL || m_pTempLine != NULL) {
		if(m_pTempWidget) {
			m_pTempWidget->DrawDragImage (&dc, m_pointLastImage);
			delete m_pTempWidget;
			m_pTempWidget = NULL;
		}
		else {
			m_pTempLine->DrawDragImage (&dc, m_pointLastImage);
			delete m_pTempLine;
			m_pTempLine = NULL;
		}
	}

	// Retrieve the HGLOBAL from the data object and create a widget.
	CSubsysDoc* pDoc = GetDocument ();
	CExtncsDoc* pExtncsDoc = ((CExtncsDoc*)pDoc->m_pExtncsDoc);
	UINT nFormat;
	CPoint newpoint,spt,ept;
	CWidget* pWidget;
	CLine* pLine;
	int x,y,id,direction,cx,cy,arrow,index,sblk,eblk,inport,outport,type,junction,connect;
	CString matrix,bmpName;
	COLORREF color;
	char name[256];
	int i,row,column,width,height;
	CPtrArray* pSubsysArray;
	CSubsysDoc* pSubsysDoc;
	CPtrArray*	pParamArray;
	int nLine;
	CPtrArray* pInOut;
	CPtrArray* pScopeArray;
	CWnd* pScopeWnd;

	nFormat = g_pExtncsMain->GetClipboardFormat ();
	HGLOBAL hData = pDataObject->GetGlobalData (nFormat);

	if (hData != NULL) {
		if(m_nSel != -1) {
			WIDGETINFO* pWidgetInfo = (WIDGETINFO*) ::GlobalLock (hData);
			x = point.x - pWidgetInfo->cx;
			y = point.y - pWidgetInfo->cy;
			color = pWidgetInfo->color;
			id = pWidgetInfo->id;
			direction = pWidgetInfo->direction;
			strcpy(name, pWidgetInfo->name);
			matrix = pWidgetInfo->matrix;
			row = pExtncsDoc->GetMatrixRow(pWidgetInfo->matrix);
			column = pExtncsDoc->GetMatrixColumn(pWidgetInfo->matrix);
			width = pWidgetInfo->width;
			height = pWidgetInfo->height;
			inport = pWidgetInfo->inport;
			outport = pWidgetInfo->outport;
			// Subsystem
			pSubsysArray = pWidgetInfo->pSubsysArray;
			pSubsysDoc = (CSubsysDoc *)pWidgetInfo->pDoc;
			bmpName = pWidgetInfo->bmp;
			pParamArray = pWidgetInfo->pParamArray;
			junction = pWidgetInfo->junction;
			connect = pWidgetInfo->connect;
			//matrixl傫ɂ
			if(row*column != 1) {
				width = pWidgetInfo->width / column;
				height = pWidgetInfo->height / row;
			}
			//Scope
			pScopeArray = pWidgetInfo->pScopeArray;
			pScopeWnd = pWidgetInfo->pScopeWnd;
			//̈폜
			::GlobalUnlock (hData);
			::GlobalFree (hData);
			// ړVʒu
			newpoint.x = x; newpoint.y = y;
			m_nSel = pDoc->AddWidget (id, newpoint, name, direction, matrix,
				width,height);
			//|[gݒ肵Ă
			pWidget = (CWidget*)pDoc->GetWidget(m_nSel);
			//ړꍇłA|[gԂ͕ێĂ
			pWidget->SetInport(inport);
			pInOut = pWidget->GetInportName();
			if(inport != pInOut->GetSize())		//͐`FbN
				pWidget->ChangeInportName();
			pWidget->SetOutport(outport);
			pInOut = pWidget->GetOutportName();
			if(outport != pInOut->GetSize())	//o͐`FbN
				pWidget->ChangeOutportName();
			//Subsystemt
			if(pWidget->GetId() == M_SUBSYSTEM) {
				//ǉ
				CopySubsystem(pWidget, pSubsysArray);
				//JĂSubsystemEBhEւ̑Ή
				//if(pSubsysDoc)
				//	pSubsysDoc->m_pWidget = pWidget;
			}
			//Bitmap
			if(bmpName.IsEmpty() == 0)	//bitmapݒ肳Ă
				pWidget->SetBitmap(bmpName);
			//p[^[
			CopyParam(pWidget, pParamArray);
			// XyW[ɊւĕύXKv
			if(id == M_XY) {
				pWidget->ChangeXyScope();
			}
			//gCELL
			pWidget->SetJunction(junction);
			pWidget->SetConnect(connect);
			//ScopeĐݒ
			pWidget->ChangeScopeInfo(pWidget, pScopeWnd, pScopeArray);
		}
		else {
			LINEINFO* pLineInfo = (LINEINFO*) ::GlobalLock (hData);
			spt = pLineInfo->spt;
			ept = pLineInfo->ept;
			cx = abs(ept.x-spt.x);
			//if(cx == 0)	cx = 1;
			cy = abs(ept.y-spt.y);
			//if(cy == 0)	cy = 1;
			if(cx == 0) {
				spt.x = point.x;
				ept.x = point.x;
			}
			else {
				spt.y = point.y;
				ept.y = point.y;
			}
			arrow = pLineInfo->arrow;
			color = pLineInfo->color;
			sblk = pLineInfo->sblk;
			eblk = pLineInfo->eblk;
			index = pLineInfo->index;
			inport = pLineInfo->inport;
			outport = pLineInfo->outport;
			type = pLineInfo->type;
			junction = pLineInfo->junction;
			//̈폜
			::GlobalUnlock (hData);
			::GlobalFree (hData);
			//ύX
			//spt.x = x; spt.y = y;
			//ept.x = x + cx; ept.y = y + cy;
			//InsertOɗTChύX
			if(arrow == 2) {
				//r
				pLine = pDoc->GetLine(m_lSel+1);
				pLine->SetSpos(ept);
			}
			else {
				//Ԑ
				pLine = pDoc->GetLine(m_lSel-1);
				pLine->SetEpos(spt);
				pLine = pDoc->GetLine(m_lSel+1);
				pLine->SetSpos(ept);
			}
			//Insert
			m_lSel = pDoc->AtLine(m_lSel+1, spt, ept, sblk, eblk, color, arrow, index,
				inport, outport, type, junction);
			//LinȇI
			m_lSel = -1;
			nLine = pDoc->GetLineCount();
			for(i = 0; i < nLine; i++) {
				pLine = pDoc->GetLine(i);
				if(pLine->GetSel())
					pLine->SetSel(FALSE);
			}
		}

		pDoc->UpdateAllViews (NULL);
		return TRUE;
	}
	return FALSE;
}

void CSubsysView::CopyParam(CWidget* pWidget, CPtrArray* p)
{
	PARAMINFO* pItem;
	PARAMINFO* sItem;
	CPtrArray*	pParam;
	int	i,nParam;

	pParam = pWidget->GetParamPointer();
	nParam = (int)p->GetSize();
	for(i = 0; i < nParam; i++) {
		sItem = (PARAMINFO*) p->GetAt(i);
		pItem = (PARAMINFO*) pParam->GetAt(i);
		//l̂ݓo^
		pItem->strValue = sItem->strValue;
	}
}

//Widgetړɂ郉C̈ړ
void CSubsysView::LoadWidgetLine(int widget, int index)
{
	CSubsysDoc* pDoc = GetDocument();
	int nCount,i,inport,outport,sblk,eblk,junc,lSel;
	CPoint spt,ept;
	CWidget* pWidget;
	MOVELINE* pItem;
	CRect rect;

	nCount = (int)m_moveArray.GetSize();
	//Widgetւ̓̓C
	for(i = 0; i < nCount; i++) {
		pItem = (MOVELINE *)m_moveArray.GetAt(i);
		junc = pItem->junction;
		if(pItem->type == 0) {
			//Srcʒu
			sblk = pItem->sblk;
			if(sblk > index)
				sblk -= 1;
			outport = pItem->outport;
			if(outport == -1) {
				spt = pItem->bpt;
				//Desʒu
				pWidget = pDoc->GetWidget( widget );
				inport = pItem->inport;
				ept = pWidget->GetInportPos( inport );
				//Rect쐬
				rect = CRect(spt, ept);
				//Line
				pDoc->InsertDivide (rect, pItem->btype, sblk,  widget, inport, junc);
			}
			else {
				pWidget = pDoc->GetWidget( sblk );
				spt = pWidget->GetOutportPos( outport );
				//Desʒu
				pWidget = pDoc->GetWidget( widget );
				inport = pItem->inport;
				ept = pWidget->GetInportPos( inport );
				//Rect쐬
				rect = CRect(spt, ept);
				//Line
				pDoc->InsertLine (rect, sblk, widget, inport, outport, junc);
			}
			//LiněAŌɏꂽLinẽCfbNX
			lSel = pDoc->GetLineCount();
			if(pItem->s_arrow == 3 && pItem->e_arrow == 1)
				pDoc->ChangeLine(lSel-1, 2);
			else if(pItem->s_arrow == 3 && pItem->e_arrow == 0)
				pDoc->ChangeLine(lSel-1, 1);
		}
	}
	//Widget̏o̓C
	for(i = 0; i < nCount; i++) {
		pItem = (MOVELINE *)m_moveArray.GetAt(i);
		junc = pItem->junction;
		if(pItem->type == 1) {
			//Srcʒu
			pWidget = pDoc->GetWidget( widget );
			outport = pItem->outport;
			if(outport == -1) {
				//outporẗʒúH
				//o͂镪򃉃C͍폜
			}
			else {
				//Srcʒu
				spt = pWidget->GetOutportPos( outport );
				//Desʒu
				eblk = pItem->eblk;
				if(eblk > index)
					eblk -= 1;
				inport = pItem->inport;
				pWidget = pDoc->GetWidget( eblk );
				ept = pWidget->GetInportPos( inport );
				//Rect쐬
				rect = CRect(spt, ept);
				//Line
				pDoc->InsertLine (rect, widget, eblk, inport, outport, junc);
			}
			//LiněAŌɏꂽLinẽCfbNX
			lSel = pDoc->GetLineCount();
			if(pItem->s_arrow == 3 && pItem->e_arrow == 1)
				pDoc->ChangeLine(lSel-1, 2);
			else if(pItem->s_arrow == 3 && pItem->e_arrow == 0)
				pDoc->ChangeLine(lSel-1, 1);
		}
	}

}

// _uNbN
// 1.p[^[ݒ
// 2.ݒp[^[݂ȏꍇ́AȂɂȂ
// 3.SopeW[̏ꍇ́AScopeJ
void CSubsysView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	int nCount,i;
	BOOL bHit;
	CWidget* pWidget;
	CSubsysDoc *pDoc = GetDocument();
	CString model;

	//XN[ɑΉ
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	// Widgetŉ
	nCount = pDoc->GetWidgetCount ();
	bHit = FALSE;
	for (i=nCount - 1; i>=0 && !bHit; i--) {
		pWidget = pDoc->GetWidget (i);
		if (pWidget->PtInWidget (point)) {
			bHit = TRUE;
			break;
		}
	}

	if(bHit) {
		model = pWidget->GetModel();
		if(model.Compare(_T("subsystem.mdl")) == NULL) {
			OpenSubsystem( pWidget, point );
		}
		else {
			OpenParam( pWidget, point );
		}
		//OnLButtonDwonɃCxgAm_nSelLɂȂĂ̂
		//ZNgĂWidgetȂ
		pWidget->SetSel (FALSE);
		m_nSel = -1;
		pDoc->UpdateAllViews (NULL);
	}
	
	CScrollView::OnLButtonDblClk(nFlags, point);
}

// SubsystemEBhEJ
void CSubsysView::OpenSubsystem(CWidget* pWidget, CPoint point)
{
	CSubsysDoc*	pSubsysDoc;
	CSubsysWnd*	pSubsysWnd;
	CSubsysDoc *pDoc = GetDocument();
	CString title;
	BLOCKINFO* pItem;

	// 2dI[vmF
	if(pWidget->GetWindow())
		return;

	// IĂWidget擾
	pItem = pWidget->GetPitem();

	pSubsysDoc = (CSubsysDoc *)g_pSubsysTemplate->CreateNewDocument();
	if(pSubsysDoc) {
		//lȂ
		pSubsysDoc->m_pWidget = pWidget;
		pSubsysDoc->m_pExtncsDoc = pDoc->m_pExtncsDoc/*pDoc*/;
		pWidget->SetDocument(pSubsysDoc);
		//EBhEǗ
		//pSubsysDoc->m_nThisIndex = m_nSubsysMax; 
		//pDoc->m_bSubsysWnd[m_nSubsysMax] = TRUE;
	}
	else {	// error
		AfxMessageBox("OpenSubsystem error 1.", MB_OK, NULL);
		return;
	}
	pSubsysWnd = (CSubsysWnd *)g_pSubsysTemplate->CreateNewFrame(pSubsysDoc, NULL);
	if(pSubsysWnd) {
		g_pSubsysTemplate->InitialUpdateFrame(pSubsysWnd, pSubsysDoc, TRUE);
		if(!m_pSubsysWnd[m_nSubsysMax]) {
			pWidget->SetWindow(pSubsysWnd);
		}
	}
	else {	// error
		AfxMessageBox("OpenSubsystem error 2.", MB_OK, NULL);
		return;
	}
	//̃XR[v
	//m_nSubsysMax += 1;
}

void CSubsysView::OpenParam(CWidget* pWidget, CPoint point)
{
	int nCount;
	PARAMWNDINFO *pItem;
	CSubsysDoc *pDoc = GetDocument();
	CPtrArray*	p;

	p = pWidget->GetParamPointer();
	nCount = (int)p->GetSize();
	if(nCount == 0)
		return;		//݂Ȃ

	//
	ClientToScreen(&point);
	CParamWnd *pParamWnd = new CParamWnd;
	if(!pParamWnd->Create( "Setting parameters", WS_OVERLAPPEDWINDOW,
		CRect(point.x, point.y, 480, 320), (CWnd*)this, pWidget))
	{
		return;
	}
	pParamWnd->ShowWindow(SW_SHOW);
	pParamWnd->PostMessage(WM_SETFOCUS, NULL, 0L);
	//ClientToScreen(&point);
	//pParamWnd->MoveWindow(point.x, point.y, 320, 240, TRUE);

	//p[^[EBhEǗ̂ߓo^
	try {
		pItem = new PARAMWNDINFO;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return;
	}
	//@ݒ
	pItem->pWnd = pParamWnd;
	pItem->pWidget = pWidget;
	//CfbNX
	nCount = (int)m_paramArray.GetSize();
	//o^
	m_paramArray.InsertAt( nCount, pItem );
	nCount++;
}

// CParamWnd̎w߂NetworkɊ֌WCell̃p[^[ύX
LRESULT CSubsysView::OnParamChange(WPARAM wParam, LPARAM lParam)
{
	CWidget* pWidget;
	int id,nCount,port,i;
	CPtrArray*	ptr;
	PARAMINFO *pItem;

	pWidget = (CWidget *)lParam;
	id = pWidget->GetId();
	ptr = pWidget->GetParamPointer();
	nCount = (int)ptr->GetSize();
	switch(id) {
	case	M_SUM:
		for (i=0; i<nCount; i++) {
			//PARAMINFO
			pItem = (PARAMINFO*) ptr->GetAt (i);
			if(pItem->strName.Compare(_T("inport")) == NULL) {
				port = atoi(pItem->strValue);
				pWidget->SetInport(port);
			}
		}
		break;
	case	M_PRODUCT:
		for (i=0; i<nCount; i++) {
			//PARAMINFO
			pItem = (PARAMINFO*) ptr->GetAt (i);
			if(pItem->strName.Compare(_T("inport")) == NULL) {
				port = atoi(pItem->strValue);
				pWidget->SetInport(port);
			}
		}
		break;
	case	M_SELECT:
		for (i=0; i<nCount; i++) {
			//PARAMINFO
			pItem = (PARAMINFO*) ptr->GetAt (i);
			if(pItem->strName.Compare(_T("inport")) == NULL) {
				port = atoi(pItem->strValue);
				pWidget->SetInport(port);
			}
		}
		break;
	case	M_XY:
		for (i=0; i<nCount; i++) {
			//PARAMINFO
			pItem = (PARAMINFO*) ptr->GetAt (i);
			if(pItem->strName.Compare(_T("type")) == NULL) {
				port = atoi(pItem->strValue);
				//port=0 -> x-y
				//port=1 -> x-y-z
				pWidget->SetInport(port+2);
				pWidget->ChangeInportName();
				//Scopeupdate
				pWidget->ChangeXyScope();
			}
		}
		break;
	case	M_SUBSYSTEM:
		for (i=0; i<nCount; i++) {
			//PARAMINFO
			pItem = (PARAMINFO*) ptr->GetAt (i);
			if(pItem->strName.Compare(_T("inport")) == NULL) {
				port = atoi(pItem->strValue);
				pWidget->SetInport(port);
			}
			if(pItem->strName.Compare(_T("outport")) == NULL) {
				port = atoi(pItem->strValue);
				pWidget->SetOutport(port);
			}
		}
		break;
	}

	//
	//Invalidate(TRUE);
	GetDocument()->UpdateAllViews(NULL);

	return 0L;
}

void CSubsysView::OnDestroy() 
{
	CScrollView::OnDestroy();
	
	//int index;
	//CExtncsDoc* pExtncsDoc = ((CExtncsDoc*)GetDocument()->m_pExtncsDoc);
	//index = GetDocument()->m_nThisIndex;
	//((CView *)(pExtncsDoc->GetExtncsView()))->PostMessage(WM_DELETE_SUBSYSTEM, index, 0L);

	int i,nCount;
	PARAMWNDINFO* pItem;
	CSubsysDoc *pDoc = GetDocument();

	nCount = (int)m_moveArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (MOVELINE*) m_moveArray.GetAt (i);
		m_moveArray.RemoveAll();
	}
	nCount = (int)m_paramArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (PARAMWNDINFO*) m_paramArray.GetAt (i);
			if (pItem->pWnd)
				pItem->pWnd->DestroyWindow();
			delete (PARAMWNDINFO*) m_paramArray.GetAt (i);
		}
		m_paramArray.RemoveAll();
	}

	//WidgetێĂSubsystemEBhENA
	pDoc->m_pWidget->SetWindow(NULL);
}

void CSubsysView::InvertRect(CDC *pDC, POINT from, POINT to)
{
	//
	POINT tmp;
	//CPen pen,*pOldPen;
    int nOldMode = pDC->SetROP2 (R2_NOT);

	//pen.CreatePen(PS_DOT, 1, RGB(0,255,0));
	//pOldPen = pDC->SelectObject (&pen);
    pDC->MoveTo (from);
	tmp.x = from.x; tmp.y = to.y;
    pDC->LineTo (tmp);
	pDC->LineTo (to);
	tmp.x = to.x; tmp.y = from.y;
	pDC->LineTo (tmp);
    pDC->LineTo (from);

	//pDC->SelectObject (pOldPen);
	//pen.DeleteObject();
    pDC->SetROP2 (nOldMode);
}

BOOL CSubsysView::IntersectLine(CRect rect, CPoint from, CPoint to)
{
	if(from.x == to.x) {	//c
		if(rect.left < from.x && rect.right > from.x) {
			//㉺؂邩
			if(from.y < to.y) {
				if(rect.top > from.y && rect.top < to.y)
					return TRUE;
				if(rect.bottom > from.y && rect.bottom < to.y)
					return TRUE;
			}
			else {
				if(rect.top > to.y && rect.top < from.y)
					return TRUE;
				if(rect.bottom > to.y && rect.bottom < from.y)
					return TRUE;
			}
		}
	}
	else {	//
		if(rect.top < from.y && rect.bottom > from.y) {
			//E؂邩
			if(from.x < to.x) {
				if(rect.left > from.x && rect.left < to.x)
					return TRUE;
				if(rect.right > from.x && rect.right < to.x)
					return TRUE;
			}
			else {
				if(rect.left > to.x && rect.left < from.x)
					return TRUE;
				if(rect.right > to.x && rect.right < from.x)
					return TRUE;
			}
		}
	}
	return FALSE;
}

int CSubsysView::CheckIntersectWidget(CPoint point)
{
	CSubsysDoc* pDoc = GetDocument();
	int	i,nCount;
	CRect rect;
	CPoint spos,epos;
	CLine* pLine;

	rect = CRect(point, CSize(32,32));
	nCount = pDoc->GetLineCount();
	for(i = 0; i < nCount; i++) {
		pLine = pDoc->GetLine(i);
		spos = pLine->GetSpos();
		epos = pLine->GetEpos();
		if(IntersectLine(rect, spos, epos)) {
			//LineCfNXԂ
			return pLine->GetIndex();
		}
	}
	return -1;
}

// delete CWidgetExtend
LRESULT CSubsysView::OnDeleteExtend(WPARAM wParam, LPARAM lParam)
{
	CWidget* pWidget;
	CSubsysDoc* pDoc = GetDocument();
	pWidget = pDoc->GetWidget (m_desIndex);
	CString matrix = pWidget->GetMatrix();
	CString name = pWidget->GetName();
	int connect = pWidget->GetConnect();
	CWidgetExtend* pWidgetExtend = (CWidgetExtend *)m_pWidgetExtend;
	BOOL flag = FALSE;

	if(wParam == 1) {
		//OnOK
		if(matrix.Compare(pWidgetExtend->m_matrix)) {
			//matrixύXꂽ
			pWidget->SetMatrix(pWidgetExtend->m_matrix);
			flag = TRUE;
		}
		if(name.Compare(pWidgetExtend->m_cell)) {
			//nameύXꂽ
			pWidget->SetName(pWidgetExtend->m_cell);
			flag = TRUE;
		}
		if(connect != pWidgetExtend->m_connect) {
			//connectionύXꂽ
			pWidget->SetConnect(pWidgetExtend->m_connect);
			flag = TRUE;
		}
		// Junction
		pWidget->SetJunction(pWidgetExtend->m_id);
		if(flag)
			pDoc->UpdateAllViews (NULL);
	}
	else {
		//OnCancel
	}
	m_pWidgetExtend->DestroyWindow();
	delete m_pWidgetExtend;
	m_pWidgetExtend = NULL;

	return 0L;
}

// delete CLineProp
LRESULT CSubsysView::OnDeleteLineprop(WPARAM wParam, LPARAM lParam)
{
	int style;
	CSubsysDoc* pDoc = GetDocument();
	CLine* pLine;
	pLine = pDoc->GetLine (m_lSel);
	BOOL flag = FALSE;
	CLineProp* pLineProp = (CLineProp *)m_pLineProp;

	if(wParam == 1) {
		//OnOK
		//ConnectionύX
		style = pLineProp->m_nLineStyle;
		//junction
		if(pLineProp->m_id != -1) {
			//VAqݒ肳ꂽ
		}
		//m_lSelőIĂ郉C̑ύX
		pDoc->ChangeLine(m_lSel, style);
	}
	else {
		// OnCancel
	}

	// delete dialog
	m_pLineProp->DestroyWindow();
	m_pLineProp = NULL;
	m_lSel = -1;

	return 0L;
}

void CSubsysView::OnAppExit() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	//SATELLITEIAExitj[
	char cmdline[_MAX_PATH];
	strcpy(cmdline, "exit\n");
	int i,ch,len;
	DWORD size;

	//A command is transmitted. 
	len = (int)strlen(cmdline);
	for(i=0; i<len; i++){
		ch = (unsigned char)cmdline[i];
		WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
	}
	
}

//
// VKSubsystem\zꍇ
// p[^Őݒ肵o̓|[gzu
//
void CSubsysView::NewSubsystem(int inport, int outport)
{
	CSubsysDoc* pDoc = GetDocument ();
	int i,x,y,index;
	CRect rect;
	CPoint pos;
	CString strName;
	char name[_MAX_PATH];

	GetClientRect(rect);
	x = 32;
	y = 32;
	strName = _T("Inport");
	for(i = 0; i < inport; i++) {
		pos = CPoint(x, y);
		strcpy(name, strName);
		if(i > 0) {
			strcat(name, "_");
			ChangeName(name);
		}
		index = pDoc->AddWidget (M_INPORT, pos, name, DIR_RIGHT, _T("1:1"), 32, 32);
		y = y + 64;
	}
	x = rect.right - 64;
	y = 32;
	strName = _T("Outport");
	for(i = 0; i < outport; i++) {
		pos = CPoint(x, y);
		strcpy(name, strName);
		if(i > 0) {
			strcat(name, "_");
			ChangeName(name);
		}
		index = pDoc->AddWidget (M_OUTPORT, pos, name, DIR_RIGHT, _T("1:1"), 32, 32);
		y = y + 64;
	}
}

void CSubsysView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	Invalidate();	
	
}

// delete param
LRESULT CSubsysView::OnDeleteParam(WPARAM wParam, LPARAM lParam)
{
	int nCount,i;
	PARAMWNDINFO *pItem;

	nCount = (int)m_paramArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (PARAMWNDINFO*) m_paramArray.GetAt (i);
			if (pItem->pWidget == (CWidget *)lParam) {
				pItem->pWnd = NULL;
				delete (PARAMWNDINFO*) m_paramArray.GetAt (i);
				m_paramArray.RemoveAt(i);
			}
			//delete (PARAMWNDINFO*) m_paramArray.GetAt (i);
		}
		//m_paramArray.RemoveAll();
	}
	return 0L;
}

// delete Scope
LRESULT CSubsysView::OnDeleteScopeFrame(WPARAM wParam, LPARAM lParam)
{
	CWidget* pWidget;
	pWidget = (CWidget *)lParam;
	pWidget->SetScope(NULL);
	return 0L;
}

// pSrcWidget̓epTargetWidgetɃRs[
void CSubsysView::CopySubsystem(CWidget* pTargetWidget, CPtrArray* pSrcWidget)
{
	CWidget* pSaveWidget;
	CWidget* pWidget;
	CWidget* pSubWidget;
	CWidget* pCopyWidget = (CWidget*)pSrcWidget;
	CSubsysDoc *pDoc = GetDocument();
	CPtrArray* pTarget;
	CPtrArray* pCopy;
	int i,j,nWidget,id,cx,cy,direction,nParam,nIndex,nLine;
	int inport,outport,connect,junction;
	int idx,type,sblk,eblk,arrow;
	COLORREF color;
	CRect rect;
	CPoint spos,epos;
	CString matrix,name;
	char strValue[100][16];
	CLine* pLine;
	CPtrArray* pInOut;
	CPtrArray* pParamArray;
	PARAMINFO* pItem;
	
	//e폜
	pDoc->SubDeleteContents(pTargetWidget);
	//Widget̃Rs[
	pTarget = pTargetWidget->GetWidgetsPointer();
	pCopy = pCopyWidget->GetWidgetsPointer();
	nWidget = (int)pCopy->GetSize();
	for(i = 0; i < nWidget; i++) {	// nSizewidgetǂ
		pWidget = (CWidget*)pCopy->GetAt(i);
		id = pWidget->GetId();
		rect = pWidget->GetRect();
		spos = CPoint(rect.left, rect.top);
		cx = rect.Width();
		cy = rect.Height();
		direction = pWidget->GetDirection();
		matrix = pWidget->GetMatrix();
		//parameter
		pParamArray = pWidget->GetParamPointer();
		nParam = (int)pParamArray->GetSize();
		for(j = 0; j < nParam; j++) {
			pItem = (PARAMINFO*)pParamArray->GetAt(j);
			strcpy(strValue[j], pItem->strValue);
		}
		//Subsystem\WidgetɃRs[
		if(nParam > 0) {
			nIndex = pDoc->AddSubWidget2(pTargetWidget, id, spos, NULL, direction, matrix, nParam, strValue, cx, cy);
		}
		else {
			nIndex = pDoc->AddSubWidget(pTargetWidget, id, spos, NULL, direction, matrix, cx, cy);
		}
		//o̓|[g
		pSubWidget = (CWidget*) pTarget->GetAt(nIndex);
		inport = pWidget->GetInport();
		pSubWidget->SetInport(inport);
		//pSubWidget->ChangeInportName();
		pInOut = pWidget->GetInportName();
		pSubWidget->SetInportName(pInOut);
		outport = pWidget->GetOutport();
		pSubWidget->SetOutport(outport);
		//pSubWidget->ChangeOutportName();
		pInOut = pWidget->GetOutportName();
		pSubWidget->SetOutportName(pInOut);
		//Name
		name = pWidget->GetName();
		pSubWidget->SetName(_T(name));
		//gCELL
		connect = pWidget->GetConnect();
		pSubWidget->SetConnect(connect);
		junction = pWidget->GetJunction();
		pSubWidget->SetJunction(junction);
		//Subsystemt
		if(pWidget->GetId() == M_SUBSYSTEM) {
			//SubsystemSubsystem
			CopySubsystem(pSubWidget, (CPtrArray*)pWidget);
		}
	}

	//Rs[Widgetw肵ALinẽRs[
	pSaveWidget = pDoc->m_pWidget;
	pDoc->m_pWidget = pTargetWidget;
	pTarget = pTargetWidget->GetLinesPointer();
	pCopy = pCopyWidget->GetLinesPointer();
	nLine = (int)pCopy->GetSize();
	for(i = 0; i < nLine; i++) {
		pLine = (CLine*) pCopy->GetAt(i);
		spos = pLine->GetSpos();
		epos = pLine->GetEpos();
		sblk = pLine->GetSblk();
		eblk = pLine->GetEblk();
		color = pLine->GetColor();
		arrow = pLine->GetArrow();
		idx = pLine->GetIndex();
		inport = pLine->GetInport();
		outport = pLine->GetOutport();
		type = pLine->GetType();
		junction = pLine->GetJunction();
		pDoc->AddLine(spos, epos, sblk, eblk, color, arrow, idx, inport, outport, type, junction);
		pTargetWidget->IncLineIndex(1);
	}
	pDoc->m_pWidget = pSaveWidget;

}

void CSubsysView::OnExtncsStart()
{
	// TODO : ɃR}h nh R[hǉ܂B
	CSubsysDoc* pDoc = GetDocument();
	CExtncsView* pView = (CExtncsView*)(pDoc->m_pExtncsView);
	pView->PostMessage(WM_EXTNCS_START, 0, 0L);
}

void CSubsysView::OnUpdateExtncsStart(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	CExtncsDoc *pDoc = (CExtncsDoc*)(GetDocument()->m_pExtncsDoc);
	CExtncsView* pView = (CExtncsView*)(GetDocument()->m_pExtncsView);
	if(!pDoc->m_bCodeGen || !pDoc->m_bCodeCompile)
		pCmdUI->Enable(FALSE);
	else {
		pCmdUI->Enable(TRUE);
		if(!pView->m_fSimuState)
			pCmdUI->SetCheck(0);
		else
			pCmdUI->SetCheck(1);
	}
}

void CSubsysView::OnExtncsStop()
{
	// TODO : ɃR}h nh R[hǉ܂B
}

void CSubsysView::OnUpdateExtncsStop(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	CExtncsDoc *pDoc = (CExtncsDoc*)(GetDocument()->m_pExtncsDoc);
	CExtncsView* pView = (CExtncsView*)(GetDocument()->m_pExtncsView);
	if(!pDoc->m_bCodeGen || !pDoc->m_bCodeCompile)
		pCmdUI->Enable(FALSE);
	else {
		pCmdUI->Enable(TRUE);
		if(pView->m_fSimuState)
			pCmdUI->SetCheck(0);
		else
			pCmdUI->SetCheck(1);
	}	
}

void CSubsysView::OnExtncsCondition()
{
	// TODO : ɃR}h nh R[hǉ܂B
	CSubsysDoc* pDoc = GetDocument();
	CExtncsView* pView = (CExtncsView*)(pDoc->m_pExtncsView);
	pView->PostMessage(WM_EXTNCS_CONDITION, 0, 0L);
}

void CSubsysView::OnUpdateExtncsCondition(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	CExtncsDoc *pDoc = (CExtncsDoc*)(GetDocument()->m_pExtncsDoc);
	if(!pDoc->m_bCodeGen || !pDoc->m_bCodeCompile)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}
