/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: WidgetExtend.cpp,v 1.3 2004/08/02 07:16:12 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "SubsysDoc.h"
#include "ExtncsDoc.h"
#include "LineProp.h"
#include "ParamWnd.h"
#include "WidgetExtend.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ParamWnd
typedef struct tagPARAMWNDINFO {
	//Window
	CParamWnd*	pWnd;
	//id
	CWidget*	pWidget;
} PARAMWNDINFO;

/////////////////////////////////////////////////////////////////////////////
// CWidgetExtend _CAO

#if 0
CWidgetExtend::CWidgetExtend(CWnd* pParent /*=NULL*/)
	: CDialog(CWidgetExtend::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWidgetExtend)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}
#endif

CWidgetExtend::CWidgetExtend()	// [hXpRXgN^[
	: CDialog()
{
}

CWidgetExtend::~CWidgetExtend()
{
	int size;

	// Widget
	size = (int)m_arrWidgets.GetSize();
	while (size)
		delete m_arrWidgets[--size];
	m_arrWidgets.RemoveAll ();

}

CWidgetExtend::Create(CView* pView)
{
	m_pView = pView;
	return CDialog::Create(CWidgetExtend::IDD, pView);
}


void CWidgetExtend::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWidgetExtend)
	DDX_Control(pDX, IDC_WIDGET_FORMAT, m_format);
	DDX_Control(pDX, IDC_WIDGET_NAME, m_name);
	DDX_Control(pDX, IDC_WIDGET_JUNC, m_junc);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWidgetExtend, CDialog)
	//{{AFX_MSG_MAP(CWidgetExtend)
	ON_WM_SETCURSOR()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_PAINT()
	ON_EN_CHANGE(IDC_WIDGET_FORMAT, OnChangeWidgetFormat)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_DELETE_PARAM, OnDeleteParam)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWidgetExtend bZ[W nh

BOOL CWidgetExtend::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// Rg[̃TuNX
	VERIFY(m_style.SubclassDlgItem(IDC_WIDGET_CONNECT, this));
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	// ZtH[}bg
	m_format.SetWindowText(m_matrix);
	if(!m_bFormat)
		m_format.EnableWindow(FALSE);
	// 
	for(int i = 0; i < 3; i++)
		m_style.AddLineItem(i);
	m_style.SetCurSel(m_connect);
	// CELL
	m_name.SetWindowText(m_cell);
	// Junction
	if(m_id != -1) {
		CRect rect;
		m_junc.GetClientRect(rect);
		CPoint point = rect.CenterPoint();
		AddWidget(CPoint(point.x-16,point.y-16), m_id, 32, 32);
	}
	//check if control enable
	if(CheckStateFormat()) {
		m_style.EnableWindow(TRUE);
		m_junc.EnableWindow(TRUE);
	}
	else {
		m_style.EnableWindow(FALSE);
		m_junc.EnableWindow(FALSE);
	}
	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

BOOL CWidgetExtend::CheckStateFormat()
{
	int index,row,column;
	CString strLeft,strRight;

	index = m_matrix.Find(':');
	if(index == -1) {
		AfxMessageBox("Illegal format.", MB_OK, NULL);
		return FALSE;
	}
	strLeft = m_matrix.Left(index);
	strRight = m_matrix.Mid(index+1);
	row = atoi(strLeft);
	column = atoi(strRight);
	if(row == 1 && column == 1)
		return(FALSE);
	else
		return(TRUE);
}

void CWidgetExtend::OnOK() 
{
	char buf[128];
	CString str,strLeft,strRight;
	int	index,row,column,nCount;

	m_format.GetWindowText(buf, 128);
	str = _T(buf);
	index = str.Find(':');
	if(index == -1) {
		AfxMessageBox("Illegal format.", MB_OK, NULL);
		return;
	}
	strLeft = str.Left(index);
	strRight = str.Mid(index+1);
	row = atoi(strLeft);
	if(row < 1 || row > MAX_ROWWIDGET) {
		AfxMessageBox("Illegal row parameter.", MB_OK, NULL);
		return;
	}
	column = atoi(strRight);
	if(column < 1 || column > MAX_COLUMNWIDGET) {
		AfxMessageBox("Illegal column parameter.", MB_OK, NULL);
		return;
	}

	//ݒ
	m_matrix = _T(buf);
	//
	//m_cell
	m_name.GetWindowText(buf, 128);
	m_cell = _T(buf);
	//m_connect
	m_connect = m_style.GetCurSel();

	//Junction
	nCount = (int)m_arrWidgets.GetSize();
	if(!nCount)
		m_id = -1;
	else {
		CWidget* pWidget = m_arrWidgets.GetAt(0);
		m_id = pWidget->GetId();
	}
	
	m_pView->PostMessage(WM_DELETE_EXTEND, 1, 0L);
	//CDialog::OnOK();
}

BOOL CWidgetExtend::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	BOOL flag;

	if(m_pDoc->m_DragImageFile) {
		//ShowCursor(FALSE);
		m_pDragImage = m_pDoc->m_DragImageFile;
		flag = m_pDragImage->BeginDrag(0, CPoint(0, 0));
		flag = m_pDragImage->DragEnter(NULL/*this*/, CPoint(0,0));
		//::SetCapture(this->GetSafeHwnd());
		return TRUE;
	}
	
	return CDialog::OnSetCursor(pWnd, nHitTest, message);
}

void CWidgetExtend::OnMouseMove(UINT nFlags, CPoint point) 
{
	CPoint newpos;
	CRect rect;

	if(m_pDoc->m_DragImageFile) {
		//BlockViewhbO
		GetWindowRect(&rect);
		newpos.x = rect.left + point.x;
		newpos.y = rect.top + point.y;
		m_pDragImage->DragEnter(NULL, newpos/*point*/);
		m_pDragImage->DragMove(newpos/*point*/);
	}
	
	CDialog::OnMouseMove(nFlags, point);
}

void CWidgetExtend::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if(m_pDoc->m_DragImageFile) {
		m_pDragImage->EndDrag();
		//::ReleaseCapture();
		//ShowCursor(TRUE);
		delete m_pDragImage;
		//Widget쐬
		CRect rect;
		m_junc.GetClientRect(rect);
		CPoint point = rect.CenterPoint();
		AddWidget(CPoint(point.x-16,point.y-16), m_pDoc->m_DragItemIndex, 32, 32);

		//m_juncɒڕ`
		CDC* pDC = m_junc.GetWindowDC();
		int nCount = (int)m_arrWidgets.GetSize();
		CWidget* pWidget;

		if (nCount) {
			for (int i=0; i<nCount; i++) {
				pWidget = m_arrWidgets.GetAt(i);
				pWidget->Draw (pDC);
			}
		}
		//
		m_pDoc->m_DragImageFile = NULL;
	}
	
	CDialog::OnLButtonUp(nFlags, point);
}

// AddWidget 1
int CWidgetExtend::AddWidget(CPoint point, int id, int cx, int cy)
{
	int nIndex = -1;
	CWidget* pWidget = NULL;

	try {
		pWidget = new CWidget (point, id, cx, cy);
		nIndex = (int)m_arrWidgets.Add (pWidget);	
	}
	catch (CMemoryException* e) {
		AfxMessageBox (_T ("Out of memory"));
		if (pWidget != NULL)
			delete pWidget;
		e->Delete ();
		return -1;
	}
	return nIndex;
}

void CWidgetExtend::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
#if 1
	// TODO
	// p[^ݒEBhEJ
	CRect rect;
	m_junc.GetWindowRect(rect);
	ClientToScreen(&point);
	if(!rect.PtInRect(point))
		return;
	
	CWidget* pWidget;
	int nCount;

	nCount = (int)m_arrWidgets.GetSize();
	if(nCount > 0) {
		ScreenToClient(&point);
		pWidget = m_arrWidgets.GetAt(0);
		OpenParam( pWidget, point );
	}
#endif

	CDialog::OnLButtonDblClk(nFlags, point);
}

void CWidgetExtend::OpenParam(CWidget* pWidget, CPoint point)
{
	int nCount;
	PARAMWNDINFO *pItem;
	CPtrArray*	p;

	p = pWidget->GetParamPointer();
	nCount = (int)p->GetSize();
	if(nCount == 0)
		return;		//݂Ȃ

	//
	ClientToScreen(&point);
	CParamWnd *pParamWnd = new CParamWnd;
	if(!pParamWnd->Create( "Setting parameters", WS_OVERLAPPEDWINDOW,
		CRect(point.x, point.y, 640, 480), (CWnd*)this, pWidget))
	{
		return;
	}
	pParamWnd->ShowWindow(SW_SHOW);
	//ClientToScreen(&point);
	//pParamWnd->MoveWindow(point.x, point.y, 320, 240, TRUE);

	//p[^[EBhEǗ̂ߓo^
	try {
		pItem = new PARAMWNDINFO;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return;
	}
	//@ݒ
	pItem->pWnd = pParamWnd;
	pItem->pWidget = pWidget;
	//CfbNX
	nCount = (int)m_paramArray.GetSize();
	//o^
	m_paramArray.InsertAt( nCount, pItem );
	nCount++;
}


void CWidgetExtend::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	CDC* pDC = m_junc.GetWindowDC();
	int nCount = (int)m_arrWidgets.GetSize();
	CWidget* pWidget;

	if (nCount) {
		for (int i=0; i<nCount; i++) {
			pWidget = m_arrWidgets.GetAt(i);
			pWidget->Draw (pDC);
		}
	}
	
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

void CWidgetExtend::OnChangeWidgetFormat() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_CHANGE tOt CRichEditCrtl().SetEventMask()
	// bZ[WRg[֑邽߂ CDialog::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	char buf[_MAX_PATH];
	m_format.GetWindowText(buf, 128);
	m_matrix = _T(buf);
	if(CheckStateFormat()) {
		m_style.EnableWindow(TRUE);
		m_junc.EnableWindow(TRUE);
	}
	else {
		m_style.EnableWindow(FALSE);
		m_junc.EnableWindow(FALSE);
	}
	
}

void CWidgetExtend::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	
	m_pView->PostMessage(WM_DELETE_EXTEND, 0, 0L);
	//CDialog::OnCancel();
}

// delete param
LRESULT CWidgetExtend::OnDeleteParam(WPARAM wParam, LPARAM lParam)
{
	int nCount,i;
	PARAMWNDINFO *pItem;

	nCount = (int)m_paramArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (PARAMWNDINFO*) m_paramArray.GetAt (i);
			if (pItem->pWidget == (CWidget *)lParam) {
				pItem->pWnd = NULL;
			}
			delete (PARAMWNDINFO*) m_paramArray.GetAt (i);
		}
		m_paramArray.RemoveAll();
	}
	return 0L;
}

void CWidgetExtend::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	int i,size;
	PARAMWNDINFO* pItem;

	// m_paramArray
	size = (int)m_paramArray.GetSize();
	if(size > 0) {
		for (i=0; i<size; i++) {
			pItem = (PARAMWNDINFO*) m_paramArray.GetAt (i);
			if (pItem->pWnd)
				pItem->pWnd->DestroyWindow();
			delete (PARAMWNDINFO*) m_paramArray.GetAt (i);
		}
		m_paramArray.RemoveAll();
	}
	
}
