/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: XyView.cpp,v 1.2 2004/09/03 10:11:05 yoshihiko Exp $ */
// XyView.cpp : t@C
//

#include "stdafx.h"
#include "extncs.h"
#include "shell/satellite4.h"		//TODO:syscomQƂ̂

#include "WidgetObj.h"
#include "XyView.h"
#include "XyWnd.h"
#include ".\xyview.h"

using namespace std;
#define printf          syscom->console->tty_printf

// CXyView

IMPLEMENT_DYNCREATE(CXyView, CScrollView)

CXyView::CXyView()
: m_index(0)
, m_simtime(0)
, m_simstep(0)
, m_nCycle(0)
, m_nSize(0)
, m_data(NULL)
, m_nWidth(0)
, m_nLength(0)
, m_nStart(0)
, m_xs(0)
, m_ys(0)
, m_zs(0)
, m_xInit(0)
, m_yInit(0)
, m_zInit(0)
, m_width(0)
, m_height(0)
, m_xmax(0)
, m_xmin(0)
, m_ymax(0)
, m_ymin(0)
, m_zmax(0)
, m_zmin(0)
, m_pParentWnd(NULL)
{
}

CXyView::~CXyView()
{
}


BEGIN_MESSAGE_MAP(CXyView, CScrollView)
	ON_WM_CREATE()
	ON_WM_DESTROY()
END_MESSAGE_MAP()


// CXyView `

void CXyView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: ̃r[̃TCY̍vvZ܂B
	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);
}

void CXyView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: `R[hɒǉĂB
	DrawXy(pDC);
}


// CXyView ff

#ifdef _DEBUG
void CXyView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CXyView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG


// CXyView bZ[W nh

void CXyView::UpdateInit(int scope, double simtime, double simstep, int cycle, int width)
{
	CXyWnd* pXyWnd = (CXyWnd*)(this->GetParent());
	CWidget* pWidget;
	CPtrArray* p;
	SCOPEINFO* pItem;

	//f[^̈
	m_index = 0;			//ԃCfbNX
	m_nCycle = cycle;		//ԓ_
	m_simtime = simtime;
	m_simstep = simstep;
	m_nWidth = width;		//f[^
	if(m_data) {
		HeapFree( GetProcessHeap(), 0, (LPVOID)m_data );
		m_data = NULL;
	}

	if (!m_data) {
//printf("\nHeapAlloc(%ld)\n",m_nCycle*m_nWidth+2*m_nWidth);
		m_data = (double *)HeapAlloc( GetProcessHeap(), HEAP_ZERO_MEMORY, (m_nCycle*m_nWidth+2*m_nWidth) * sizeof( double ));
	}

	//_ݒ
	pWidget = pXyWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	pItem = (SCOPEINFO*) p->GetAt (scope);
	m_nLength = (int)(m_nCycle * atof(pItem->strTime) / simtime);
	m_nStart = 0;

	//TRUEƔwiĂ܂
	Invalidate(TRUE);
}

void CXyView::UpdateData(int cycle, int scope, int size, float* data)
{
	int i;
//printf("UpdateData[%4d] ",cycle);
	for(i = 0; i < size; i++) {
		m_data[cycle*size+i] = (double)(*data++);
//printf("%f ",m_data[cycle*size+i]);
	}
	m_index = cycle;
//printf("\n");

	//vZɕ\
	//CScopeWnd* pScopeWnd = (CScopeWnd*)(m_pParentWnd/*this->GetParent()*/);
	//CWidget* pWidget;
	//CPtrArray*	p;
	//SCOPEINFO* pItem;
	//pWidget = pScopeWnd->m_pWidget;
	//p = pWidget->GetScopePointer();
	//pItem = (SCOPEINFO*) p->GetAt (scope);
	CDC *pDC = GetDC();
	DrawData(pDC);
	ReleaseDC(pDC);
}

void CXyView::DrawXy(CDC* pDC)
{
	COLORREF	textColor;
	CPen	dataColor(PS_SOLID, 1, RGB(255, 0, 0));
	textColor = RGB(0, 0, 0);
	int	i,xs,ys,xe,ye;
	double xdata,xscl,ydata,yscl;
	CPoint from,to;
	CPen*	pOldPen;
	CRgn newRgn;

	//
	pDC->SetBkMode( TRANSPARENT );
	pDC->SetTextColor( textColor );

	//Scope
	DrawInit(pDC);
	//f[^\
	if(m_data) {
		newRgn.CreateRectRgn(m_xInit, m_yInit,
				m_xInit+m_width, m_yInit+m_height);
		pDC->SelectClipRgn(&newRgn);
		pOldPen = pDC->SelectObject(&dataColor);
		xs = m_xs;
		ys = m_ys;
		xscl = m_xmax - m_xmin;
		yscl = m_ymax - m_ymin;
		for(i=m_nStart; i <m_index; i++) {
			xdata = m_data[i*m_nWidth];
			ydata = m_data[i*m_nWidth+1];
			xe = m_xInit + (int)((double)m_width*(m_xmax-xdata)/xscl);
			ye = m_yInit + (int)((double)m_height*(m_ymax-ydata)/yscl);
			if(i != 0) {
				//ŏ̃f[^
				from = CPoint(xs, ys);
				to = CPoint(xe, ye);
				InvertLine(pDC, from, to);
			}
			xs = xe; ys = ye;
		}
		pDC->SelectObject(pOldPen);
		newRgn.DeleteObject();
	}
}

void CXyView::DrawInit(CDC* pDC)
{
	int		x,y,/*z,*/xs,ys,zs,xe,ye,ze;
	CPoint	from,to;
	CPen	lineColor(PS_SOLID, 1, RGB(0, 0, 0));
	COLORREF	textColor;
	textColor = RGB(0, 0, 0);
	CPen*	pOldPen;
	pOldPen = pDC->SelectObject(&lineColor);
	CRect	rect, rc, rc3d;
	CString name;
	CSize size;
	CBrush	backBrush( RGB(255,255,255) );
	CRgn newRgn;
	int width, height;

	//
	pDC->SetBkMode( TRANSPARENT );
	pDC->SetTextColor( textColor );
	//_
	x = 0; y = 0;
	//g
	GetClientRect(rect);
	width = rect.Width();
	height = rect.Height();
	rc.left = (long)(x + width * 0.05);
	rc.top = (long)(y + height * 0.05);
	rc.right = (long)(x + width * 0.95);
	rc.bottom = (long)(y + height * 0.95);
	pDC->FillRect( &rc, &backBrush);
	// 3D
	rc3d.left = rc.left+1;
	rc3d.top = rc.top+1;
	rc3d.right = rc.right+1;
	rc3d.bottom = rc.bottom+1;
	COLORREF topColor = GetSysColor(COLOR_3DLIGHT);
	COLORREF bottomColor = GetSysColor(COLOR_3DDKSHADOW);
	pDC->Draw3dRect( &rc, bottomColor, topColor );
	pDC->Draw3dRect( &rc3d, bottomColor, topColor );
	//W
	xs = (int)(x + width * 0.2);
	ys = (int)(y + height * 0.1);
	xe = (int)(x + width * 0.9);
	ye = (int)(y + height * 0.9);
	zs = 0;
	ze = 0;
	//ʒu
	if(m_index == 0) {	//0ȊÓA`撆
		m_xs = xs;
		m_ys = ys;
		m_zs = 0;
	}
	m_xInit = xs;
	m_yInit = ys;
	m_zInit = zs;
	m_width = (int)(width*0.7);
	m_height = (int)(height*0.8);
	//c
	from = CPoint(xs, ys);
	to = CPoint(xs, ye);
	InvertLine(pDC, from, to);
	//y = ys;
	//step = (int)((double)m_height / 4);
	//for(i = 0; i <= 4; i++) {
	//	from = CPoint(xs-5, y+i*step);
	//	to = CPoint(xs, y+i*step);
	//	InvertLine(pDC, from, to);
	//}
	//
	from = CPoint(xs, ye);
	to = CPoint(xe, ye);
	InvertLine(pDC, from, to);
	//x = xs;
	//step = (int)((double)m_width / 5);
	//for(i = 0; i <= 5; i++) {
	//	from = CPoint(xs+i*step, ym-3);
	//	to = CPoint(xs+i*step, ym+3);
	//	InvertLine(pDC, from, to);
	//}

	//ő^ŏ\
	//if(!pItem->autoScale) {
	//	m_ymax = atof(pItem->strVmax);
	//	m_ymin = atof(pItem->strVmin);
	//}
	//else
	//	SetAutoscale();
	SetScale();

	//O
	SetTitle(pDC);
	//P
	SetUnits(pDC);
	pDC->SelectObject(pOldPen);
}

void CXyView::InvertLine(CDC* pDC, POINT from, POINT to)
{
    //int nOldMode = pDC->SetROP2 (R2_NOT);
    pDC->MoveTo (from);
    pDC->LineTo (to);
    //pDC->SetROP2 (nOldMode);
}

void CXyView::DrawData(CDC* pDC)
{
	int	xs,ys,xe,ye;
	double xdata,xscl,ydata,yscl;
	CPoint from,to;
	CPen	dataColor(PS_SOLID, 1, RGB(255, 0, 0));
	CPen*	pOldPen;
	CRgn newRgn;

	if(!m_data)
		return;
	this->OnPrepareDC(pDC);
	newRgn.CreateRectRgn(m_xInit, m_yInit,
			m_xInit+m_width, m_yInit+m_height);
	pDC->SelectClipRgn(&newRgn);
	pOldPen = pDC->SelectObject(&dataColor);
	xs = m_xs;
	ys = m_ys;
	xscl = m_xmax - m_xmin;
	yscl = m_ymax - m_ymin;
	xdata = m_data[m_index*m_nWidth];
	ydata = m_data[m_index*m_nWidth+1];
	xe = m_xInit + (int)((double)m_width*(m_xmax-xdata)/xscl);
	ye = m_yInit + (int)((double)m_height*(m_ymax-ydata)/yscl);
	if((m_index-1) != 0) {
		//ŏ̃f[^
		from = CPoint(xs, ys);
		to = CPoint(xe, ye);
		InvertLine(pDC, from, to);
	}
	m_xs = xe; m_ys = ye;
	pDC->SelectObject(pOldPen);
	newRgn.DeleteObject();
}

void CXyView::SetScale(void)
{
	CXyWnd* pXyWnd = (CXyWnd*)(this->GetParent());
	CWidget* pWidget;
	CPtrArray*	p;
	SCOPEINFO* pItem;
	int i,nSize;
	pWidget = pXyWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	nSize = (int)p->GetSize();
	for(i = 0; i < nSize; i++) {
		pItem = (SCOPEINFO*) p->GetAt (i);
		if(pItem->strName.Compare(_T("x")) == NULL) {
			m_xmax = atof(pItem->strVmax);
			m_xmin = atof(pItem->strVmin);
		}
		else if(pItem->strName.Compare(_T("y")) == NULL) {
			m_ymax = atof(pItem->strVmax);
			m_ymin = atof(pItem->strVmin);
		}
		else {
			m_zmax = atof(pItem->strVmax);
			m_zmin = atof(pItem->strVmin);
		}
	}
}

int CXyView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CScrollView::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO :  ɓȍ쐬R[hǉĂB
	// ̫Đݒ
	m_font.CreateFont(12,
		0,0,0,FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,
		OUT_STROKE_PRECIS,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
		DEFAULT_PITCH,_T("MS PSVbN"));

	return 0;
}

void CXyView::OnDestroy()
{
	CScrollView::OnDestroy();

	// TODO : ɃbZ[W nh R[hǉ܂B
	// ̫ĵ޼ު
	m_font.DeleteObject();
}

//
// TODO
// 3\́A
void CXyView::SetTitle(CDC* pDC)
{
	CString name;
	CSize size;
	int xm,ym;
	CFont*	pOldFont;
	CXyWnd* pXyWnd;
	CWidget* pWidget;
	CPtrArray*	p;
	SCOPEINFO* pItem;
	int i,nSize;


	pOldFont = pDC->SelectObject( &m_font );
	pXyWnd = (CXyWnd*)(this->GetParent());
	pWidget = pXyWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	nSize = (int)p->GetSize();
	for(i = 0; i < nSize; i++) {
		pItem = (SCOPEINFO*) p->GetAt (i);
		if(pItem->strName.Compare(_T("x")) == NULL) {
			xm = m_xInit + m_width / 2;
			name = pItem->strName;
			size = pDC->GetTextExtent(name, name.GetLength());
			pDC->TextOut(xm-size.cx/2, m_yInit+m_height, name);
		}
		else if(pItem->strName.Compare(_T("y")) == NULL) {
			ym = m_yInit + m_height / 2;
			name = pItem->strName;
			size = pDC->GetTextExtent(name, name.GetLength());
			pDC->TextOut(m_xInit-size.cx, ym-size.cy/2, name);
		}
	}
	pDC->SelectObject( pOldFont );
}

//
// TODO
// 3\́A
void CXyView::SetUnits(CDC* pDC)
{
	CString name;
	CSize size;
	int xm,ym;
	CFont*	pOldFont;
	CXyWnd* pXyWnd;
	CWidget* pWidget;
	CPtrArray*	p;
	SCOPEINFO* pItem;
	int i,nSize;

	pOldFont = pDC->SelectObject( &m_font );
	pXyWnd = (CXyWnd*)(this->GetParent());
	pWidget = pXyWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	nSize = (int)p->GetSize();
	for(i = 0; i < nSize; i++) {
		pItem = (SCOPEINFO*) p->GetAt (i);
		if(pItem->strName.Compare(_T("x")) == NULL) {
			// xmax
			xm = m_xInit + m_width;
			name = pItem->strVmax;
			size = pDC->GetTextExtent(name, name.GetLength());
			pDC->TextOut(xm-size.cx, m_yInit+m_height, name);
			// xmin
			xm = m_xInit;
			name = pItem->strVmin;
			size = pDC->GetTextExtent(name, name.GetLength());
			pDC->TextOut(xm, m_yInit+m_height, name);
		}
		else if(pItem->strName.Compare(_T("y")) == NULL) {
			// ymax
			ym = m_yInit;
			name = pItem->strVmax;
			size = pDC->GetTextExtent(name, name.GetLength());
			pDC->TextOut(m_xInit-size.cx, ym, name);
			// ymin
			ym = m_yInit+m_height;
			name = pItem->strVmin;
			size = pDC->GetTextExtent(name, name.GetLength());
			pDC->TextOut(m_xInit-size.cx, ym-size.cy, name);
		}
	}
	pDC->SelectObject( pOldFont );
}
