/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: XyWnd.cpp,v 1.4 2004/09/14 07:22:21 yoshihiko Exp $ */
// XyWnd.cpp : t@C
//

#include "stdafx.h"
#include "extncs.h"

#include "WidgetObj.h"
#include "XyView.h"
#include "XyDoc.h"
#include "XyWnd.h"
#include ".\xywnd.h"


// CXyWnd

IMPLEMENT_DYNCREATE(CXyWnd, CFrameWnd)

CXyWnd::CXyWnd()
{
}

CXyWnd::~CXyWnd()
{
}


BEGIN_MESSAGE_MAP(CXyWnd, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

// CXyWnd
BOOL CXyWnd::Create(LPCSTR szTitle,
		LONG style			/* = WS_OVERLAPPEDWINDOW */,
		const RECT& rect	/* = rectDefault */,
		CWnd* pWnd		/* = NULL */,
		CWidget* pWidget)
{
	const char* pszConnectionClass =
		AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS,
					NULL,
					(HBRUSH)(COLOR_MENU+1),
					NULL);
	//o^
	m_pWidget = pWidget;
	m_pParentView = pWnd;
	m_strParent = _T(szTitle);

	return CFrameWnd::Create(pszConnectionClass, szTitle,
				WS_OVERLAPPEDWINDOW/* & (~WS_MINIMIZEBOX) | WS_TABSTOP | WS_CHILD*/,
					rect, NULL, MAKEINTRESOURCE(IDR_XY) );
}

// CXyWnd bZ[W nh

BOOL CXyWnd::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style &= ~FWS_ADDTOTITLE;
	//ʒuƃTCY
	//cs.x = 0;
	//cs.y = 0;
	cs.cx = 320;
	cs.cy = 320;
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	return TRUE;
}

int CXyWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// ACR\[X[h
	HICON hIcon = AfxGetApp()->LoadIcon(IDI_EXTNCS);
	ASSERT(hIcon);
	// EBhEɐVACRw肷
	this->SendMessage(WM_SETICON, TRUE, (LPARAM)hIcon);
	
	// ^Cg
	char title[_MAX_PATH];
	sprintf(title, "Xy : %s/%s", m_strParent,m_pWidget->GetName());
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);

	// CXyViewA^b`
	CRuntimeClass* pNewViewClass;
	pNewViewClass = RUNTIME_CLASS(CXyView);
	CCreateContext context;
	context.m_pNewViewClass = pNewViewClass;
	context.m_pCurrentDoc = NULL;
	CView* pNewView = STATIC_DOWNCAST(CView, CreateView(&context));
	if (pNewView != NULL)
	{
		// the new view is there, but invisible and not active...
		((CXyView*)pNewView)->m_pParentWnd = this;
		pNewView->ShowWindow(SW_SHOW);
		pNewView->OnInitialUpdate();
		SetActiveView(pNewView);
		RecalcLayout();
		m_pXyView = pNewView;
	}
	else
		m_pXyView = NULL;

	return 0;
}

BOOL CXyWnd::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext)
{

	return CFrameWnd::OnCreateClient(lpcs, pContext);
}

void CXyWnd::OnDestroy()
{
	CFrameWnd::OnDestroy();

	// TODO : ɃbZ[W nh R[hǉ܂B
}

void CXyWnd::ScopeSet(int scope, double simtime, double simstep, int cycle, int size)
{
	CXyView* pXyView = (CXyView*)m_pXyView;
	if(pXyView) {
		pXyView->UpdateInit(scope, simtime, simstep, cycle, size);
	}
}

void CXyWnd::ScopeUpdate(int cycle, int index, int size, float* data)
{
	CXyView* pXyView = (CXyView*)m_pXyView;
	if(pXyView) {
		pXyView->UpdateData(cycle, index, size, data);
	}
}

BOOL CXyWnd::OnHelpInfo(HELPINFO* pHelpInfo)
{
	// wv
	AfxGetApp()->WinHelp(0x20000+IDR_XY, HELP_CONTEXT);
	return TRUE;

	//return CFrameWnd::OnHelpInfo(pHelpInfo);
}
