/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: NcsdefInputPage.cpp,v 1.4 2004/08/24 00:02:08 yoshihiko Exp $ */

#include "stdafx.h"
#include "ncsdef.h"
#include "NcsdefInputPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNcsdefInputPage vpeB y[W

IMPLEMENT_DYNCREATE(CNcsdefInputPage, CPropertyPage)

CNcsdefInputPage::CNcsdefInputPage() : CPropertyPage(CNcsdefInputPage::IDD)
{
	//{{AFX_DATA_INIT(CNcsdefInputPage)
	//}}AFX_DATA_INIT
	m_nInput = 0;
	m_editMode = MANUAL_EDIT;
}

CNcsdefInputPage::~CNcsdefInputPage()
{
	//폜
	Clear(FALSE);
}

void CNcsdefInputPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNcsdefInputPage)
	DDX_Control(pDX, IDC_INPUT_LIST, m_list);
	DDX_Control(pDX, IDC_INPUT_REMOVE, m_remove);
	DDX_Control(pDX, IDC_INPUT_ADD, m_add);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNcsdefInputPage, CPropertyPage)
	//{{AFX_MSG_MAP(CNcsdefInputPage)
	ON_NOTIFY(LVN_GETDISPINFO, IDC_INPUT_LIST, OnGetdispinfoInputList)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_INPUT_LIST, OnEndlabeleditInputList)
	ON_NOTIFY(LVN_BEGINLABELEDIT, IDC_INPUT_LIST, OnBeginlabeleditInputList)
	ON_BN_CLICKED(IDC_INPUT_ADD, OnInputAdd)
	ON_BN_CLICKED(IDC_INPUT_REMOVE, OnInputRemove)
	ON_WM_CTLCOLOR()
	ON_WM_DESTROY()
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNcsdefInputPage bZ[W nh

BOOL CNcsdefInputPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	CRect rect;
	m_list.GetClientRect(&rect);
	DWORD dwExStyle = m_list.GetExtendedStyle();
	dwExStyle |= LVS_EX_GRIDLINES;
	dwExStyle |= LVS_EX_FULLROWSELECT;
	//dwExStyle |= LVS_EDITLABELS;
	m_list.SetExtendedStyle(dwExStyle);
	m_list.InsertColumn (0, _T ("Name"), LVCFMT_LEFT, rect.Width());
	m_list.DeleteAllItems();
	//
	m_dlgBrush.CreateSolidBrush(RGB(0,255,0));

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CNcsdefInputPage::CreateInputArray(char* name)
{
	INPUTITEM* pItem;

	try {
		pItem = new INPUTITEM;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return;
	}
	if(!name)
		pItem->strName = _T("");
	else
		pItem->strName = _T(name);
	m_inputArray.InsertAt( m_nInput, pItem );
}

void CNcsdefInputPage::AddInput(int item, INPUTITEM* pItem)
{
	LV_ITEM lvi;
	// registration
	lvi.mask = LVIF_TEXT | LVIF_PARAM; 
	lvi.iItem = item; 
	lvi.iSubItem = 0; 
	lvi.pszText = LPSTR_TEXTCALLBACK;
	lvi.lParam = (LPARAM) pItem;

	if (m_list.InsertItem (&lvi) == -1) {
		return;
	}
}

void CNcsdefInputPage::OnGetdispinfoInputList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	if (pDispInfo->item.mask & LVIF_TEXT) {
		INPUTITEM* pItem = (INPUTITEM*) pDispInfo->item.lParam;
		::lstrcpy (pDispInfo->item.pszText, pItem->strName);
	}
	
	*pResult = 0;
}

void CNcsdefInputPage::OnEndlabeleditInputList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	int iItem;
	INPUTITEM* pItem;
	CString str;

	str = _T(pDispInfo->item.pszText);
	if(str.GetLength() == 0) {
		*pResult = FALSE;
		return;
	}

	iItem = pDispInfo->item.iItem;
	pItem = (INPUTITEM*)m_list.GetItemData(iItem);
	pItem->strName = str;
	
	*pResult = TRUE;
}

void CNcsdefInputPage::OnBeginlabeleditInputList(NMHDR* pNMHDR, LRESULT* pResult) 
{
    LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
    *pResult = 1;

	if(m_editMode == MANUAL_EDIT) {
		if (! m_list.PrepareLabelEdit(pDispInfo)) {
			return;
		}
	}
	else
		m_editMode = MANUAL_EDIT;

    // To Do
    // pDispInfo->item.iItem  pDispInfo->item.iSubItem ɂ`FbNs
    // ҏWȂȂ΁A*pResult  1 ɂāÅ֐𔲂

    // ҏWsꍇɂ́ABeginLabelEdit ĂсA֐甲
    //
    m_list.BeginLabelEdit(pDispInfo, pResult);
}

void CNcsdefInputPage::OnInputAdd() 
{
	CreateInput(NULL);
}

void CNcsdefInputPage::CreateInput(char *name)
{
	//CPtrArray
	CreateInputArray(name);

	// Xgɓo^
	INPUTITEM* pItem;
	pItem = (INPUTITEM *)m_inputArray.GetAt(m_nInput);
	AddInput(m_nInput, pItem);
	m_list.SetItemState(m_nInput, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	m_list.SetFocus();
	m_nInput++;

	//ҏW[hɓ
	m_editMode = AUTO_EDIT;
	ListView_EditLabel(m_list, m_nInput-1);

}

void CNcsdefInputPage::OnInputRemove() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	INPUTITEM* pItem;
	int nItem;
	POSITION pos;
	pos = m_list.GetFirstSelectedItemPosition();
	if (pos == NULL)
		return;
	else
	{
	   while (pos)
	   {
		  nItem = m_list.GetNextSelectedItem(pos);
		  //TRACE1("Item %d was selected!\n", nItem);
		  // you could do your own processing on nItem here
		pItem = (INPUTITEM *)m_inputArray.GetAt(nItem);
		if(pItem)
			delete pItem;
		m_inputArray.RemoveAt(nItem);
		m_list.DeleteItem(nItem);
		m_nInput--;
			
	   }
	}
	
}

HBRUSH CNcsdefInputPage::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CPropertyPage::OnCtlColor(pDC, pWnd, nCtlColor);
	
	if(nCtlColor == CTLCOLOR_DLG) {
		//Change background color
		//return m_dlgBrush;
	}
	return hbr;
}

void CNcsdefInputPage::OnDestroy() 
{
	CPropertyPage::OnDestroy();
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	m_dlgBrush.DeleteObject();	
}

void CNcsdefInputPage::Clear(BOOL fg)
{
	int nCount,i;
	INPUTITEM* pInfo;
	nCount = (int)m_inputArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pInfo =  (INPUTITEM*) m_inputArray.GetAt (i);
			delete pInfo;
		}
		m_inputArray.RemoveAll();
	}
	m_nInput = 0;
	// list̃NA
	if(fg) {
		nCount = m_list.GetItemCount();
		m_list.DeleteAllItems();
	}
}

BOOL CNcsdefInputPage::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	AfxGetApp()->WinHelp(0x20000+IDD_NCSDEF_INPUT, HELP_CONTEXT);
	return TRUE;
	
	//return CPropertyPage::OnHelpInfo(pHelpInfo);
}
