/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: NcsdefObsPage.h,v 1.3 2004/08/24 00:02:08 yoshihiko Exp $ */

#if !defined(AFX_NCSDEFOBSPAGE_H__B509D70D_73FF_4EC5_871F_8FBCF072F1FF__INCLUDED_)
#define AFX_NCSDEFOBSPAGE_H__B509D70D_73FF_4EC5_871F_8FBCF072F1FF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// NcsdefObsPage.h : wb_[ t@C
//

#include "ListCtrlEdit.h"

/////////////////////////////////////////////////////////////////////////////
// CNcsdefObsPage _CAO

class CNcsdefObsPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CNcsdefObsPage)

// RXgNV
public:
	CNcsdefObsPage();
	~CNcsdefObsPage();

// _CAO f[^
	//{{AFX_DATA(CNcsdefObsPage)
	enum { IDD = IDD_NCSDEF_OBS };
	CListCtrlEdit	m_list;
	CButton	m_remove;
	CButton	m_add;
	//}}AFX_DATA


// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B

	//{{AFX_VIRTUAL(CNcsdefObsPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	//}}AFX_VIRTUAL

// Cve[V
public:
	void CreateObs(char *name, char *label, char *unit);
	void Clear(BOOL fg);

private:
	int	m_nObs;
	CPtrArray m_obsArray;
	void AddObs(int item, OBSITEM* pItem);
	void CreateObsArray(char *name, char *label, char *unit);
	int		m_editMode;

protected:
	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CNcsdefObsPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnBeginlabeleditObsList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnEndlabeleditObsList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnObsAdd();
	afx_msg void OnObsRemove();
	afx_msg void OnGetdispinfoObsList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_NCSDEFOBSPAGE_H__B509D70D_73FF_4EC5_871F_8FBCF072F1FF__INCLUDED_)
