/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: NcsdefParamPage.cpp,v 1.4 2004/08/24 00:02:08 yoshihiko Exp $ */

#include "stdafx.h"
#include "ncsdef.h"
#include "NcsdefParamPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNcsdefParamPage vpeB y[W

IMPLEMENT_DYNCREATE(CNcsdefParamPage, CPropertyPage)

CNcsdefParamPage::CNcsdefParamPage() : CPropertyPage(CNcsdefParamPage::IDD)
{
	//{{AFX_DATA_INIT(CNcsdefParamPage)
	//}}AFX_DATA_INIT
	m_nParam = 0;
	m_editMode = MANUAL_EDIT;
}

CNcsdefParamPage::~CNcsdefParamPage()
{
	// 폜
	Clear(FALSE);
}

void CNcsdefParamPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNcsdefParamPage)
	DDX_Control(pDX, IDC_PARAM_LIST, m_list);
	DDX_Control(pDX, IDC_PARAM_REMOVE, m_remove);
	DDX_Control(pDX, IDC_PARAM_ADD, m_add);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNcsdefParamPage, CPropertyPage)
	//{{AFX_MSG_MAP(CNcsdefParamPage)
	ON_NOTIFY(LVN_GETDISPINFO, IDC_PARAM_LIST, OnGetdispinfoParamList)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_PARAM_LIST, OnEndlabeleditParamList)
	ON_BN_CLICKED(IDC_PARAM_ADD, OnParamAdd)
	ON_BN_CLICKED(IDC_PARAM_REMOVE, OnParamRemove)
	ON_NOTIFY(NM_DBLCLK, IDC_PARAM_LIST, OnDblclkParamList)
	ON_NOTIFY(LVN_BEGINLABELEDIT, IDC_PARAM_LIST, OnBeginlabeleditParamList)
	ON_WM_HELPINFO()
	ON_WM_CTLCOLOR()
	ON_NOTIFY(NM_SETFOCUS, IDC_PARAM_LIST, OnSetfocusParamList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNcsdefParamPage bZ[W nh

BOOL CNcsdefParamPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	CRect rect;
	m_list.GetClientRect(&rect);
	DWORD dwExStyle = m_list.GetExtendedStyle();
	dwExStyle |= LVS_EX_GRIDLINES;
	dwExStyle |= LVS_EX_FULLROWSELECT;
	//dwExStyle |= LVS_EDITLABELS;
	m_list.SetExtendedStyle(dwExStyle);
	m_list.DeleteAllItems();

	
	m_list.InsertColumn (0, _T ("Name"), LVCFMT_LEFT, 80);
	m_list.InsertColumn (1, _T ("Value"), LVCFMT_LEFT, 128);
	m_list.InsertColumn (2, _T ("Unit"), LVCFMT_LEFT, rect.Width()-80-128);
	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CNcsdefParamPage::OnGetdispinfoParamList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	
	if (pDispInfo->item.mask & LVIF_TEXT) {
		PARAMITEM* pItem = (PARAMITEM*) pDispInfo->item.lParam;

		switch (pDispInfo->item.iSubItem) {
			case 0: // Name
				::lstrcpy (pDispInfo->item.pszText, pItem->strName);
				break;

			case 1: //Value
				::lstrcpy (pDispInfo->item.pszText, pItem->strValue);
				break;

			case 2: // Unit
				::lstrcpy (pDispInfo->item.pszText, pItem->strUnit);
				break;
		}
	}
	
	*pResult = 0;
}

void CNcsdefParamPage::OnEndlabeleditParamList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	CString str,disp[3],strRight;
	int iItem,iSubItem,idx,pos;
	PARAMITEM* pItem;

	str = _T(pDispInfo->item.pszText);
	if(str.GetLength() == 0) {
		*pResult = FALSE;
		return;
	}
	else {
		iItem = pDispInfo->item.iItem;
		pItem = (PARAMITEM*)m_list.GetItemData(iItem);
		iSubItem = pDispInfo->item.iSubItem;

		//':'Zp[^Ƃ
		if(iSubItem == 0) {
			disp[0] = str;
			disp[1] = _T("");
			disp[2] = _T("");
			idx = 0;
			pos = str.Find(_T(":"));
			while(pos != -1) {
				disp[idx++] = str.Left(pos);
				strRight = str.Mid(pos+1);
				str = strRight;
				disp[idx] = str;
				pos = str.Find(_T(":"));
			}
		}

		switch(iSubItem) {
		case 0:
			pItem->strName = disp[0];
			if(disp[1].GetLength()>0)
				pItem->strValue = disp[1];
			if(disp[2].GetLength()>0)
				pItem->strUnit = disp[2];
			break;
		case 1:
			pItem->strValue = str;
			break;
		case 2:
			pItem->strUnit = str;
			break;
		}
	}

	*pResult = TRUE;
}

void CNcsdefParamPage::AddParam(int item, PARAMITEM* pItem)
{
	LV_ITEM lvi;

	/*add a var to listview*/
	lvi.mask = LVIF_TEXT | LVIF_PARAM; 
	lvi.iItem = item; 
	lvi.iSubItem = 0; 
	lvi.pszText = LPSTR_TEXTCALLBACK;
	lvi.lParam = (LPARAM) pItem;


	if (m_list.InsertItem (&lvi) == -1) {
		return;
	}
}

void CNcsdefParamPage::CreateParamArray(char *name, char *value, char*unit)
{
	PARAMITEM* pItem;

	try {
		pItem = new PARAMITEM;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return;
	}
	if(!name)
		pItem->strName = _T("");
	else
		pItem->strName = _T(name);
	if(!value)
		pItem->strValue = _T("");
	else
		pItem->strValue = _T(value);
	if(!unit)
		pItem->strUnit = _T("");
	else
		pItem->strUnit = _T(unit);
	m_paramArray.InsertAt( m_nParam, pItem );
}

void CNcsdefParamPage::OnParamAdd() 
{
	CreateParam(NULL, NULL, NULL);
}

void CNcsdefParamPage::CreateParam(char *name, char *value, char*unit)
{
	//CPtrArray
	CreateParamArray(name, value, unit);

	// Xgɓo^
	PARAMITEM* pItem;
	pItem = (PARAMITEM *)m_paramArray.GetAt(m_nParam);
	AddParam(m_nParam, pItem);
	m_list.SetItemState(m_nParam, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	m_list.SetFocus();
	m_nParam++;
	
	//ҏW[hɓ
	m_editMode = AUTO_EDIT;
	ListView_EditLabel(m_list, m_nParam-1);
}

void CNcsdefParamPage::OnParamRemove() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	PARAMITEM* pItem;
	int nItem;
	POSITION pos;
	pos = m_list.GetFirstSelectedItemPosition();
	if (pos == NULL)
		return;
	else
	{
	   while (pos)
	   {
		  nItem = m_list.GetNextSelectedItem(pos);
		  //TRACE1("Item %d was selected!\n", nItem);
		  // you could do your own processing on nItem here
		pItem = (PARAMITEM *)m_paramArray.GetAt(nItem);
		if(pItem)
			delete pItem;
		m_paramArray.RemoveAt(nItem);
		m_list.DeleteItem(nItem);
		m_nParam--;
			
	   }
	}
	
}

void CNcsdefParamPage::OnDblclkParamList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	

	int iItem = pDispInfo->item.iItem/*iSubItem*/;
	int iSubItem = pDispInfo->item.iSubItem;
	CString str;
	str = m_list.GetItemText(iSubItem, iItem);
	
	*pResult = 0;
}

void CNcsdefParamPage::OnBeginlabeleditParamList(NMHDR* pNMHDR, LRESULT* pResult) 
{
    LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
    *pResult = 1;

	if(m_editMode == MANUAL_EDIT) {
		if (! m_list.PrepareLabelEdit(pDispInfo)) {
			return;
		}
	}
	else
		m_editMode = MANUAL_EDIT;

    // To Do
    // pDispInfo->item.iItem  pDispInfo->item.iSubItem ɂ`FbNs
    // ҏWȂȂ΁A*pResult  1 ɂāÅ֐𔲂

    // ҏWsꍇɂ́ABeginLabelEdit ĂсA֐甲
    //
    m_list.BeginLabelEdit(pDispInfo, pResult);
}

void CNcsdefParamPage::Clear(BOOL fg)
{
	int nCount,i;
	PARAMITEM* pInfo;
	nCount = (int)m_paramArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pInfo =  (PARAMITEM*) m_paramArray.GetAt (i);
			delete pInfo;
		}
		m_paramArray.RemoveAll();
	}
	m_nParam = 0;
	// list̃NA
	if(fg) {
		nCount = m_list.GetItemCount();
		m_list.DeleteAllItems();
	}
}

BOOL CNcsdefParamPage::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	AfxGetApp()->WinHelp(0x20000+IDD_NCSDEF_PARAM, HELP_CONTEXT);
	return TRUE;
	
	//return CPropertyPage::OnHelpInfo(pHelpInfo);
}

HBRUSH CNcsdefParamPage::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CPropertyPage::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: ̈ʒu DC ̃Agr[gύXĂ
	
	// TODO: ftHg̃uV]݂̂̂łȂꍇɂ́AႤuVԂĂ
	return hbr;
}

void CNcsdefParamPage::OnSetfocusParamList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	
	*pResult = 0;
}
