/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: NcsdefView.h,v 1.2 2004/05/19 04:15:11 yoshihiko Exp $ */

#if !defined(AFX_NCSDEFVIEW_H__72211FF6_D85D_4F29_A7F7_F63BB451863D__INCLUDED_)
#define AFX_NCSDEFVIEW_H__72211FF6_D85D_4F29_A7F7_F63BB451863D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// NcsdefView.h : wb_[ t@C
//

/////////////////////////////////////////////////////////////////////////////
// CNcsdefView tH[ r[

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif

class CNcsdefView : public CFormView
{
protected:
	CNcsdefView();           // IɎgpveNg RXgN^B
	DECLARE_DYNCREATE(CNcsdefView)

// tH[ f[^
public:
	//{{AFX_DATA(CNcsdefView)
	enum { IDD = IDD_NCSDEF };
		// : ClassWizard ͂̈ʒuɃf[^oǉ܂B
	//}}AFX_DATA

// Agr[g
public:
	CNcsdefInputPage m_defInputPage;
	CNcsdefOutputPage m_defOutputPage;
	CNcsdefParamPage m_defParamPage;
	CNcsdefObsPage m_defObsPage;
	CNcsdefFuncPage m_defFuncPage;
	CNcsdefSheet m_ncsdefSheet;
	CString	m_strModelPath;

// Iy[V
public:
	CNcsdefDoc* GetDocument();
	BOOL	LoadNcsModel(char *modelfile);

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CNcsdefView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	//}}AFX_VIRTUAL

// Cve[V
private:
	void	FileAsSave();
	BOOL	CheckAllItem();
	BOOL	CreateModel(const char *pathname); 
	CString GetModuleName(CString str);
	CString GetModuleType(CString str);
	int		GetModuleExinput(FILE* fp, CString str);
	int		GetModuleInput(FILE* fp, CString str);
	int		GetModuleOutput(FILE* fp, CString str);
	int		GetModuleObs(FILE* fp, CString str);
	int		GetModuleParam(FILE* fp, CString str);
	BOOL	GetSomeItems(CString str, int *nCount, int tag);
	void	SetItem(char *pItem, int tag);
	void	GetModuleFunc(FILE* fp, CString str);
	void	Print(const char *str);
	CString	ModifiedLine(char *line);

protected:
	virtual ~CNcsdefView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CNcsdefView)
	afx_msg void OnFileOpen();
	afx_msg void OnUpdateFileOpen(CCmdUI* pCmdUI);
	afx_msg void OnFileSave();
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnModuleCheck();
	afx_msg void OnUpdateModuleCheck(CCmdUI* pCmdUI);
	afx_msg void OnModuleAppend();
	afx_msg void OnUpdateModuleAppend(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_NCSDEFVIEW_H__72211FF6_D85D_4F29_A7F7_F63BB451863D__INCLUDED_)
