/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: dlfcn.h,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#ifndef __DLFCN_H__
#define __DLFCN_H__

#ifdef DLLEXPORT
# undef DLLEXPORT
#endif
#ifdef DLLIMPORT
# undef DLLIMPORT
#endif
#ifdef DECLSPEC
# undef DECLSPEC
#endif
#ifdef WIN32
#  define DLLEXPORT __declspec(dllexport)
#  define DLLIMPORT __declspec(dllimport)
# ifdef LIBSATELLITE_EXPORTS
#  define DECLSPEC DLLEXPORT
# else
#  define DECLSPEC DLLIMPORT
# endif
#else
# define DLLEXPORT
# define DLLIMPORT
# define DECLSPEC
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef RTLD_LAZY
#define RTLD_LAZY 0 // dummy
#define RTLD_NOW  1 // dummy
#endif

// dynamic loding fuctions
DECLSPEC void* dlopen(const char *path, int mode);
DECLSPEC void* dlsym(void *handle, const char *symbol);
DECLSPEC const char* dlerror(void);
DECLSPEC int dlclose(void *handle);

#ifdef __cplusplus
}
#endif

#endif //__DLFCN_H__
