/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: sync3305_3163.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */
//
//	I/O{[hW[
//	sync3305_3163.cpp
//	3305g`o͂A3163Ŏ荞
//
//
//	The calling syntax is:
//
//y=sync3305_3163(x,interval,data_num,channel,board_num,range,repeat)
//

#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "FbiAd.h"
#include "FbiDa.h"
//#include "resource.h"
//#define		SYNC_ON
//#define		SAMPLE_NUM	900

#ifdef __cplusplus
extern "C" {
#endif

extern HANDLE hDeviceHandle;

static HANDLE hDeviceHandle3163;
static HANDLE hDeviceHandle3305;
static HANDLE	hAdEvent;

static int da3305_start(
double xp[],
double *interval,
int *data_num,
int *channel,
int *board_num,
int *range,
int *repeat
)
{
        DASMPLREQ SmplConfig;
		DAMODEREQ ModeConfig;
        ULONG ulSmplNum,i,addr;
        WORD wChannel,j;
        char strDeviceName[256];
		WORD *pData;
		WORD wMax,wMin,wMid;
		ULONG ulRange,ulTrigMode,ulMode;
		double scale,daout;
		DABOARDSPEC BoardSpec;
		int errcode;

        /* Parameters */
        ulSmplNum = (ULONG)(*data_num);
        wChannel = (WORD)(*channel);

        /*Device name*/
        sprintf(strDeviceName, "FBIDA%d", *board_num);

        /*Device open*/
        hDeviceHandle3305 = DaOpen(strDeviceName);
        if(hDeviceHandle3305 == INVALID_HANDLE_VALUE) {
			printf("DaOpen error.\n");
			return FALSE;
		}

		/*Board Spec*/
		errcode = DaGetDeviceInfo(hDeviceHandle3305, &BoardSpec);
		if(errcode != DA_ERROR_SUCCESS) {
			printf("DaGetDeviceInfo error.\n");
			return FALSE;
		}
        /*Set board*/
	    errcode = DaSetBoardConfig(hDeviceHandle3305, ulSmplNum, NULL, NULL, 0);
		if(errcode != DA_ERROR_SUCCESS) {
			printf("DaSetBoardConfig error.\n");
			return FALSE;
		}
		//hEvent = CreateEvent(0, TRUE, FALSE, NULL);
        //DaSetBoardConfig(hDeviceHandle3305, ulSmplNum, hEvent, NULL, 0);

        /*Get Sampling Config*/
        errcode = DaGetSamplingConfig(hDeviceHandle3305, &SmplConfig);
		if(errcode != DA_ERROR_SUCCESS) {
			printf("DaGetSamplingConfig error.\n");
			return FALSE;
		}

        /*Set Sampling Config*/
		scale = 1.0;
		switch(*range) {
			case	0:
				ulRange = DA_5V;
				ulMode = DA_RANGE_BIPOLAR;
				scale = 5;
		wMax = 0xfff;	wMid = 0x7ff;	wMin = 0x7ff;
				break;
			case	1:
				ulMode = DA_RANGE_BIPOLAR;
				ulRange = DA_2P5V;
				scale = 2.5;
		wMax = 0xfff;	wMid = 0x7ff;	wMin = 0x7ff;
				break;
			case	2:
				ulRange = DA_1V;
				ulMode = DA_RANGE_BIPOLAR;
				scale = 1.0;
		wMax = 0xfff;	wMid = 0x7ff;	wMin = 0x7ff;
				break;
			case	3:
				ulRange = DA_0_5V;
				ulMode = DA_RANGE_UNIPOLAR;
				scale = 5;
		wMax = 0xfff;	wMid = 0xfff;	wMin = 0x0;
				break;
			case	4:
				ulRange = DA_0_2P5V;
				ulMode = DA_RANGE_UNIPOLAR;
				scale = 2.5;
		wMax = 0xfff;	wMid = 0xfff;	wMin = 0x0;
				break;
			case	5:
				ulRange = DA_0_1V;
				ulMode = DA_RANGE_UNIPOLAR;
				scale = 1.0;
		wMax = 0xfff;	wMid = 0xfff;	wMin = 0x0;
				break;
		}
//ulRange = DA_1V;
		SmplConfig.ulSmplRepeat = (ULONG)(*repeat);
		SmplConfig.fSmplFreq = (float)(*interval);
        if(wChannel == 1) {
                /*1Channel*/
                SmplConfig.ulChCount = 1;
                SmplConfig.SmplChReq[0].ulChNo = 1;
				SmplConfig.SmplChReq[0].ulRange = ulRange;
        }
        else {
                /*2Channel*/
                SmplConfig.ulChCount = 2;
                SmplConfig.SmplChReq[0].ulChNo = 1;
				SmplConfig.SmplChReq[0].ulRange = ulRange;
                SmplConfig.SmplChReq[1].ulChNo = 2;
				SmplConfig.SmplChReq[1].ulRange = ulRange;
        }
		ulTrigMode = DA_FREERUN;
		SmplConfig.ulTrigMode = ulTrigMode;
        errcode = DaSetSamplingConfig(hDeviceHandle3305, &SmplConfig);
		if(errcode != DA_ERROR_SUCCESS) {
			printf("DaSetSamplingCpnfig error.\n");
			return FALSE;
		}

		/*Oo͂Lɂ*/
		/* Set mode */
		errcode = DaGetMode(hDeviceHandle3305, &ModeConfig);
		if(errcode != DA_ERROR_SUCCESS) {
			printf("DaGetMode error.\n");
			return FALSE;
		}
		ModeConfig.ulExClock = DA_EXCLK_OUT;
        if(wChannel == 1) {
                /*1Channel*/
				ModeConfig.ModeChReq[0].ulRange = ulMode;
				ModeConfig.ModeChReq[0].fVolt = scale;
        }
        else {
                /*2Channel*/
				ModeConfig.ModeChReq[0].ulRange = ulMode;
				ModeConfig.ModeChReq[0].fVolt = scale;
				ModeConfig.ModeChReq[1].ulRange = ulMode;
				ModeConfig.ModeChReq[1].fVolt = scale;
        }
		errcode = DaSetMode(hDeviceHandle3305, &ModeConfig);
		if(errcode != DA_ERROR_SUCCESS) {
			printf("DaSetMode error.\n");
			return FALSE;
		}

		/*Clear the analog output data*/
		errcode = DaClearSamplingData(hDeviceHandle3305);
		if(errcode != DA_ERROR_SUCCESS) {
			printf("DaClearSamplingData error.\n");
			return FALSE;
		}

        /* Set data */
		pData = (WORD *)malloc(ulSmplNum * sizeof( WORD ) * wChannel );
		addr = 0;
		for(i = 0; i < ulSmplNum; i++) {
			for(j=0;j<wChannel;j++) {
				//daout = xp[j*ulSmplNum+i];
				daout = xp[addr];
				if(daout >= scale)
					daout = scale;
				if(daout < -scale)
					daout = scale;
				//pData[addr] = (WORD)(wMid * daout / scale/*yp[j*ulSmplNum+i]*/ + wMid);
				pData[addr] = (WORD)(wMid * daout / scale/*yp[j*ulSmplNum+i]*/ + wMin);
				//pData[addr] = 0xffff;
				addr++;
			}
		}
        errcode = DaSetSamplingData(hDeviceHandle3305, pData, ulSmplNum);
		if(errcode != DA_ERROR_SUCCESS) {
			printf("DaSetSamplingData error.\n");
			return FALSE;
		}
		free(pData);

        /* Sampling start */
	    //DaStartSampling(hDeviceHandle3305, FLAG_SYNC);

        /* Device close */
        //DaClose(hDeviceHandle3305);
		return TRUE;
}

static int ad3163_start(
double *interval,
int *data_num,
int *channel,
int *board_num,
int *range
)
{
	ADSMPLREQ SmplConfig;
	ULONG ulSmplNum;
	WORD wChannel;
	char strDeviceName[256];
	ULONG ulRange,ulFastMode,ulTrigMode;
	int errcode;
	double scale;

	/* Parameters */
#ifdef SAMPLE_NUM
	ulSmplNum = SAMPLE_NUM;
#else
	ulSmplNum = (ULONG)(*data_num);
#endif
	wChannel = (WORD)(*channel);
	/*Device name*/
	sprintf(strDeviceName, "FBIAD%d", *board_num);
	/*Device open*/
#if 0
	hDeviceHandle3163 = AdOpen(strDeviceName);
	if(hDeviceHandle3163 == INVALID_HANDLE_VALUE) {
		printf("AdOpen error.\n");
		return FALSE;
	}
#else
	hDeviceHandle3163 = hDeviceHandle;
#endif

#ifndef SYNC_ON
	/*Event*/
	hAdEvent = CreateEvent(0, TRUE, FALSE, NULL);
    errcode = AdSetBoardConfig(hDeviceHandle3163, hAdEvent, NULL, 0);
	if(errcode != AD_ERROR_SUCCESS) {
		printf("AdSetBoardConfig error.\n");
		return FALSE;
	}
#endif

	/*Board Spec*/
	//AdGetDeviceInfo(hDeviceHandle3163, &BoardSpec);

	/*Get Sampling Config*/
	errcode = AdGetSamplingConfig(hDeviceHandle3163, &SmplConfig);
	if(errcode != AD_ERROR_SUCCESS) {
		printf("AdGetSamplingConfig error.\n");
		return FALSE;
	}

	/*Set Sampling Config*/
	ulRange = AD_5V;	/* default */
	scale = 5.0;
	switch(*range) {
		case	0:
			ulRange = AD_5V;
			scale = 5.0;
			break;
		case	1:
			ulRange = AD_2P5V;
			scale = 2.5;
			break;
		case	2:
			ulRange = AD_1V;
			scale = 1.0;
			break;
		case	3:
			ulRange = AD_0_5V;
			scale = 5.0;
			break;
		case	4:
			ulRange = AD_0_2P5V;
			scale = 2.5;
			break;
		case	5:
			ulRange = AD_0_1V;
			scale = 1.0;
			break;
	}
	//ulRange = AD_0_5V;
	//SmplConfig.fSmplFreq = (float)(*interval);
	//ONbNgpɂ́A0.0ݒ肷
	SmplConfig.fSmplFreq = 0.0;
	SmplConfig.ulSmplNum = ulSmplNum;
	ulFastMode = AD_NORMAL_MODE;
	SmplConfig.ulFastMode = ulFastMode;
	if(wChannel == 1) {
			/*1Channel*/
			SmplConfig.ulChCount = 1;
			SmplConfig.SmplChReq[0].ulChNo = 1;
			SmplConfig.SmplChReq[0].ulRange = ulRange;
	}
	else {
			/*2Channel*/
			SmplConfig.ulChCount = 2;
			SmplConfig.SmplChReq[0].ulChNo = 1;
			SmplConfig.SmplChReq[0].ulRange = ulRange;
			SmplConfig.SmplChReq[1].ulChNo = 2;
			SmplConfig.SmplChReq[1].ulRange = ulRange;
	}
	ulTrigMode = AD_FREERUN;
	SmplConfig.ulTrigMode = ulTrigMode;

	errcode = AdSetSamplingConfig(hDeviceHandle3163, &SmplConfig);
	if(errcode != AD_ERROR_SUCCESS) {
		printf("AdSetSamplingConfig error.\n");
		return FALSE;
	}

	//obt@NA
	errcode = AdClearSamplingData(hDeviceHandle3163);
	if(errcode != AD_ERROR_SUCCESS) {
		printf("AdClearSamplingData error.\n");
		return FALSE;
	}

	//ݒemF
	/*Get Sampling Config*/
	//AdGetSamplingConfig(hDeviceHandle3163, &SmplConfig);

	/* Sampling start */
#ifdef SYNC_ON
//SYNCŏI
    /* Sampling start */
	errcode = DaStartSampling(hDeviceHandle3305, FLAG_ASYNC);
	if(errcode != DA_ERROR_SUCCESS) {
		printf("DaStartSampling error.\n");
		return FALSE;
	}

	/* Sampling start */
	errcode = AdStartSampling(hDeviceHandle3163, FLAG_SYNC);
	if(errcode != AD_ERROR_SUCCESS) {
		printf("AdStartSampling error.\n");
		return FALSE;
	}
	errcode = DaStopSampling(hDeviceHandle3305);
	if(errcode != DA_ERROR_SUCCESS) {
		printf("DaStopSampling error.\n");
		return FALSE;
	}
#else
//ASYNCŏI
	errcode = AdStartSampling(hDeviceHandle3163, FLAG_ASYNC);
	if(errcode != AD_ERROR_SUCCESS) {
		printf("AdStartSampling error.\n");
		return FALSE;
	}

    /* Sampling start */
	errcode = DaStartSampling(hDeviceHandle3305, FLAG_ASYNC);
	if(errcode != DA_ERROR_SUCCESS) {
		printf("DaStartSampling error.\n");
		return FALSE;
	}

	ULONG limit;
	limit = (ULONG)(*data_num / *interval * 1000 + 1);
	WaitForSingleObject(hAdEvent, INFINITE/*limit*/);
	ResetEvent(hAdEvent);
	CloseHandle(hAdEvent);
	printf("Async samplind done.\n");
	//TvO~
	errcode = AdStopSampling( hDeviceHandle3163 );
	if(errcode != AD_ERROR_SUCCESS) {
		if(errcode != AD_ERROR_STOP_SAMPLING) {
			printf("AdStopSampling error.\n");
			return FALSE;
		}
	}
	errcode = DaStopSampling(hDeviceHandle3305);
	if(errcode != DA_ERROR_SUCCESS) {
		printf("DaStopSampling error.\n");
		return FALSE;
	}

    /* Device close */
    DaClose(hDeviceHandle3305);

#endif

	return TRUE;
}

static int ad3163_stop( double yp[], WORD wChannel, int length, int range )
{
	WORD *pWordSmplData;
	ULONG	addr,len;
	WORD ch,wData;
	int	errcode;
	ULONG ulSmplNum;
	double	scale;
	WORD BASE,MAX;

	//
#ifdef SAMPLE_NUM
	ulSmplNum = SAMPLE_NUM;
#else
	ulSmplNum = length;
#endif

	//W
	scale = 5.0;
	switch(range) {
		case	0:
			scale = 5.0;
			BASE = 0x7ff; MAX = 0x7ff;
			break;
		case	1:
			scale = 2.5;
			BASE = 0x7ff; MAX = 0x7ff;
			break;
		case	2:
			scale = 1.0;
			BASE = 0x7ff; MAX = 0x7ff;
			break;
		case	3:
			scale = 5.0;
			BASE = 0x0; MAX = 0xfff;
			break;
		case	4:
			scale = 2.5;
			BASE = 0x0; MAX = 0xfff;
			break;
		case	5:
			scale = 1.0;
			BASE = 0x0; MAX = 0xfff;
			break;
	}


	//TvO~
	//errcode = AdStopSampling( hDeviceHandle3163 );
	//ICxg҂
	//WaitForSingleObject(hAdEvent, INFINITE);
	//ResetEvent(hAdEvent);
	//CloseHandle(hAdEvent);

	/*Buffer yp clear*/
	addr = 0;
	for(len = 0; len < ulSmplNum; len++) {
		for(ch = 0; ch < wChannel; ch++) {
			yp[ch*ulSmplNum+len] = 0.0;
			addr++;
		}
	}
	/* Get Data */
	pWordSmplData = (WORD *)malloc(ulSmplNum * wChannel * sizeof(WORD));
	errcode = AdGetSamplingData(hDeviceHandle3163, pWordSmplData, &ulSmplNum);
	if(errcode != AD_ERROR_SUCCESS) {
		printf("Get sample number error : %d\n",ulSmplNum);
		free(pWordSmplData);
		return FALSE;
	}
	/* Set Data */
	addr = 0;
	for(len = 0; len < ulSmplNum; len++) {
		for(ch = 0; ch < wChannel; ch++) {
			wData = (WORD)*(pWordSmplData+addr);
            //yp[ch*ulSmplNum+len] = scale *(double)(wData - BASE)/MAX;
            yp[addr] = scale *(double)(wData - BASE)/MAX;
			addr++;
		}
	}
	free(pWordSmplData);

	/*Device close*/
	//AdClose(hDeviceHandle3163);

    DaClose(hDeviceHandle3305);
	return TRUE;
}

DLLEXPORT int sync3305_3163()
{
	Buffer *xp;
	Buffer *yp;
    double interval;
    int data_num;
    int channel;
    int board_num;
	int range;
	int repeat;
	int dim, index[MAX_INDEX];
	int	total_num;
	int errcode;

	// Check for proper number of arguments */
	if(GetArgNum() != 7)
		exit(1);
	/* Parameters */
	xp = GetSeries(0,&dim,index);
	interval = GetScalar(1);
	data_num = (int)GetScalar(2);
	if(index[0]<=data_num)
		exit(3);
	channel = (int)GetScalar(3);
	if(dim != channel)
		exit(4);
	board_num = (int)GetScalar(4);
	range = (int)GetScalar(5);
	repeat = (int)GetScalar(6);

	//repeat񐔂data_num͂Sf[^
	total_num = data_num/* * repeat*/;
	//DAo͂𓯊ŃX^[g
	errcode = da3305_start(xp, &interval, &index[0], &channel, &board_num, &range, &repeat);
	if(!errcode)
		exit(1);
	//ADݒ肵񓯊ŃX^[g
	errcode = ad3163_start(&interval, &total_num, &channel, &board_num, &range);
	if(!errcode)
		exit(1);
	//DAo͂𓯊ŃX^[g
	//da3305_start(xp, &interval, &data_num, &channel, &board_num, &range, &repeat);
	//~f[^
	if (( yp = AllocBuffer( data_num * channel ) ) == NULL )
		exit(2);

	errcode = ad3163_stop(yp, channel, total_num, range);

	if(channel == 1) {
		dim = 1;
#ifdef SAMPLE_NUM
		index[0] = SAMPLE_NUM;
#else
		index[0] = total_num;
#endif
	}
	else {
		dim = 2;
#ifdef SAMPLE_NUM
		index[0] = SAMPLE_NUM;
#else
		index[0] = total_num;
#endif
		index[1] = dim;
	}
	ReturnSeries(yp, dim, index);
	return 0;
}

#ifdef __cplusplus
}
#endif

