/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: main.cpp,v 1.8 2005/03/17 14:10:30 orrisroot Exp $ */


#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <windows.h>

#include <stdio.h>
#include <conio.h>

#include "shell/satellite4.h"
#include "win32_console.h"

static sl_shell *pshell;
static tty_console *console;

BOOL cbrk_handler(DWORD type){
  switch (type) {
  case CTRL_BREAK_EVENT:
  case CTRL_C_EVENT:
	setsigint();
  case CTRL_CLOSE_EVENT:
  case CTRL_LOGOFF_EVENT:
  case CTRL_SHUTDOWN_EVENT:
    delete pshell;
    delete console;
    ExitProcess(1);
  default: break;
  }
  return(FALSE);
}

int main(int argc,char *argv[]){
#ifdef _DEBUG
  _CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF | _CRTDBG_DELAY_FREE_MEM_DF);
  //_CrtSetBreakAlloc(119873);
#endif
  console = new win32_console;
  pshell  = new sl_shell(console);
  SetConsoleCtrlHandler((PHANDLER_ROUTINE)cbrk_handler, TRUE);
  if(pshell->initialize(argc,argv)) {
    /***** test code for symbol event callback *****/
    /* symlist_set_var_callback(symlist_var_event_callback); */
    /***** test code for module event callback *****/
    /* module_set_callback(module_event_callback); */
    /* Main loop */
    pshell->shell_main();
  }
  delete pshell;
  delete console;
  return 0;
}
