/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ChildFrm.cpp,v 1.4 2004/08/02 07:15:22 yoshihiko Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "stdafx.h"
#include "win_shell.h"
#include "shell/satellite4.h"

#include "MainFrm.h"
#include "ConsoleDoc.h"
#include "ConsoleView.h"
#include "ChildFrm.h"
#include <direct.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//global definition
extern CConsoleView* g_pConsole;
extern char g_charScriptText[_MAX_PATH];

/////////////////////////////////////////////////////////////////////////////
// CChildFrame

IMPLEMENT_DYNCREATE(CChildFrame, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CChildFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CChildFrame)
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	ON_MESSAGE(ID_SCRIPT_EXE, OnScriptExe)
	ON_MESSAGE(ID_SCRIPT_QUIT, OnScriptQuit)
	ON_MESSAGE(ID_SYMBOL_PASTE, OnSymbolPaste)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChildFrame NX̍\z/

CChildFrame::CChildFrame()
{
	// TODO: oR[ḧʒuɒǉĂB
	m_bScriptRun = FALSE;	
}

CChildFrame::~CChildFrame()
{

}

BOOL CChildFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ̈ʒu CREATESTRUCT cs ̐ݒsāAWindow NX܂
	//       X^CύXĂB
	cs.style &= ~FWS_ADDTOTITLE;

	if( !CMDIChildWnd::PreCreateWindow(cs) )
		return FALSE;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CChildFrame NX̐ff

#ifdef _DEBUG
void CChildFrame::AssertValid() const
{
	CMDIChildWnd::AssertValid();
}

void CChildFrame::Dump(CDumpContext& dc) const
{
	CMDIChildWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CChildFrame NX̃bZ[Wnh

// exitR}h
void CChildFrame::OnAppExit() 
{
	char cmdline[_MAX_PATH];
	strcpy(cmdline, "exit\n");
	int i,ch,len;
	DWORD size;

	//A command is transmitted. 
	len = (int)strlen(cmdline);
	for(i=0; i<len; i++){
		ch = (unsigned char)cmdline[i];
		WriteFile(g_pConsole->m_hStdinW, &ch, sizeof(int), &size, NULL);
	}
}

LRESULT CChildFrame::OnScriptExe(WPARAM wParam, LPARAM lParam)
{
	char pszName[_MAX_PATH],shortName[_MAX_PATH];
	char curdir[_MAX_PATH];
	char drv[16];
	char dir[_MAX_PATH],fname[_MAX_PATH],fext[16];
	char tmpdir[_MAX_PATH];
	char cmdline[_MAX_PATH];
	DWORD size;
	int i,ch,len,cnt;
	CString str;

	/**/
	_getcwd(curdir, _MAX_PATH);
	/*g_charScriptText has a script for performing. */
	strcpy(pszName, g_charScriptText);
	/**/
	_splitpath(pszName, drv,dir,fname,fext);
	dir[strlen(dir)-1] = '\0';
	sprintf(tmpdir,"%s%s",fname,fext);
	if(Access((LPCTSTR)tmpdir,SL_FATTR_FOK) == 0) {
		str = _T(fname);
		str += _T(fext);
	}
	else {
		//It performs on the absolute path. 
		GetShortPathName(pszName, shortName, _MAX_PATH);
		/* \\ is changed into /. */
		str = _T(shortName);
		for(i = 0; i < str.GetLength(); i++) {
			if(str.GetAt(i) == '\\')
				str.SetAt(i, '/');
		}
	}
	//The script to perform is generated. 
	sprintf(cmdline,"inline(\"%s\")\n",str);
	if(wParam == INLINE_MODE) {
		//A command is transmitted. 
		len = (int)strlen(cmdline);
		for(i=0,cnt = 0; i<len; i++){
			ch = (unsigned char)cmdline[i];
			if((ch & 0x80))
				cnt += 1;
			WriteFile(g_pConsole->m_hStdinW, &ch, sizeof(int), &size, NULL);
		}
		// SẴR[h]̂ŁAScripts...
		// ̒lfNgĒ~]
		//A button is controlled. 
		g_pConsole->m_bScriptRun = TRUE;
		g_pConsole->m_charCodeAddr = (int)strlen(cmdline)-cnt-1;
	}
	else {
		//It transmits one character at a time. 
		int	el,ret,*cmdbuf,line = 0;
		char buf[256],msg[_MAX_PATH];
		FILE *fp;
		CString str;

		fp = fopen(g_charScriptText, "r");
		if(!fp)
			return 0L;

		g_pConsole->m_bInputMode = TRUE;
		while(!feof(fp)) {
			if(fgets(buf,256,fp) == NULL)
				break;
			fprintf(stdout,"%s\n",buf);
			if(buf[0] != '#') {
				len = (int)strlen(buf);
				cmdbuf = (int *)malloc(len*sizeof(int)+1);
				for(el = 0; el < len; el++) {
					cmdbuf[el] = (unsigned char)buf[el];
				}
				WriteFile(g_pConsole->m_hStdinW,
					cmdbuf, sizeof(int)*len, &size, NULL);
				free(cmdbuf);
				/*Put message*/
				sprintf(msg,"line:%d\nPlease click the OK button.", line);
				ret = ::MessageBox(NULL,msg, PACKAGE_STRING,
					MB_OKCANCEL | MB_ICONINFORMATION);
				if(ret == IDCANCEL)
					break;
			}
			line++;
		}
		fclose(fp);
		g_pConsole->m_bInputMode = FALSE;
	}

	return 0L;
}

LRESULT CChildFrame::OnScriptQuit(WPARAM wParam, LPARAM lParam)
{
	setsigint_win32();
	g_pConsole->m_bScriptRun = FALSE;
	return 0L;
}

#if 0
void CChildFrame::OnHelpDemo() 
{
	//
	// Demo_CAO
	//
	CDemoDlg dlgDemo(this);
	dlgDemo.DoModal();

}
#endif

void CChildFrame::Run(CString path)
{
	char pszName[_MAX_PATH];
	char curdir[_MAX_PATH];
	char targetpath[_MAX_PATH];
	char drive[16];
	char dir[_MAX_PATH];
	char file[64];
	char ext[16];
	char cmdline[_MAX_PATH];
	int i;
	char ch;

	//st@C
	strcpy(pszName, path);
	//Jg
	_getcwd(curdir, _MAX_PATH);
	_splitpath(pszName, drive, dir, file, ext);
	dir[strlen(dir)-1] = '\0';
	sprintf(targetpath,"%s%s", drive,dir);
	//ύX
	_chdir(targetpath);
	//XNvg쐬
	sprintf(cmdline,"inline(\"%s%s\")\n",file, ext);
	
	for(i=0;i<(int)strlen(cmdline);i++){
		ch = cmdline[i];
		g_pConsole->SendMessage(WM_CHAR,TCHAR(ch),0L);
		if(ch == '\\')
			g_pConsole->SendMessage(WM_CHAR,TCHAR(ch),0L);
	}
}

int CChildFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: ̈ʒuɌŗL̍쐬pR[hǉĂ

	return 0;
}

void CChildFrame::OnDestroy() 
{
	CDocument* pDocument;
	pDocument = GetActiveDocument();
	if(!pDocument)
		return;

	WINDOWPLACEMENT wndpl;
	GetWindowPlacement(&wndpl);

	if(pDocument->IsKindOf(RUNTIME_CLASS(CConsoleDoc))) {
	AfxGetApp()->WriteProfileInt(VERSION,"console_left",wndpl.rcNormalPosition.left);
	AfxGetApp()->WriteProfileInt(VERSION,"console_top",wndpl.rcNormalPosition.top);
	AfxGetApp()->WriteProfileInt(VERSION,"console_right",wndpl.rcNormalPosition.right);
	AfxGetApp()->WriteProfileInt(VERSION,"console_bottom",wndpl.rcNormalPosition.bottom);
	}

	CMDIChildWnd::OnDestroy();
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	
}

LRESULT CChildFrame::OnSymbolPaste(WPARAM wParam, LPARAM lParam)
{
	char cmdline[_MAX_PATH];
	int i,ch,len;
	DWORD size;

	//y[XgpeLXg
	strcpy(cmdline, g_charScriptText);
	
	//A command is transmitted. 
	len = (int)strlen(cmdline);
	for(i=0; i<len; i++){
		ch = (unsigned char)cmdline[i];
		WriteFile(g_pConsole->m_hStdinW, &ch, sizeof(int), &size, NULL);
	}
	//A button is controlled. 
	g_pConsole->m_charCodeAddr = (int)strlen(cmdline);

	return 0L;
}

BOOL CChildFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
#if 0
	CMainFrame* pMainFrame;
	char title[_MAX_PATH];
	pMainFrame = (CMainFrame *)AfxGetMainWnd(); 
	if(pMainFrame->m_nOpenWindow == 0) {
		if (!m_wndDriveSplitter.CreateStatic (this, 1, 2) ||
			!m_wndDriveSplitter.CreateView (0, 1, RUNTIME_CLASS
				(CDriveAttr), CSize (0, 0), pContext) ||
			!m_wndDriveSplitter.CreateView (0, 0, RUNTIME_CLASS (CDriveView),
				CSize (192, 0), pContext))
			return FALSE;
		// set title
		sprintf(title, "FileViewer");
		this->SendMessage(WM_SETTEXT,0,(LPARAM)title);
		return TRUE;
	}
#endif	
	return CMDIChildWnd::OnCreateClient(lpcs, pContext);
}
