/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: CmdCtrl.cpp,v 1.3 2004/08/02 07:15:22 yoshihiko Exp $ */

#include "stdafx.h"
#include "win_shell.h"
#include "CmdCtrl.h"
#include "shell/satellite4.h"

#include "ConsoleDoc.h"
#include "ConsoleView.h"
#include "MainFrm.h"
#include <io.h>
#include <direct.h>
#include ".\cmdctrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Image indexes
#define		ILO_ROOT			0
#define		ILO_MODULE			1
#define		ILO_COMMAND			2
#define		TVIF_DEFAULT	(TVIF_CHILDREN | TVIF_HANDLE | TVIF_IMAGE | TVIF_PARAM | TVIF_SELECTEDIMAGE | TVIF_STATE | TVIF_TEXT)
#define		TVIS_DEFAULT	(TVIS_BOLD | TVIS_CUT | TVIS_DROPHILITED | TVIS_EXPANDED | TVIS_EXPANDEDONCE | TVIS_SELECTED)

//global definition
extern	CConsoleView* g_pConsole;
extern	char g_charScriptText[_MAX_PATH];
extern	void ContextHelp(const char *text, int mode);

/////////////////////////////////////////////////////////////////////////////
// CCmdCtrl

CCmdCtrl::CCmdCtrl()
{
	m_contextFlag = FALSE;
	m_strHelpText = _T("");
	/*The variable for tooltip */
	m_pToolTip = NULL;
	m_hCurItem = NULL;
	m_font = NULL;
}

CCmdCtrl::~CCmdCtrl()
{
	if(m_pToolTip)
		delete m_pToolTip;
	if(m_font != NULL){
		m_font->DeleteObject();
		delete m_font;
	}
}


BEGIN_MESSAGE_MAP(CCmdCtrl, CTreeCtrl)
	//{{AFX_MSG_MAP(CCmdCtrl)
	ON_WM_CREATE()
	ON_NOTIFY_REFLECT(TVN_SELCHANGING, OnSelchanging)
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_CMDVIEW_HELP, OnCmdviewHelp)
	ON_UPDATE_COMMAND_UI(ID_CMDVIEW_HELP, OnUpdateCmdviewHelp)
	//}}AFX_MSG_MAP
	//ON_NOTIFY_EX( TTN_NEEDTEXT, 0, OnToolTipNotify )
//	ON_WM_HELPINFO()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCmdCtrl bZ[W nh

int CCmdCtrl::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeCtrl::OnCreate(lpCreateStruct) == -1)
		return -1;

	// set font
    m_font = new CFont;
    m_font->CreateFont(
    14,                        // nHeight
    0,                         // nWidth
    0,                         // nEscapement
    0,                         // nOrientation
    FW_NORMAL,                 // nWeight
    FALSE,                     // bItalic
    FALSE,                     // bUnderline
    0,                         // cStrikeOut
    SHIFTJIS_CHARSET,          // nCharSet
    OUT_CHARACTER_PRECIS,      // nOutPrecision
    CLIP_DEFAULT_PRECIS,       // nClipPrecision
    DEFAULT_QUALITY,           // nQuality
    FIXED_PITCH | FF_MODERN ,  // nPitchAndFamily
    "lr@o");           // lpszFacename
	this->SetFont( m_font );
#if 0
	int width, autopop;
    m_pToolTip = new CToolTipCtrl;
    if(m_pToolTip->Create(this/*, dwStyle*/)) {
		m_pToolTip->AddTool(this, LPSTR_TEXTCALLBACK );
		m_pToolTip->Activate(TRUE);
		//width = m_pToolTip->SetMaxTipWidth(256);
		autopop = m_pToolTip->GetDelayTime(TTDT_AUTOPOP);
	}
#endif

	/* ImageList is generated. */
    m_ilObjects.Create (IDB_CMDLIST, 16, 1, RGB (255, 0, 255));
    SetImageList (&m_ilObjects, TVSIL_NORMAL);
	// OnCreateł́AinitializełȂ
	//Initialize();

	return 0;
}

void CCmdCtrl::Initialize()
{
	int autopop;

    m_pToolTip = new CToolTipCtrl;
    if(m_pToolTip->Create(this/*, dwStyle*/)) {
		m_pToolTip->AddTool(this, LPSTR_TEXTCALLBACK );
		m_pToolTip->Activate(TRUE);
		//width = m_pToolTip->SetMaxTipWidth(256);
		autopop = m_pToolTip->GetDelayTime(TTDT_AUTOPOP);
	}
	/* ImageList is generated. */
    //m_ilObjects.Create (IDB_CMDLIST, 16, 1, RGB (255, 0, 255));
    //SetImageList (&m_ilObjects, TVSIL_NORMAL);

	/*Processing when opening a window on the way */
	int i,nCount;
	CPtrArray* ptr;
	CMDINFO* pItem;
	char module_name[_MAX_PATH];
	if(g_pConsole) {
		ptr = &(g_pConsole->m_cmdArray);
		nCount = (int)ptr->GetSize();
		for(i = 0; i < nCount; i++) {
			pItem = (CMDINFO*)ptr->GetAt(i);
			if(pItem->node == 0) {
				strcpy(module_name, pItem->strName);
				Module(module_name, ptr);
			}
		}
	}

}

void CCmdCtrl::Module(char *module_name, CPtrArray *pCmdArray)
{
	HTREEITEM hParent;
	hParent = SetModuleName(TVI_ROOT, module_name);
	SetCommandList(hParent, module_name, pCmdArray);
	SortChildren(hParent);
}

HTREEITEM CCmdCtrl::SetModuleName(HTREEITEM hParent, char *name)
{
	HTREEITEM hChild;
    hChild = InsertItem (name, ILO_MODULE, ILO_MODULE, hParent);
	return hChild;
}

BOOL CCmdCtrl::SetCommandList(HTREEITEM hParent, char *module_name, CPtrArray *pCmdArray)
{
	int i,nCount;
	CMDINFO* pItem;

	nCount = (int)pCmdArray->GetSize();
	for(i = 0; i < nCount; i++) {
		pItem = (CMDINFO *)pCmdArray->GetAt(i);
		if(pItem->strParent.Compare(_T(module_name)) == 0) {
			SetCommandName(hParent,pItem);
		}
	}
	return TRUE;
}


HTREEITEM CCmdCtrl::SetCommandName(HTREEITEM hParent, CMDINFO* pItem)
{
	HTREEITEM hChild;
	CString strCmd;

	strCmd = pItem->strName;
	strCmd += _T("(");
	strCmd += pItem->strArgs;
	strCmd += _T(")");
    hChild = InsertItem (strCmd/*pItem->strName*/, ILO_COMMAND,
            ILO_COMMAND, hParent);
	SetItemData(hChild, (DWORD)pItem);

	return hChild;
}

BOOL CCmdCtrl::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CTreeCtrl::PreCreateWindow (cs))
		return FALSE;

    cs.style |= (TVS_HASLINES | TVS_LINESATROOT | TVS_HASBUTTONS |
        TVS_SHOWSELALWAYS | TVS_INFOTIP);
	return TRUE;
}

void CCmdCtrl::OnSelchanging(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	HTREEITEM hItem = (HTREEITEM)pNMTreeView->itemNew.hItem;
	if(!hItem)
		return;

	CString text;
	text = GetItemText(hItem);
	
	if(m_contextFlag) {
		//Help dsiplay
		m_imageHelp.EndDrag();
		m_imageHelp.DeleteImageList();
		m_contextFlag = FALSE;
		ContextHelp( (LPCTSTR)text, PDF_PAGE );
	}

	*pResult = 0;
}

/*The response to a TTN_NEEDTEXT message */
//BOOL CCmdCtrl::OnToolTipNotify( UINT id, NMHDR *pNMHDR, LRESULT *pResult)
BOOL CCmdCtrl::ToolTipNotify(NMHDR *pNMHDR)
{
	TOOLTIPTEXT *pTTT = (TOOLTIPTEXT*)pNMHDR;
	CRect rect;

	HTREEITEM hItem = HitTest(m_curpos);
	if(!hItem)
		return TRUE;
	GetItemRect(hItem, rect, TRUE);
	if(!rect.PtInRect(m_curpos)) {
		return TRUE;
	}

	/*The text of a toolhint is set up. */
	CString name,parent,strMsg;
	int nImage,nSelImage;
	char msg[_MAX_PATH];
	CMDINFO* pItem;

	name = GetItemText(hItem);
	GetItemImage(hItem,nImage,nSelImage);
	if(nImage == ILO_MODULE)
		sprintf(msg, "%s module", name);
	else if(nImage == ILO_COMMAND) {
		/*Tooltip including the argument is displayed. */
		pItem = (CMDINFO*)GetItemData(hItem);
		/*A text domain is acquired. */
		GetItemRect(hItem, &rect, TRUE);
		/*The message displayed from mouse information is acquired. */
		strMsg = GetTooltipMsg(pItem, m_curpos, rect);
		sprintf(msg, "%s", strMsg);
	}
	strcpy(pTTT->szText, msg);

	/*The displayed item is saved. */
	m_hCurItem = hItem;

	//if(m_pToolTip->GetActiveWindow() == NULL) {
	//m_pToolTip->SetActiveWindow();
	//}
	return TRUE;
}

//
// }EXʒupointrectň͂܂ꂽ񂩂c[`bv
// 肷֐
//
CString CCmdCtrl::GetTooltipMsg(CMDINFO* pItem, CPoint point, CRect rect)
{
	CClientDC dc (this);
	//OnPrepareDC (&dc);
	//dc.DPtoLP (&point);

	char msg[_MAX_PATH];
	CSize siz;
	int index,arg,xs,xe,ocx;
	CString strMsg;

	//\CfbNX擾
	index = 0;
	if(pItem->argnum != 0) {
		//ŏ'('܂
		sprintf(msg,"%s(",pItem->strName);
		//`FbN
		siz = dc.GetTextExtent(msg, (int)strlen(msg));
		xs = rect.left;
		xe = xs + siz.cx;
		ocx = siz.cx;
		if(point.x < xs || point.x > xe) {
			//argunum
			xs = xe;
			for(arg = 0; arg < pItem->argnum; arg++) {
				//argԖڂ̈擾
				strMsg = GetArgMsg(arg+1, pItem->strArgs, _T(","));
				strcat(msg, strMsg);
				strcat(msg, ",");
				//`FbN
				siz = dc.GetTextExtent(msg, (int)strlen(msg));
				xe = xs + (siz.cx-ocx);
				ocx = siz.cx;
				if(point.x >= xs && point.x < xe) {
					index = arg + 1;
					break;
				}
				xs = xe;
			}
		}
	}
	//indexŎw肳ꂽmsgԂ悤ɂ
	if(index == 0)
		return pItem->strExplain;
	strMsg = pItem->strMsg[index-1];
	return strMsg;
}

// msgargŎw肳ꂽԖڂ̓eԂ
CString CCmdCtrl::GetArgMsg(int arg, CString msg, char *sdlm)
{
	int pos,i;
	CString strLeft,strRight;

	strLeft = msg;
	strRight = msg;
	for(i = 0; i < arg; i++) {
		pos = strRight.Find(_T(sdlm));
		if(pos == -1) {
			//strRight += _T(")");
			return strRight;
		}
		strLeft = strRight.Left(pos);
		strRight = strRight.Mid(pos+(int)strlen(sdlm));
	}
	//strLeft += _T(",");
	return strLeft;
}


void CCmdCtrl::OnMouseMove(UINT nFlags, CPoint point) 
{
	/*The present mouse position is registered. */
	m_curpos = point;
	CRect rect;

	HTREEITEM hItem = HitTest(m_curpos);
	if(hItem) {
		GetItemRect(hItem, rect, TRUE);
		if(!rect.PtInRect(m_curpos)) {
			if(m_pToolTip)
				m_pToolTip->Pop();
		}
		else if(hItem != m_hCurItem) {
			if(m_pToolTip)
				m_pToolTip->Pop();
		}
	}
	else {
		if(m_pToolTip)
			m_pToolTip->Pop();
	}

	CTreeCtrl::OnMouseMove(nFlags, point);
}

BOOL CCmdCtrl::PreTranslateMessage(MSG* pMsg) 
{
	HTREEITEM hItem;
	CRect rect;
	if(pMsg->message== WM_LBUTTONDOWN ||
        pMsg->message== WM_LBUTTONUP ||
        pMsg->message== WM_MOUSEMOVE) {
		if(m_pToolTip) {
			hItem = HitTest(m_curpos);
			GetItemRect(hItem, rect, TRUE);
			if(rect.PtInRect(m_curpos))
				m_pToolTip->RelayEvent(pMsg);
		}
	}
	
	return CTreeCtrl::PreTranslateMessage(pMsg);
}

void CCmdCtrl::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// HitTests
	HTREEITEM hItem;
	TVHITTESTINFO info;
	int iImg,iSelImg;
	m_strHelpText = _T("");
	info.pt = point;
	hItem = HitTest( &info );
	if( !hItem || info.flags != TVHT_ONITEMLABEL )
		return;

	//I
	SelectItem( hItem );

	//j[
	CMenu menu,*pPopup;
	//get command name
	m_strHelpText = GetItemText(hItem);
	//check
	GetItemImage(hItem, iImg, iSelImg);
	if(iImg == ILO_MODULE)
		return;

	// }EX|C^XN[Wɕϊ
	ClientToScreen( &point );
	// gɃtH[JXݒ
	SetForegroundWindow();
	// |bvAbvj[̍쐬
	// IDR_POPUP_DRIVE̓j[̃\[XID
	menu.LoadMenu( IDR_POPUP_CMDVIEW );
	pPopup = menu.GetSubMenu( 0 );
	// |bvAbvj[\
	pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			point.x, point.y, this);
	// LoadMenuJ
	menu.DestroyMenu();

	//I
	SelectItem( NULL );
	
	CTreeCtrl::OnRButtonDown(nFlags, point);
}

void CCmdCtrl::OnCmdviewHelp() 
{
	CString func;
	int pos;
	pos = m_strHelpText.Find(_T("("));
	if(pos == -1)
		func = m_strHelpText;
	else
		func = m_strHelpText.Left(pos);
	ContextHelp(func, PDF_PAGE);	
	
}

void CCmdCtrl::OnUpdateCmdviewHelp(CCmdUI* pCmdUI) 
{
	if(m_strHelpText.GetLength() > 1)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
	
}

