/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: CodeChg.cpp,v 1.2 2004/08/05 05:41:36 yoshihiko Exp $ */
/////////////////////////////////////////////////////////////////////////////
//	Ӽޭ
//	  CodeChg.cpp
//	A Unix file is changed into a Windows file. 
/////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"

#include "CodeChg.h"

//	萔
char CHAR_CR = '\r';
char CHAR_LF = '\n';

/////////////////////////////////////////////////////////////////////////////
//	CReturnCode::CheckReturnCode
/////////////////////////////////////////////////////////////////////////////
int CReturnCode::CheckReturnCode(std::istream& inStream)
{
	CHAR	first,second;
	int	theReturnCode = RCODE_NO;
	
	inStream.seekg(0);
	while(!inStream.eof())
	{
		//inStream >> std::noskipws >> first;
		inStream >> first;
		if(inStream.eof())
		{
			if(first == CHAR_CR)
				return RCODE_CR;
			else if(first == CHAR_LF)
				return RCODE_LF;
			else
				return RCODE_NO;
		}

		//inStream >> std::noskipws >> second;
		inStream >> second;
		inStream.seekg(-1,std::ios::cur);
		
		if(first == CHAR_CR)
		{
			if(second == CHAR_LF)
				return RCODE_CRLF;
			else
				return RCODE_CR;
		}
		else if(first == CHAR_LF)
		{
			return RCODE_LF;
		}
	}
	return RCODE_NO;
}

// ---------------------------------------------------------------------------
//		 Convert(LStream*,LStream*,SInt32,SInt32)	[static,public]
// ---------------------------------------------------------------------------
//	
bool CReturnCode::Convert(std::istream& inStream,std::ostream& outStream,int nSaveCode)
{
	int nSrcCode = CheckReturnCode(inStream);

	if((nSrcCode == RCODE_NO) || (nSrcCode == nSaveCode))
		return false;

	if(nSrcCode == RCODE_CR)
	{
		if(nSaveCode == RCODE_LF)
			ConvertSS(inStream,outStream,CHAR_CR,CHAR_LF);
		else if(nSaveCode = RCODE_CRLF)
			ConvertSD(inStream,outStream,CHAR_CR,CHAR_CR,CHAR_LF);
	}
	else if(nSrcCode == RCODE_LF)
	{
		if(nSaveCode == RCODE_CR)
			ConvertSS(inStream,outStream,CHAR_LF,CHAR_CR);
		else if(nSaveCode == RCODE_CRLF)
			ConvertSD(inStream,outStream,CHAR_LF,CHAR_CR,CHAR_LF);
	}
	else if(nSrcCode == RCODE_CRLF)
	{
		if(nSaveCode == RCODE_CR)
			ConvertDS(inStream,outStream,CHAR_CR,CHAR_LF,CHAR_CR);
		else if(nSaveCode == RCODE_LF)
			ConvertDS(inStream,outStream,CHAR_CR,CHAR_LF,CHAR_LF);
	}
	return true;
}


/////////////////////////////////////////////////////////////////////////////
//	CReturnCode::CopyBlock
/////////////////////////////////////////////////////////////////////////////
void CReturnCode::CopyBlock(std::istream& inStream, std::ostream& outStream,
						   long nPos, long nBytes, StMemBlock& buf)
{
	if(nBytes > 0)
	{
		if((long)buf.Size() < nBytes)
			buf.Resize(nBytes);
		
		long savedPos = inStream.tellg();
		inStream.seekg(nPos,std::ios::beg);
		inStream.read(buf,nBytes);
		inStream.seekg(savedPos,std::ios::beg);
		outStream.write(buf,nBytes);
	}
}

/////////////////////////////////////////////////////////////////////////////
//	CReturnCode::ConvertSS
/////////////////////////////////////////////////////////////////////////////
void CReturnCode::ConvertSS(std::istream &inStream, std::ostream &outStream, char cSrc, char cDst)
{
	char ch;
	StMemBlock buf;
	long nPos=0;
	long nBytes;

	inStream.seekg(0);
	outStream.flush();
	while(!inStream.eof())
	{
		inStream >> ch;
		if(inStream.eof())
		{
			inStream.clear();
			nBytes = inStream.tellg()-nPos;
			CopyBlock(inStream,outStream,nPos,nBytes,buf);
			break;
		}
		else if(ch == cSrc)
		{
			nBytes = inStream.tellg()-nPos-1L;
			CopyBlock(inStream,outStream,nPos,nBytes,buf);
			outStream << cDst;
			nPos = inStream.tellg();
		}
		
	}
}

/////////////////////////////////////////////////////////////////////////////
//	CReturnCode::ConvertSD
/////////////////////////////////////////////////////////////////////////////
void CReturnCode::ConvertSD(std::istream& inStream,std::ostream& outStream,char cSrc,char cDstF,char cDstS)
{
	char ch;
	StMemBlock buf;
	long nPos=0;
	long nBytes;

	inStream.seekg(0);
	outStream.flush();
	while(!inStream.eof())
	{
		inStream >> ch;
		if(inStream.eof())
		{
			inStream.clear();
			nBytes = inStream.tellg()-nPos;
			CopyBlock(inStream,outStream,nPos,nBytes,buf);
			break;
		}
		else if(ch == cSrc)
		{
			nBytes = inStream.tellg()-nPos-1L;
			CopyBlock(inStream,outStream,nPos,nBytes,buf);
			outStream << cDstF << cDstS;
			nPos = inStream.tellg();
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
//	CReturnCode::ConvertDS
/////////////////////////////////////////////////////////////////////////////
void CReturnCode::ConvertDS(std::istream& inStream,std::ostream& outStream,char cSrcF,char cSrcS,char cDst)
{
	char ch;
	StMemBlock buf;
	long nPos=0;
	long nBytes;

	inStream.seekg(0);
	outStream.flush();
	while(!inStream.eof())
	{
		inStream >> ch;
		if(inStream.eof())
		{
			inStream.clear();
			nBytes = inStream.tellg()-nPos;
			CopyBlock(inStream,outStream,nPos,nBytes,buf);
			break;
		}
		else if((ch == cSrcF) && (inStream.peek() == cSrcS))
		{
			nBytes = inStream.tellg()-nPos-1L;
			CopyBlock(inStream,outStream,nPos,nBytes,buf);
			outStream << cDst;
			inStream.seekg(1,std::ios::cur);
			nPos = inStream.tellg();
		}
	}
}
