/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: CodeChg.h,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */
// ===========================================================================
//	CodeChg.h
//	A Unix file is changed into a Windows file. 
// ===========================================================================

#pragma once

#include <iostream>
#include "CodeChgSub.h"

//	sR[h
const int RCODE_NO = 0;
const int RCODE_CR = 1;
const int RCODE_LF = 2;
const int RCODE_CRLF = 3;

//	NX錾
class CReturnCode {
public:
	//	=== Check Method ===
	static	int	CheckReturnCode(std::istream& inStream);
	//	=== Converting Methods ===
	static	bool	Convert(std::istream& inSourceStream,std::ostream& ioDestStream,int nSaveCode);
protected:
	static void ConvertSS(std::istream& inStream,std::ostream& outStream,char cSrc, char cDst);
	static void ConvertSD(std::istream& inStream,std::ostream& outStream,char cSrc, char cDstF, char cDstS);
	static void ConvertDS(std::istream& inStream,std::ostream& outStream,char cSrcF,char cSrcS, char cDst);
	
private:
	static void CopyBlock(std::istream& inStream, std::ostream& outStream, long nPos, long nBytes, StMemBlock& buf);
};
