/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: CodeView.cpp,v 1.6 2004/08/02 07:15:22 yoshihiko Exp $ */

#include "stdafx.h"
#include "win_shell.h"
#include "shell/satellite4.h"

#include "ConsoleDoc.h"
#include "ConsoleView.h"
#include "DemoView.h"
#include "CodeView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//global definition
extern CConsoleView* g_pConsole;
extern char g_charScriptText[_MAX_PATH];
extern void ContextHelp(const char *text, int mode);

/////////////////////////////////////////////////////////////////////////////
// CCodeView

IMPLEMENT_DYNCREATE(CCodeView, CEditView)

CCodeView::CCodeView()
{
	m_backColor = GetSysColor(COLOR_WINDOW);
	m_textColor = GetSysColor(COLOR_WINDOWTEXT);
	m_hBrBack = ::CreateSolidBrush(m_backColor);
	m_pDemoInfo = NULL;
	m_manual = NULL;
}

CCodeView::~CCodeView()
{
	m_font.DeleteObject();
	::DeleteObject(m_hBrBack);
	if(m_manual)
		delete m_manual;

}


BEGIN_MESSAGE_MAP(CCodeView, CEditView)
	//{{AFX_MSG_MAP(CCodeView)
	ON_WM_CREATE()
	ON_WM_CTLCOLOR_REFLECT()
	ON_COMMAND(ID_SCRIPT_RUN, OnScriptRun)
	ON_UPDATE_COMMAND_UI(ID_SCRIPT_RUN, OnUpdateScriptRun)
	ON_COMMAND(ID_SCRIPT_STOP, OnScriptStop)
	ON_UPDATE_COMMAND_UI(ID_SCRIPT_STOP, OnUpdateScriptStop)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_DEMO_VIEW_README, OnDemoViewReadme)
	ON_UPDATE_COMMAND_UI(ID_DEMO_VIEW_README, OnUpdateDemoViewReadme)
	ON_COMMAND(ID_DEMO_VIEW_SCRIPT, OnDemoViewScript)
	ON_UPDATE_COMMAND_UI(ID_DEMO_VIEW_SCRIPT, OnUpdateDemoViewScript)
	ON_COMMAND(ID_DEMO_VIEW_MODEL, OnDemoViewModel)
	ON_UPDATE_COMMAND_UI(ID_DEMO_VIEW_MODEL, OnUpdateDemoViewModel)
	ON_COMMAND(ID_DEMO_VIEW_STEP, OnDemoViewStep)
	ON_COMMAND(ID_DEMO_VIEW_INLINE, OnDemoViewInline)
	ON_COMMAND(ID_DEMO_MANUAL, OnDemoManual)
	ON_UPDATE_COMMAND_UI(ID_DEMO_MANUAL, OnUpdateDemoManual)
	//}}AFX_MSG_MAP
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_LINE, OnUpdateLineNumber)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCodeView `

void CCodeView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: ̈ʒuɕ`p̃R[hǉĂ
}

/////////////////////////////////////////////////////////////////////////////
// CCodeView ff

#ifdef _DEBUG
void CCodeView::AssertValid() const
{
	CEditView::AssertValid();
}

void CCodeView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCodeView bZ[W nh

void CCodeView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	CDemoInfo* pDemoInfo;

	if(!pHint)
		return;
	pDemoInfo = (CDemoInfo*) pHint;
    if (lHint == 0x5C || lHint == 0x5D/*Magic number*/) {
		/*All screens are eliminated. */
		/*AllClear();*/
		//ݒ
		m_pDemoInfo = pHint;
		/*The contents of a file are displayed. */
		if(lHint == 0x5C)
			Display(pDemoInfo);		// Script
		else
			Display(pDemoInfo);		// Readme
		/*Since OpenTopics deleted, a button has no necessity.*/
#if 0
		if(pDemoInfo->exemode == CONSOLE_MODE)
			SetManualButton();
		else {
			if(m_manual) {
				delete m_manual;
				m_manual = NULL;
			}
		}
#endif
	}
#if 0
	else if (lHint == 0x5E) {
		/*When the demonstration is changed*/
		Save(pDemoInfo);
	}
#endif

}

void CCodeView::SetManualButton()
{
	int x,y;
	x=224;		//̒ĺAKɐݒ肵
	y=20;
	if(m_manual)
		delete m_manual;
	m_manual = new CButton;
	m_manual->Create(_T("Open topics"), WS_VISIBLE | BS_PUSHBUTTON | WS_TABSTOP,
				CRect(x, y, x+128, y+24), this, ID_DEMO_MANUAL);
	m_manual->SetFont(&m_font);
}

/*The contents of a file are displayed. */
void CCodeView::Display(CDemoInfo* pDemoInfo)
{
	char pathname[_MAX_PATH];
	char strFile[_MAX_PATH];
	CString szScript;
	CString szCmd;
	const char* tmpdir;

	/*The path to examples is acquired. */
	tmpdir = get_tmpdir();
	if(!tmpdir)
		return;
	sprintf(pathname, "%s/examples/", tmpdir);
	/*The path of a script is acquired. */
	if(pDemoInfo->exefg == FILE_TXT) {
		strcat(pathname, pDemoInfo->readme);
	}
	else if(pDemoInfo->exefg == FILE_SL) {
		strcat(pathname, pDemoInfo->script);
	}
	else {
		strcat(pathname, pDemoInfo->model);
	}

	/*CR-LF conversion is performed. */
	if(((CShellApp*)AfxGetApp())->TranslateReturnCode(pathname, strFile)) {
		//successful
		if(::CopyFile(strFile, pathname, FALSE)) {
			//succesful
		}
	}

	CFile theFile;
	theFile.Open(pathname, CFile::modeRead);
	CArchive archive(&theFile, CArchive::load);

	this->SerializeRaw(archive);

	archive.Close();
	theFile.Close();
}

void CCodeView::Print(const char *str)
{
	CString strout;

	strout = _T(str);
	strout += _T("\r\n");
	GetEditCtrl().SetSel(-1, -1);
	GetEditCtrl().ReplaceSel(strout);
}

void CCodeView::AllClear()
{
	GetEditCtrl().SetReadOnly(FALSE);
	GetEditCtrl().SetSel(0, -1);
	GetEditCtrl().Clear();
	GetEditCtrl().SetReadOnly(TRUE);
}

int CCodeView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CEditView::OnCreate(lpCreateStruct) == -1)
		return -1;

	// Set font
	m_font.CreateFont(14,
		0,0,0,FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,
		CLIP_DEFAULT_PRECIS/*OUT_STROKE_PRECIS*/,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
		/*DEFAULT_PITCH*/FIXED_PITCH,_T("lr@o"));
	this->SetFont( &m_font );

	//	Set margins
	GetEditCtrl() .SetMargins(LEFT_MARGIN, RIGHT_MARGIN);
	//	Read Only
	GetEditCtrl() .SetReadOnly(TRUE);

	return 0;
}

BOOL CCodeView::PreCreateWindow(CREATESTRUCT& cs) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
    //cs.style |= ES_READONLY;
	
	return CEditView::PreCreateWindow(cs);
}

HBRUSH CCodeView::CtlColor(CDC* pDC, UINT nCtlColor) 
{
	// TODO: ̈ʒu DC ̃Agr[gύXĂ
	pDC->SetTextColor(m_textColor);	//OiF̕ύX
	pDC->SetBkColor(m_backColor);	//wiF̕ύX
	return m_hBrBack;		//wiuVԂ
	
	// TODO: enhĂяoȂꍇ͂ŃuṼnhƂ NULL ȊOԂ悤ɂĂ
	//return NULL;
}

void CCodeView::OnScriptRun() 
{
	if(!m_pDemoInfo)
		return;
	char pathname[_MAX_PATH];
	CDemoInfo* pDemoInfo = (CDemoInfo *)m_pDemoInfo;
	const char* tmpdir;

	//if(GetModuleDirectory(modulepath,_MAX_PATH) == 0)
	tmpdir = get_tmpdir();
	if(!tmpdir)
		return;
	/*The script of a path is set up absolutely. */ 
	sprintf(pathname, "%s/examples/", tmpdir);
	strcat(pathname, pDemoInfo->script);
	strcpy(g_charScriptText, pathname);
	this->GetParentFrame()->PostMessage(ID_SCRIPT_EXE, pDemoInfo->exemode, 0L);
	/* Activate console */
	g_pConsole->SetFocus();	
}

void CCodeView::OnUpdateScriptRun(CCmdUI* pCmdUI) 
{
	if(!m_pDemoInfo) {
		pCmdUI->Enable(FALSE);
		return;
	}
	CDemoInfo* pDemoInfo = (CDemoInfo *)m_pDemoInfo;
	if(pDemoInfo->exefg != FILE_SL)
		pCmdUI->Enable(FALSE);
	else {
		if(g_pConsole->m_bScriptRun)
			pCmdUI->Enable(FALSE);
		else
			pCmdUI->Enable(TRUE);
	}
	
}

void CCodeView::OnScriptStop() 
{
	this->GetParentFrame()->PostMessage(ID_SCRIPT_QUIT, 0, 0L);
	
}

void CCodeView::OnUpdateScriptStop(CCmdUI* pCmdUI) 
{
	if(!m_pDemoInfo) {
		pCmdUI->Enable(FALSE);
		return;
	}
	if(g_pConsole->m_bScriptRun)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
	
}

void CCodeView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CMenu menu,*pPopup;

	// }EX|C^XN[Wɕϊ
	ClientToScreen( &point );
	// gɃtH[JXݒ
	SetForegroundWindow();
	// |bvAbvj[̍쐬
	// IDR_POPUP_DRIVE̓j[̃\[XID
	menu.LoadMenu( IDR_POPUP_DEMO_VIEW );
	/*The state of the popup menu is set up. */
	CDemoInfo* pDemoInfo = (CDemoInfo *)m_pDemoInfo;
	if(pDemoInfo->readme.GetLength() == 0)
		menu.EnableMenuItem(ID_DEMO_VIEW_README, MF_GRAYED);
	else {
		if(pDemoInfo->exefg == FILE_TXT)
			menu.CheckMenuItem(ID_DEMO_VIEW_README,MF_CHECKED);
	}
	if(pDemoInfo->script.GetLength() == 0)
		menu.EnableMenuItem(ID_DEMO_VIEW_SCRIPT, MF_GRAYED);
	else {
		if(pDemoInfo->exefg == FILE_SL)
			menu.CheckMenuItem(ID_DEMO_VIEW_SCRIPT,MF_CHECKED);
	}
	if(pDemoInfo->model.GetLength() == 0)
		menu.EnableMenuItem(ID_DEMO_VIEW_MODEL, MF_GRAYED);
	else {
		if(pDemoInfo->exefg == FILE_MDL)
			menu.CheckMenuItem(ID_DEMO_VIEW_MODEL,MF_CHECKED);
	}
	if(pDemoInfo->exefg != FILE_SL) {
		menu.EnableMenuItem(ID_DEMO_VIEW_STEP, MF_GRAYED);
		menu.EnableMenuItem(ID_DEMO_VIEW_INLINE, MF_GRAYED);
	}
	else {
		if(pDemoInfo->exemode == INLINE_MODE)
			menu.CheckMenuItem(ID_DEMO_VIEW_INLINE,MF_CHECKED);
		else
			menu.CheckMenuItem(ID_DEMO_VIEW_STEP,MF_CHECKED);
	}
	if(pDemoInfo->page == 0) {
		menu.EnableMenuItem(ID_DEMO_MANUAL, MF_GRAYED);
	}

	pPopup = menu.GetSubMenu( 0 );
	// |bvAbvj[\
	pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			point.x, point.y, this);
	// LoadMenuJ
	menu.DestroyMenu();
	
	CEditView::OnRButtonDown(nFlags, point);
}

void CCodeView::OnDemoViewReadme() 
{
	CDemoInfo* pDemoInfo = (CDemoInfo *)m_pDemoInfo;
	if(pDemoInfo->exefg != FILE_TXT) {
		pDemoInfo->exefg = FILE_TXT;
		Display(pDemoInfo);
	}	
}

void CCodeView::OnUpdateDemoViewReadme(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
}

void CCodeView::OnDemoViewScript() 
{
	CDemoInfo* pDemoInfo = (CDemoInfo *)m_pDemoInfo;
	if(pDemoInfo->exefg != FILE_SL) {
		pDemoInfo->exefg = FILE_SL;
		Display(pDemoInfo);
	}	
}

void CCodeView::OnUpdateDemoViewScript(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CCodeView::OnDemoViewModel() 
{
	CDemoInfo* pDemoInfo = (CDemoInfo *)m_pDemoInfo;
	if(pDemoInfo->exefg != FILE_MDL) {
		pDemoInfo->exefg = FILE_MDL;
		Display(pDemoInfo);
	}		
}

void CCodeView::OnUpdateDemoViewModel(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CCodeView::OnDemoViewStep() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	CDemoInfo* pDemoInfo = (CDemoInfo *)m_pDemoInfo;
	pDemoInfo->exemode = CONSOLE_MODE;
	
}

void CCodeView::OnDemoViewInline() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	CDemoInfo* pDemoInfo = (CDemoInfo *)m_pDemoInfo;
	pDemoInfo->exemode = INLINE_MODE;
	
}

void CCodeView::OnDemoManual() 
{
	//PDF_TEXT̏ꍇA{ƂȂ
	char page[16];
	sprintf(page,"%d",((CDemoInfo*)m_pDemoInfo)->page);
	ContextHelp(page, PDF_TEXT);	
	
}

void CCodeView::OnUpdateDemoManual(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CCodeView::OnUpdateLineNumber(CCmdUI* pCmdUI)
{
    int nLine = GetEditCtrl().LineIndex(-1);

    CString string;
    string.Format (_T ("Line %d"), nLine);
    pCmdUI->Enable (TRUE);
    pCmdUI->SetText (string);
}

