/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: CodeView.h,v 1.2 2004/05/18 08:05:22 yoshihiko Exp $ */
#if !defined(AFX_CODEVIEW_H__1A8F8E29_BDB6_40EF_98CF_E7C0FED524BE__INCLUDED_)
#define AFX_CODEVIEW_H__1A8F8E29_BDB6_40EF_98CF_E7C0FED524BE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CCodeView r[

class CCodeView : public CEditView
{
protected:
	CCodeView();           // IɎgpveNg RXgN^
	DECLARE_DYNCREATE(CCodeView)

// Agr[g
public:
	CFont m_font;
	HBRUSH		m_hBrBack;
	COLORREF	m_backColor;
	COLORREF	m_textColor;
	CObject* m_pDemoInfo;
	CButton*	m_manual;


// Iy[V
public:
	void	Display(CDemoInfo* pItem);
	void	Print(const char *str);
	void	AllClear();
	void	SetManualButton();
	//void	Save(CString filename);

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B

	//{{AFX_VIRTUAL(CCodeView)
	protected:
	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Cve[V
protected:
	virtual ~CCodeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(CCodeView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
	afx_msg void OnScriptRun();
	afx_msg void OnUpdateScriptRun(CCmdUI* pCmdUI);
	afx_msg void OnScriptStop();
	afx_msg void OnUpdateScriptStop(CCmdUI* pCmdUI);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnDemoViewReadme();
	afx_msg void OnUpdateDemoViewReadme(CCmdUI* pCmdUI);
	afx_msg void OnDemoViewScript();
	afx_msg void OnUpdateDemoViewScript(CCmdUI* pCmdUI);
	afx_msg void OnDemoViewModel();
	afx_msg void OnUpdateDemoViewModel(CCmdUI* pCmdUI);
	afx_msg void OnDemoViewStep();
	afx_msg void OnDemoViewInline();
	afx_msg void OnDemoManual();
	afx_msg void OnUpdateDemoManual(CCmdUI* pCmdUI);
	//}}AFX_MSG
    afx_msg void OnUpdateLineNumber (CCmdUI* pCmdUI);
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_CODEVIEW_H__1A8F8E29_BDB6_40EF_98CF_E7C0FED524BE__INCLUDED_)
