/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ComView.cpp,v 1.3 2004/06/15 04:37:49 yoshihiko Exp $ */

#include "stdafx.h"
#include "win_shell.h"
#include "shell/satellite4.h"

#include "ComDoc.h"
#include "ComView.h"
#include "ConsoleDoc.h"
#include "ConsoleView.h"
#include "MainFrm.h"
#include <io.h>
#include <direct.h>
#include ".\comview.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//global definition
extern	CConsoleView* g_pConsole;
extern char g_charScriptText[_MAX_PATH];

/////////////////////////////////////////////////////////////////////////////
// CComView

IMPLEMENT_DYNCREATE(CComView, CEditView)

BEGIN_MESSAGE_MAP(CComView, CEditView)
	//{{AFX_MSG_MAP(CComView)
	ON_WM_CREATE()
	ON_COMMAND(ID_SCRIPT_RUN, OnScriptRun)
	ON_UPDATE_COMMAND_UI(ID_SCRIPT_RUN, OnUpdateScriptRun)
	ON_COMMAND(ID_SCRIPT_STOP, OnScriptStop)
	ON_UPDATE_COMMAND_UI(ID_SCRIPT_STOP, OnUpdateScriptStop)
	ON_UPDATE_COMMAND_UI(ID_WIN_SIGMA, OnUpdateWinSigma)
	ON_COMMAND(ID_WIN_SIGMA, OnWinSigma)
	//}}AFX_MSG_MAP
// WR}h
	ON_COMMAND(ID_FILE_PRINT, CEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CEditView::OnFilePrintPreview)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_LINE, OnUpdateLineNumber)
	ON_UPDATE_COMMAND_UI(ID_CONSOLE, OnUpdateConsole)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CComView NX̍\z/

CComView::CComView()
{
	// TODO: ̏ꏊɍ\zp̃R[hǉĂB
	m_bDocModified = FALSE;
}

CComView::~CComView()
{
}

BOOL CComView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB

	BOOL bPreCreated = CEditView::PreCreateWindow(cs);
	cs.style &= ~(ES_AUTOHSCROLL|WS_HSCROLL);	// [h bvgp\ɂ܂

	return bPreCreated;
}

/////////////////////////////////////////////////////////////////////////////
// CComView NX̕`

void CComView::OnDraw(CDC* pDC)
{
	CComDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: ̏ꏊɃlCeBu f[^p̕`R[hǉ܂B
}

/////////////////////////////////////////////////////////////////////////////
// CComView NẌ

BOOL CComView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// ftHg CEditView ̈
	return CEditView::OnPreparePrinting(pInfo);
}

void CComView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// ftHg CEditView ňJn܂B
	CEditView::OnBeginPrinting(pDC, pInfo);
}

void CComView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// ftHg CEditView ̈̌㏈
	CEditView::OnEndPrinting(pDC, pInfo);
}

/////////////////////////////////////////////////////////////////////////////
// CComView NX̐ff

#ifdef _DEBUG
void CComView::AssertValid() const
{
	CEditView::AssertValid();
}

void CComView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}

CComDoc* CComView::GetDocument() // fobO o[W̓CCłB
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CComDoc)));
	return (CComDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CComView NX̃bZ[W nh

void CComView::OnInitialUpdate() 
{
	CEditView::OnInitialUpdate();
	
	// set title
	char title[_MAX_PATH];
	CComDoc* pDoc = GetDocument();
	strcpy(title, pDoc->GetPathName/*GetTitle*/());
	if(_access(title,0)== -1) {
		strcpy(title, "null");
		pDoc->SetTitle(title);
	}
	this->GetParent()->SendMessage(WM_SETTEXT,0,(LPARAM)title);
}

int CComView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CEditView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// Change icon
	HICON hIcon = AfxGetApp()->LoadIcon(IDI_SCRIPT);
	ASSERT(hIcon);
	this->GetParent()->SendMessage(WM_SETICON, TRUE, (LPARAM)hIcon);
	//	Set margins
	GetEditCtrl() .SetMargins(LEFT_MARGIN, RIGHT_MARGIN);
	
	return 0;
}

void CComView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	CComDoc* pDoc = GetDocument();
	CString pszName;
	if (lHint == 0x70) {
		//ۑ
		pszName = _T((LPCTSTR)pHint);
		Save(pszName);
		pDoc->SetPathName(pszName);
		//OύX
		char pathname[_MAX_PATH];
		char fname[64],fext[16];
		char title[_MAX_PATH];

		strcpy(pathname, pszName);
		_splitpath(pathname, NULL, NULL, fname, fext);
		sprintf(title,"%s%s", fname, fext);
		pDoc->SetTitle(title);
		this->GetParent()->SendMessage(WM_SETTEXT,0,(LPARAM)title);

	}
}

//\e̕ۑ
void CComView::Save(CString filename)
{
	int		i,linenum,length;
	FILE*	fp;
	char	linebuf[256];

	linenum = GetEditCtrl().GetLineCount();
	if(linenum > 1) {
		if((fp = fopen(filename, "w")) == NULL) {
			AfxMessageBox("Open error.",MB_OK,NULL);
		}
		else {
			for(i = 0; i < linenum-1; i++) {
				length = GetEditCtrl().GetLine(i,linebuf,256);
				linebuf[length] = '\0';
				fprintf(fp,"%s\n",linebuf);
			}
			fclose(fp);
		}
	}
}

void CComView::OnScriptRun() 
{
	//sls
	CComDoc* pDoc = GetDocument();
	CString pszName = pDoc->GetPathName();
	if(pDoc->IsModified()) {
		Save( pszName );
		pDoc->SetModifiedFlag(FALSE);
	}
	// ChildFrameŎs
	strcpy(g_charScriptText, pszName);
	this->GetParent()->PostMessage(ID_SCRIPT_EXE, 0, 0L);
}

void CComView::OnUpdateScriptRun(CCmdUI* pCmdUI) 
{
	//slt@CȂs{^L
	CComDoc* pDoc = GetDocument();
	CString pszName = pDoc->GetTitle();
	if(pszName.Find(".sl") == -1)
		pCmdUI->Enable(FALSE);
	else {
		if(g_pConsole->m_bScriptRun)
			pCmdUI->Enable(FALSE);
		else
			pCmdUI->Enable(TRUE);
	}

	//
	char title[_MAX_PATH];
	if(pDoc->IsModified()) {	//ύX
		if(!m_bDocModified) {
			//^CgύX
			strcpy(title, pDoc->GetTitle());
			strcat(title, " *");
			this->GetParent()->SendMessage(WM_SETTEXT,0,(LPARAM)title);
			m_bDocModified = TRUE;
		}
	}
	else {
		if(m_bDocModified) {
			strcpy(title, pDoc->GetTitle());
			this->GetParent()->SendMessage(WM_SETTEXT,0,(LPARAM)title);
			m_bDocModified = FALSE;
		}
	}
}

void CComView::OnUpdateLineNumber(CCmdUI* pCmdUI)
{
    int nLine = GetEditCtrl ().LineFromChar (-1) + 1;

    CString string;
    string.Format (_T ("Line %d"), nLine);
    pCmdUI->Enable (TRUE);
    pCmdUI->SetText (string);
}

void CComView::OnScriptStop() 
{
	// IR[h
	// ChildFrameŎs
	this->GetParent()->PostMessage(ID_SCRIPT_QUIT, 0, 0L);
	
}

void CComView::OnUpdateScriptStop(CCmdUI* pCmdUI) 
{
	// et[
	// ChildFrameŎs
	if(g_pConsole->m_bScriptRun)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
	
}

void CComView::OnUpdateWinSigma(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	//if(g_pConsole->m_bExtendSigma)
	if(((CMainFrame *)AfxGetMainWnd())->m_bShowToolbar)
		pCmdUI->SetCheck(0);
	else
		pCmdUI->SetCheck(1);
	
}

void CComView::OnWinSigma() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	g_pConsole->OpenWinSigma();	
}

void CComView::OnUpdateConsole(CCmdUI *pCmdUI)
{
	// ɊJĂ̂
	pCmdUI->Enable(FALSE);	
}
