/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ConsoleDoc.cpp,v 1.5 2004/08/05 05:41:36 yoshihiko Exp $ */

#include "stdafx.h"
#include "win_shell.h"
#include "shell/satellite4.h"

#include "ConsoleDoc.h"
#include "ConsoleView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConsoleDoc

IMPLEMENT_DYNCREATE(CConsoleDoc, CDocument)

CConsoleDoc::CConsoleDoc()
{
	// 
	m_RealSize = CSize(0,0)/*.SetSize(0,0)*/;
	m_LogicalSize = CSize(0,0)/*.SetSize(0,0)*/;
	m_TextBuffer   = NULL;
	m_TextAttrib   = NULL;
	m_TextInfo     = NULL;
	m_sCopyArea = CPoint(0,0)/*.SetPoint(0,0)*/;
	m_eCopyArea = CPoint(0,0)/*.SetPoint(0,0)*/;
	// text buffer
	m_textAddr = 0;
	for(int i=0; i < MAX_CONSOLE_SIZE; i++)
		m_textBuffer[i] = _T("");
	// valuable database
	int nCount = (int)m_varArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (VARINFO*) m_varArray.GetAt (i);
		m_varArray.RemoveAll();
	}
	// OnSizeŎgp
	m_SaveRealSize = CSize(0,0)/*.SetSize(0,0)*/;
	m_SaveLogicalSize = CSize(0,0)/*.SetSize(0,0)*/;
	m_SaveTextBuffer   = NULL;
	m_SaveTextAttrib   = NULL;
}

//BOOL CConsoleDoc::OnNewDocument()
//{
//	if (!CDocument::OnNewDocument())
//		return FALSE;
//	return TRUE;
//}

CConsoleDoc::~CConsoleDoc()
{
	FreeTextBuffer();
	int nCount = (int)m_varArray.GetSize();
	if(nCount > 0) {
		for (int i=0; i<nCount; i++)
			delete (VARINFO*) m_varArray.GetAt (i);
		m_varArray.RemoveAll();
	}
}


BEGIN_MESSAGE_MAP(CConsoleDoc, CDocument)
	//{{AFX_MSG_MAP(CConsoleDoc)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConsoleDoc ff

#ifdef _DEBUG
void CConsoleDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CConsoleDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CConsoleDoc VACY

BOOL CConsoleDoc::AllocateTextBuffer(int x, int y)
{
  int i,j;
  /* set current status */
  m_RealSize = CSize(x,y)/*.SetSize(x,y)*/;
  m_LogicalSize = CSize(x,y)/*.SetSize(x,y)*/;

  /* memory allocation */
  m_TextBuffer = (char**)malloc(sizeof(char*)*y);
  if(m_TextBuffer == NULL) goto fatal;
  memset(m_TextBuffer,0,sizeof(char*)*y);

  m_TextAttrib = (int**)malloc(sizeof(int*)*y);
  if(m_TextAttrib == NULL) goto fatal;
  memset(m_TextAttrib,0,sizeof(int*)*y);

  m_TextInfo = (int*)malloc(sizeof(int)*y);
  if(m_TextInfo == NULL) goto fatal;

  for(i=0; i<y; i++){
    m_TextBuffer[i] = (char*)malloc(sizeof(char)*256/*x*/);
    if(m_TextBuffer[i] == NULL) goto fatal;

    m_TextAttrib[i] = (int*)malloc(sizeof(int)*256/*x*/);
    if(m_TextAttrib[i] == NULL) goto fatal;

    for(j=0; j<256/*x*/; j++){
      m_TextBuffer[i][j]=' ';
      m_TextAttrib[i][j]=TEXT_ATTRIBUTE_NORMAL;
    }
	m_TextInfo[i] = FALSE;
  }
  return TRUE;

fatal:
  FreeTextBuffer();
  return FALSE;
}


void CConsoleDoc::FreeTextBuffer()
{
  int i,len;
  CString str;
  if(m_TextBuffer){
    for(i=0; i<m_RealSize.cy; i++)
		if(m_TextBuffer[i]) {
			str = _T(m_TextBuffer[i]);
			len = str.GetLength();
			free(m_TextBuffer[i]);
		}
    free(m_TextBuffer);
  }
  if(m_TextAttrib){
    for(i=0; i<m_RealSize.cy; i++)
      if(m_TextAttrib[i]) free(m_TextAttrib[i]);
    free(m_TextAttrib);
  }
  if(m_TextInfo){
    free(m_TextInfo);
  }
  m_TextAttrib   = NULL;
  m_TextBuffer   = NULL;
  m_TextInfo = NULL;
  m_RealSize = CSize(0,0)/*.SetSize(0,0)*/;
  m_LogicalSize = CSize(0,0)/*.SetSize(0,0)*/;
  m_sCopyArea = CPoint(0,0)/*.SetPoint(0,0)*/;
  m_eCopyArea = CPoint(0,0)/*.SetPoint(0,0)*/;
}

BOOL CConsoleDoc::InitializeTextBuffer(int xinit, int maxline)
{
  /* check arguments */
  if(xinit <= 0 || maxline <= 0) return FALSE;
  FreeTextBuffer();
  return AllocateTextBuffer(xinit,maxline);
}


BOOL CConsoleDoc::ResizeTextBuffer(int x, int y)
{
  int i,j,n;
  CSize pre;
 
  if(y > m_RealSize.cy) return FALSE;

  pre = CSize(m_LogicalSize.cx, m_LogicalSize.cy)/*.SetSize(m_LogicalSize.cx, m_LogicalSize.cy)*/;
  m_LogicalSize = CSize(x,y)/*.SetSize(x,y)*/;

  /* resize buffer length */
  if(x > m_RealSize.cx){
    char *buff;
    int  *attr;
    for(i=0; i<m_RealSize.cy; i++){
      buff = (char*)realloc(m_TextBuffer[i], sizeof(char)*x);
      if(buff == NULL) return FALSE;
      m_TextBuffer[i] = buff;
      attr = (int*)realloc(m_TextAttrib[i], sizeof(int)*x);
      if(attr == NULL) return FALSE;
      m_TextAttrib[i] = attr;
      for(j=m_RealSize.cx; j<x; j++){
        m_TextBuffer[i][j] = ' ';
        m_TextAttrib[i][j] = TEXT_ATTRIBUTE_NORMAL;
      }
    }
    m_RealSize.cx = x;
  }

  /* clear resized memory area */
  n = max(pre.cy, m_LogicalSize.cy);
  for(i=m_LogicalSize.cx; i<pre.cx; i++){
    for(j=0; j<n; j++){
      m_TextBuffer[j][i] = ' ';
      m_TextAttrib[j][i] = TEXT_ATTRIBUTE_NORMAL;
    }
  }
  n = max(pre.cx, m_LogicalSize.cx);
  for(i=m_LogicalSize.cy; i<pre.cy; i++){
    for(j=0; j<n; j++){
      m_TextBuffer[i][j] = ' ';
      m_TextAttrib[i][j] = TEXT_ATTRIBUTE_NORMAL;
    }
  }

  return TRUE;
}

BOOL CConsoleDoc::ScrollTextBuffer(bool dir)
{
  int i;
  char *buff;
  int  *attr;
  if(m_RealSize.cy == 0) return FALSE;
  if(m_RealSize.cy == 1) return TRUE;
  if(dir){
    /* backup first buffer */
    buff = m_TextBuffer[0];
    attr = m_TextAttrib[0];
    /* clear oldest line buffer */
    for(i=0; i<m_RealSize.cx; i++){
      buff[i] = ' ';
      attr[i] = TEXT_ATTRIBUTE_NORMAL;
    }
    for(i=1; i<m_RealSize.cy; i++){
      m_TextBuffer[i-1] = m_TextBuffer[i];
      m_TextAttrib[i-1] = m_TextAttrib[i];
    }
    m_TextBuffer[m_RealSize.cy-1] = buff;
    m_TextAttrib[m_RealSize.cy-1] = attr;
  }else{
    buff = m_TextBuffer[m_RealSize.cy-1];
    attr = m_TextAttrib[m_RealSize.cy-1];
    /* clear oldest line buffer */
    for(i=0; i<m_RealSize.cx; i++){
      buff[i] = ' ';
      attr[i] = TEXT_ATTRIBUTE_NORMAL;
    }
    for(i=m_RealSize.cy-1; i>0; i--){
      m_TextBuffer[i] = m_TextBuffer[i-1];
      m_TextAttrib[i] = m_TextAttrib[i-1];
    }
    m_TextBuffer[0] = buff;
    m_TextAttrib[0] = attr;
  }
  return TRUE;
}

BOOL CConsoleDoc::SaveTextBuffer(int xpos, int ypos, int attr, const char *str, size_t len)
{
  size_t i,tail;
  tail = xpos + len;
  if(tail > (size_t)m_LogicalSize.cx || ypos > m_LogicalSize.cy) return FALSE;
  for(i=xpos; i<tail; i++){
    m_TextBuffer[ypos][i] = str[i-xpos];
    m_TextAttrib[ypos][i] = attr;
  }
  return TRUE;
}

void CConsoleDoc::ClearSelectedBuffer()
{
  int i,j;
  for(i=0; i<m_RealSize.cy; i++){
    for(j=0; j<m_RealSize.cx; j++)
      m_TextAttrib[i][j] &= ~TEXT_ATTRIBUTE_SELECT;
  }
  m_sCopyArea.x = 0;
  m_sCopyArea.y = 0;
  m_eCopyArea.x = 0;
  m_eCopyArea.y = 0;
}


BOOL CConsoleDoc::SelectTextBuffer(int xs, int ys, int xe, int ye)
{
  int i,j,tmp;
  if(xs < 0 ) xs = 0;
  if(xe < 0 ) xe = 0;
  if(ys < 0 ) ys = 0;
  if(ye < 0 ) ye = 0;

  /* swap y pos and x pos */
  if(ys > ye){
    tmp = ye; ye = ys; ys = tmp;
    tmp = xe; xe = xs; xs = tmp;
  }else if(ys == ye && xe > xe){
    tmp = xe; xe = xs; xs = tmp;
  }

  /* check buffer size */
  if(ye >= m_LogicalSize.cy) ye = m_LogicalSize.cy - 1;
  if(xe >  m_LogicalSize.cx) xe = m_LogicalSize.cx;

  if(ys == ye && xs == xe) return TRUE;

  m_sCopyArea.x = xs;
  m_sCopyArea.y = ys;
  m_eCopyArea.x = xe;
  m_eCopyArea.y = ye;

  /* first line */
  if(ys == ye) tmp = xe;
  else         tmp = m_LogicalSize.cx;
  for(i=xs; i<tmp; i++){
    m_TextAttrib[ys][i] |= TEXT_ATTRIBUTE_SELECT;
  }
  /* middle line */
  for(i=ys+1; i<ye; i++){
    for(j=0; j<m_LogicalSize.cx; j++){
      m_TextAttrib[i][j] |= TEXT_ATTRIBUTE_SELECT;
    }
  }
  /* last line */
  if(ys != ye){
    for(i=0; i<xe; i++){
      m_TextAttrib[ye][i] |= TEXT_ATTRIBUTE_SELECT;
    }
  }
  return TRUE;
}

const char *CConsoleDoc::GetTextBuffer(int xp, int yp)
{
  if(xp >= m_LogicalSize.cx || yp >= m_LogicalSize.cy)
  //if(xp > m_LogicalSize.cx || yp > m_LogicalSize.cy)
    return NULL;
  return &m_TextBuffer[yp][xp];
}

int CConsoleDoc::GetTextAttribute(int xp, int yp)
{
  if(xp  >= m_LogicalSize.cx || yp >= m_LogicalSize.cy)
    return -1;
  return m_TextAttrib[yp][xp];
}

BOOL CConsoleDoc::SetTextBufferToClipboard()
{
  int i,j,tmp;
  SIZE_T len;
  COleDataSource *pData;
  HGLOBAL hData;
  char *ptr;

  /* check has selected area */
  if(m_sCopyArea == m_eCopyArea) return FALSE;

  /* count up coping data */
  len = 0;
  /* first line */
  if(m_sCopyArea.y == m_eCopyArea.y) tmp = m_eCopyArea.x;
  else                               tmp = m_RealSize.cx;
  for(i=m_sCopyArea.x; i<tmp; i++){
    len ++;
    if(m_TextBuffer[m_sCopyArea.y][i] == '\n'){
      break;
    }
  }
  /* middle line */
  for(i=m_sCopyArea.y+1; i<m_eCopyArea.y; i++){
    for(j=0; j<m_LogicalSize.cx; j++){
      len ++;
      if(m_TextBuffer[i][j] == '\n'){
        break;
      }
    }
  }
  /* last line */
  if(m_sCopyArea.y != m_eCopyArea.y){
    for(i=0; i<m_eCopyArea.x; i++){
      len ++;
      if(m_TextBuffer[m_eCopyArea.y][i] == '\n'){
        break;
      }
    }
  }
  if( len == 0 ) return FALSE;
  len ++; /* add terminater */

  pData = new COleDataSource;
  hData = ::GlobalAlloc(GMEM_SHARE, len);
  ptr = (char*)::GlobalLock(hData);
  len = 0;
  for(i=m_sCopyArea.x; i<tmp; i++){
    ptr[len] = m_TextBuffer[m_sCopyArea.y][i];
    len ++;
    if(m_TextBuffer[m_sCopyArea.y][i] == '\n') break;
  }
  /* middle line */
  for(i=m_sCopyArea.y+1; i<m_eCopyArea.y; i++){
    for(j=0; j<m_LogicalSize.cx; j++){
      ptr[len] = m_TextBuffer[i][j];
      len ++;
      if(m_TextBuffer[i][j] == '\n') break;
    }
  }
  /* last line */
  if(m_sCopyArea.y != m_eCopyArea.y){
    for(i=0; i<m_eCopyArea.x; i++){
      ptr[len] = m_TextBuffer[m_eCopyArea.y][i];
      len ++;
      if(m_TextBuffer[m_eCopyArea.y][i] == '\n') break;
    }
  }
  ptr[len] = '\0';
  // Get the currently selected data
  ::GlobalUnlock(hData);

  pData->CacheGlobalData( CF_TEXT, hData );
  pData->SetClipboard();
  pData->FlushClipboard();
  return TRUE;
}

void CConsoleDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂ
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂ
	}
}

/////////////////////////////////////////////////////////////////////////////
// CConsoleDoc R}h

// m_varArrayɒǉ
int CConsoleDoc::AddVar(char *buf)
{
	VARINFO* pItem;
	CString str, strName, strType;
	int nCount,i,pos;

	//o
	str = _T(buf);
	pos = str.Find(_T(":"));
	strType = str.Left(pos);
	strName = str.Mid(pos+1);
	//ꖼ`FbN
	nCount = (int)m_varArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (VARINFO *) m_varArray.GetAt (i);
			if(strName.Compare(pItem->strName) == 0)
				return FALSE;
		}
	}

	//
	try {
		pItem = new VARINFO;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return FALSE;
	}
	pItem->strName = strName;
	if(strType.Compare("scalar") == 0)
		pItem->type = SCALAR_OBJECT;
	else if(strType.Compare("series") == 0)
		pItem->type = SERIES_OBJECT;
	else if(strType.Compare("string") == 0)
		pItem->type = STRING_OBJECT;
	else if(strType.Compare("snapshot") == 0)
		pItem->type = SNAPSHOT_OBJECT;
	//o^
	m_varArray.InsertAt( nCount, pItem );
	nCount++;

	return nCount;
}

BOOL CConsoleDoc::SaveModified() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	return TRUE;
	//return CDocument::SaveModified();
}

//OnSizesꂽƂ̃hLg
BOOL CConsoleDoc::SaveTextBuffer(char *name)
{
	//CString	m_textBuffer[MAX_CONSOLE_SIZE];
	//short	m_textAttr[MAX_CONSOLE_SIZE][256];
	//short	m_textCrPos[MAX_CONSOLE_SIZE];
	//CSize  m_RealSize;
	//CSize  m_LogicalSize;
	//char **m_TextBuffer;
	//int  **m_TextAttrib;

	int line,xlen,ylen,x;
	FILE* fp;
	char path[_MAX_PATH],buf[_MAX_PATH];
	CString strFile,strBuf;

	GetHomeDirectory(path, _MAX_PATH);
	strFile = _T(path);
	strFile += _T('\\');
	strFile += _T(name);
	fp = fopen(strFile, "w");
	if(!fp)
		return FALSE;

	xlen = m_RealSize.cx;
	ylen = m_RealSize.cy;
	fprintf(fp,"**** Size ****\n");
	fprintf(fp,"LogicalSize:%d %d\n",
		m_LogicalSize.cx,m_LogicalSize.cy);
	fprintf(fp,"RealSize:%d %d\n",
		m_RealSize.cx,m_RealSize.cy);
	fprintf(fp,"**** m_TextBuffer ****\n");
	for(line=0; line < ylen; line++) {
		if(m_TextBuffer[line] != NULL) {
			strncpy(buf, m_TextBuffer[line], xlen);
			buf[xlen] = '\0';
			fprintf(fp,"[%4d][%d]",line,m_TextInfo[line]);
			for(x = 0; x < (int)strlen(buf); x++) {
				if(buf[x] == '\n')
					break;
				if(buf[x] == ' ')
					fprintf(fp,"&");
				else
					fprintf(fp,"%c",buf[x]);
			}
			fprintf(fp,"\n");
		}
		else {
			fprintf(fp,"--->null\n");
		}
	}
	fprintf(fp,"**** m_TextAttrib ****\n");
	for(line=0; line < ylen; line++) {
		for(x = 0; x < xlen; x++)
			fprintf(fp,"[%4d]:%d", line,m_TextAttrib[line][x]);
		fprintf(fp,"\n");
	}
	fclose(fp);
	return TRUE;
}

//OnSizesꂽƂ̃hLg
BOOL CConsoleDoc::InitializeSaveTextBuffer(int xlen, int ylen)
{
	/* set current status */
	m_SaveRealSize = CSize(xlen,ylen);
	m_SaveLogicalSize = CSize(xlen,ylen);

	int i,j,x,y;
	char buf[_MAX_PATH];
	char *cptr;

	x = 0; y = 0;
	m_textBuffer[y] = _T("");
	for(i = 0; i < ylen; i++) {
		strncpy(buf, m_TextBuffer[i], xlen);
		buf[xlen] = '\0';
		if(m_TextInfo[i]) {
			//ps
			cptr = strstr(buf, "\n");
			if(cptr == NULL) {
				m_textBuffer[y] += _T(buf);
				for(j = 0; j < xlen; j++)
					m_textAttr[y][x++] = m_TextAttrib[i][j];
			}
			else {
				//r'\n'݂
				*(cptr+1) = '\0';
				m_textBuffer[y] += _T(buf);
				for(j = 0; j < (int)strlen(buf); j++)
					m_textAttr[y][x++] = m_TextAttrib[i][j];
			}
		}
		else {
			cptr = strstr(buf, "\n");
			if(cptr == NULL) {
				//SĕŖ߂Ă
				m_textBuffer[y] += _T(buf);
				for(j = 0; j < xlen; j++)
					m_textAttr[y][x++] = m_TextAttrib[i][j];
			}
			else {
				//r'\n'݂
				*(cptr+1) = '\0';
				m_textBuffer[y] += _T(buf);
				for(j = 0; j < (int)strlen(buf); j++)
					m_textAttr[y][x++] = m_TextAttrib[i][j];
			}
			//y̍XV
			y++;
			x= 0;
			if(y < MAX_CONSOLE_LINE)
				m_textBuffer[y] = _T("");	//MAX_CONSOLE_LINE܂ł݂Ȃ
		}
	}
	//ҏWAhX
	m_textAddr = y;

	return TRUE;

	//폜
	//FreeSaveTextBuffer();
	//Ԃۑ
	//return AllocateSaveTextBuffer(m_LogicalSize.cx, m_LogicalSize.cy);
}

BOOL CConsoleDoc::AllocateSaveTextBuffer(int x, int y)
{
  int i;
  /* set current status */
  m_SaveRealSize = CSize(x,y)/*.SetSize(x,y)*/;
  m_SaveLogicalSize = CSize(x,y)/*.SetSize(x,y)*/;

  /* memory allocation */
  m_SaveTextBuffer = (char**)malloc(sizeof(char*)*y);
  if(m_SaveTextBuffer == NULL) goto fatal;
  memset(m_SaveTextBuffer,0,sizeof(char*)*y);

  m_SaveTextAttrib = (int**)malloc(sizeof(int*)*y);
  if(m_SaveTextAttrib == NULL) goto fatal;
  memset(m_SaveTextAttrib,0,sizeof(int*)*y);

  for(i=0; i<y; i++){
    m_SaveTextBuffer[i] = (char*)malloc(sizeof(char)*x);
    if(m_SaveTextBuffer[i] == NULL) goto fatal;

    m_SaveTextAttrib[i] = (int*)malloc(sizeof(int)*x);
    if(m_SaveTextAttrib[i] == NULL) goto fatal;

	memcpy(m_SaveTextBuffer[i], m_TextBuffer[i], sizeof(char)*x);
	memcpy(m_SaveTextAttrib[i], m_TextAttrib[i], sizeof(int)*x);
  }
  return TRUE;

fatal:
  FreeSaveTextBuffer();
  return FALSE;
}

void CConsoleDoc::FreeSaveTextBuffer()
{
  int i;
  if(m_SaveTextBuffer){
    for(i=0; i<m_SaveRealSize.cy; i++)
      if(m_SaveTextBuffer[i]) free(m_SaveTextBuffer[i]);
    free(m_SaveTextBuffer);
  }
  if(m_SaveTextAttrib){
    for(i=0; i<m_SaveRealSize.cy; i++)
      if(m_SaveTextAttrib[i]) free(m_SaveTextAttrib[i]);
    free(m_SaveTextAttrib);
  }
  m_SaveTextAttrib   = NULL;
  m_SaveTextBuffer   = NULL;
  m_SaveRealSize = CSize(0,0)/*.SetSize(0,0)*/;
  m_SaveLogicalSize = CSize(0,0)/*.SetSize(0,0)*/;
}

// m_textBufferm_TextBufferRs[
// 傫̊֌WōĊmF
int CConsoleDoc::CopyTextBuffer(int linenum)
{
	int sxlen,sylen,xlen,ylen,i,j,x,y,length,pos;
	int hiden = 0;
	char ch;
	BOOL crfg, crcode;

	//ÂTCY
	sxlen = m_SaveLogicalSize.cx;
	sylen = m_SaveLogicalSize.cy;
	//VTCY
	xlen = m_LogicalSize.cx;
	ylen = m_LogicalSize.cy;
	//Rs[
	y = 0;
	for(i = 0; i < m_textAddr; i++) {
		if(xlen < sxlen) {
			//TCYkꂽꍇ
			x = 0;
			crfg = FALSE;
			crcode = FALSE;
			length = m_textBuffer[i].GetLength();
			for(j = 0; j < length; j++) {
				ch = m_textBuffer[i].GetAt(j);
				if(ch == '\n')
					crcode = TRUE;
				m_TextBuffer[y][x] = ch;
				m_TextAttrib[y][x] = m_textAttr[i][j];
				if(++x == xlen) {
					//TCYȂꍇɔ
					if(i == m_textAddr-1)
						break;		//ŏIs̏ꍇ
					m_TextInfo[y] = TRUE;
					y++;
					x = 0;
					crfg = TRUE;
					hiden++;
					if(y >= MAX_CONSOLE_LINE) {
						ScrollCopyTextBuffer();
						hiden--;
						y--;
					}
				}
			}
			//Ō̕mF
			if(!crcode && crfg) {
				//p񂪐܂ԂAVsɂ
				m_TextBuffer[y][x] = '\n';
				m_TextAttrib[y][x] = 0;	// Normal
			}
			if(i != m_textAddr-1) {
				y++;
				if(y >= MAX_CONSOLE_LINE) {
					ScrollCopyTextBuffer();
					y--;
				}
			}
		}
		else {
			pos = m_textBuffer[i].Find(_T('\n'));
			if(pos == -1) {
				//'\n'݂ȂԂŊgꂽ
				m_textBuffer[i].Insert(sxlen, '\n');
				m_textAttr[i][sxlen] = 0;
			}
			x = 0;
			crfg = FALSE;
			crcode = FALSE;
			length = m_textBuffer[i].GetLength();
			for(j = 0; j < length; j++) {
				ch = m_textBuffer[i].GetAt(j);
				if(ch == '\n')
					crcode = TRUE;
				m_TextBuffer[y][x] = ch;
				m_TextAttrib[y][x] = m_textAttr[i][j];
				if(++x > xlen) {
					//TCYȂꍇɔ
					if(i == m_textAddr-1)
						break;		//ŏIs̏ꍇ
					m_TextInfo[y] = TRUE;
					y++;
					x = 0;
					crfg = TRUE;
					hiden++;
				}
			}
			//Ō̕mF
			if(!crcode && crfg) {
				//p񂪐܂ԂAVsɂ
				m_TextBuffer[y][x] = '\n';
				m_TextAttrib[y][x] = 0;	// Normal
			}
			if(i != m_textAddr-1)
				y++;
		}
	}

	//Ō̍śAvvĝ
	return hiden-(linenum-m_textAddr);
}

void CConsoleDoc::ScrollCopyTextBuffer()
{
  int i;
  char *buff;
  int  *attr;
  BOOL  info;

  /* backup first buffer */
  buff = m_TextBuffer[0];
  attr = m_TextAttrib[0];
  /* clear oldest line buffer */
  for(i=0; i<m_RealSize.cx; i++){
	buff[i] = ' ';
	attr[i] = TEXT_ATTRIBUTE_NORMAL;
  }
  info = FALSE;
  for(i=1; i<m_RealSize.cy; i++){
	m_TextBuffer[i-1] = m_TextBuffer[i];
	m_TextAttrib[i-1] = m_TextAttrib[i];
	m_TextInfo[i-1] = m_TextInfo[i];
  }
  m_TextBuffer[m_RealSize.cy-1] = buff;
  m_TextAttrib[m_RealSize.cy-1] = attr;
  m_TextInfo[m_RealSize.cy-1] = info;
}

BOOL CConsoleDoc::ChkSpaceLine(char *linebuf, int len)
{
	for(int i = 0; i < len; i++) {
		if(linebuf[i] != ' ')
			return FALSE;
	}
	return TRUE;
}
