/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: DemoView.h,v 1.3 2004/07/11 03:41:18 yoshihiko Exp $ */
#if !defined(AFX_DEMOVIEW_H__24E21FD5_01FD_434C_A83C_5494D9600746__INCLUDED_)
#define AFX_DEMOVIEW_H__24E21FD5_01FD_434C_A83C_5494D9600746__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define	TVIF_DEFAULT	(TVIF_CHILDREN | TVIF_HANDLE | TVIF_IMAGE | TVIF_PARAM | TVIF_SELECTEDIMAGE | TVIF_STATE | TVIF_TEXT)
#define	TVIS_DEFAULT	(TVIS_BOLD | TVIS_CUT | TVIS_DROPHILITED | TVIS_EXPANDED | TVIS_EXPANDEDONCE | TVIS_SELECTED)

typedef struct {
  char *title;
  char *readme;
  char *script;
  char *model;
  int	exemode;
  int	page;
} Demo;

class CDemoInfo { // f
public:
	CDemoInfo() {
	}
public:
	CString title;
	CString readme;
	CString script;
	CString model;
	int		exemode;
	int		page;
	int		exefg;
};

/////////////////////////////////////////////////////////////////////////////
// CDemoView r[

class CDemoView : public CTreeView
{
protected:
	CDemoView();           // IɎgpveNg RXgN^
	DECLARE_DYNCREATE(CDemoView)

// Agr[g
public:
	CImageList	m_ImageList;
	HTREEITEM	*m_hParent;
	COLORREF	m_backColor;
	HTREEITEM hParentStart;
	HTREEITEM hParentShell;
	HTREEITEM hParentSystem;
	HTREEITEM hParentGpm;
	HTREEITEM hParentIspp;
	HTREEITEM hParentNcs;
	HTREEITEM hParentNpe;
	HTREEITEM hParentDcm;
	HTREEITEM hParentTut;

// Iy[V
public:

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B

	//{{AFX_VIRTUAL(CDemoView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Cve[V
protected:
	virtual ~CDemoView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	void	Initialize();
	void	SetInitDemo();
	HTREEITEM AddItemRoot(char *item, int child, int image);
	HTREEITEM AddItem(HTREEITEM hParent, char *item, BOOL children, int image, CDemoInfo *pDemoInfo);
	void	GetDemoParent();
	void	GetDemoChild(HTREEITEM hParent, CString strTitle, CString strPath);
	CString GetDemoTitle(CString parent, CString child);

	// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(CDemoView)
	afx_msg void OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnScriptRun();
	afx_msg void OnUpdateScriptRun(CCmdUI* pCmdUI);
	afx_msg void OnScriptStop();
	afx_msg void OnUpdateScriptStop(CCmdUI* pCmdUI);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_DEMOVIEW_H__24E21FD5_01FD_434C_A83C_5494D9600746__INCLUDED_)
