/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: DriveCtrl.h,v 1.1 2004/05/18 07:58:58 yoshihiko Exp $ */

#if !defined(AFX_DRIVECTRL_H__28549D9C_C486_41D0_ADF4_1DA83E130FB9__INCLUDED_)
#define AFX_DRIVECTRL_H__28549D9C_C486_41D0_ADF4_1DA83E130FB9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DriveCtrl.h : wb_[ t@C
//

/////////////////////////////////////////////////////////////////////////////
// CDriveCtrl EBhE

class CDriveCtrl : public CTreeCtrl
{
// RXgNV
public:
	CDriveCtrl();

// Agr[g
public:
	int		m_FileType;
	CImageList *m_pDragImage;
	CString	m_strMyComputer;
	CString	m_strMyNetwork;
	BOOL	m_bSelScript;
	CPoint	m_curMousePos;
	BOOL	m_bPopupMenu;
	CToolTipCtrl* m_pToolTip;
	HTREEITEM m_hCurItem;
	HTREEITEM m_hDragItem;

protected:
	CImageList m_ilDrives;

// Iy[V
public:
	void Refresh();
	void SetFtype(int ftype);
	BOOL IsScriptFile();
	BOOL SetScriptFile();

protected:
	BOOL AddDriveItem (LPCTSTR pszDrive, HTREEITEM hParent);
	int AddDirectories (HTREEITEM hItem, LPCTSTR pszPath);
	void ChangeSlash(char *path);
	HTREEITEM SelectDirectory(HTREEITEM hItem, LPCTSTR pszPath, LPCTSTR pszHome);
	void DeleteLocalFiles (HTREEITEM hItem);
	BOOL AddLocalFiles (HTREEITEM hItem, LPCTSTR pszPath);
	void DeleteAllChildren (HTREEITEM hItem);
	void DeleteFirstChild (HTREEITEM hItem);
	CString GetPathFromItem (HTREEITEM hItem);
	BOOL SetButtonState (HTREEITEM hItem, LPCTSTR pszPath);
	int AddDrives (HTREEITEM hParent);
	BOOL PathRefresh(CString path);
	int GetSpecialFolder(DWORD csidl, char *path, char *specialName);
	LPITEMIDLIST CDriveCtrl::GetNextItemID(LPITEMIDLIST pidl);
	LPITEMIDLIST CDriveCtrl::CopyItemID(LPITEMIDLIST pidl);
	void PrintStrRet(LPITEMIDLIST pidl, LPSTRRET lpStr, char *name);
	HTREEITEM AddItem(char* name, int image, int nimage,
					HTREEITEM hParent, const char *path);
	int AddNetworks(HTREEITEM hParent);
	BOOL AddNetworkItem(				LPCTSTR	lpszName,
										LPSTR	lpszPath,
										LPSTR	lpszDescription);
	HRESULT GetLinkInfo(			LPCTSTR lpszLinkName,
									LPSTR	lpszPath,
									LPSTR	lpszDescription);
	void DeleteChildItemData(HTREEITEM hParent);
	int AddLocals(HTREEITEM hItem, char path[]);
	BOOL	OnEditDuplicate(HTREEITEM hItem);
	HTREEITEM GetStateSearch(UINT targeState);

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CDriveCtrl)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Cve[V
public:
	virtual ~CDriveCtrl();

	// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(CDriveCtrl)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnItemexpanding(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnEditCut();
	afx_msg void OnUpdateEditCut(CCmdUI* pCmdUI);
	afx_msg void OnScriptRun();
	afx_msg void OnFileOpen();
	afx_msg void OnBegindrag(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnDestroy();
	afx_msg void OnDblclk(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnEditDelete();
	afx_msg void OnUpdateEditDelete(CCmdUI* pCmdUI);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnEditRename();
	afx_msg void OnUpdateEditRename(CCmdUI* pCmdUI);
	afx_msg void OnEndlabeledit(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnFileChdir();
	afx_msg void OnUpdateFileChdir(CCmdUI* pCmdUI);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnScriptStep();
	afx_msg void OnFileAll();
	afx_msg void OnUpdateFileAll(CCmdUI* pCmdUI);
	afx_msg void OnFileSl();
	afx_msg void OnUpdateFileSl(CCmdUI* pCmdUI);
	afx_msg void OnFileMdl();
	afx_msg void OnUpdateFileMdl(CCmdUI* pCmdUI);
	afx_msg void OnFileTxt();
	afx_msg void OnUpdateFileTxt(CCmdUI* pCmdUI);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_DRIVECTRL_H__28549D9C_C486_41D0_ADF4_1DA83E130FB9__INCLUDED_)
