/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: MainFrm.h,v 1.3 2004/07/11 03:41:18 yoshihiko Exp $ */

#if !defined(AFX_MAINFRM_H__6465C5A9_23B7_424A_AEF8_594EFC7D05E7__INCLUDED_)
#define AFX_MAINFRM_H__6465C5A9_23B7_424A_AEF8_594EFC7D05E7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CmdBar.h"
#include "DriveBar.h"
#include "WorkBar.h"

class CMainFrame : public CMDIFrameWnd
{
	DECLARE_DYNAMIC(CMainFrame)
public:
	CMainFrame();

// Agr[g
public:
    CCmdBar     m_wndCmdBar;
	CDriveBar	m_wndDriveBar;
	CWorkBar	m_wndWorkBar;
	DWORD		m_dwCookie;

// Iy[V
public:
	BOOL	CheckHelpDemo();
	BOOL	CheckDemoChild(CString str);
	void	OnFileviewerOpen();
	void	OnWorkspaceOpen();
	void	OnCmdviewOpen();
	BOOL	m_bShowToolbar;
	int		m_nOpenWindow;

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL DestroyWindow();
	//}}AFX_VIRTUAL

// Cve[V
public:
	void ShowToolbar(BOOL cmdShow);
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // Rg[ o[po
	CStatusBar  m_wndStatusBar;
	CToolBar    m_wndToolBar;

// ꂽbZ[W }bv֐
protected:
    BOOL CreateStatusBar ();
	BOOL CreateCmdViewer(int open);
	BOOL CreateFileViewer(int open);
	BOOL CreateWorkViewer(int open);
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnConsole();
	afx_msg void OnUpdateConsole(CCmdUI* pCmdUI);
	afx_msg void OnFileviewer();
	afx_msg void OnUpdateFileviewer(CCmdUI* pCmdUI);
	afx_msg void OnWorkspace();
	afx_msg void OnUpdateWorkspace(CCmdUI* pCmdUI);
	afx_msg void OnDestroy();
	afx_msg void OnCmdview();
	afx_msg void OnUpdateCmdview(CCmdUI* pCmdUI);
	afx_msg void OnHelpDemo();
	afx_msg void OnUpdateHelpDemo(CCmdUI* pCmdUI);
	//}}AFX_MSG
	afx_msg LRESULT OnExitShell(WPARAM wParam, LPARAM lParam);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg LRESULT OnShowToolbar(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnConsoleActive(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
public:
	virtual void WinHelp(DWORD dwData, UINT nCmd = HELP_CONTEXT);
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_MAINFRM_H__6465C5A9_23B7_424A_AEF8_594EFC7D05E7__INCLUDED_)
