/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: WorkBar.cpp,v 1.3 2004/07/11 03:41:18 yoshihiko Exp $ */

#include "stdafx.h"
#include "win_shell.h"

#include "WorkBar.h"
//TODO:helpproj
#include "htmlhelp.h"
#include ".\workbar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWorkBar

CWorkBar::CWorkBar()
{
	m_bSetTree = FALSE;
}

CWorkBar::~CWorkBar()
{
}


BEGIN_MESSAGE_MAP(CWorkBar, CDocControlBar)
    //{{AFX_MSG_MAP(CWorkBar)
    ON_WM_CREATE()
    ON_WM_SIZE()
	//}}AFX_MSG_MAP
	ON_WM_HELPINFO()
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWorkBar message handlers

int CWorkBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CDocControlBar::OnCreate(lpCreateStruct) == -1)
        return -1;

	DWORD dwStyle;
	dwStyle = WS_CHILD | WS_VISIBLE | TVS_INFOTIP | TVS_NOTOOLTIPS;
    if (!m_wndChild.Create(dwStyle,
		CRect(0,0,0,0), this, ID_WORK_CTRL))
        return -1;

#if 0
    // older versions of Windows* (NT 3.51 for instance)
    // fail with DEFAULT_GUI_FONT
    if (!m_font.CreateStockObject(DEFAULT_GUI_FONT))
        if (!m_font.CreatePointFont(80, "MS Sans Serif"))
            return -1;
    m_wndChild.SetFont(&m_font);
#endif
    return 0;
}

void CWorkBar::OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler)
{
	CDocControlBar::OnUpdateCmdUI(pTarget, bDisableIfNoHndler);

	UpdateDialogControls(pTarget, bDisableIfNoHndler);
}

void CWorkBar::OnSize(UINT nType, int cx, int cy) 
{
    CDocControlBar::OnSize(nType, cx, cy);

    // TODO: Add your message handler code here
    CRect rc;
    GetClientRect(rc);

    m_wndChild.MoveWindow(rc);
}

// CCmdCtrl̏tO
BOOL CWorkBar::GetStatus()
{
	return m_bSetTree;
}

// Tree쐬
void CWorkBar::SetTree()
{
	m_wndChild.Initialize();
	m_bSetTree = TRUE;
}

/**/
void CWorkBar::AddVar(VARINFO *pItem)
{
	m_wndChild.AddVar(pItem);
}

/**/
void CWorkBar::DeleteVar(VARINFO *pItem)
{
	m_wndChild.DeleteVar(pItem);
}

BOOL CWorkBar::OnHelpInfo(HELPINFO* pHelpInfo)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	return CDocControlBar::OnHelpInfo(pHelpInfo);
}
