/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: WorkCtrl.cpp,v 1.2 2004/08/02 07:15:22 yoshihiko Exp $ */

#include "stdafx.h"
#include "win_shell.h"
#include "WorkCtrl.h"
#include "shell/satellite4.h"

#include "ConsoleDoc.h"
#include "ConsoleView.h"
#include "MainFrm.h"
#include <stdio.h>
#include <io.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//global definition
extern CConsoleView* g_pConsole;
extern char g_charScriptText[_MAX_PATH];

/////////////////////////////////////////////////////////////////////////////
// CWorkCtrl

CWorkCtrl::CWorkCtrl()
{
	m_nSelectedItem = -1;
}

CWorkCtrl::~CWorkCtrl()
{

}


BEGIN_MESSAGE_MAP(CWorkCtrl, CListCtrl)
	//{{AFX_MSG_MAP(CWorkCtrl)
	ON_WM_CREATE()
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnGetdispinfo)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(IDR_POPUP_WORK_BM, OnPopupWorkBm)
	ON_WM_LBUTTONDBLCLK()
	ON_UPDATE_COMMAND_UI(IDR_POPUP_WORK_BM, OnUpdatePopupWorkBm)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateEditCut)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWorkCtrl bZ[W nh

BOOL CWorkCtrl::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CListCtrl::PreCreateWindow (cs))
		return FALSE;
    cs.style &= ~LVS_TYPEMASK;
    cs.style |= LVS_REPORT;
	//cs.style |= LVS_SORTDESCENDING;
	cs.style |= LVS_NOSORTHEADER;

	return TRUE;
}

int CWorkCtrl::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CListCtrl::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: ̈ʒuɌŗL̍쐬pR[hǉĂ
	DWORD dwExStyle = GetExtendedStyle();
	dwExStyle |= LVS_EX_GRIDLINES;
	dwExStyle |= LVS_EX_FULLROWSELECT;
	SetExtendedStyle(dwExStyle);
	
	/*An icon image is created. */
    m_objImages.Create (IDB_OBJLIST, 16, 1, RGB (255, 0, 255));
    SetImageList (&m_objImages, LVSIL_SMALL);
	/*Columns is created.*/
	InsertColumn (0, _T ("Name"), LVCFMT_LEFT, 128);
	InsertColumn (1, _T ("Type"), LVCFMT_LEFT, 64);
	InsertColumn (2, _T ("Value"), LVCFMT_LEFT, 256);

	return 0;
}

void CWorkCtrl::Initialize()
{
	/*Processing when opening a window on the way */
	int i,nCount;
	CPtrArray* ptr;
	VARINFO* pItem;
	if(g_pConsole) {
		ptr = &(g_pConsole->m_varArray);
		nCount = (int)ptr->GetSize();
		for(i = 0; i < nCount; i++) {
			pItem = (VARINFO*)ptr->GetAt(i);
			AddVar(pItem);
		}
	}
}

void CWorkCtrl::OnGetdispinfo(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CString typeName;
	int i;
	char tmp[64];
	char value[_MAX_PATH];
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	
	if (pDispInfo->item.mask & LVIF_TEXT) {
		VARINFO* pItem = (VARINFO*) pDispInfo->item.lParam;

		switch (pDispInfo->item.iSubItem) {
			case 0: // Name
				::lstrcpy (pDispInfo->item.pszText, pItem->strName);
				break;

			case 1: // Type
				switch(pItem->type) {
				case	SCALAR_OBJECT:
					typeName = _T("scalar");	break;
				case	SERIES_OBJECT:
					typeName = _T("series");	break;
				case	STRING_OBJECT:
					typeName = _T("string");	break;
				case	SNAPSHOT_OBJECT:
					typeName = _T("snapshot");	break;
				}
				::lstrcpy (pDispInfo->item.pszText, typeName);
				break;

			case 2: // Value
				switch(pItem->type) {
				case	SCALAR_OBJECT:
					sprintf(value, "%s", pItem->strValue);
					break;
				case	SERIES_OBJECT:
					strcpy(value, "index:  ");
					for(i= 0; i < pItem->dim; i++) {
						sprintf(tmp, "%d  ", pItem->index[i]);
						strcat(value, tmp);
					}
					break;
				case	STRING_OBJECT:
					strcpy(value, pItem->strValue);
					break;
				case	SNAPSHOT_OBJECT:
					strcpy(value, "index:  ");
					for(i= 0; i < pItem->dim; i++) {
						sprintf(tmp, "%d  ", pItem->index[i]);
						strcat(value, tmp);
					}
					break;
				}
				::lstrcpy (pDispInfo->item.pszText, value);
				break;
		}
	}
	*pResult = 0;

}

void CWorkCtrl::AddVar(VARINFO *pItem)
{
	int sel,nCount;
	LV_ITEM lvi;
	CPtrArray* ptr;

	switch(pItem->type) {
	case	SCALAR_OBJECT:
		sel = 3;
		break;
	case	SERIES_OBJECT:
		sel = 0;
		break;
	case	STRING_OBJECT:
		sel = 2;
		break;
	case	SNAPSHOT_OBJECT:
		sel = 1;
		break;
	}
	if(g_pConsole) {
		/*get the number of variables*/
		ptr = &(g_pConsole->m_varArray);
		nCount = (int)ptr->GetSize();
		/*add a var to listview*/
		lvi.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM; 
		lvi.iItem = nCount; 
		lvi.iSubItem = 0; 
		lvi.iImage = sel;
		lvi.pszText = LPSTR_TEXTCALLBACK; 
		lvi.lParam = (LPARAM) pItem;

		if (InsertItem (&lvi) == -1) {
			return;
		}
	}
}

void CWorkCtrl::DeleteVar(VARINFO *pItem)
{
	int i,nCount;
	VARINFO* pTmpItem;

	nCount = GetItemCount();
	for(i = 0; i < nCount; i++) {
		pTmpItem = (VARINFO*)GetItemData(i);
		if(pItem == pTmpItem) {
			DeleteItem(i);
			break;
		}
	}
}

void CWorkCtrl::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// HitTests
	int nItem;
	LVHITTESTINFO info;
	UINT state;

	m_nSelectedItem = -1;
	info.pt = point;
	nItem = HitTest( &info );
	if(nItem == -1)
		return;

	//Is it chosen? 
	state = GetItemState(nItem, LVIS_SELECTED);
	if(state != LVIS_SELECTED)
		return;
	m_nSelectedItem = nItem;

	//j[
	VARINFO* pItem;
	CMenu menu,*pPopup;

	// Get var
	pItem = (VARINFO*)GetItemData(nItem);

	// }EX|C^XN[Wɕϊ
	ClientToScreen( &point );
	// gɃtH[JXݒ
	SetForegroundWindow();
	// |bvAbvj[̍쐬
	// IDR_POPUP_DRIVE̓j[̃\[XID
	menu.LoadMenu( IDR_POPUP_WORK );
	/*The state of the popup menu is set up. */
	if(pItem) {
		if(pItem->type != SERIES_OBJECT && pItem->type != SNAPSHOT_OBJECT)
			menu.EnableMenuItem(IDR_POPUP_WORK_BM, MF_GRAYED);
	}
	else {
		menu.EnableMenuItem(IDR_POPUP_WORK_BM, MF_GRAYED);
	}
	pPopup = menu.GetSubMenu( 0 );
	// |bvAbvj[\
	pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			point.x, point.y, this);
	// LoadMenuJ
	menu.DestroyMenu();
	
	CListCtrl::OnRButtonDown(nFlags, point);
}

void CWorkCtrl::OnPopupWorkBm() 
{
	UINT state;
	char buf[_MAX_PATH],cmdbuf[_MAX_PATH];
	int i,nItem,len,*cmd;
	DWORD size;
	VARINFO* pItem;

	if(m_nSelectedItem == -1)
		return;
	//Is it chosen? 
	state = GetItemState(m_nSelectedItem, LVIS_SELECTED);
	if(state != LVIS_SELECTED)
		return;

	//TODO
	POSITION pos = GetFirstSelectedItemPosition();
	if (pos != NULL) {
		strcpy(cmdbuf, "");
		while (pos)
		{
			nItem = GetNextSelectedItem(pos);
			pItem = (VARINFO *)GetItemData(nItem);
			sprintf(buf, "bm(%s)\n",pItem->strName);
			strcat(cmdbuf, buf);
		}
		len = (int)strlen(cmdbuf);
		cmd = (int *)malloc(len*sizeof(int)+1);
		for(i = 0; i < len; i++) {
			cmd[i] = (unsigned char)cmdbuf[i];
		}
		WriteFile(g_pConsole->m_hStdinW,
			cmd, sizeof(int)*len, &size, NULL);
		free(cmd);
	}	
}

//The contents of a variable are displayed on a console. 
void CWorkCtrl::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	int nItem,i,len,*cmd;
	LVHITTESTINFO info;
	char cmdbuf[_MAX_PATH];
	VARINFO* pItem;
	DWORD size;

	info.pt = point;
	nItem = HitTest( &info );
	if(nItem == -1 || (info.flags != LVHT_ONITEMLABEL && info.flags != LVHT_ONITEMICON))
		return;
	
	pItem = (VARINFO*)GetItemData(nItem);
	sprintf(cmdbuf, "%s\n",pItem->strName);
	len = (int)strlen(cmdbuf);
	cmd = (int *)malloc(len*sizeof(int)+1);
	if(cmd) {
		for(i = 0; i < len; i++)
			cmd[i] = (unsigned char)cmdbuf[i];
		WriteFile(g_pConsole->m_hStdinW,
			cmd, sizeof(int)*len, &size, NULL);
		free(cmd);
	}
	
	CListCtrl::OnLButtonDblClk(nFlags, point);
}

void CWorkCtrl::OnUpdatePopupWorkBm(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CWorkCtrl::OnEditCut() 
{
	// The variables chosen is deleted. 
	int i,len,*cmdbuf;
	DWORD size;
	char cmdline[_MAX_PATH];
	int nItem;
	VARINFO* pItem;

	POSITION pos = GetFirstSelectedItemPosition();
	if (pos != NULL) {
		while (pos)
		{
			nItem = GetNextSelectedItem(pos);
			pItem = (VARINFO *)GetItemData(nItem);

	sprintf(cmdline,"undef(%s)\n",pItem->strName);
	len = (int)strlen(cmdline);
	cmdbuf = (int *)malloc(len*sizeof(int)+1);
	for(i = 0; i < len; i++) {
		cmdbuf[i] = (unsigned char)cmdline[i];
	}
	WriteFile(g_pConsole->m_hStdinW, cmdbuf, sizeof(int)*len, &size, NULL);
	free(cmdbuf);

		}
	}
	else {
		return;
	}	
}

void CWorkCtrl::OnUpdateEditCut(CCmdUI* pCmdUI) 
{
	//ϐ폜Lɂ	
	UINT uCount = GetSelectedCount ();
	if(uCount > 0)
		pCmdUI->Enable(TRUE);
	else	
		pCmdUI->Enable(FALSE);
	
}
