/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: win_shell.cpp,v 1.6 2004/08/05 05:41:36 yoshihiko Exp $ */

#include "stdafx.h"
#include "win_shell.h"
#include "shell/satellite4.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "ComDoc.h"
#include "ComView.h"
#include "ConsoleDoc.h"
#include "ConsoleView.h"
#include "fileutil.h"
#include "DemoDoc.h"
#include "DemoView.h"
#include "DemoWnd.h"
#include "config.h"
#include <direct.h>

#define  __IMPORTSYMBOL__
#include "libsatellite.h"
#undef   __IMPORTSYMBOL__
#include <iostream>
#include <fstream>
#include "CodeChg.h"
using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CConsoleView* g_pConsole;
int		g_bChdirFlag;
CMultiDocTemplate* g_pEditDocTemplate;
CMultiDocTemplate* g_pConsoleDocTemplate;
CSingleDocTemplate* g_pDemoDocTemplate;
char g_charScriptText[_MAX_PATH];

extern HANDLE gWinShellEvent;

/////////////////////////////////////////////////////////////////////////////
// CShellApp

BEGIN_MESSAGE_MAP(CShellApp, CWinApp)
	//{{AFX_MSG_MAP(CShellApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpenUtil)
	//}}AFX_MSG_MAP
	// W̃t@C{hLg R}h
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// ẄZbgAbv R}h
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShellApp NX̍\z

CShellApp::CShellApp()
{
	// TODO: ̈ʒuɍ\zpR[hǉĂB
	//  InitInstance ̏dvȏׂċLqĂB
	m_bSaveFlag = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// B CShellApp IuWFNg

CShellApp theApp;

//  ID ͂̃AvP[VvIɃj[NɂȂ悤ɐ܂B
// Aʂ ID w肵Ȃ΁AύXĂ܂܂B

// {529734EC-C1AB-404F-983B-E7F307D4ED1B}
static const CLSID clsid =
{ 0x529734ec, 0xc1ab, 0x404f, { 0x98, 0x3b, 0xe7, 0xf3, 0x7, 0xd4, 0xed, 0x1b } };

/////////////////////////////////////////////////////////////////////////////
// CShellApp NX̏

BOOL CShellApp::InitInstance()
{
	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// OLE Cȕ
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();

	// WIȏ
	// ̋@\gpAst@C̃TCY
	// Έȉ̓̏[`̒sKvȂ
	// 폜ĂB

#ifdef _AFXDLL
	Enable3dControls();		// L DLL ̒ MFC gpꍇɂ͂ĂяoĂB
#else
	Enable3dControlsStatic();	// MFC ƐÓIɃNĂꍇɂ͂ĂяoĂB
#endif

	// ݒ肪ۑ鉺̃WXg L[ύX܂B
	// TODO: ̕AЖ܂͏ȂǓK؂Ȃ̂
	// ύXĂB
	SetRegistryKey(_T("DSP Technology"));

	LoadStdProfileSettings();  // W INI t@C̃IvV[ނ܂ (MRU ܂)

	// AvP[Vp̃hLg ev[go^܂BhLg ev[g
	//  ̓hLgAt[ EBhEƃr[邽߂ɋ@\܂B

	g_pEditDocTemplate = new CMultiDocTemplate(
		IDR_WIN_SHTYPE,
		RUNTIME_CLASS(CComDoc),
		RUNTIME_CLASS(CChildFrame), // JX^ MDI qt[
		RUNTIME_CLASS(CComView));
	AddDocTemplate(g_pEditDocTemplate);

	g_pConsoleDocTemplate = new CMultiDocTemplate(
		IDR_CONSOLE,
		RUNTIME_CLASS(CConsoleDoc),
		RUNTIME_CLASS(CChildFrame/*CMDIChildWnd*/), // JX^ MDI qt[
		RUNTIME_CLASS(CConsoleView));
	AddDocTemplate(g_pConsoleDocTemplate);

	g_pDemoDocTemplate = new CSingleDocTemplate(
		IDR_DEMO,
		RUNTIME_CLASS(CDemoDoc),
		RUNTIME_CLASS(CDemoWnd),
		RUNTIME_CLASS(CDemoView));
	AddDocTemplate(g_pDemoDocTemplate);

	// hLg ev[g COleTemplateServer ڑ܂B
	// COleTemplateServer ̓hLg ev[gŎw肳ꂽ
	// g OLE ReiɗvɐVKhLg
	// 쐬܂B
//m_server.ConnectTemplate(clsid, g_pEditDocTemplate, FALSE);

	// sƂׂĂ OLE T[o[ t@Ngo^܂B
	// ̃AvP[VIuWFNg邽߂ OLE Cugp\ɂ܂B
//COleTemplateServer::RegisterAll();
		// : MDI AvP[V̓R}hC /Embedding  /Automation 
		//       w肳ĂȂĂׂẴT[o[ IuWFNgo^܂B

	// C MDI t[ EBhE쐬
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// DDEAfile open ȂǕW̃VF R}h̃R}hC͂܂B
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// OLE T[o[ƂċNĂ邩mF܂B
	if (cmdInfo.m_bRunEmbedded || cmdInfo.m_bRunAutomated)
	{
		// AvP[V /Embedding  /Automation ŎsĂ鎞ɂ
		// C EBhE ͕\ł܂B
		return TRUE;
	}

	// VXe WXgĂăT[o[ AvP[VX^h A
	// Nꂽɂ́AVXe WXgXVĂB
//m_server.UpdateRegistry(OAT_DISPATCH_OBJECT);
//COleObjectFactory::UpdateRegistryAll();
	//OJĂ΁AΉ
	int open;
	open = AfxGetApp()->GetProfileInt(VERSION,"cmd_enable",FALSE);
	if(open)
		pMainFrame->OnCmdviewOpen();
	open = AfxGetApp()->GetProfileInt(VERSION,"drive_enable",FALSE);
	if(open)
		pMainFrame->OnFileviewerOpen();
	open = AfxGetApp()->GetProfileInt(VERSION,"work_enable",FALSE);
	if(open)
		pMainFrame->OnWorkspaceOpen();
	//ConsoleJ
	//g_pConsoleDocTemplate->OpenDocumentFile(NULL);
	CDocument*	pDocument;
	CFrameWnd*	pWnd;
	pDocument = g_pConsoleDocTemplate->CreateNewDocument();
	if(!pDocument) {
		AfxMessageBox("Console:CreateNewDocument error", MB_OK, NULL);
		return FALSE;
	}
	pWnd = g_pConsoleDocTemplate->CreateNewFrame(pDocument, NULL);
	if(pWnd) {
		//position and size
		CRect rcWindow;
		rcWindow.left = AfxGetApp()->GetProfileInt(VERSION,"console_left",0);
		rcWindow.top = AfxGetApp()->GetProfileInt(VERSION,"console_top",0);
		rcWindow.right = AfxGetApp()->GetProfileInt(VERSION,"console_right",512);
		if((rcWindow.right-rcWindow.left) < 512)
			rcWindow.right = rcWindow.left + 512;
		rcWindow.bottom = AfxGetApp()->GetProfileInt(VERSION,"console_bottom",320);
		pWnd->MoveWindow(rcWindow);
		g_pConsoleDocTemplate->InitialUpdateFrame(pWnd, pDocument, TRUE);
	}
	else {	// error
		AfxMessageBox("Console:CreateNewFrame error.", MB_OK, NULL);
		return FALSE;
	}

	// Helpt@CpX
	char modulepath[_MAX_PATH];
	int len,i;

	//if(GetModuleFileName(NULL,modulepath,_MAX_PATH) != 0) {
	//	len = strlen(modulepath);
	//	for(i=len-1;i>=0;i--){
	//	  if(modulepath[i] == '\\'){
	//		modulepath[i]='\0';
	//		break;
	//	  }
	//	}
	//	strcat(modulepath, "\\doc");
	//	strcat(modulepath, "\\");
	//	strcat(modulepath, "win_shell.hlp");
	//	m_pszHelpFilePath=_tcsdup(_T(modulepath));
	//}
	if(GetModuleFileName(NULL,modulepath,_MAX_PATH) != 0) {
		free((void*)m_pszHelpFilePath);
		len = (int)strlen(modulepath);
		for(i=len-1;i>=0;i--){
		  if(modulepath[i] == '\\'){
			modulepath[i]='\0';
			break;
		  }
		}
		strcat(modulepath, "\\doc");
		strcat(modulepath, "\\");
		strcat(modulepath, "sl4help.chm");
		m_pszHelpFilePath=_tcsdup(_T(modulepath));
	}

	// C EBhEꂽ̂ŁA\ƍXVs܂B
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WŎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CStatic	m_version;
	//}}AFX_DATA

	// ClassWizard z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_VERSION, m_version);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// _CAOs邽߂̃AvP[V R}h
void CShellApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CShellApp bZ[W nh

BOOL CShellApp::SaveAllModified() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
#if 0
	WINDOWPLACEMENT wndpl;
	//AfxGetMainWnd()->GetWindowPlacement(&wndpl);
	m_pMainWnd->GetWindowPlacement(&wndpl);

	WriteProfileInt(VERSION,"main_left",wndpl.rcNormalPosition.left);
	WriteProfileInt(VERSION,"main_top",wndpl.rcNormalPosition.top);
	WriteProfileInt(VERSION,"main_right",wndpl.rcNormalPosition.right);
	WriteProfileInt(VERSION,"main_bottom",wndpl.rcNormalPosition.bottom);
#endif

	if (!m_bSaveFlag)
		CWinApp::SaveAllModified();
	m_bSaveFlag = TRUE;
	return TRUE;
}

///////////////////////////////////////////////////////////////////////
// ǉ\bh

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_version.SetWindowText(VERSION);
	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}


void CShellApp::OnFileOpenUtil() 
{
	LPCSTR	lpszFilter;
	CString lpszPathname;
	char	curdir[_MAX_PATH],strFile[_MAX_PATH];
	POSITION pos;

	lpszFilter = "Script Files (*.sl) | *.sl|Model Files (*.mdl) | *.mdl|Text Files (*.txt) | *.txt||";
	CFileUtil	dlgFile(TRUE, _T(".sl"),_T(""),
		OFN_ALLOWMULTISELECT|OFN_FILEMUSTEXIST,
		lpszFilter, NULL);
	dlgFile.m_ofn.lpstrTitle = "Open";
	dlgFile.m_ofn.lpstrInitialDir = _getcwd(curdir, _MAX_PATH);
	if(dlgFile.DoModal() == IDOK) {
		pos = dlgFile.GetStartPosition();
		while (pos != NULL) {
			lpszPathname = dlgFile.GetNextPathName( pos );
			break;
		}
		if(!pos) {
				if(TranslateReturnCode(lpszPathname, strFile)) {
					//successfulȂ
					if(::CopyFile(strFile, lpszPathname, FALSE)) {
						//succesful
					}
					else {
						AfxMessageBox("TranslateReturnCode failed.",MB_OK,NULL);
					}
				}
				OpenDocumentFile(lpszPathname);
		}
	}
	
}

BOOL CShellApp::TranslateReturnCode(LPCTSTR lpszPathName, char* strFile)
{
	CReturnCode chcrlf;
	int ret;
	const char* tmpdir;
	char tmpfile[_MAX_PATH];
	BOOL fg = FALSE;
	char title[128],ext[128];

	std::ifstream inf(lpszPathName, ios_base::binary);
	tmpdir = get_tmpdir();
	_splitpath(lpszPathName, NULL, NULL, title, ext);
	sprintf(tmpfile, "%s/%s%s", tmpdir,title,ext);
	std::ofstream outf(tmpfile, ios_base::binary);
	ret = chcrlf.CheckReturnCode(inf >> std::noskipws );
	if(ret == RCODE_LF) {
		chcrlf.Convert(inf >> std::noskipws,
			outf, RCODE_CRLF);
	}

	if(ret == RCODE_LF) {
		//outf.~ofstream();
		//inf.~ifstream();
		strcpy(strFile, tmpfile);
		fg = TRUE;
	}

	return fg;
}
