/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: win_shell.h,v 1.2 2004/05/18 08:05:22 yoshihiko Exp $ */

#if !defined(AFX_WIN_SHELL_H__0B10F791_FB3B_468E_931D_67F93408CF68__INCLUDED_)
#define AFX_WIN_SHELL_H__0B10F791_FB3B_468E_931D_67F93408CF68__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

//Pipe
#define		PIPE_BUF_SIZE	256

/* max line number of console */
#define		MAX_CONSOLE_LINE	300/*1024*/

#define		MAX_CONSOLE_SIZE    300

#define		TTY_COLOR	COLORREF
#define		MAX_SCRIPT_SIZE		1024
#define		COMMAND_INPUT		0
#define		SCRIPT_INPUT		1
//̒`́AVShell̎gp
#define		NEW_SHELL
//̒`́ApipeLɂ
#define		PIPE_PROCESS
//File Type
#define	FILE_SL		0	//slt@C
#define FILE_ALL	1	//SẴt@C
#define FILE_MDL	2
#define FILE_TXT	3

//[U[`bZ[W
#define		ID_TTY_TEXT_PRINT	(WM_USER+1)
#define		ID_TTY_EXIT			(WM_USER+2)
#define		ID_TTY_CURSOR		(WM_USER+3)
#define     ID_TTY_TEXT_MODE    (WM_USER+4)
#define		ID_SCRIPT_EXE		(WM_USER+5)
#define		ID_SCRIPT_QUIT		(WM_USER+6)
#define		ID_SYMBOL_PASTE		(WM_USER+7)
#define		ID_MODULE_LOAD		(WM_USER+7)
#define		ID_EXIT_SHELL		99999
#define		CONSOLE_ACTIVE		9997

#define		UNDEF_OBJECT		0
#define		SCALAR_OBJECT		4	// scalar
#define		SERIES_OBJECT		1	// series
#define		SNAPSHOT_OBJECT		2	// snapshot
#define		STRING_OBJECT		3	// string
typedef struct	tagVARINFO {
	CString		strName;
	int			type;
	int			dim;
	int			index[10];
	CString		strValue;
} VARINFO;

#define		PDF_PAGE			0
#define		PDF_TEXT			1

#define		MAX_ARG				20
typedef struct	tagCMDINFO {
	int			node;
	CString		strParent;
	CString		strName;
	CString		strExplain;
	int			argnum;
	CString		strArgs;
	CString		strMsg[MAX_ARG];
} CMDINFO;

// editor margins
#define		LEFT_MARGIN		5
#define		RIGHT_MARGIN	5
// executable method
#define		INLINE_MODE		0
#define		CONSOLE_MODE	1

#include "resource.h"       // C V{

/////////////////////////////////////////////////////////////////////////////
// CShellApp:
// ̃NX̓̒`ɊւĂ win_shell.cpp t@CQƂĂB
//

class CShellApp : public CWinApp
{
public:
	CShellApp();
	BOOL TranslateReturnCode(LPCTSTR lpszPathName, char* strFile);
#if 0
	void WriteRegInt(char *key, char* param, long value);
	long ReadRegInt(char *key, char* param, long value);
#endif

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CShellApp)
	public:
	virtual BOOL InitInstance();
	virtual BOOL SaveAllModified();
	//}}AFX_VIRTUAL

// Cve[V
	//COleTemplateServer m_server;
	BOOL m_bSaveFlag;
		// hLg쐬邽߂̃T[o[ IuWFNg
	//{{AFX_MSG(CShellApp)
	afx_msg void OnAppAbout();
	afx_msg void OnFileOpenUtil();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_WIN_SHELL_H__0B10F791_FB3B_468E_931D_67F93408CF68__INCLUDED_)
