/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ConsoleDoc.h,v 1.2 2004/04/21 10:39:53 orrisroot Exp $ */

#if !defined(AFX_CONSOLEDOC_H__09D30A0B_D91D_41CC_A4E9_FE31D6D517BE__INCLUDED_)
#define AFX_CONSOLEDOC_H__09D30A0B_D91D_41CC_A4E9_FE31D6D517BE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CConsoleDoc : public CDocument
{
protected: // create from serialization only
  CConsoleDoc();
  DECLARE_DYNCREATE(CConsoleDoc)

// Attributes
private:
  CSize  m_RealSize;
  CSize  m_LogicalSize;
  CPoint m_sCopyArea;
  CPoint m_eCopyArea;
  char **m_TextBuffer;
  int  **m_TextAttrib;

// Operations
private:
  void FreeTextBuffer();
  BOOL AllocateTextBuffer(int x, int y);
public:
  BOOL InitializeTextBuffer(int xinit, int maxline);
  BOOL ResizeTextBuffer(int x, int y);
  BOOL ScrollTextBuffer(bool dir);
  BOOL SaveTextBuffer(int xpos, int ypos, int attr, const char *str, size_t len);
  void ClearSelectedBuffer();
  BOOL SelectTextBuffer(int xs, int ys, int xe, int ye);
  const char *GetTextBuffer(int xp, int yp);
  int  GetTextAttribute(int xp, int yp);
  BOOL SetTextBufferToClipboard();

// Overrides
  //{{AFX_VIRTUAL(CConsoleDoc)
public:
  virtual BOOL OnNewDocument();
  virtual void Serialize(CArchive& ar);
  //}}AFX_VIRTUAL

// Inplementetion
public:
  virtual ~CConsoleDoc();
#ifdef _DEBUG
  virtual void AssertValid() const;
  virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
  //{{AFX_MSG(CConsoleDoc)
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
public:
  virtual void DeleteContents();
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_CONSOLEDOC_H__09D30A0B_D91D_41CC_A4E9_FE31D6D517BE__INCLUDED_)
