/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.morilib.automata.TextBound;
import net.morilib.automata.nfa.NFAAlternative;
import net.morilib.automata.nfa.NFABuildException;
import net.morilib.automata.nfa.NFAConcatenation;
import net.morilib.automata.nfa.NFAEpsilonBound;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAOptional;
import net.morilib.automata.nfa.NFAParenthesis;
import net.morilib.automata.nfa.NFARepetition;
import net.morilib.automata.nfa.SingleSetNFA;
import net.morilib.grammar.lr.ContextFreeGrammar;
import net.morilib.grammar.lr.ContextFreeReduceAction;
import net.morilib.grammar.lr.ContextFreeRule;
import net.morilib.grammar.lr.LALR1Items;
import net.morilib.grammar.lr.LALR1Table;
import net.morilib.grammar.lr.LRParseException;
import net.morilib.grammar.lr.LRParser;
import net.morilib.grammar.lr.LexicalAnalyser;
import net.morilib.grammar.lr.Nonterminal;
import net.morilib.grammar.lr.SemanticAttributes;
import net.morilib.grammar.lr.Terminal;
import net.morilib.range.Interval;
import net.morilib.range.Intervals;
import net.morilib.range.Range;
import net.morilib.util.Inclimentor;
import net.morilib.util.IntInclimentor;
import net.morilib.util.Tuple2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NFABuilder<A> {
    private static final Term LETTR = new Term("c");
    private static final Term LPAR = new Term("(");
    private static final Term RPAR = new Term(")");
    private static final Term STAR = new Term("*");
    private static final Term PLUS = new Term("+");
    private static final Term BAR = new Term("|");
    private static final Term LPARL = new Term("[");
    private static final Term DOT = new Term(".");
    private static final Term RPARL = new Term("]");
    private static final Term MINUS = new Term("-");
    private static final Term CARET = new Term("^");
    private static final Term QUES = new Term("?");
    private static final Term DOLL = new Term("$");
    private static final Term BSLA = new Term("\\");
    private static final Map<Character, Term> RE_TOKENS;
    private static final Map<Character, Term> CH_TOKENS;
    private static final LALR1Table PTABLE;
    private static final ContextFreeRule S1;
    private static final ContextFreeRule S2;
    private static final ContextFreeRule L1;
    private static final ContextFreeRule L2;
    private static final ContextFreeRule T1;
    private static final ContextFreeRule T2;
    private static final ContextFreeRule T3;
    private static final ContextFreeRule T4;
    private static final ContextFreeRule F1;
    private static final ContextFreeRule FP;
    private static final ContextFreeRule F2;
    private static final ContextFreeRule F3;
    private static final ContextFreeRule F4;
    private static final ContextFreeRule F5;
    private static final ContextFreeRule F6;
    private static final ContextFreeRule C1;
    private static final ContextFreeRule C2;
    private static final ContextFreeRule D1;
    private static final ContextFreeRule D2;
    private static final ContextFreeRule E1;
    private static final ContextFreeRule E2;
    private static final Range ALLSET;
    private static final Range DOTSET;
    private LRParser<Attr<A>> parser = this.createParser();
    private Inclimentor<A> reseq;
    private Inclimentor<Integer> capseq;

    static {
        ALLSET = Intervals.newClosedInterval(new Integer(0), new Integer(Integer.MAX_VALUE));
        HashMap<Character, Term> rt = new HashMap<Character, Term>();
        HashMap<Character, Term> ct = new HashMap<Character, Term>();
        rt.put(Character.valueOf('('), LPAR);
        rt.put(Character.valueOf(')'), RPAR);
        rt.put(Character.valueOf('*'), STAR);
        rt.put(Character.valueOf('+'), PLUS);
        rt.put(Character.valueOf('|'), BAR);
        rt.put(Character.valueOf('['), LPARL);
        rt.put(Character.valueOf('.'), DOT);
        rt.put(Character.valueOf('?'), QUES);
        rt.put(Character.valueOf('^'), CARET);
        rt.put(Character.valueOf('$'), DOLL);
        rt.put(Character.valueOf('\\'), BSLA);
        ct.put(Character.valueOf(']'), RPARL);
        ct.put(Character.valueOf('-'), MINUS);
        ct.put(Character.valueOf('^'), CARET);
        RE_TOKENS = Collections.unmodifiableMap(rt);
        CH_TOKENS = Collections.unmodifiableMap(ct);
        HashSet<ContextFreeRule> rules = new HashSet<ContextFreeRule>();
        NTer s = new NTer("S");
        NTer l = new NTer("L");
        NTer lp = new NTer("LP");
        NTer t = new NTer("T");
        NTer f = new NTer("F");
        NTer c = new NTer("C");
        NTer d = new NTer("D");
        NTer e = new NTer("E");
        S1 = new ContextFreeRule(s, s, BAR, l);
        S2 = new ContextFreeRule(s, l);
        L1 = new ContextFreeRule(l, l, t);
        L2 = new ContextFreeRule(l, t);
        T1 = new ContextFreeRule(t, f, STAR);
        T2 = new ContextFreeRule(t, f, PLUS);
        T3 = new ContextFreeRule(t, f);
        T4 = new ContextFreeRule(t, f, QUES);
        F1 = new ContextFreeRule(f, lp, s, RPAR);
        FP = new ContextFreeRule(lp, LPAR);
        F2 = new ContextFreeRule(f, LETTR);
        F3 = new ContextFreeRule(f, LPARL, c, RPARL);
        F4 = new ContextFreeRule(f, DOT);
        F5 = new ContextFreeRule(f, CARET);
        F6 = new ContextFreeRule(f, DOLL);
        C1 = new ContextFreeRule(c, CARET, d);
        C2 = new ContextFreeRule(c, d);
        D1 = new ContextFreeRule(d, d, e);
        D2 = new ContextFreeRule(d, e);
        E1 = new ContextFreeRule(e, LETTR, MINUS, LETTR);
        E2 = new ContextFreeRule(e, LETTR);
        rules.add(S1);
        rules.add(S2);
        rules.add(L1);
        rules.add(L2);
        rules.add(T1);
        rules.add(T2);
        rules.add(T3);
        rules.add(T4);
        rules.add(F1);
        rules.add(FP);
        rules.add(F2);
        rules.add(F3);
        rules.add(F4);
        rules.add(F5);
        rules.add(F6);
        rules.add(C1);
        rules.add(C2);
        rules.add(D1);
        rules.add(D2);
        rules.add(E1);
        rules.add(E2);
        ContextFreeGrammar g = ContextFreeGrammar.newInstance(rules, s);
        LALR1Items items = LALR1Items.newLALR(g);
        PTABLE = new LALR1Table(items);
        DOTSET = Intervals.newRightOpenInterval(new Integer(10), new Integer(11)).complement(ALLSET);
    }

    private LRParser<Attr<A>> createParser() {
        LRParser<Attr<A>> parser = new LRParser<Attr<A>>(PTABLE);
        parser.setAction(S1, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr r1 = attrs.get(0);
                Attr r2 = attrs.get(2);
                Attr re = new Attr();
                re.nfa = NFAAlternative.newInstance(r1.nfa, r2.nfa);
                return re;
            }
        });
        parser.setAction(S2, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                return attrs.get(0);
            }
        });
        parser.setAction(L1, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr r1 = attrs.get(0);
                Attr r2 = attrs.get(1);
                Attr re = new Attr();
                re.nfa = NFAConcatenation.newInstance(r1.nfa, r2.nfa);
                return re;
            }
        });
        parser.setAction(L2, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                return attrs.get(0);
            }
        });
        parser.setAction(T1, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr r1 = attrs.get(0);
                Attr re = new Attr();
                re.nfa = NFARepetition.newInstance(r1.nfa, true);
                return re;
            }
        });
        parser.setAction(T2, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr r1 = attrs.get(0);
                Attr re = new Attr();
                re.nfa = NFARepetition.newInstance(r1.nfa, false);
                return re;
            }
        });
        parser.setAction(T3, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                return attrs.get(0);
            }
        });
        parser.setAction(T4, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr r1 = attrs.get(0);
                Attr re = new Attr();
                re.nfa = NFAOptional.newInstance(r1.nfa);
                return re;
            }
        });
        parser.setAction(F1, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr r1 = attrs.get(1);
                Attr re = new Attr();
                Object rq = NFABuilder.this.reseq.getObject();
                int sq = attrs.get(0).cno;
                re.nfa = NFAParenthesis.newInstance(r1.nfa, new Tuple2(rq, sq));
                return re;
            }
        });
        parser.setAction(FP, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr re = new Attr();
                re.cno = (Integer)NFABuilder.this.capseq.getObject();
                NFABuilder.this.capseq.suc();
                return re;
            }
        });
        parser.setAction(F2, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                return attrs.get(0);
            }
        });
        parser.setAction(F3, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr r1 = attrs.get(1);
                Attr re = new Attr();
                re.nfa = SingleSetNFA.newInstance(r1.charset);
                return re;
            }
        });
        parser.setAction(F4, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr re = new Attr();
                re.nfa = SingleSetNFA.newInstance(DOTSET);
                return re;
            }
        });
        parser.setAction(F5, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr re = new Attr();
                re.nfa = NFAEpsilonBound.newInstance(TextBound.BEGIN_LINE);
                return re;
            }
        });
        parser.setAction(F6, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr re = new Attr();
                re.nfa = NFAEpsilonBound.newInstance(TextBound.END_LINE);
                return re;
            }
        });
        parser.setAction(C1, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr r1 = attrs.get(1);
                Attr re = new Attr();
                re.charset = r1.charset.complement(ALLSET);
                return re;
            }
        });
        parser.setAction(C2, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                return attrs.get(0);
            }
        });
        parser.setAction(D1, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr r1 = attrs.get(0);
                Attr r2 = attrs.get(1);
                Attr re = new Attr();
                re.charset = r1.charset.join(r2.charset);
                return re;
            }
        });
        parser.setAction(D2, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                return attrs.get(0);
            }
        });
        parser.setAction(E1, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr r1 = attrs.get(0);
                Attr r2 = attrs.get(2);
                Attr re = new Attr();
                if (r1.chr > r2.chr) {
                    throw new NFABuildException();
                }
                Interval rz = Intervals.newRightOpenInterval(new Integer(r1.chr), new Integer(r2.chr + '\u0001'));
                re.charset = rz;
                return re;
            }
        });
        parser.setAction(E2, new ContextFreeReduceAction<Attr<A>>(){

            @Override
            public Attr<A> action(ContextFreeRule event, SemanticAttributes<Attr<A>> attrs) {
                Attr r1 = attrs.get(0);
                Attr re = new Attr();
                Interval rz = Intervals.newRightOpenInterval(new Integer(r1.chr), new Integer(r1.chr + '\u0001'));
                re.charset = rz;
                return re;
            }
        });
        return parser;
    }

    private NFABuilder(Inclimentor<A> reseq) {
        this.reseq = reseq;
    }

    public static <A> NFABuilder<A> getInstance(Inclimentor<A> reseq) {
        return new NFABuilder<A>(reseq);
    }

    public NFAObject<Integer, A, Tuple2<A, Integer>> parse(CharSequence seq) {
        this.capseq = new IntInclimentor();
        try {
            Attr<A> res = this.parser.parse(new Lexer(seq));
            return ((Attr)res).nfa;
        }
        catch (LRParseException e) {
            throw new NFABuildException(e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Attr<A> {
        private NFAObject<Integer, A, Tuple2<A, Integer>> nfa;
        private Range charset;
        private char chr;
        private int cno;

        private Attr() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Lexer<A>
    implements LexicalAnalyser<Attr<A>> {
        private CharSequence seq;
        private Map<Character, Term> tset = NFABuilder.access$0();
        private int ptr = 0;
        private boolean befLparl = false;

        private Lexer(CharSequence seq) {
            this.seq = seq;
        }

        private NFAObject<Integer, A, Tuple2<A, Integer>> getLtr(int c) {
            Interval rz = Intervals.newRightOpenInterval(new Integer(c), new Integer(c + 1));
            return SingleSetNFA.newInstance(rz);
        }

        @Override
        public boolean isEnded() {
            return this.ptr >= this.seq.length();
        }

        @Override
        public LexicalAnalyser.Token<Attr<A>> nextToken() {
            if (this.isEnded()) {
                return LexicalAnalyser.Token.endMarker();
            }
            char c = this.seq.charAt(this.ptr++);
            Term t = this.tset.get(Character.valueOf(c));
            Attr atr = new Attr();
            if (this.tset == RE_TOKENS) {
                if (t == LPARL) {
                    this.befLparl = true;
                    this.tset = CH_TOKENS;
                } else if (t == BSLA) {
                    t = LETTR;
                    if (this.isEnded()) {
                        atr.nfa = this.getLtr(c);
                    } else {
                        atr.nfa = this.getLtr(this.seq.charAt(this.ptr++));
                    }
                } else if (t == null) {
                    t = LETTR;
                    atr.nfa = this.getLtr(c);
                }
            } else if (this.tset == CH_TOKENS) {
                if (t == CARET && !this.befLparl) {
                    t = LETTR;
                    atr.chr = c;
                } else if (t == MINUS && this.befLparl) {
                    t = LETTR;
                    atr.chr = c;
                } else if (t == null) {
                    t = LETTR;
                    atr.chr = c;
                } else if (t == RPARL) {
                    this.tset = RE_TOKENS;
                }
                this.befLparl = false;
            }
            return new LexicalAnalyser.Token(t, atr);
        }
    }

    private static class NTer
    implements Nonterminal {
        String sym;

        private NTer(String s) {
            this.sym = s;
        }

        public String toString() {
            return this.sym;
        }
    }

    private static class Term
    implements Terminal {
        String sym;

        private Term(String s) {
            this.sym = s;
        }

        public String toString() {
            return this.sym;
        }
    }
}

