/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.Map;
import java.util.WeakHashMap;
import net.morilib.lisp.Atom;
import net.morilib.lisp.LispString;
import net.morilib.lisp.SymbolName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Symbol
extends Atom
implements SymbolName {
    public static final Symbol QUOTE = Symbol.getSymbol("quote");
    public static final Symbol QUASIQUOTE = Symbol.getSymbol("quasiquote");
    public static final Symbol UNQUOTE = Symbol.getSymbol("unquote");
    public static final Symbol UNQUOTE_SPLICING = Symbol.getSymbol("unquote-splicing");
    private static Map<String, Symbol> flyweight;
    private String name;
    private Symbol replace = null;
    private boolean replaced = false;
    private Symbol macroSymbol = null;

    private Symbol(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Symbol getSymbol(String name) {
        if (name == null) {
            throw new NullPointerException("Symbol");
        }
        Class<Symbol> clazz = Symbol.class;
        synchronized (Symbol.class) {
            Symbol res;
            if (flyweight == null) {
                flyweight = new WeakHashMap<String, Symbol>();
            }
            if ((res = flyweight.get(name)) == null) {
                res = new Symbol(name);
                flyweight.put(name, res);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return res;
        }
    }

    static Symbol newAndMark(Map<Symbol, Symbol> box, Symbol sym, boolean mark) {
        Symbol res;
        if (sym == null) {
            throw new NullPointerException();
        }
        if (mark) {
            res = box.get(sym);
            if (res == null) {
                res = new Symbol(null);
                res.replace = sym;
                res.replaced = true;
                res.macroSymbol = sym;
                box.put(sym, res);
            }
        } else if (!sym.replaced) {
            res = sym;
        } else {
            res = sym.replace;
            if (res == null) {
                throw new NullPointerException();
            }
        }
        return res;
    }

    public static Symbol gensym() {
        Symbol res = new Symbol(null);
        return res;
    }

    public static Symbol encloseSymbol(Symbol sym) {
        Symbol res = new Symbol(null);
        res.macroSymbol = sym.macroSymbol;
        return res;
    }

    public boolean isEqv(Atom a) {
        return this.equals(a);
    }

    @Override
    public String getName() {
        return this.name == null ? "#:" + this.hashCode() : this.name;
    }

    public boolean isGenerated() {
        return this.name == null;
    }

    public boolean isReplaced() {
        return this.replace != null;
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.getName());
    }

    @Override
    public String print() {
        return this.getName();
    }

    @Override
    public String getResult() {
        return this.getName();
    }

    Symbol getEnclosedSymbol() {
        Symbol sym = this;
        while (sym.macroSymbol != null) {
            sym = sym.macroSymbol;
        }
        return sym;
    }

    public String toString() {
        return "Symbol:" + this.getName();
    }

    @Override
    public boolean isTypeSymbol() {
        return true;
    }
}

