/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range;

import net.morilib.range.Range;
import net.morilib.util.Objects;

public final class Ranges {
    private Ranges() {
    }

    static int compareInfimum(Object o1, boolean b1, Object o2, boolean b2) {
        int r = Objects.compareBound(o1, o2);
        return r != 0 ? r : (b1 && !b2 ? 1 : (!b1 && b2 ? -1 : 0));
    }

    static int compareSupremum(Object o1, boolean b1, Object o2, boolean b2) {
        int r = Objects.compareBound(o1, o2);
        return r != 0 ? r : (b1 && !b2 ? -1 : (!b1 && b2 ? 1 : 0));
    }

    static boolean inCoveredLowerHalfPlane(Range src, Range d) {
        if (d.isSupremumClosed() || src.isSupremumOpen()) {
            return !src.isSupremumBoundAboveAllClosureOf(d);
        }
        return src.isSupremumBoundBelowAllClosureOf(d);
    }

    static boolean inCoveredUpperHalfPlane(Range src, Range d) {
        if (d.isInfimumClosed() || src.isInfimumOpen()) {
            return !src.isInfimumBoundBelowAllClosureOf(d);
        }
        return d.isInfimumBoundAboveAllClosureOf(src);
    }

    public static Range sum(Range r1, Range r2) {
        return r1.join(r2);
    }

    public static Range overlap(Range r1, Range r2) {
        return r1.meet(r2);
    }

    public static boolean inBounds(Range t, Object o) {
        return !t.isInfimumAbove(o) && !t.isSupremumBelow(o);
    }
}

