/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.LispBigInt;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.util.Inclimentor;
import net.morilib.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LispSmallInt
extends LispInteger {
    private int value;

    LispSmallInt(int value) {
        this.value = value;
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex((double)this.value + c.getRealDouble(), c.getImagDouble());
        }
        if (x instanceof LispSmallInt) {
            long vr1 = this.value;
            long vr2 = x.getExactSmallInt();
            return LispInteger.valueOf(vr1 + vr2);
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return LispInteger.valueOf(vb.add(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger nd = r.getDenominator();
            BigInteger nn = vb.multiply(r.getDenominator()).add(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            return new LispDouble((double)this.value + ((LispDouble)x).doubleValue());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispComplex) {
            double xr = ((LispComplex)x).getRealDouble();
            double xi = ((LispComplex)x).getImagDouble();
            double n = this.value;
            if (xr == 0.0) {
                return LispComplex.newComplex(0.0, -n / xi);
            }
            return LispComplex.newComplex(n * xr / (xr * xr + xi * xi), -(n * xi) / (xr * xr + xi * xi));
        }
        if (x instanceof LispSmallInt) {
            return LispRational.newRational(this.value, x.getExactSmallInt());
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return LispRational.newRational(vb, x.getBigInteger());
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger nd = r.getNumerator();
            BigInteger nn = vb.multiply(r.getDenominator());
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            return new LispDouble((double)this.value / ((LispDouble)x).doubleValue());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (c.getRealDouble() == 0.0) {
                return LispComplex.newComplex(0.0, (double)this.value * c.getImagDouble());
            }
            return LispComplex.newComplex((double)this.value * c.getRealDouble(), (double)this.value * c.getImagDouble());
        }
        if (x instanceof LispSmallInt) {
            long vr1 = this.value;
            long vr2 = x.getExactSmallInt();
            return LispInteger.valueOf(vr1 * vr2);
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return LispInteger.valueOf(vb.multiply(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger nd = r.getDenominator();
            BigInteger nn = vb.multiply(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            return new LispDouble((double)this.value * ((LispDouble)x).doubleValue());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex((double)this.value - c.getRealDouble(), -c.getImagDouble());
        }
        if (x instanceof LispSmallInt) {
            long vr1 = this.value;
            long vr2 = x.getExactSmallInt();
            return LispInteger.valueOf(vr1 - vr2);
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return LispInteger.valueOf(vb.subtract(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger nd = r.getDenominator();
            BigInteger nn = vb.multiply(r.getDenominator()).subtract(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            return new LispDouble((double)this.value - ((LispDouble)x).doubleValue());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber uminus() {
        return new LispSmallInt(-this.value);
    }

    @Override
    public int signum() {
        return Utils.signum(this.value);
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispComplex) {
            return false;
        }
        if (x instanceof LispSmallInt) {
            return this.value == x.getExactSmallInt();
        }
        if (x instanceof LispBigInt) {
            return false;
        }
        if (x instanceof LispRational) {
            return false;
        }
        if (x instanceof LispDouble) {
            return (double)this.value == ((LispDouble)x).doubleValue();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public boolean isLessThan(LispReal x) {
        if (x instanceof LispSmallInt) {
            return this.value < x.getExactSmallInt();
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return vb.compareTo(x.getBigInteger()) < 0;
        }
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger n1 = vb.multiply(r.getDenominator());
            return n1.compareTo(n2 = r.getNumerator()) < 0;
        }
        if (x instanceof LispDouble) {
            return (double)this.value < x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        if (x instanceof LispSmallInt) {
            return this.value > x.getExactSmallInt();
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return vb.compareTo(x.getBigInteger()) > 0;
        }
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger n1 = vb.multiply(r.getDenominator());
            return n1.compareTo(n2 = r.getNumerator()) > 0;
        }
        if (x instanceof LispDouble) {
            return (double)this.value > x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber toInexact() {
        return new LispDouble(this.value);
    }

    public boolean equals(Object x) {
        if (x instanceof LispSmallInt) {
            return this.value == ((LispSmallInt)x).value;
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * l + this.value;
        return l;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public String print() {
        return Integer.toString(this.value);
    }

    @Override
    public String getResult() {
        return Integer.toString(this.value);
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        return new LispString(Integer.toString(this.value, radix));
    }

    @Override
    public boolean isOne() {
        return this.value == 1;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public int getExactSmallInt() {
        return this.value;
    }

    @Override
    public double getRealDouble() {
        return this.value;
    }

    @Override
    public boolean equalIncliment(Inclimentor<?> i) {
        if (i instanceof LispSmallInt) {
            return this.value == ((LispSmallInt)i).value;
        }
        return i.equalInt(this.value);
    }

    @Override
    public boolean equalInt(int i) {
        return this.value == i;
    }

    @Override
    public boolean equalInt(BigInteger i) {
        return i.equals(BigInteger.valueOf(this.value));
    }

    @Override
    public Inclimentor<LispInteger> suc() {
        return this.suc(1);
    }

    @Override
    public Inclimentor<LispInteger> suc(int step) {
        long r = (long)this.value + (long)step;
        return LispInteger.valueOf(r);
    }

    @Override
    public int toInt() {
        return this.value;
    }
}

