/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Logger;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CodeExecutorFactory;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.CompilerFactory;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.InitLispLoader;
import net.morilib.lisp.InitSubrLoader;
import net.morilib.lisp.InitVarLoader;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.JavaException;
import net.morilib.lisp.JavaInstance;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Parser;
import net.morilib.lisp.ReadException;
import net.morilib.lisp.ReadFileException;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.util.LogEnv;

public final class Scheme {
    public static final int SCHEME_VERSION = 5;
    private static Logger _log = LogEnv.init("schlush.main");
    private Environment global;
    private LispCompiler comp;
    private CodeExecutor exec;
    private IntStack memento;
    private Parser parser;
    private LispMessage message;
    private String stackTrace;

    private Scheme(LispMessage msg) {
        if (msg == null) {
            throw new NullPointerException();
        }
        this.global = new Environment();
        this.message = msg;
        this.comp = CompilerFactory.getInstance(this.message);
        this.exec = CodeExecutorFactory.getInstance(this.message);
        this.memento = this.exec.newMemento();
        this.parser = new Parser(this.global, this.message);
    }

    Scheme(Environment env, LispMessage msg) {
        if (env == null) {
            throw new NullPointerException();
        }
        if (msg == null) {
            throw new NullPointerException();
        }
        this.global = env;
        this.message = msg;
        this.comp = CompilerFactory.getInstance(this.message);
        this.exec = CodeExecutorFactory.getInstance(this.message);
        this.memento = this.exec.newMemento();
        this.parser = new Parser(this.global, this.message);
    }

    public static Scheme newInstance(Locale lc) {
        Scheme res = new Scheme(LispMessage.getInstance(lc));
        InitSubrLoader.load(res.global);
        InitVarLoader.load(res.global);
        res.parser.clear();
        InitLispLoader.load(res);
        res.parser.clear();
        return res;
    }

    public static Scheme newInstance() {
        return Scheme.newInstance(Locale.getDefault());
    }

    static Environment newNullEnv(int ver) {
        Scheme res = new Scheme(LispMessage.getInstance());
        InitSubrLoader.loadNullEnv(res.global, ver);
        InitVarLoader.loadNullEnv(res.global, ver);
        res.parser.clear();
        InitLispLoader.loadNullEnv(res, ver);
        res.parser.clear();
        return res.global;
    }

    static Environment newRnRSEnv(int ver) {
        Scheme res = new Scheme(LispMessage.getInstance());
        InitSubrLoader.loadRnRSEnv(res.global, ver);
        InitVarLoader.loadRnRSEnv(res.global, ver);
        res.parser.clear();
        InitLispLoader.loadRnRSEnv(res, ver);
        res.parser.clear();
        return res.global;
    }

    public Datum input(Datum sexp) {
        try {
            Datum d = sexp;
            CompiledCode.Builder b = new CompiledCode.Builder();
            long t = System.currentTimeMillis();
            d = this.comp.expandMacro(d, this.global, this.exec, this.memento);
            IntLispUtils.timelog(_log, "Expand Macro : ", t);
            t = System.currentTimeMillis();
            this.comp.compile(d, this.global, b, true, new Cons(), true, new LinkedList<Cons>(), this.exec, this.memento, new LispCompiler.MiscInfo(null));
            b.addReturnOp();
            IntLispUtils.timelog(_log, "Compile : ", t);
            t = System.currentTimeMillis();
            Datum res = this.exec.exec(b.getCodeRef(), this.global, this.memento);
            IntLispUtils.timelog(_log, "Execute : ", t);
            _log.fine(this.memento.toString());
            Datum datum = res;
            return datum;
        }
        finally {
            this.parser.clear();
            this.stackTrace = this.memento.getStackTrace();
            this.memento = this.exec.newMemento();
        }
    }

    public Datum input(String rd) {
        block5: {
            this.parser.read(rd);
            if (this.parser.parse()) break block5;
            return null;
        }
        try {
            Datum d = this.parser.getDatum();
            if (d != null) {
                return this.input(d);
            }
            this.parser.clear();
            return null;
        }
        catch (ReadException e) {
            this.parser.clear();
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public Datum exec(String rd) {
        Datum res = this.input(rd);
        if (res == null) {
            throw new IllegalArgumentException("S-exp is not completed");
        }
        return res;
    }

    public void readFile(Reader rd1) throws IOException {
        BufferedReader rd = new BufferedReader(rd1);
        int lineno = 0;
        try {
            while (true) {
                String read = rd.readLine();
                ++lineno;
                if (read != null) {
                    this.input(read);
                    continue;
                }
                break;
            }
        }
        catch (ReadException e) {
            String ln = this.message.get("err.lineno");
            throw new ReadFileException(String.valueOf(lineno) + ln + ":" + e.getMessage(), e);
        }
        catch (LispException e) {
            String ln = this.message.get("err.lineno");
            throw new ReadFileException(String.valueOf(lineno) + ln + ":" + e.getMessage(), e);
        }
        catch (JavaException e) {
            String ln = this.message.get("err.lineno");
            throw new ReadFileException(String.valueOf(lineno) + ln + ":" + e.getMessage(), e);
        }
        this.parser.clear();
    }

    public void readEvalPrintLoop(Reader rd1) throws IOException {
        BufferedReader rd = new BufferedReader(rd1);
        block4: while (true) {
            String prompt = " >";
            Datum res = null;
            try {
                while (res == null) {
                    System.out.print(prompt);
                    String r2 = rd.readLine();
                    if (r2 == null) break block4;
                    res = this.input(r2);
                    prompt = ">>";
                }
                System.out.println(LispUtils.getResult(res));
            }
            catch (ReadException e) {
                System.err.println(String.valueOf(this.message.get("err.repl.read")) + e.getMessage());
            }
            catch (LispException e) {
                String tra = this.stackTrace;
                System.err.println(String.valueOf(this.message.get("err.repl.err")) + e.getMessage());
                if (tra != null && !tra.equals("")) {
                    System.err.println(this.message.get("err.stacktrace"));
                    System.err.print(tra);
                }
                _log.fine("Stack trace\n" + tra);
            }
            catch (JavaException e) {
                System.err.println(String.valueOf(this.message.get("err.repl.err")) + e.getMessage());
            }
        }
    }

    public static void main(String[] args) throws IOException {
        Scheme eval = Scheme.newInstance();
        if (args.length == 0) {
            eval.readEvalPrintLoop(new InputStreamReader(System.in));
            System.exit(0);
        } else {
            InputStream ins = args[0].equals("-") ? System.in : new FileInputStream(args[0]);
            try {
                eval.readFile(new InputStreamReader(ins));
                System.exit(0);
            }
            catch (ReadFileException e) {
                System.err.println(e.getMessage());
                System.exit(2);
            }
        }
    }

    public void set(String var, Object o) {
        this.global.bindDatum(Symbol.getSymbol(var), LispUtils.toDatum(o));
    }

    public void setDotList(String var, Object cdr, Object ... lst) {
        ConsListBuilder b = new ConsListBuilder();
        Object[] objectArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            b.append(LispUtils.toDatum(o));
            ++n2;
        }
        this.global.bindDatum(Symbol.getSymbol(var), b.get(LispUtils.toDatum(cdr)));
    }

    public void setList(String var, Object ... lst) {
        this.setDotList(var, Nil.NIL, lst);
    }

    public void setJavaInstance(String var, Object o) {
        this.global.bindDatum(Symbol.getSymbol(var), new JavaInstance(o));
    }

    public Datum get(String var) {
        return this.global.findDatum(Symbol.getSymbol(var));
    }

    public String getString(String var) {
        Datum d = this.get(var);
        if (d instanceof LispString) {
            return ((LispString)d).getString();
        }
        throw new ClassCastException();
    }

    public BigInteger getExactInteger(String var) {
        Datum d = this.get(var);
        if (d instanceof LispInteger) {
            return d.getBigInteger();
        }
        throw new ClassCastException();
    }

    public int getExactInt(String var) {
        return this.getExactInteger(var).intValue();
    }

    public long getExactLong(String var) {
        return this.getExactInteger(var).longValue();
    }

    public LispNumber getNumber(String var) {
        Datum d = this.get(var);
        if (d instanceof LispNumber) {
            return (LispNumber)d;
        }
        throw new ClassCastException();
    }

    public LispReal getReal(String var) {
        LispNumber n = this.getNumber(var);
        if (n.isReal()) {
            return n.getReal();
        }
        throw new ClassCastException();
    }

    public double getDouble(String var) {
        return this.getReal(var).getRealDouble();
    }

    public int getInt(String var) {
        return this.getReal(var).getBigInteger().intValue();
    }

    public long getLong(String var) {
        return this.getReal(var).getBigInteger().longValue();
    }

    public Object getJavaInstance(String var) {
        Datum d = this.get(var);
        if (d instanceof JavaInstance) {
            return ((JavaInstance)d).getJavaInstance();
        }
        throw new ClassCastException();
    }

    public Datum call(String var, Object ... lst) {
        CompiledCode.Builder cd = new CompiledCode.Builder();
        Datum fn = this.get(var);
        cd.addPush(fn);
        cd.addPush(LispUtils.toConsList(lst));
        cd.addCall();
        cd.addReturnOp();
        return this.exec.exec(cd.getCodeRef(), this.global, this.memento);
    }

    public String callString(String var, Object ... lst) {
        Datum d = this.call(var, lst);
        if (d instanceof LispString) {
            return ((LispString)d).getString();
        }
        throw new ClassCastException();
    }

    public BigInteger callExactInteger(String var, Object ... lst) {
        Datum d = this.call(var, lst);
        if (d instanceof LispInteger) {
            return d.getBigInteger();
        }
        throw new ClassCastException();
    }

    public int callExactInt(String var, Object ... lst) {
        return this.callExactInteger(var, lst).intValue();
    }

    public long callExactLong(String var, Object ... lst) {
        return this.callExactInteger(var, lst).longValue();
    }

    public LispNumber callNumber(String var, Object ... lst) {
        Datum d = this.call(var, lst);
        if (d instanceof LispNumber) {
            return (LispNumber)d;
        }
        throw new ClassCastException();
    }

    public LispReal callReal(String var, Object ... lst) {
        LispNumber n = this.callNumber(var, lst);
        if (n.isReal()) {
            return n.getReal();
        }
        throw new ClassCastException();
    }

    public double callDouble(String var, Object ... lst) {
        return this.callReal(var, lst).getRealDouble();
    }

    public int callInt(String var, Object ... lst) {
        return this.callReal(var, lst).getBigInteger().intValue();
    }

    public long callLong(String var, Object ... lst) {
        return this.callReal(var, lst).getBigInteger().longValue();
    }
}

