/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sss.servlet.http;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.sss.servlet.http.HasAttribute;
import net.morilib.lisp.sss.servlet.http.LispHttpSession;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;

public class LispHttpRequest
extends Datum
implements HasAttribute {
    HttpServletRequest req;

    LispHttpRequest(HttpServletRequest req) {
        this.req = req;
    }

    @Override
    public Object getAttribute(String name) {
        return this.req.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.req.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.req.removeAttribute(name);
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<http-request>");
    }

    public static class GetParameter
    extends BinaryArgs {
        protected Datum toDatum(String str) {
            return str == null ? Nil.NIL : new LispString(str);
        }

        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispHttpRequest)) {
                throw mesg.getError("err.sss.require.httprequest", c1a);
            }
            if (!(c2a instanceof LispString)) {
                throw mesg.getError("err.require.string", c2a);
            }
            HttpServletRequest r = ((LispHttpRequest)c1a).req;
            return this.toDatum(r.getParameter(c2a.getString()));
        }
    }

    public static class GetParameterInteger
    extends GetParameter {
        @Override
        protected Datum toDatum(String str) {
            try {
                if (str == null || str.equals("")) {
                    return Nil.NIL;
                }
                return LispInteger.valueOf((long)Long.parseLong(str));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return LispInteger.valueOf((BigInteger)new BigInteger(str));
                }
                catch (NumberFormatException e) {
                    return Symbol.getSymbol((String)"type-mismatch");
                }
            }
        }
    }

    public static class GetSession
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispHttpRequest) {
                HttpServletRequest r = ((LispHttpRequest)c1a).req;
                return new LispHttpSession(r.getSession());
            }
            throw mesg.getError("err.sss.require.httprequest", c1a);
        }
    }

    public static class IsSessionValid
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispHttpRequest) {
                HttpServletRequest r = ((LispHttpRequest)c1a).req;
                return LispBoolean.getInstance((boolean)r.isRequestedSessionIdValid());
            }
            throw mesg.getError("err.sss.require.httprequest", c1a);
        }
    }

    public static class SetCharacterEncoding
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispHttpRequest)) {
                throw mesg.getError("err.sss.require.httprequest", c1a);
            }
            if (!(c2a instanceof LispString)) {
                throw mesg.getError("err.require.string", c2a);
            }
            HttpServletRequest r = ((LispHttpRequest)c1a).req;
            try {
                r.setCharacterEncoding(c2a.getString());
            }
            catch (UnsupportedEncodingException e) {
                throw mesg.getError("err.unsupportedencoding", c2a);
            }
            return Undef.UNDEF;
        }
    }
}

