/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.morilib.automata.nfa.CompoundNFA;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAState;

public final class NFAAlternative<T, A, B>
extends CompoundNFA<T, A, B> {
    final NFAState beginState = new NFAObject.IntStateObject(this, 0);
    final NFAState endState = new NFAObject.IntStateObject(this, 1);

    private NFAAlternative() {
    }

    public static <T, A, B> NFAAlternative<T, A, B> newInstance(Collection<NFAState> col) {
        NFAAlternative<T, A, B> res = new NFAAlternative<T, A, B>();
        res.nfas = new ArrayList();
        return res;
    }

    public static <T, A, B> NFAAlternative<T, A, B> newInstance(NFAObject<T, A, B>[] arr) {
        NFAAlternative<T, A, B> res = new NFAAlternative<T, A, B>();
        res.nfas = Arrays.asList(arr);
        return res;
    }

    public static <T, A, B> NFAAlternative<T, A, B> newInstance(NFAObject<T, A, B> a, NFAObject<T, A, B> b) {
        NFAAlternative<T, A, B> res = new NFAAlternative<T, A, B>();
        res.nfas = new ArrayList();
        res.nfas.add(a);
        res.nfas.add(b);
        return res;
    }

    @Override
    void addInitialStates(Set<NFAState> res) {
        res.add(this.beginState);
    }

    @Override
    void addStatesEpsilon(Set<NFAState> res, NFAState state) {
        if (this.beginState.equals(state)) {
            int i = 0;
            while (i < this.nfas.size()) {
                ((NFAObject)this.nfas.get(i)).addInitialStates(res);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nfas.size()) {
                if (((NFAObject)this.nfas.get(i)).isState(state)) {
                    ((NFAObject)this.nfas.get(i)).addStatesEpsilon(res, state);
                    if (((NFAObject)this.nfas.get(i)).isFinal(state)) {
                        res.add(this.endState);
                    }
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isState(NFAState o) {
        int i = 0;
        while (i < this.nfas.size()) {
            if (((NFAObject)this.nfas.get(i)).isState(o)) {
                return true;
            }
            ++i;
        }
        return this.beginState.equals(o) || this.endState.equals(o);
    }

    @Override
    public boolean isInitialState(NFAState state) {
        return this.beginState.equals(state);
    }

    @Override
    public boolean isFinal(NFAState state) {
        return this.endState.equals(state);
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        return Collections.singleton(this.endState);
    }
}

