/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number.complex;

import net.morilib.lang.Hashes;
import net.morilib.lang.algebra.FieldElement;
import net.morilib.lang.number.complex.ComplexImaginaryPart;
import net.morilib.lang.number.complex.ImaginaryPart;
import net.morilib.lang.number.complex.RectanglarComplexDouble;

public abstract class ComplexDouble
implements FieldElement<ComplexDouble> {
    public static final ComplexDouble NaN = new ComplexDouble(){

        @Override
        public ComplexDouble negate() {
            return this;
        }

        @Override
        public ComplexDouble subtract(ComplexDouble x) {
            return this;
        }

        @Override
        public ComplexDouble add(ComplexDouble x) {
            return this;
        }

        @Override
        public ComplexDouble multiply(int n) {
            return this;
        }

        @Override
        public ComplexDouble multiply(ComplexDouble x) {
            return this;
        }

        @Override
        public ComplexDouble power(int n) {
            return this;
        }

        @Override
        public ComplexDouble invert() {
            return this;
        }

        @Override
        public ComplexDouble divide(ComplexDouble x) {
            return this;
        }

        @Override
        public double realPart() {
            return Double.NaN;
        }

        @Override
        public double imagPart() {
            return Double.NaN;
        }

        @Override
        public double abs() {
            return Double.NaN;
        }

        @Override
        public double angle() {
            return Double.NaN;
        }

        @Override
        public ComplexDouble rotate(double rad) {
            return this;
        }

        @Override
        public boolean isNaN() {
            return true;
        }

        @Override
        public boolean isInfinity() {
            return false;
        }

        @Override
        public String toString() {
            return "NaN";
        }
    };
    public static final ComplexDouble ONE = RectanglarComplexDouble.valueOf(1.0, 0.0);
    public static final ComplexDouble I = RectanglarComplexDouble.valueOf(0.0, 1.0);
    public static final ComplexDouble REAL_POSITIVE_INFINITY = RectanglarComplexDouble.valueOf(Double.POSITIVE_INFINITY, 0.0);
    public static final ComplexDouble REAL_NEGATIVE_INFINITY = RectanglarComplexDouble.valueOf(Double.NEGATIVE_INFINITY, 0.0);
    public static final ComplexDouble ZERO = new ComplexDouble(){

        @Override
        public ComplexDouble negate() {
            return this;
        }

        @Override
        public ComplexDouble subtract(ComplexDouble x) {
            return (ComplexDouble)x.negate();
        }

        @Override
        public ComplexDouble add(ComplexDouble x) {
            return this;
        }

        @Override
        public ComplexDouble multiply(int n) {
            return this;
        }

        @Override
        public ComplexDouble multiply(ComplexDouble x) {
            return this;
        }

        @Override
        public ComplexDouble power(int n) {
            return n <= 0 ? NaN : this;
        }

        @Override
        public ComplexDouble invert() {
            return INFINITY;
        }

        @Override
        public ComplexDouble divide(ComplexDouble x) {
            return this;
        }

        @Override
        public double realPart() {
            return 0.0;
        }

        @Override
        public double imagPart() {
            return 0.0;
        }

        @Override
        public double abs() {
            return 0.0;
        }

        @Override
        public double angle() {
            return 0.0;
        }

        @Override
        public ComplexDouble rotate(double rad) {
            return this;
        }

        @Override
        public boolean isNaN() {
            return false;
        }

        @Override
        public boolean isInfinity() {
            return false;
        }

        @Override
        public boolean isReal() {
            return true;
        }

        @Override
        public boolean isInteger() {
            return true;
        }
    };
    public static final ComplexDouble INFINITY = new ComplexDouble(){

        @Override
        public ComplexDouble negate() {
            return this;
        }

        @Override
        public ComplexDouble subtract(ComplexDouble x) {
            return x.isInfinity() ? NaN : this;
        }

        @Override
        public ComplexDouble add(ComplexDouble x) {
            return x.isInfinity() ? INFINITY : this;
        }

        @Override
        public ComplexDouble multiply(int n) {
            return this;
        }

        @Override
        public ComplexDouble multiply(ComplexDouble x) {
            return x.isInfinity() ? INFINITY : this;
        }

        @Override
        public ComplexDouble power(int n) {
            return this;
        }

        @Override
        public ComplexDouble invert() {
            return ZERO;
        }

        @Override
        public ComplexDouble divide(ComplexDouble x) {
            return x.isInfinity() ? NaN : this;
        }

        @Override
        public double realPart() {
            return Double.NaN;
        }

        @Override
        public double imagPart() {
            return Double.NaN;
        }

        @Override
        public double abs() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public double angle() {
            return Double.NaN;
        }

        @Override
        public ComplexDouble rotate(double rad) {
            return this;
        }

        @Override
        public boolean isNaN() {
            return false;
        }

        @Override
        public boolean isInfinity() {
            return true;
        }

        @Override
        public boolean isReal() {
            return false;
        }

        @Override
        public boolean isInteger() {
            return false;
        }
    };

    public final double getPart(ImaginaryPart base) {
        if (base == ComplexImaginaryPart.I) {
            return this.imagPart();
        }
        if (base == ComplexImaginaryPart.ONE) {
            return this.realPart();
        }
        throw new IllegalArgumentException(base.toString());
    }

    public abstract double realPart();

    public abstract double imagPart();

    public abstract double abs();

    public abstract double angle();

    public abstract ComplexDouble rotate(double var1);

    public abstract boolean isNaN();

    public abstract boolean isInfinity();

    @Override
    public ComplexDouble multiply(double x) {
        if (x == 0.0) {
            return ZERO;
        }
        return this.multiply(RectanglarComplexDouble.realValueOf(x));
    }

    @Override
    public ComplexDouble divide(double x) {
        if (x == 0.0) {
            return INFINITY;
        }
        return this.divide(RectanglarComplexDouble.realValueOf(x));
    }

    @Override
    public ComplexDouble add(double x) {
        return this.add(RectanglarComplexDouble.realValueOf(x));
    }

    @Override
    public ComplexDouble subtract(double x) {
        return this.subtract(RectanglarComplexDouble.realValueOf(x));
    }

    public boolean isReal() {
        return this.imagPart() == 0.0;
    }

    public boolean isInteger() {
        return this.isReal() && Math.IEEEremainder(this.realPart(), 1.0) == 0.0;
    }

    @Override
    public boolean isUnit() {
        return this.realPart() == 1.0 && this.imagPart() == 0.0;
    }

    @Override
    public boolean isZero() {
        return this.realPart() == 0.0 && this.imagPart() == 0.0;
    }

    public ComplexDouble rotateDegree(int deg) {
        return this.rotate((double)deg * Math.PI / 180.0);
    }

    public final boolean equals(Object o) {
        if (o instanceof ComplexDouble) {
            ComplexDouble c = (ComplexDouble)o;
            return this.realPart() == c.realPart() && this.imagPart() == c.imagPart();
        }
        return false;
    }

    public final int hashCode() {
        if (this.isInfinity()) {
            return Integer.MAX_VALUE;
        }
        return Hashes.hashCode(this.realPart()) + Hashes.hashCode(this.imagPart()) * 37;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isZero()) {
            return "0";
        }
        if (this.realPart() != 0.0) {
            b.append(this.realPart());
        }
        if (this.imagPart() > 0.0) {
            b.append("+").append(this.imagPart()).append("i");
        } else if (this.imagPart() < 0.0) {
            b.append(this.imagPart()).append("i");
        }
        return b.toString();
    }
}

