/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lang.Decimal32;
import net.morilib.lang.Decimal64;
import net.morilib.lang.number.AbstractNumericalField;
import net.morilib.lang.number.Double2;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.NumericalField;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDecimal32;
import net.morilib.lisp.LispDecimal64;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispHalf;
import net.morilib.lisp.LispInexactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispOctonion;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispRangedDouble;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;

public final class LispFloat
extends LispInexactReal
implements JavaObjective,
Serializable {
    public static final NumericalField<LispReal> FIELD = new AbstractNumericalField<LispReal>(){

        @Override
        public LispReal valueOf(int v) {
            return this.valueOf((float)v);
        }

        @Override
        public LispReal valueOf(long v) {
            return this.valueOf((float)v);
        }

        @Override
        public LispReal valueOf(Integer2 v) {
            return this.valueOf(v.floatValue());
        }

        @Override
        public LispReal getUnit() {
            return ONE;
        }

        @Override
        public LispReal getZero() {
            return ZERO;
        }

        @Override
        public LispReal valueOf(float v) {
            return new LispFloat(v);
        }

        @Override
        public LispReal valueOf(double v) {
            return this.valueOf((float)v);
        }

        @Override
        public LispReal valueOf(BigDecimal v) {
            return this.valueOf(v.floatValue());
        }

        @Override
        public LispReal valueOf(Rational v) {
            return this.valueOf(v.floatValue());
        }
    };
    public static final LispFloat ZERO = new LispFloat(0.0f);
    public static final LispFloat ONE = new LispFloat(1.0f);
    public static final LispFloat POSITIVE_INFINITY = new LispFloat(Float.POSITIVE_INFINITY);
    public static final LispFloat NEGATIVE_INFINITY = new LispFloat(Float.NEGATIVE_INFINITY);
    public static final LispFloat NaN = new LispFloat(Float.NaN);
    private float number;

    public LispFloat(float x) {
        this.number = x;
    }

    @Override
    public BigInteger getNumerator() {
        LispExactReal r = LispDouble.toExact(this.number);
        return r.getNumerator();
    }

    @Override
    public BigInteger getDenominator() {
        LispExactReal r = LispDouble.toExact(this.number);
        return r.getDenominator();
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return new LispRangedDouble((double)this.number + x.getRealDouble(), ((LispRangedDouble)x).error);
        }
        if (x instanceof LispHalf) {
            return new LispFloat(this.number + x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble((double)this.number + x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.add(Decimal32.toDecimal(this.number), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.add(Decimal64.toDecimal(this.number), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispFloat(this.number + x.getRealFloat());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (x == LispComplex.INFINITY) {
                return LispComplex.INFINITY;
            }
            return LispComplex.newComplex(this.add(c.getReal()), c.getImag());
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.add(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.add(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return new LispRangedDouble((double)this.number - x.getRealDouble(), ((LispRangedDouble)x).error);
        }
        if (x instanceof LispHalf) {
            return new LispFloat(this.number - x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble((double)this.number - x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.subtract(Decimal32.toDecimal(this.number), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.subtract(Decimal64.toDecimal(this.number), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispFloat(this.number - x.getRealFloat());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (x == LispComplex.INFINITY) {
                return LispComplex.INFINITY;
            }
            return LispComplex.newComplex(this.subtract(c.getReal()), c.getImag().uminus());
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.sub(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.sub(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return LispRangedDouble.valueOf((double)this.number * x.getRealDouble(), (double)this.number * ((LispRangedDouble)x).error);
        }
        if (x instanceof LispHalf) {
            return new LispFloat(this.number * x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble((double)this.number * x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.multiply(Decimal32.toDecimal(this.number), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.multiply(Decimal64.toDecimal(this.number), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispFloat(this.number * x.getRealFloat());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (x == LispComplex.INFINITY) {
                return LispComplex.INFINITY;
            }
            return LispComplex.newComplex(this.multiply(c.getReal()), this.multiply(c.getImag()));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.mul(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.mul(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            LispRangedDouble x0 = (LispRangedDouble)x;
            if (x0.isZeroIncluded()) {
                return LispDouble.NaN;
            }
            double y1 = (double)this.number / x0.getRealDouble() + (double)this.number * x0.error;
            double y2 = (double)this.number / x0.getRealDouble() - (double)this.number * x0.error;
            return LispRangedDouble.valueOf((y1 + y2) / 2.0, Math.abs(y1 - y2) / 2.0);
        }
        if (x instanceof LispRangedDouble) {
            return new LispRangedDouble((double)this.number + x.getRealDouble(), ((LispRangedDouble)x).error);
        }
        if (x instanceof LispHalf) {
            return new LispFloat(this.number / x.getRealFloat());
        }
        if (x instanceof LispDouble) {
            return new LispDouble((double)this.number / x.getRealDouble());
        }
        if (x instanceof LispDecimal32) {
            return new LispDecimal32(Decimal32.divide(Decimal32.toDecimal(this.number), x.getRealDecimal32()));
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.divide(Decimal64.toDecimal(this.number), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispFloat(this.number / x.getRealFloat());
        }
        if (x instanceof LispComplex) {
            LispReal xr = x.getReal();
            LispReal xi = x.getImag();
            LispReal xn = xr.multiply(xr).add(xi.multiply(xi));
            if (x == LispComplex.INFINITY) {
                return this.isExact() ? LispInteger.ZERO : LispDouble.ZERO;
            }
            return LispComplex.newComplex(this.multiply(xr).divide(xn), this.multiply(xi).uminus().divide(xn));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.div(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.div(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispFloat uminus() {
        return new LispFloat(-this.number);
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispHalf) {
            return this.number == x.getRealFloat();
        }
        if (x instanceof LispFloat) {
            return this.number == x.getRealFloat();
        }
        if (x instanceof LispDouble) {
            return (double)this.number == x.getRealDouble();
        }
        if (x instanceof LispDecimal32) {
            return this.number == x.getRealFloat();
        }
        if (x instanceof LispDecimal64) {
            return this.number == x.getRealFloat();
        }
        return false;
    }

    @Override
    public boolean isLessThan(LispReal x) {
        return this.number < x.getRealFloat();
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        return this.number > x.getRealFloat();
    }

    public BigInteger bigIntegerValue() {
        BigDecimal dec = new BigDecimal(this.number);
        return dec.toBigInteger();
    }

    @Override
    public double doubleValue() {
        return this.number;
    }

    @Override
    public int signum() {
        return this.number > 0.0f ? 1 : (this.number < 0.0f ? -1 : 0);
    }

    @Override
    public LispExactReal toExact() {
        return LispDouble.toExact(this.number);
    }

    @Override
    public String print() {
        return LispFloat.disp(this.number);
    }

    @Override
    public String getResult() {
        return LispFloat.disp(this.number);
    }

    @Override
    public boolean isInteger() {
        return IntLispUtils.toIntegerExact(this.number) != null;
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (Float.isNaN(this.number)) {
            return new LispString("+nan.0");
        }
        if (this.number == Float.POSITIVE_INFINITY) {
            return new LispString("+inf.0");
        }
        if (this.number == Float.NEGATIVE_INFINITY) {
            return new LispString("-inf.0");
        }
        return new LispString(Float.toString(this.number));
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.number);
    }

    @Override
    public boolean isOne() {
        return (double)this.number == 1.0;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (Double.isInfinite(this.number) || Double.isNaN(this.number)) {
            throw new NumberFormatException("Infinities or NaNs is not supported");
        }
        return BigDecimal.valueOf(this.number);
    }

    @Override
    public double getRealDouble() {
        return this.number;
    }

    @Override
    public long getRealDecimal64() {
        return Decimal64.toDecimal(this.number);
    }

    @Override
    public int getRealDecimal32() {
        return Decimal32.toDecimal(this.number);
    }

    @Override
    public boolean isInfinity() {
        return Double.isInfinite(this.number);
    }

    @Override
    public LispReal invert() {
        return new LispFloat(1.0f / this.number);
    }

    @Override
    public boolean isUnit() {
        return (double)this.number == 1.0;
    }

    @Override
    public LispReal multiply(int n) {
        return new LispFloat(this.number * (float)n);
    }

    @Override
    public LispReal power(int n) {
        return new LispFloat((float)Math.pow(this.number, n));
    }

    @Override
    public NumericalField<LispReal> getUniverse() {
        return FIELD;
    }

    @Override
    public int castInt() {
        return (int)this.number;
    }

    @Override
    public long castLong() {
        return (long)this.number;
    }

    @Override
    public Integer2 castInteger2() {
        return Double2.valueOf(this.number).castInteger2();
    }

    @Override
    public int intFloor() {
        return (int)this.longFloor();
    }

    @Override
    public long longFloor() {
        return (long)Math.floor(this.number);
    }

    @Override
    public Integer2 getInteger2Floor() {
        Rational r = Rational.valueOf(this.number);
        return r.getInteger2Floor();
    }

    @Override
    public int intCeil() {
        return (int)this.longCeil();
    }

    @Override
    public long longCeil() {
        return (long)Math.ceil(this.number);
    }

    @Override
    public Integer2 getInteger2Ceil() {
        Rational r = Rational.valueOf(this.number);
        return r.getInteger2Ceil();
    }

    @Override
    public Rational getRational() {
        return LispDouble.toExact(this.number).getRational();
    }

    @Override
    public float floatValue() {
        return this.number;
    }

    @Override
    public Object toObject() {
        return new Double(this.number);
    }

    @Override
    public LispReal floor() {
        return new LispFloat((float)Math.floor(this.number));
    }

    @Override
    public LispReal ceil() {
        return new LispFloat((float)Math.ceil(this.number));
    }

    @Override
    public boolean equals(Object x) {
        if (x instanceof LispFloat) {
            return this.number == ((LispFloat)x).number;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.number);
    }

    @Override
    public String toString() {
        return Double.toString(this.number);
    }
}

