/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.morilib.lisp.Atom;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.LispCharArray;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispPurelyMutableCollection;
import net.morilib.lisp.collection.LispSequence;
import net.morilib.lisp.iterator.ILispIterable;
import net.morilib.lisp.iterator.ILispIterator;
import net.morilib.lisp.math.algebra.ILispAddable;
import net.morilib.lisp.sort.SRFI95Sequence;
import net.morilib.lisp.sos.LispType;
import net.morilib.lisp.subr.CharEqual;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.util.Iterators;
import net.morilib.util.Strings;
import net.morilib.util.io.UTF16;

public final class LispString
extends Atom
implements JavaObjective,
LispSequence,
LispPurelyMutableCollection,
LispArrayPrototype,
ILispAddable<LispString>,
SRFI95Sequence<LispString>,
ILispIterable,
Serializable {
    private static final long serialVersionUID = -2492989855710883745L;
    public static final LispString EMPTY = new LispString("");
    private String value;

    public LispString(String value) {
        if (value == null) {
            throw new NullPointerException("string is null");
        }
        this.value = value;
    }

    public LispString(LispString str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.value = str.value;
    }

    public static LispString valueOf(String s) {
        return new LispString(s);
    }

    public boolean isEqualTo(LispString a) {
        return this.value.equals(a.value);
    }

    @Override
    public String getString() {
        return this.value;
    }

    public void setString(String value) {
        this.value = value;
    }

    @Override
    public LispString toLispString() {
        return this;
    }

    @Override
    public String print() {
        return this.value;
    }

    @Override
    public String getResult() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.value.length()) {
            char c = this.value.charAt(i);
            if (c == '\\') {
                b.append("\\\\");
            } else if (c == '\"') {
                b.append("\\\"");
            } else {
                b.append(c);
            }
            ++i;
        }
        return "\"" + b.toString() + "\"";
    }

    @Override
    public boolean isTypeString() {
        return true;
    }

    @Override
    public LispType getType() {
        return LispType.STRING;
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    public LispString copy() {
        return new LispString(this);
    }

    @Override
    public Procedure equivalence() {
        return new CharEqual();
    }

    @Override
    public Datum copyAdd(Datum d) {
        return this.copy().add(d);
    }

    @Override
    public Datum add(Datum d) {
        if (d instanceof LispCharacter) {
            this.value = String.valueOf(this.value) + Strings.newString(d.getCharacter());
            return this;
        }
        throw new ClassCastException("err.require.char");
    }

    @Override
    public Datum copyDelete(Datum d) {
        return this.copy().delete(d);
    }

    @Override
    public Datum delete(Datum d) {
        if (d instanceof LispCharacter) {
            StringBuilder b = new StringBuilder(this.value);
            int i = this.value.indexOf(d.getCharacter());
            if (i >= 0) {
                b.deleteCharAt(i);
            }
            this.value = b.toString();
            return this;
        }
        throw new ClassCastException("err.require.char");
    }

    @Override
    public Datum copyDeleteAll(Datum d) {
        return this.copy().deleteAll(d);
    }

    @Override
    public Datum deleteAll(Datum d) {
        if (d instanceof LispCharacter) {
            int i;
            StringBuilder b = new StringBuilder(this.value);
            while ((i = b.toString().indexOf(d.getCharacter())) >= 0) {
                b.deleteCharAt(i);
            }
            this.value = b.toString();
            return this;
        }
        throw new ClassCastException("err.require.char");
    }

    @Override
    public Datum copyAddFrom(LispBag d) {
        return this.copy().addFrom(d);
    }

    @Override
    public Datum addFrom(LispBag d) {
        for (Datum x : d) {
            this.add(x);
        }
        return this;
    }

    @Override
    public Datum copyDeleteFrom(LispBag d) {
        return this.copy().deleteFrom(d);
    }

    @Override
    public Datum deleteFrom(LispBag d) {
        for (Datum x : d) {
            this.delete(x);
        }
        return this;
    }

    @Override
    public Datum copyDeleteAllFrom(LispBag d) {
        return this.copy().deleteAllFrom(d);
    }

    @Override
    public Datum deleteAllFrom(LispBag d) {
        for (Datum x : d) {
            this.deleteAll(x);
        }
        return this;
    }

    @Override
    public Symbol getCollectionName() {
        return Symbol.getSymbol("string");
    }

    @Override
    public int size() {
        return this.value.length();
    }

    @Override
    public boolean equivalence(Datum a, Datum b) {
        if (a instanceof LispCharacter && b instanceof LispCharacter) {
            return a.getCharacter() == b.getCharacter();
        }
        throw new ClassCastException("err.require.char");
    }

    @Override
    public Datum prototype() {
        return new LispString("");
    }

    @Override
    public Datum clear() {
        this.value = "";
        return this;
    }

    @Override
    public boolean equalTo(LispCollection col) {
        int i = 0;
        for (Datum x : col) {
            if (!(x instanceof LispCharacter)) {
                throw new ClassCastException("err.require.char");
            }
            if (x.getCharacter() == this.value.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalTo(LispCollection col, Procedure proc, Environment env, LispMessage mesg) {
        int i = 0;
        for (Datum x : col) {
            if (!(x instanceof LispCharacter)) {
                throw new ClassCastException("err.require.char");
            }
            if (Scheme.callva(proc, env, mesg, x, LispCharacter.valueOf(this.value.charAt(i++))).isTrue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Datum duplicate() {
        return new LispString(this);
    }

    @Override
    public boolean contains(Datum d) {
        if (d instanceof LispCharacter) {
            return this.value.indexOf(d.getCharacter()) >= 0;
        }
        throw new ClassCastException("err.require.char");
    }

    @Override
    public Iterator<Datum> iterator() {
        final int[] i = new int[]{0};
        return new Iterator<Datum>(){

            @Override
            public boolean hasNext() {
                return i[0] < LispString.this.value.length();
            }

            @Override
            public Datum next() {
                int n = i[0];
                i[0] = n + 1;
                return new LispCharacter(LispString.this.value.charAt(n));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public LispCharacter get(int index) {
        return new LispCharacter(this.value.charAt(index));
    }

    @Override
    public Datum copySet(int index, Datum d) {
        char[] cs = this.value.toCharArray();
        if (d instanceof LispCharacter) {
            cs[index] = d.getCharacter();
            return new LispString(new String(cs));
        }
        throw new ClassCastException("err.require.char");
    }

    @Override
    public Datum set(int index, Datum d) {
        return this.copySet(index, d);
    }

    @Override
    public Datum replace(LispSequence src, int srcPos, int destPos, int len) {
        char[] cs = this.value.toCharArray();
        int i = 0;
        while (i < len) {
            Datum d = src.get(i + srcPos);
            if (!(d instanceof LispCharacter)) {
                throw new ClassCastException("err.require.char");
            }
            cs[i + destPos] = d.getCharacter();
            ++i;
        }
        return new LispString(new String(cs));
    }

    @Override
    public Datum arraycopy(LispSequence src, int srcPos, int destPos, int len) {
        return this.replace(src, srcPos, destPos, len);
    }

    @Override
    public Datum copy(int b, int e) {
        if (b >= this.value.length()) {
            throw new IndexOutOfBoundsException("" + b);
        }
        return new LispString(this.value.substring(b, e));
    }

    @Override
    public int count(Datum c2a) {
        int r = 0;
        if (c2a instanceof LispCharacter) {
            char c = c2a.getCharacter();
            int i = 0;
            while (i < this.value.length()) {
                if (c == this.value.charAt(i)) {
                    ++r;
                }
                ++i;
            }
            return r;
        }
        throw new ClassCastException("err.require.char");
    }

    @Override
    public Datum toList() {
        return LispUtils.stringToList(this.value);
    }

    @Override
    public Datum first() {
        if (this.value.length() == 0) {
            throw new NoSuchElementException();
        }
        return LispCharacter.valueOf(this.value.charAt(0));
    }

    @Override
    public Datum last() {
        if (this.value.length() == 0) {
            throw new NoSuchElementException();
        }
        return LispCharacter.valueOf(this.value.charAt(this.value.length() - 1));
    }

    @Override
    public ILispArray makeArray(int ... is) {
        return new LispCharArray(this.value.isEmpty() ? (char)'\u0000' : this.value.charAt(0), is);
    }

    @Override
    public LispString add(LispString y) {
        return LispString.valueOf(String.valueOf(this.value) + y.value);
    }

    public int[] toUTF32() {
        return UTF16.getInts(this.value);
    }

    public LispVector toVector() {
        int[] r1 = this.toUTF32();
        Datum[] r2 = new Datum[r1.length];
        int i = 0;
        while (i < r1.length) {
            r2[i] = LispCharacter.valueOf(r1[i]);
            ++i;
        }
        return new LispVector(r2);
    }

    public static LispString toString(LispVector v, LispMessage mesg) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < v.size()) {
            b.appendCodePoint(SubrUtils.getCharacterCodePoint(v.get(i), mesg));
            ++i;
        }
        return new LispString(b.toString());
    }

    public static LispString toString(LispVector v) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < v.size()) {
            int c = ((LispCharacter)v.get(i)).getCharacterCodePoint();
            b.appendCodePoint(c);
            ++i;
        }
        return new LispString(b.toString());
    }

    @Override
    public boolean isSorted(Comparator<Datum> cmp) {
        return this.toVector().isSorted(cmp);
    }

    @Override
    public LispString merge(LispString m, Comparator<Datum> cmp) {
        return LispString.toString(this.toVector().merge(m.toVector(), cmp));
    }

    @Override
    public LispString mergeS(LispString m, Comparator<Datum> cmp) {
        LispVector r = this.toVector();
        r.mergeS(m.toVector(), cmp);
        this.value = LispString.toString((LispVector)r).value;
        return this;
    }

    @Override
    public LispString sort(Comparator<Datum> cmp) {
        return LispString.toString((LispVector)this.toVector().sort((Comparator)cmp));
    }

    @Override
    public void sortS(Comparator<Datum> cmp) {
        LispVector r = this.toVector();
        r.sortS(cmp);
        this.value = LispString.toString((LispVector)r).value;
    }

    @Override
    public ILispIterator lispIterator() {
        final int[] ptr = new int[]{0};
        return new ILispIterator(){

            @Override
            public boolean isTerminated() {
                return ptr[0] >= LispString.this.value.length();
            }

            @Override
            public ILispIterator next() {
                if (this.isTerminated()) {
                    throw new NoSuchElementException();
                }
                int n = ptr[0];
                ptr[0] = n + 1;
                if (Character.isHighSurrogate(LispString.this.value.charAt(n))) {
                    ptr[0] = ptr[0] + 1;
                }
                return this;
            }

            @Override
            public Datum getCurrentDatum() {
                if (this.isTerminated()) {
                    throw new NoSuchElementException();
                }
                return LispCharacter.valueOf(LispString.this.value.codePointAt(ptr[0]));
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispString) {
            return this.value.equals(((LispString)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        return "\"" + this.value + "\"";
    }

    public static class StringCopyS
    extends Subr {
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            String s = SubrUtils.getString(c3a, mesg);
            return this.execute(c1a, c2a, s, 0, s.length(), mesg);
        }

        protected Datum execute(Datum c1a, Datum c2a, String str, int b, int e, LispMessage mesg) {
            char[] t = SubrUtils.getString(c1a, mesg).toCharArray();
            char[] s = str.toCharArray();
            int ts = SubrUtils.getSmallInt(c2a, mesg);
            if (ts >= t.length) {
                throw mesg.getError("err.string.outofrange", c1a);
            }
            if (e - b > t.length - ts) {
                throw mesg.getError("err.string.outofrange");
            }
            System.arraycopy(s, b, t, ts, e - b);
            ((LispString)c1a).value = new String(t);
            return Undef.UNDEF;
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            int e;
            int b;
            String s;
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 3) {
                return this.execute(l.get(0), l.get(1), l.get(2), env, mesg);
            }
            if (l.size() == 4) {
                s = SubrUtils.getString(l.get(2), mesg);
                b = SubrUtils.getSmallInt(l.get(3), mesg);
                e = s.length();
                if (b >= s.length()) {
                    throw mesg.getError("err.string.outofrange", l.get(3));
                }
            } else if (l.size() == 5) {
                s = SubrUtils.getString(l.get(2), mesg);
                b = SubrUtils.getSmallInt(l.get(3), mesg);
                e = SubrUtils.getSmallInt(l.get(4), mesg);
                if (b >= s.length()) {
                    throw mesg.getError("err.string.outofrange", l.get(3));
                }
                if (e > s.length()) {
                    throw mesg.getError("err.string.outofrange", l.get(4));
                }
                if (b > e) {
                    throw mesg.getError("err.range.invalid");
                }
            } else {
                throw mesg.getError("err.argument", body);
            }
            return this.execute(l.get(0), l.get(1), s, b, e, mesg);
        }
    }

    public static class StringDowncaseS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument", body);
            String s = SubrUtils.getString(d1, mesg);
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            ((LispString)d1).value = new String(Strings.toLowerCase(s.toCharArray(), b, e));
            return Undef.UNDEF;
        }
    }

    public static class StringFillS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum c1a = Iterators.nextIf(itr, mesg.getError("err.argument", body));
            Datum c2a = Iterators.nextIf(itr, mesg.getError("err.argument", body));
            Datum c3a = Iterators.nextIf(itr, LispInteger.ZERO);
            Datum c4a = Iterators.nextIf(itr, null);
            char[] cs = SubrUtils.getString(c1a, mesg).toCharArray();
            char ch = SubrUtils.getCharacter(c2a, mesg);
            int e = cs.length;
            SubrUtils.checkTerminated(itr, body, mesg);
            int b = SubrUtils.getSmallInt(c3a, mesg);
            if (c4a != null) {
                e = SubrUtils.getSmallInt(c4a, mesg);
            }
            int i = b;
            while (i < e) {
                cs[i] = ch;
                ++i;
            }
            ((LispString)c1a).value = new String(cs);
            return Undef.UNDEF;
        }
    }

    public static class StringReverseS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument", body);
            String s = SubrUtils.getString(d1, mesg);
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            ((LispString)d1).value = new String(Strings.reverse(s.toCharArray(), b, e));
            return Undef.UNDEF;
        }
    }

    public static class StringSetS
    extends TernaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            char[] cs = SubrUtils.getString(c1a, mesg).toCharArray();
            int i = SubrUtils.getSmallInt(c2a, mesg);
            char ch = SubrUtils.getCharacter(c3a, mesg);
            if (i < 0 || i >= cs.length) {
                throw mesg.getError("err.string.outofrange", c2a);
            }
            cs[i] = ch;
            ((LispString)c1a).value = new String(cs);
            return Undef.UNDEF;
        }
    }

    public static class StringTitlecaseS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument", body);
            String s = SubrUtils.getString(d1, mesg);
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            ((LispString)d1).value = new String(Strings.toTitleCase(s.toCharArray(), b, e));
            return Undef.UNDEF;
        }
    }

    public static class StringUpcaseS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument", body);
            String s = SubrUtils.getString(d1, mesg);
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            ((LispString)d1).value = new String(Strings.toUpperCase(s.toCharArray(), b, e));
            return Undef.UNDEF;
        }
    }

    public static class StringXcopyS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument", body);
            String w = SubrUtils.getString(d1, mesg);
            int z = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            String s = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            int f = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            int t = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length() + f, mesg);
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
            char[] c = w.toCharArray();
            Strings.xcopy(c, z, s, f, t, b, e);
            ((LispString)d1).value = new String(c);
            return Undef.UNDEF;
        }
    }
}

