/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.array.InvalidDimensionException;
import net.morilib.lisp.array.LispArrayIndices;
import net.morilib.lisp.array.ValueOutOfBoundsException;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;
import net.morilib.util.primitive.IntegerArrayVector;

public class ArraySetS
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        int[] i;
        ConsIterator itr = new ConsIterator(body);
        Datum a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (!(a instanceof ILispArray)) {
            throw mesg.getError("err.srfi25.require.array", a);
        }
        if (d instanceof LispArrayIndices) {
            i = ((LispArrayIndices)d).getpos();
        } else if (d instanceof ILispArray) {
            ILispArray b = (ILispArray)((Object)d);
            if (b.rank() != 1) {
                throw mesg.getError("err.srfi25.dimension.invalid", d);
            }
            LispVector v = b.toVector();
            i = new int[v.size()];
            int j = 0;
            while (j < v.size()) {
                i[j] = SubrUtils.getSmallInt(v.get(j), mesg);
                ++j;
            }
            d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        } else {
            IntegerArrayVector iv = new IntegerArrayVector();
            while (itr.hasNext()) {
                iv.add(SubrUtils.getSmallInt(d, mesg));
                d = Iterators.nextIf(itr);
                if (d != null) continue;
            }
            i = iv.toIntArray();
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        try {
            ((ILispArray)((Object)a)).setToArray(d, i);
            return Undef.UNDEF;
        }
        catch (InvalidDimensionException e) {
            throw mesg.getError("err.srfi25.dimension.invalid");
        }
        catch (IndexOutOfBoundsException e) {
            throw mesg.getError("err.range.invalid");
        }
        catch (ClassCastException e) {
            throw mesg.getError("err.srfi25.typemismatch");
        }
        catch (ValueOutOfBoundsException e) {
            throw mesg.getError("err.srfi47.valueoutofrange", e.getMessage());
        }
    }
}

