/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.bits;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;

public class BitField
extends TernaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
        int s = SubrUtils.getSmallInt(c2a, mesg);
        int e = SubrUtils.getSmallInt(c3a, mesg);
        if (s < 0) {
            throw mesg.getError("err.require.int.nonnegative", c2a);
        }
        if (e < 0) {
            throw mesg.getError("err.require.int.nonnegative", c3a);
        }
        if (s > e) {
            throw mesg.getError("err.srfi60.index.invalid");
        }
        if (s == e) {
            return LispInteger.ZERO;
        }
        if (c1a instanceof LispInteger) {
            BigInteger b = c1a.getBigInteger();
            b = b.shiftRight(s);
            b = b.andNot(BigInteger.valueOf(-1L).shiftLeft(e - s));
            return LispInteger.valueOf(b);
        }
        throw mesg.getError("err.require.int", c1a);
    }
}

