/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.bits;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.BitUtils;

public class Logcount
extends UnaryArgs {
    private static final byte[] POS_CNT = new byte[256];
    private static final byte[] NEG_CNT = new byte[256];

    static {
        int i = -128;
        while (i < 128) {
            int j = i & 0xFF;
            Logcount.POS_CNT[j] = (byte)BitUtils.countBit(j);
            Logcount.NEG_CNT[j] = (byte)(8 - POS_CNT[j]);
            ++i;
        }
    }

    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispInteger) {
            LispInteger n = (LispInteger)c1a;
            byte[] ctbl = n.signum() >= 0 ? POS_CNT : NEG_CNT;
            byte[] b = n.getBigInteger().toByteArray();
            long r = 0L;
            int i = 0;
            while (i < b.length) {
                r += (long)ctbl[b[i] & 0xFF];
                ++i;
            }
            return LispInteger.valueOf(r);
        }
        throw mesg.getError("err.require.int", c1a);
    }
}

